/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.RepeatableContainer;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class JoinColumnsJpaAnnotation
implements JoinColumns,
RepeatableContainer<JoinColumn> {
    private JoinColumn[] value;
    private ForeignKey foreignKey;

    public JoinColumnsJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
    }

    public JoinColumnsJpaAnnotation(JoinColumns annotation, SourceModelBuildingContext modelContext) {
        this.value = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_COLUMNS, "value", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_COLUMNS, "foreignKey", modelContext);
    }

    public JoinColumnsJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.value = (JoinColumn[])attributeValues.get("value");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JoinColumns.class;
    }

    public JoinColumn[] value() {
        return this.value;
    }

    public void value(JoinColumn[] value) {
        this.value = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }
}

