/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class NamedEntityGraphJpaAnnotation
implements NamedEntityGraph {
    private String name;
    private NamedAttributeNode[] attributeNodes;
    private boolean includeAllAttributes;
    private NamedSubgraph[] subgraphs;
    private NamedSubgraph[] subclassSubgraphs;

    public NamedEntityGraphJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.attributeNodes = new NamedAttributeNode[0];
        this.includeAllAttributes = false;
        this.subgraphs = new NamedSubgraph[0];
        this.subclassSubgraphs = new NamedSubgraph[0];
    }

    public NamedEntityGraphJpaAnnotation(NamedEntityGraph annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "attributeNodes", modelContext);
        this.includeAllAttributes = annotation.includeAllAttributes();
        this.subgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subgraphs", modelContext);
        this.subclassSubgraphs = (NamedSubgraph[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_ENTITY_GRAPH, "subclassSubgraphs", modelContext);
    }

    public NamedEntityGraphJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.attributeNodes = (NamedAttributeNode[])attributeValues.get("attributeNodes");
        this.includeAllAttributes = (Boolean)attributeValues.get("includeAllAttributes");
        this.subgraphs = (NamedSubgraph[])attributeValues.get("subgraphs");
        this.subclassSubgraphs = (NamedSubgraph[])attributeValues.get("subclassSubgraphs");
    }

    public Class<? extends Annotation> annotationType() {
        return NamedEntityGraph.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public NamedAttributeNode[] attributeNodes() {
        return this.attributeNodes;
    }

    public void attributeNodes(NamedAttributeNode[] value) {
        this.attributeNodes = value;
    }

    public boolean includeAllAttributes() {
        return this.includeAllAttributes;
    }

    public void includeAllAttributes(boolean value) {
        this.includeAllAttributes = value;
    }

    public NamedSubgraph[] subgraphs() {
        return this.subgraphs;
    }

    public void subgraphs(NamedSubgraph[] value) {
        this.subgraphs = value;
    }

    public NamedSubgraph[] subclassSubgraphs() {
        return this.subclassSubgraphs;
    }

    public void subclassSubgraphs(NamedSubgraph[] value) {
        this.subclassSubgraphs = value;
    }
}

