/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class OneToOneJpaAnnotation
implements OneToOne,
AttributeMarker.Fetchable,
AttributeMarker.Cascadeable,
AttributeMarker.Optionalable {
    private Class<?> targetEntity;
    private CascadeType[] cascade;
    private FetchType fetch;
    private boolean optional;
    private String mappedBy;
    private boolean orphanRemoval;

    public OneToOneJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.targetEntity = Void.TYPE;
        this.cascade = new CascadeType[0];
        this.fetch = FetchType.EAGER;
        this.optional = true;
        this.mappedBy = "";
        this.orphanRemoval = false;
    }

    public OneToOneJpaAnnotation(OneToOne annotation, SourceModelBuildingContext modelContext) {
        this.targetEntity = annotation.targetEntity();
        this.cascade = annotation.cascade();
        this.fetch = annotation.fetch();
        this.optional = annotation.optional();
        this.mappedBy = annotation.mappedBy();
        this.orphanRemoval = annotation.orphanRemoval();
    }

    public OneToOneJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.targetEntity = (Class)attributeValues.get("targetEntity");
        this.cascade = (CascadeType[])attributeValues.get("cascade");
        this.fetch = (FetchType)attributeValues.get("fetch");
        this.optional = (Boolean)attributeValues.get("optional");
        this.mappedBy = (String)attributeValues.get("mappedBy");
        this.orphanRemoval = (Boolean)attributeValues.get("orphanRemoval");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return OneToOne.class;
    }

    public Class<?> targetEntity() {
        return this.targetEntity;
    }

    public void targetEntity(Class<?> value) {
        this.targetEntity = value;
    }

    @Override
    public CascadeType[] cascade() {
        return this.cascade;
    }

    @Override
    public void cascade(CascadeType[] value) {
        this.cascade = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public void optional(boolean value) {
        this.optional = value;
    }

    public String mappedBy() {
        return this.mappedBy;
    }

    public void mappedBy(String value) {
        this.mappedBy = value;
    }

    public boolean orphanRemoval() {
        return this.orphanRemoval;
    }

    public void orphanRemoval(boolean value) {
        this.orphanRemoval = value;
    }
}

