/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.SqlResultSetMapping;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class SqlResultSetMappingJpaAnnotation
implements SqlResultSetMapping {
    private String name;
    private EntityResult[] entities;
    private ConstructorResult[] classes;
    private ColumnResult[] columns;

    public SqlResultSetMappingJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.entities = new EntityResult[0];
        this.classes = new ConstructorResult[0];
        this.columns = new ColumnResult[0];
    }

    public SqlResultSetMappingJpaAnnotation(SqlResultSetMapping annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.entities = (EntityResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.SQL_RESULT_SET_MAPPING, "entities", modelContext);
        this.classes = (ConstructorResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.SQL_RESULT_SET_MAPPING, "classes", modelContext);
        this.columns = (ColumnResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.SQL_RESULT_SET_MAPPING, "columns", modelContext);
    }

    public SqlResultSetMappingJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.entities = (EntityResult[])attributeValues.get("entities");
        this.classes = (ConstructorResult[])attributeValues.get("classes");
        this.columns = (ColumnResult[])attributeValues.get("columns");
    }

    public Class<? extends Annotation> annotationType() {
        return SqlResultSetMapping.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public EntityResult[] entities() {
        return this.entities;
    }

    public void entities(EntityResult[] value) {
        this.entities = value;
    }

    public ConstructorResult[] classes() {
        return this.classes;
    }

    public void classes(ConstructorResult[] value) {
        this.classes = value;
    }

    public ColumnResult[] columns() {
        return this.columns;
    }

    public void columns(ColumnResult[] value) {
        this.columns = value;
    }
}

