/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.Index;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.IndexCollector;
import org.hibernate.boot.models.annotations.spi.UniqueConstraintCollector;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class TableGeneratorJpaAnnotation
implements TableGenerator,
UniqueConstraintCollector,
IndexCollector {
    private String name;
    private String table;
    private String catalog;
    private String schema;
    private String pkColumnName;
    private String valueColumnName;
    private String pkColumnValue;
    private int initialValue;
    private int allocationSize;
    private UniqueConstraint[] uniqueConstraints;
    private Index[] indexes;
    private String options;

    public TableGeneratorJpaAnnotation(SourceModelBuildingContext modelContext) {
        this("", modelContext);
    }

    public TableGeneratorJpaAnnotation(String name, SourceModelBuildingContext modelContext) {
        this.name = name;
        this.table = "";
        this.catalog = "";
        this.schema = "";
        this.pkColumnName = "";
        this.valueColumnName = "";
        this.pkColumnValue = "";
        this.initialValue = 0;
        this.allocationSize = 50;
        this.uniqueConstraints = new UniqueConstraint[0];
        this.indexes = new Index[0];
        this.options = "";
    }

    public TableGeneratorJpaAnnotation(TableGenerator annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.table = annotation.table();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.pkColumnName = annotation.pkColumnName();
        this.valueColumnName = annotation.valueColumnName();
        this.pkColumnValue = annotation.pkColumnValue();
        this.initialValue = annotation.initialValue();
        this.allocationSize = annotation.allocationSize();
        this.uniqueConstraints = (UniqueConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.TABLE_GENERATOR, "uniqueConstraints", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.TABLE_GENERATOR, "indexes", modelContext);
        this.options = annotation.options();
    }

    public TableGeneratorJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.table = (String)attributeValues.get("table");
        this.catalog = (String)attributeValues.get("catalog");
        this.schema = (String)attributeValues.get("schema");
        this.pkColumnName = (String)attributeValues.get("pkColumnName");
        this.valueColumnName = (String)attributeValues.get("valueColumnName");
        this.pkColumnValue = (String)attributeValues.get("pkColumnValue");
        this.initialValue = (Integer)attributeValues.get("initialValue");
        this.allocationSize = (Integer)attributeValues.get("allocationSize");
        this.uniqueConstraints = (UniqueConstraint[])attributeValues.get("uniqueConstraints");
        this.indexes = (Index[])attributeValues.get("indexes");
        this.options = (String)attributeValues.get("options");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return TableGenerator.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String table() {
        return this.table;
    }

    public void table(String value) {
        this.table = value;
    }

    public String catalog() {
        return this.catalog;
    }

    public void catalog(String value) {
        this.catalog = value;
    }

    public String schema() {
        return this.schema;
    }

    public void schema(String value) {
        this.schema = value;
    }

    public String pkColumnName() {
        return this.pkColumnName;
    }

    public void pkColumnName(String value) {
        this.pkColumnName = value;
    }

    public String valueColumnName() {
        return this.valueColumnName;
    }

    public void valueColumnName(String value) {
        this.valueColumnName = value;
    }

    public String pkColumnValue() {
        return this.pkColumnValue;
    }

    public void pkColumnValue(String value) {
        this.pkColumnValue = value;
    }

    public int initialValue() {
        return this.initialValue;
    }

    public void initialValue(int value) {
        this.initialValue = value;
    }

    public int allocationSize() {
        return this.allocationSize;
    }

    public void allocationSize(int value) {
        this.allocationSize = value;
    }

    @Override
    public UniqueConstraint[] uniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public void uniqueConstraints(UniqueConstraint[] value) {
        this.uniqueConstraints = value;
    }

    @Override
    public Index[] indexes() {
        return this.indexes;
    }

    @Override
    public void indexes(Index[] value) {
        this.indexes = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public void apply(JaxbTableGeneratorImpl jaxbGenerator, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbGenerator.getName())) {
            this.name(jaxbGenerator.getName());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getTable())) {
            this.table(jaxbGenerator.getTable());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getCatalog())) {
            this.catalog(jaxbGenerator.getCatalog());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getSchema())) {
            this.schema(jaxbGenerator.getSchema());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getPkColumnName())) {
            this.pkColumnName(jaxbGenerator.getPkColumnName());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getPkColumnValue())) {
            this.pkColumnValue(jaxbGenerator.getPkColumnValue());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getValueColumnName())) {
            this.valueColumnName(jaxbGenerator.getValueColumnName());
        }
        if (jaxbGenerator.getInitialValue() != null) {
            this.initialValue(jaxbGenerator.getInitialValue());
        }
        if (jaxbGenerator.getAllocationSize() != null) {
            this.allocationSize(jaxbGenerator.getAllocationSize());
        }
        if (StringHelper.isNotEmpty(jaxbGenerator.getOptions())) {
            this.options(jaxbGenerator.getOptions());
        }
        this.uniqueConstraints(XmlAnnotationHelper.collectUniqueConstraints(jaxbGenerator.getUniqueConstraints(), xmlDocumentContext));
        this.indexes(XmlAnnotationHelper.collectIndexes(jaxbGenerator.getIndexes(), xmlDocumentContext));
    }
}

