/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.cache", description="Logging related to Hibernate second-level caching")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90001001, max=90002000)
public interface SecondLevelCacheLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.cache";
    public static final SecondLevelCacheLogger L2CACHE_LOGGER = (SecondLevelCacheLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), SecondLevelCacheLogger.class, (String)"org.hibernate.orm.cache");
    public static final int NAMESPACE = 90001000;

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempt to start an already-started RegionFactory, probably because a SessionFactory was not closed. Using previously created RegionFactory.", id=90001001)
    public void attemptToStartAlreadyStartedCacheProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempt to stop an already-stopped JCacheRegionFactory.", id=90001002)
    public void attemptToStopAlreadyStoppedCacheProvider();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Read-only caching was requested for mutable entity [%s]", id=90001003)
    public void readOnlyCachingMutableEntity(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Read-only caching was requested for mutable natural-id for entity [%s]", id=90001004)
    public void readOnlyCachingMutableNaturalId(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="A soft-locked cache entry in region [%s] with key [%s] was expired by the underlying cache. If this happens regularly, consider increasing the cache timeouts and/or capacity limits.", id=90001005)
    public void softLockedCacheExpired(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing cache region [%1$s] was created with provider-specific default policies. Explicitly configure the region and its policies, or disable this warning by setting '%2$s' to '%3$s'.", id=90001006)
    public void missingCacheCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Using legacy cache name [%2$s] because configuration could not be found for cache [%1$s]. Update configuration to rename cache [%2$s] to [%1$s].", id=90001007)
    public void usingLegacyCacheName(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache region [%1$s] has the access type '%2$s' which is not supported by [%3$s]. Ensure cache implementation supports JTA transactions.", id=90001008)
    public void nonStandardSupportForAccessType(String var1, String var2, String var3);
}

