/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.GenerationType;
import jakarta.persistence.TemporalType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.ColumnAliasExtractor;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.LobMergeStrategy;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.CastStrEmulation;
import org.hibernate.dialect.function.CoalesceIfnullEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CurrentFunction;
import org.hibernate.dialect.function.ExtractFunction;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.function.LocatePositionEmulation;
import org.hibernate.dialect.function.LpadRpadPadEmulation;
import org.hibernate.dialect.function.OrdinalFunction;
import org.hibernate.dialect.function.SqlFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.StandardTemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver;
import org.hibernate.engine.jdbc.env.spi.AnsiSqlKeywords;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.spi.MultiKeyLoadSizingStrategy;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.StandardAuxiliaryDatabaseObjectExporter;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.internal.StandardTableCleaner;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.internal.StandardTableMigrator;
import org.hibernate.tool.schema.internal.StandardUniqueKeyExporter;
import org.hibernate.tool.schema.internal.StandardUserDefinedTypeExporter;
import org.hibernate.tool.schema.spi.Cleaner;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.TableMigrator;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LongNVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.NCharJdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.NVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsJdbcTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsOffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsJdbcTimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsOffsetDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public abstract class Dialect
implements ConversionContext,
TypeContributor,
FunctionContributor {
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final Pattern ESCAPE_CLOSING_COMMENT_PATTERN = Pattern.compile("\\*/");
    private static final Pattern ESCAPE_OPENING_COMMENT_PATTERN = Pattern.compile("/\\*");
    private static final Pattern QUERY_PATTERN = Pattern.compile("^\\s*(select\\b.+?\\bfrom\\b.+?)(\\b(where|join)\\b.+?)$");
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)Dialect.class.getName());
    protected static final double LOG_BASE2OF10 = Math.log(10.0) / Math.log(2.0);
    private final Properties properties = new Properties();
    private final Set<String> sqlKeywords = new HashSet<String>();
    private final SizeStrategy sizeStrategy = new SizeStrategyImpl();
    private final DatabaseVersion version;
    protected static final String[] TRUE_STRING_VALUES = new String[]{"t", "true", "y", "1"};
    protected static final String[] FALSE_STRING_VALUES = new String[]{"f", "false", "n", "0"};
    protected static final LobMergeStrategy LEGACY_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            return target;
        }
    };
    protected static final LobMergeStrategy STREAM_XFER_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setBinaryStream(1L);
                    InputStream detachedStream = original.getBinaryStream();
                    detachedStream.transferTo(connectedStream);
                    return target;
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to copy stream content", e);
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge BLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeBlob(original, target, session);
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    detachedStream.transferTo(connectedStream);
                    return target;
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to copy stream content", e);
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge CLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeClob(original, target, session);
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    detachedStream.transferTo(connectedStream);
                    return target;
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to copy stream content", e);
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge NCLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeNClob(original, target, session);
        }
    };
    protected static final LobMergeStrategy NEW_LOCATOR_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createBlob(ArrayHelper.EMPTY_BYTE_ARRAY) : lobCreator.createBlob(original.getBinaryStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge BLOB data");
            }
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createClob("") : lobCreator.createClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge CLOB data");
            }
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createNClob("") : lobCreator.createNClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge NCLOB data");
            }
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> null;
    private final StandardTableExporter tableExporter = new StandardTableExporter(this);
    private final StandardUserDefinedTypeExporter userDefinedTypeExporter = new StandardUserDefinedTypeExporter(this);
    private final StandardSequenceExporter sequenceExporter = new StandardSequenceExporter(this);
    private final StandardIndexExporter indexExporter = new StandardIndexExporter(this);
    private final StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this);
    private final StandardUniqueKeyExporter uniqueKeyExporter = new StandardUniqueKeyExporter(this);
    private final StandardAuxiliaryDatabaseObjectExporter auxiliaryObjectExporter = new StandardAuxiliaryDatabaseObjectExporter(this);
    private final StandardTemporaryTableExporter temporaryTableExporter = new StandardTemporaryTableExporter(this);
    private final StandardTableMigrator tableMigrator = new StandardTableMigrator(this);
    private final StandardTableCleaner tableCleaner = new StandardTableCleaner(this);
    protected final MultiKeyLoadSizingStrategy STANDARD_MULTI_KEY_LOAD_SIZING_STRATEGY = this::calculateBatchSize;

    @Deprecated(since="6.0")
    protected Dialect() {
        this((DatabaseVersion)null);
    }

    protected Dialect(DatabaseVersion version) {
        this.version = version;
        this.checkVersion();
        this.registerDefaultKeywords();
        this.initDefaultProperties();
    }

    protected Dialect(DialectResolutionInfo info) {
        this.version = this.determineDatabaseVersion(info);
        this.checkVersion();
        this.registerDefaultKeywords();
        this.registerKeywords(info);
        this.initDefaultProperties();
    }

    protected void checkVersion() {
        DatabaseVersion version = this.getVersion();
        DatabaseVersion minimumVersion = this.getMinimumSupportedVersion();
        if (version != null && version.isBefore(minimumVersion.getMajor(), minimumVersion.getMinor(), minimumVersion.getMicro())) {
            LOG.unsupportedDatabaseVersion(this.getClass().getName(), version.getMajor() + "." + version.getMinor() + "." + version.getMicro(), minimumVersion.getMajor() + "." + minimumVersion.getMinor() + "." + minimumVersion.getMicro());
        }
    }

    public DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        return info.makeCopyOrDefault(this.getMinimumSupportedVersion());
    }

    protected void initDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", Integer.toString(this.getDefaultStatementBatchSize()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", Boolean.toString(this.getDefaultNonContextualLobCreation()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", Boolean.toString(this.getDefaultUseGetGeneratedKeys()));
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(16));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-6));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(5));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-5));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(6));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(7));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(8));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(91));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(92));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2013));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3007));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(93));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2014));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3003));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(1));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(12, 4001, 12).withTypeCapacity(this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2005));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-15));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(-9, 4002, -9).withTypeCapacity(this.getMaxNVarcharLength(), this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2011));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-2));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(-3, 4003, -3).withTypeCapacity(this.getMaxVarbinaryLength(), this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2004));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4001));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4002));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4003));
        if (this.supportsStandardArrays()) {
            ddlTypeRegistry.addDescriptor(new ArrayDdlTypeImpl(this, false));
        }
        if (this.rowId(null) != null) {
            ddlTypeRegistry.addDescriptor(this.simpleSqlType(-8));
        }
    }

    protected boolean isLob(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 2004, 2005, 2011, 4001, 4002, 4003 -> true;
            default -> false;
        };
    }

    private DdlTypeImpl simpleSqlType(int sqlTypeCode) {
        return new DdlTypeImpl(sqlTypeCode, this.isLob(sqlTypeCode), this.columnType(sqlTypeCode), this.castType(sqlTypeCode), this);
    }

    private CapacityDependentDdlType.Builder sqlTypeBuilder(int sqlTypeCode, int biggestSqlTypeCode, int castTypeCode) {
        return CapacityDependentDdlType.builder(sqlTypeCode, this.isLob(sqlTypeCode) ? CapacityDependentDdlType.LobKind.ALL_LOB : (this.isLob(biggestSqlTypeCode) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), this.columnType(biggestSqlTypeCode), this.castType(castTypeCode), this);
    }

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -8 -> "rowid";
            case 16 -> "boolean";
            case -6 -> "tinyint";
            case 5 -> "smallint";
            case 4 -> "integer";
            case -5 -> "bigint";
            case 6 -> "float($p)";
            case 7 -> "real";
            case 8 -> "double precision";
            case 2 -> "numeric($p,$s)";
            case 3 -> "decimal($p,$s)";
            case 91 -> "date";
            case 92 -> "time($p)";
            case 2013 -> "time($p) with time zone";
            case 93 -> "timestamp($p)";
            case 2014 -> "timestamp($p) with time zone";
            case 3007 -> {
                if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
                    yield this.columnType(2013);
                }
                yield this.columnType(92);
            }
            case 3003 -> {
                if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
                    yield this.columnType(2014);
                }
                yield this.columnType(93);
            }
            case 1 -> "char($l)";
            case 12 -> "varchar($l)";
            case 2005 -> "clob";
            case -15 -> "nchar($l)";
            case -9 -> "nvarchar($l)";
            case 2011 -> "nclob";
            case -2 -> "binary($l)";
            case -3 -> "varbinary($l)";
            case 2004 -> "blob";
            case 4001 -> this.columnType(2005);
            case 4002 -> this.columnType(2011);
            case 4003 -> this.columnType(2004);
            default -> throw new IllegalArgumentException("unknown type: " + sqlTypeCode);
        };
    }

    public boolean stripsTrailingSpacesFromChar() {
        return false;
    }

    protected String castType(int sqlTypeCode) {
        return this.columnType(sqlTypeCode);
    }

    protected void registerDefaultKeywords() {
        this.sqlKeywords.addAll(new AnsiSqlKeywords().sql2003());
    }

    protected void registerKeywords(DialectResolutionInfo info) {
        for (String keyword : StringHelper.splitAtCommas(info.getSQLKeywords())) {
            this.registerKeyword(keyword);
        }
    }

    public DatabaseVersion getVersion() {
        return this.version;
    }

    protected DatabaseVersion getMinimumSupportedVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        int parenthesisIndex = columnTypeName.lastIndexOf(40);
        String baseTypeName = parenthesisIndex == -1 ? columnTypeName : columnTypeName.substring(0, parenthesisIndex).trim();
        return this.resolveSqlTypeCode(columnTypeName, baseTypeName, typeConfiguration);
    }

    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getDdlTypeRegistry().getSqlTypeCode(baseTypeName);
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        String componentTypeName;
        Integer sqlTypeCode;
        int arraySuffixIndex;
        if (jdbcTypeCode == 2003 && (arraySuffixIndex = columnTypeName.toLowerCase(Locale.ROOT).indexOf(" array")) != -1 && (sqlTypeCode = this.resolveSqlTypeCode(componentTypeName = columnTypeName.substring(0, arraySuffixIndex), jdbcTypeRegistry.getTypeConfiguration())) != null) {
            return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode), ColumnTypeInformation.EMPTY);
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        return precision;
    }

    public String getEnumTypeDeclaration(String name, String[] values) {
        return null;
    }

    public String getEnumTypeDeclaration(Class<? extends Enum<?>> enumType) {
        return this.getEnumTypeDeclaration(enumType.getSimpleName(), EnumHelper.getEnumeratedValues(enumType));
    }

    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public String[] getCreateEnumTypeCommand(Class<? extends Enum<?>> enumType) {
        return this.getCreateEnumTypeCommand(enumType.getSimpleName(), EnumHelper.getEnumeratedValues(enumType));
    }

    public String[] getDropEnumTypeCommand(String name) {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public String[] getDropEnumTypeCommand(Class<? extends Enum<?>> enumType) {
        return this.getDropEnumTypeCommand(enumType.getSimpleName());
    }

    public String getCheckCondition(String columnName, String[] values) {
        StringBuilder check = new StringBuilder();
        check.append(columnName).append(" in (");
        String separator = "";
        boolean nullIsValid = false;
        for (String value : values) {
            if (value == null) {
                nullIsValid = true;
                continue;
            }
            check.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        check.append(')');
        if (nullIsValid) {
            check.append(" or ").append(columnName).append(" is null");
        }
        return check.toString();
    }

    public String getCheckCondition(String columnName, Class<? extends Enum<?>> enumType) {
        return this.getCheckCondition(columnName, EnumHelper.getEnumeratedValues(enumType));
    }

    public String getCheckCondition(String columnName, long min, long max) {
        return columnName + " between " + min + " and " + max;
    }

    @Deprecated(since="6.5", forRemoval=true)
    public String getCheckCondition(String columnName, long[] values) {
        Long[] boxedValues = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxedValues[i] = values[i];
        }
        return this.getCheckCondition(columnName, boxedValues);
    }

    public String getCheckCondition(String columnName, Long[] values) {
        StringBuilder check = new StringBuilder();
        check.append(columnName).append(" in (");
        String separator = "";
        boolean nullIsValid = false;
        for (Long value : values) {
            if (value == null) {
                nullIsValid = true;
                continue;
            }
            check.append(separator).append(value);
            separator = ",";
        }
        check.append(')');
        if (nullIsValid) {
            check.append(" or ").append(columnName).append(" is null");
        }
        return check.toString();
    }

    public String getCheckCondition(String columnName, Set<?> valueSet, JdbcType jdbcType) {
        boolean isCharacterJdbcType = SqlTypes.isCharacterType(jdbcType.getJdbcTypeCode());
        assert (isCharacterJdbcType || SqlTypes.isIntegral(jdbcType.getJdbcTypeCode()));
        StringBuilder check = new StringBuilder();
        check.append(columnName).append(" in (");
        String separator = "";
        boolean nullIsValid = false;
        for (Object value : valueSet) {
            if (value == null) {
                nullIsValid = true;
                continue;
            }
            if (isCharacterJdbcType) {
                check.append(separator).append('\'').append(value).append('\'');
            } else {
                check.append(separator).append(value);
            }
            separator = ",";
        }
        check.append(')');
        if (nullIsValid) {
            check.append(" or ").append(columnName).append(" is null");
        }
        return check.toString();
    }

    @Override
    public void contributeFunctions(FunctionContributions functionContributions) {
        this.initializeFunctionRegistry(functionContributions);
    }

    @Override
    public int ordinal() {
        return 0;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType<Instant> instantType = basicTypeRegistry.resolve(StandardBasicTypes.INSTANT);
        BasicType<OffsetDateTime> offsetDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        BasicType<LocalDateTime> localDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE_TIME);
        BasicType<LocalTime> localTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_TIME);
        BasicType<LocalDate> localDateType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.everyAny_sumCase(this.supportsPredicateAsExpression());
        functionFactory.math();
        functionFactory.round();
        functionFactory.trigonometry();
        functionFactory.sinh_exp();
        functionFactory.cosh_exp();
        functionFactory.tanh_exp();
        functionFactory.pi_acos();
        functionFactory.log_ln();
        functionFactory.coalesce();
        functionFactory.nullif();
        functionFactory.leftRight();
        functionFactory.replace();
        functionFactory.concat();
        functionFactory.lowerUpper();
        functionFactory.substring();
        functionFactory.locate();
        functionFactory.length_characterLength();
        functionContributions.getFunctionRegistry().register("position", new LocatePositionEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation(typeConfiguration, false));
        functionContributions.getFunctionRegistry().register("trim", new TrimFunction(this, typeConfiguration));
        functionContributions.getFunctionRegistry().register("cast", new CastFunction(this, functionContributions.getTypeConfiguration().getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForBoolean()));
        functionFactory.collate();
        functionContributions.getFunctionRegistry().register("extract", new ExtractFunction(this, typeConfiguration));
        functionFactory.leastGreatest();
        functionContributions.getFunctionRegistry().register("ifnull", new CoalesceIfnullEmulation());
        functionFactory.pad();
        functionContributions.getFunctionRegistry().register("pad", new LpadRpadPadEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("str", new CastStrEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("ordinal", new OrdinalFunction(typeConfiguration));
        functionFactory.format_toChar();
        functionFactory.timestampaddAndDiff(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionContributions.getFunctionRegistry().registerAlternateKey("dateadd", "timestampadd");
        functionContributions.getFunctionRegistry().registerAlternateKey("datediff", "timestampdiff");
        functionContributions.getFunctionRegistry().register("current_date", new CurrentFunction("current_date", this.currentDate(), dateType));
        functionContributions.getFunctionRegistry().register("current_time", new CurrentFunction("current_time", this.currentTime(), timeType));
        functionContributions.getFunctionRegistry().register("current_timestamp", new CurrentFunction("current_timestamp", this.currentTimestamp(), timestampType));
        functionContributions.getFunctionRegistry().registerAlternateKey("current date", "current_date");
        functionContributions.getFunctionRegistry().registerAlternateKey("current time", "current_time");
        functionContributions.getFunctionRegistry().registerAlternateKey("current timestamp", "current_timestamp");
        functionContributions.getFunctionRegistry().register("local_date", new CurrentFunction("local_date", this.currentDate(), localDateType));
        functionContributions.getFunctionRegistry().register("local_time", new CurrentFunction("local_time", this.currentLocalTime(), localTimeType));
        functionContributions.getFunctionRegistry().register("local_datetime", new CurrentFunction("local_datetime", this.currentLocalTimestamp(), localDateTimeType));
        functionContributions.getFunctionRegistry().register("offset_datetime", new CurrentFunction("offset_datetime", this.currentTimestampWithTimeZone(), offsetDateTimeType));
        functionContributions.getFunctionRegistry().registerAlternateKey("local date", "local_date");
        functionContributions.getFunctionRegistry().registerAlternateKey("local time", "local_time");
        functionContributions.getFunctionRegistry().registerAlternateKey("local datetime", "local_datetime");
        functionContributions.getFunctionRegistry().registerAlternateKey("offset datetime", "offset_datetime");
        functionContributions.getFunctionRegistry().register("instant", new CurrentFunction("instant", this.currentTimestampWithTimeZone(), instantType));
        functionContributions.getFunctionRegistry().registerAlternateKey("current_instant", "instant");
        functionContributions.getFunctionRegistry().register("sql", new SqlFunction());
    }

    public String currentDate() {
        return "current_date";
    }

    public String currentTime() {
        return "current_time";
    }

    public String currentTimestamp() {
        return "current_timestamp";
    }

    public String currentLocalTime() {
        return this.currentTime();
    }

    public String currentLocalTimestamp() {
        return this.currentTimestamp();
    }

    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    public String extractPattern(org.hibernate.query.common.TemporalUnit unit) {
        return "extract(?1 from ?2)";
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'true' when 0 then 'false' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'true' when 'N' then 'false' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'true' when 'F' then 'false' else null end";
                    }
                }
                break;
            }
            case INTEGER: 
            case LONG: {
                switch (from) {
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case INTEGER_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return this.buildStringToBooleanCast("1", "0");
                    }
                    case INTEGER: 
                    case LONG: {
                        return "abs(sign(?1))";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case YN_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return this.buildStringToBooleanCast("'Y'", "'N'");
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'Y' when 'F' then 'N' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'Y' when false then 'N' else null end";
                    }
                }
                break;
            }
            case TF_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return this.buildStringToBooleanCast("'T'", "'F'");
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'T' when 'N' then 'F' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'T' when false then 'F' else null end";
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return this.buildStringToBooleanCast("true", "false");
                    }
                    case INTEGER_BOOLEAN: 
                    case INTEGER: 
                    case LONG: {
                        return "(?1<>0)";
                    }
                    case YN_BOOLEAN: {
                        return "(?1<>'N')";
                    }
                    case TF_BOOLEAN: {
                        return "(?1<>'F')";
                    }
                }
            }
        }
        return "cast(?1 as ?2)";
    }

    protected String buildStringToBooleanCast(String trueValue, String falseValue) {
        boolean supportsValuesList = this.supportsValuesList();
        StringBuilder sb = new StringBuilder();
        sb.append("(select v.x from (");
        if (supportsValuesList) {
            sb.append("values (");
            sb.append(trueValue);
            sb.append("),(");
            sb.append(falseValue);
            sb.append(")) v(x)");
        } else {
            sb.append("select ");
            sb.append(trueValue);
            sb.append(" x");
            sb.append(this.getFromDualForSelectOnly());
            sb.append(" union all select ");
            sb.append(falseValue);
            sb.append(this.getFromDualForSelectOnly());
            sb.append(") v");
        }
        sb.append(" left join (");
        if (supportsValuesList) {
            sb.append("values");
            int separator = 32;
            for (String trueStringValue : TRUE_STRING_VALUES) {
                sb.append((char)separator);
                sb.append("('");
                sb.append(trueStringValue);
                sb.append("',");
                sb.append(trueValue);
                sb.append(')');
                separator = 44;
            }
            for (String falseStringValue : FALSE_STRING_VALUES) {
                sb.append(",('");
                sb.append(falseStringValue);
                sb.append("',");
                sb.append(falseValue);
                sb.append(')');
            }
            sb.append(") t(k,v)");
        } else {
            sb.append("select '");
            sb.append(TRUE_STRING_VALUES[0]);
            sb.append("' k,");
            sb.append(trueValue);
            sb.append(" v");
            sb.append(this.getFromDualForSelectOnly());
            for (int i = 1; i < TRUE_STRING_VALUES.length; ++i) {
                sb.append(" union all select '");
                sb.append(TRUE_STRING_VALUES[i]);
                sb.append("',");
                sb.append(trueValue);
                sb.append(this.getFromDualForSelectOnly());
            }
            for (String falseStringValue : FALSE_STRING_VALUES) {
                sb.append(" union all select '");
                sb.append(falseStringValue);
                sb.append("',");
                sb.append(falseValue);
                sb.append(this.getFromDualForSelectOnly());
            }
            sb.append(") t");
        }
        sb.append(" on ");
        sb.append(this.getLowercaseFunction());
        sb.append("(?1)=t.k where t.v is null or v.x=t.v)");
        return sb.toString();
    }

    protected String buildStringToBooleanCastDecode(String trueValue, String falseValue) {
        boolean supportsValuesList = this.supportsValuesList();
        StringBuilder sb = new StringBuilder();
        sb.append("(select v.x from (");
        if (supportsValuesList) {
            sb.append("values (");
            sb.append(trueValue);
            sb.append("),(");
            sb.append(falseValue);
            sb.append(")) v(x)");
        } else {
            sb.append("select ");
            sb.append(trueValue);
            sb.append(" x");
            sb.append(this.getFromDualForSelectOnly());
            sb.append(" union all select ");
            sb.append(falseValue);
            sb.append(this.getFromDualForSelectOnly());
            sb.append(") v");
        }
        sb.append(", (");
        if (supportsValuesList) {
            sb.append("values (");
            sb.append(this.buildStringToBooleanDecode(trueValue, falseValue));
            sb.append(")) t(v)");
        } else {
            sb.append("select ");
            sb.append(this.buildStringToBooleanDecode(trueValue, falseValue));
            sb.append(" v");
            sb.append(this.getFromDualForSelectOnly());
            sb.append(") t");
        }
        sb.append(" where t.v is null or v.x=t.v)");
        return sb.toString();
    }

    protected String buildStringToBooleanDecode(String trueValue, String falseValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("decode(");
        sb.append(this.getLowercaseFunction());
        sb.append("(?1)");
        for (String trueStringValue : TRUE_STRING_VALUES) {
            sb.append(",'");
            sb.append(trueStringValue);
            sb.append("',");
            sb.append(trueValue);
        }
        for (String falseStringValue : FALSE_STRING_VALUES) {
            sb.append(",'");
            sb.append(falseStringValue);
            sb.append("',");
            sb.append(falseValue);
        }
        sb.append(",null)");
        return sb.toString();
    }

    public String getDual() {
        return "(values(0))";
    }

    public String getFromDualForSelectOnly() {
        return "";
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        return "trim(" + specification + (isWhitespace ? "" : " ?2") + " from ?1)";
    }

    public boolean supportsFractionalTimestampArithmetic() {
        return true;
    }

    public String timestampdiffPattern(org.hibernate.query.common.TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not yet support #timestampdiffPattern");
    }

    public String timestampaddPattern(org.hibernate.query.common.TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not yet support #timestampaddPattern");
    }

    public boolean equivalentTypes(int typeCode1, int typeCode2) {
        return typeCode1 == typeCode2 || SqlTypes.isNumericOrDecimal(typeCode1) && SqlTypes.isNumericOrDecimal(typeCode2) || SqlTypes.isFloatOrRealOrDouble(typeCode1) && SqlTypes.isFloatOrRealOrDouble(typeCode2) || SqlTypes.isVarcharType(typeCode1) && SqlTypes.isVarcharType(typeCode2) || SqlTypes.isVarbinaryType(typeCode1) && SqlTypes.isVarbinaryType(typeCode2) || this.isCompatibleIntegralType(typeCode1, typeCode2) || SqlTypes.isEnumType(typeCode1) && SqlTypes.isVarcharType(typeCode2) || this.sameColumnType(typeCode1, typeCode2);
    }

    private boolean isCompatibleIntegralType(int typeCode1, int typeCode2) {
        return switch (typeCode1) {
            case -6 -> {
                if (typeCode2 == -6 || typeCode2 == 5 || typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (typeCode2 == 5 || typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean sameColumnType(int typeCode1, int typeCode2) {
        try {
            return Objects.equals(this.columnType(typeCode1), this.columnType(typeCode2));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public Properties getDefaultProperties() {
        return this.properties;
    }

    public int getDefaultStatementBatchSize() {
        return 1;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return false;
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + ", version: " + this.getVersion();
    }

    @Override
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.contributeTypes(typeContributions, serviceRegistry);
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.registerColumnTypes(typeContributions, serviceRegistry);
        NationalizationSupport nationalizationSupport = this.getNationalizationSupport();
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (nationalizationSupport == NationalizationSupport.EXPLICIT) {
            jdbcTypeRegistry.addDescriptor(NCharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(NVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(LongNVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(NClobJdbcType.DEFAULT);
        }
        if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
            jdbcTypeRegistry.addDescriptor(TimestampUtcAsOffsetDateTimeJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(TimeUtcAsOffsetTimeJdbcType.INSTANCE);
        } else {
            jdbcTypeRegistry.addDescriptor(TimestampUtcAsJdbcTimestampJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(TimeUtcAsJdbcTimeJdbcType.INSTANCE);
        }
        if (this.supportsStandardArrays()) {
            jdbcTypeRegistry.addTypeConstructorIfAbsent(ArrayJdbcTypeConstructor.INSTANCE);
        }
        if (this.supportsMaterializedLobAccess()) {
            jdbcTypeRegistry.addDescriptor(3004, BlobJdbcType.MATERIALIZED);
            jdbcTypeRegistry.addDescriptor(3005, ClobJdbcType.MATERIALIZED);
            jdbcTypeRegistry.addDescriptor(3006, NClobJdbcType.MATERIALIZED);
        }
    }

    public LobMergeStrategy getLobMergeStrategy() {
        return NEW_LOCATOR_LOB_MERGE_STRATEGY;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public String getNativeIdentifierGeneratorStrategy() {
        return this.getNativeValueGenerationStrategy().name().toLowerCase(Locale.ROOT);
    }

    @Incubating
    public GenerationType getNativeValueGenerationStrategy() {
        return this.getIdentityColumnSupport().supportsIdentityColumns() ? GenerationType.IDENTITY : GenerationType.SEQUENCE;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return IdentityColumnSupportImpl.INSTANCE;
    }

    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getQuerySequencesString() == null ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorLegacyImpl.INSTANCE;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support GUIDs");
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public boolean supportsTemporaryTablePrimaryKey() {
        return true;
    }

    public LimitHandler getLimitHandler() {
        throw new UnsupportedOperationException("this dialect does not support query pagination");
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public LockingStrategy getLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_FORCE_INCREMENT -> new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            case LockMode.UPGRADE_NOWAIT, LockMode.UPGRADE_SKIPLOCKED, LockMode.PESSIMISTIC_WRITE -> new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            case LockMode.PESSIMISTIC_READ -> new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            case LockMode.OPTIMISTIC_FORCE_INCREMENT -> new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            case LockMode.OPTIMISTIC -> new OptimisticLockingStrategy(lockable, lockMode);
            case LockMode.READ -> new SelectLockingStrategy(lockable, lockMode);
            default -> throw new IllegalArgumentException("Unsupported lock mode");
        };
    }

    public String getForUpdateString(LockOptions lockOptions) {
        return this.getForUpdateString(lockOptions.getLockMode(), lockOptions.getTimeOut());
    }

    private String getForUpdateString(LockMode lockMode, int timeout) {
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadLockString(timeout);
            case LockMode.PESSIMISTIC_WRITE -> this.getWriteLockString(timeout);
            case LockMode.PESSIMISTIC_FORCE_INCREMENT, LockMode.UPGRADE_NOWAIT -> this.getForUpdateNowaitString();
            case LockMode.UPGRADE_SKIPLOCKED -> this.getForUpdateSkipLockedString();
            default -> "";
        };
    }

    public String getForUpdateString(LockMode lockMode) {
        return this.getForUpdateString(lockMode, -1);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getReadLockString(timeout);
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    public RowLockStrategy getReadRowLockStrategy() {
        return this.getWriteRowLockStrategy();
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
            LockMode lm = entry.getValue();
            if (!lm.greaterThan(lockMode)) continue;
            lockMode = lm;
        }
        lockOptions.setLockMode(lockMode);
        return this.getForUpdateString(lockOptions);
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    protected int getTimeoutInSeconds(int millis) {
        return millis == 0 ? 0 : Math.max(1, Math.round((float)millis / 1000.0f));
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getTableTypeString() {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getBeforeDropStatement() {
        return null;
    }

    @Deprecated(since="6.6")
    public String getDropTableString(String tableName) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(tableName).append(this.getCascadeConstraintsString());
        if (this.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique index" : "create index";
    }

    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public boolean hasAlterTable() {
        return true;
    }

    public String getAlterTableString(String tableName) {
        StringBuilder sb = new StringBuilder("alter table ");
        if (this.supportsIfExistsAfterAlterTable()) {
            sb.append("if exists ");
        }
        sb.append(tableName);
        return sb.toString();
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return false;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddColumnSuffixString() {
        return "";
    }

    public boolean dropConstraints() {
        return true;
    }

    public String getDropForeignKeyString() {
        return "drop constraint";
    }

    public String getDropUniqueKeyString() {
        return "drop constraint";
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterConstraintName() {
        return false;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return null;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30);
        res.append(" add constraint ").append(this.quote(constraintName)).append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + this.quote(constraintName) + " " + foreignKeyDefinition;
    }

    public boolean useCrossReferenceForeignKeys() {
        return false;
    }

    public String getCrossReferenceParentTableFilter() {
        return null;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public String getCreateUserDefinedTypeKindString() {
        return "";
    }

    public String getCreateUserDefinedTypeExtensionsString() {
        return "";
    }

    public boolean supportsIfExistsBeforeTypeName() {
        return false;
    }

    public boolean supportsIfExistsAfterTypeName() {
        return false;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public boolean supportsStandardCurrentTimestampFunction() {
        return true;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return null;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsUnionInSubquery() {
        return this.supportsUnionAll();
    }

    @Deprecated(since="6")
    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public boolean supportsNoColumnsInsert() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getCaseInsensitiveLike() {
        return "like";
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public boolean supportsTruncateWithCast() {
        return true;
    }

    public boolean supportsIsTrue() {
        return false;
    }

    public String transformSelectString(String select) {
        return select;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public int getMaxIdentifierLength() {
        return Integer.MAX_VALUE;
    }

    public String toBooleanValueString(boolean bool) {
        StringBuilder sb = new StringBuilder();
        this.appendBooleanValueString(new StringBuilderSqlAppender(sb), bool);
        return sb.toString();
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool ? (char)'1' : '0');
    }

    protected void registerKeyword(String word) {
        this.sqlKeywords.add(word.toLowerCase(Locale.ROOT));
    }

    public Set<String> getKeywords() {
        return this.sqlKeywords;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, @Nullable DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(this.sqlKeywords);
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        return builder.build();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String toQuotedIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return this.openQuote() + name + this.closeQuote();
    }

    public String quote(String name) {
        if (name == null) {
            return null;
        }
        if (name.charAt(0) == '`') {
            return this.openQuote() + name.substring(1, name.length() - 1) + this.closeQuote();
        }
        return name;
    }

    @Incubating
    public SchemaManagementTool getFallbackSchemaManagementTool(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        return new HibernateSchemaManagementTool();
    }

    public Exporter<Table> getTableExporter() {
        return this.tableExporter;
    }

    public TableMigrator getTableMigrator() {
        return this.tableMigrator;
    }

    public Cleaner getTableCleaner() {
        return this.tableCleaner;
    }

    public Exporter<UserDefinedType> getUserDefinedTypeExporter() {
        return this.userDefinedTypeExporter;
    }

    public Exporter<Sequence> getSequenceExporter() {
        return this.sequenceExporter;
    }

    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        return this.foreignKeyExporter;
    }

    public Exporter<UniqueKey> getUniqueKeyExporter() {
        return this.uniqueKeyExporter;
    }

    public Exporter<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjectExporter() {
        return this.auxiliaryObjectExporter;
    }

    public TemporaryTableExporter getTemporaryTableExporter() {
        return this.temporaryTableExporter;
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.PERSISTENT;
    }

    public String getTemporaryTableCreateOptions() {
        return null;
    }

    public String getTemporaryTableCreateCommand() {
        return switch (this.getSupportedTemporaryTableKind()) {
            default -> throw new IncompatibleClassChangeError();
            case TemporaryTableKind.PERSISTENT -> "create table";
            case TemporaryTableKind.LOCAL -> "create local temporary table";
            case TemporaryTableKind.GLOBAL -> "create global temporary table";
        };
    }

    public String getTemporaryTableDropCommand() {
        return "drop table";
    }

    public String getTemporaryTableTruncateCommand() {
        return "delete from";
    }

    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        return "";
    }

    public TempTableDdlTransactionHandling getTemporaryTableDdlTransactionHandling() {
        return TempTableDdlTransactionHandling.NONE;
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.CLEAN;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.NONE;
    }

    public boolean canCreateCatalog() {
        return false;
    }

    public String[] getCreateCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No create catalog syntax supported by " + this.getClass().getName());
    }

    public String[] getDropCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No drop catalog syntax supported by " + this.getClass().getName());
    }

    public boolean canCreateSchema() {
        return true;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema " + schemaName};
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName};
    }

    public String getCurrentSchemaCommand() {
        return null;
    }

    public SchemaNameResolver getSchemaNameResolver() {
        return DefaultSchemaNameResolver.INSTANCE;
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public String getNullColumnString(String columnType) {
        return this.getNullColumnString();
    }

    public String quoteCollation(String collation) {
        return collation;
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getUserDefinedTypeComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public ColumnAliasExtractor getColumnAliasExtractor() {
        return ColumnAliasExtractor.COLUMN_LABEL_EXTRACTOR;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean useConnectionToCreateLob() {
        return !this.useInputStreamToInsertBlob();
    }

    public boolean supportsOrdinalSelectItemReference() {
        return true;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.GREATEST;
    }

    public boolean supportsNullPrecedence() {
        return true;
    }

    public boolean requiresCastForConcatenatingNonStrings() {
        return false;
    }

    public boolean requiresFloatCastingOfIntegerDivision() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean requiresParensForTupleCounts() {
        return this.supportsTupleCounts();
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 0;
    }

    public int getParameterCountLimit() {
        return this.getInExpressionCountLimit();
    }

    public boolean forceLobAsLastValue() {
        return false;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return false;
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return false;
    }

    public UniqueDelegate getUniqueDelegate() {
        return new AlterTableUniqueDelegate(this);
    }

    public String getQueryHintString(String query, List<String> hintList) {
        String hints = String.join((CharSequence)", ", hintList);
        return StringHelper.isEmpty(hints) ? query : this.getQueryHintString(query, hints);
    }

    public String getQueryHintString(String query, String hints) {
        return query;
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.SCROLL_INSENSITIVE;
    }

    public boolean supportsOffsetInSubquery() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return true;
    }

    public boolean supportsSubqueryInSelect() {
        return true;
    }

    public boolean supportsInsertReturning() {
        return false;
    }

    public boolean supportsInsertReturningRowId() {
        return this.supportsInsertReturning();
    }

    public boolean supportsUpdateReturning() {
        return this.supportsInsertReturning();
    }

    public boolean supportsInsertReturningGeneratedKeys() {
        return false;
    }

    public boolean unquoteGetGeneratedKeys() {
        return false;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return false;
    }

    public boolean supportsLateral() {
        return false;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.NO_REF_CURSOR_INSTANCE;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return null;
    }

    public MultiKeyLoadSizingStrategy getMultiKeyLoadSizingStrategy() {
        return this.STANDARD_MULTI_KEY_LOAD_SIZING_STRATEGY;
    }

    public MultiKeyLoadSizingStrategy getBatchLoadSizingStrategy() {
        return this.getMultiKeyLoadSizingStrategy();
    }

    private int calculateBatchSize(int numberOfColumns, int numberOfKeys, boolean padToPowerOfTwo) {
        int batchSize = padToPowerOfTwo ? MathHelper.ceilingPowerOfTwo(numberOfKeys) : numberOfKeys;
        int maxBatchSize = this.getParameterCountLimit() / numberOfColumns;
        return maxBatchSize > 0 && batchSize > maxBatchSize ? maxBatchSize : batchSize;
    }

    public boolean isJdbcLogWarningsEnabledByDefault() {
        return true;
    }

    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
    }

    public boolean supportsPartitionBy() {
        return false;
    }

    public boolean supportsNamedParameters(@Nullable DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData != null && databaseMetaData.supportsNamedParameters();
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.EXPLICIT;
    }

    public boolean supportsNationalizedMethods() {
        return true;
    }

    public AggregateSupport getAggregateSupport() {
        return AggregateSupportImpl.INSTANCE;
    }

    public boolean supportsStandardArrays() {
        return false;
    }

    public boolean useArrayForMultiValuedParameters() {
        return this.supportsStandardArrays() && this.getPreferredSqlTypeCodeForArray() == 2003;
    }

    public String getArrayTypeName(String javaElementTypeName, String elementTypeName, Integer maxLength) {
        if (this.supportsStandardArrays()) {
            return maxLength == null ? elementTypeName + " array" : elementTypeName + " array[" + maxLength + "]";
        }
        return null;
    }

    public void appendArrayLiteral(SqlAppender appender, Object[] literal, JdbcLiteralFormatter<Object> elementFormatter, WrapperOptions wrapperOptions) {
        if (!this.supportsStandardArrays()) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support array literals");
        }
        appender.appendSql("ARRAY[");
        if (literal.length != 0) {
            if (literal[0] == null) {
                appender.appendSql("null");
            } else {
                elementFormatter.appendJdbcLiteral(appender, literal[0], this, wrapperOptions);
            }
            for (int i = 1; i < literal.length; ++i) {
                appender.appendSql(',');
                if (literal[i] == null) {
                    appender.appendSql("null");
                    continue;
                }
                elementFormatter.appendJdbcLiteral(appender, literal[i], this, wrapperOptions);
            }
        }
        appender.appendSql(']');
    }

    public boolean supportsDistinctFromPredicate() {
        return false;
    }

    public int getPreferredSqlTypeCodeForArray() {
        return this.supportsStandardArrays() ? 2003 : -3;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public boolean supportsNonQueryWithCTE() {
        return false;
    }

    public boolean supportsRecursiveCTE() {
        return false;
    }

    public boolean supportsConflictClauseForInsertCTE() {
        return false;
    }

    public boolean supportsValuesList() {
        return false;
    }

    public boolean supportsValuesListForInsert() {
        return true;
    }

    public boolean supportsFromClauseInUpdate() {
        return false;
    }

    public boolean supportsSkipLocked() {
        return false;
    }

    public boolean supportsNoWait() {
        return false;
    }

    public boolean supportsWait() {
        return this.supportsNoWait();
    }

    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSingleQuoteEscapedString(literal);
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("X'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return true;
    }

    public boolean supportsMaterializedLobAccess() {
        return true;
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return this.supportsMaterializedLobAccess();
    }

    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (queryOptions.getDatabaseHints() != null && !queryOptions.getDatabaseHints().isEmpty()) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        return sql;
    }

    public static String addQueryHints(String query, String hints) {
        Matcher matcher = QUERY_PATTERN.matcher(query);
        if (matcher.matches() && matcher.groupCount() > 1) {
            String startToken = matcher.group(1);
            String endToken = matcher.group(2);
            return startToken + " use index (" + hints + ") " + endToken;
        }
        return query;
    }

    protected String prependComment(String sql, String comment) {
        return "/* " + Dialect.escapeComment(comment) + " */ " + sql;
    }

    public static String escapeComment(String comment) {
        if (StringHelper.isNotEmpty(comment)) {
            String escaped = ESCAPE_CLOSING_COMMENT_PATTERN.matcher(comment).replaceAll("*\\\\/");
            return ESCAPE_OPENING_COMMENT_PATTERN.matcher(escaped).replaceAll("/\\\\*");
        }
        return comment;
    }

    public HqlTranslator getHqlTranslator() {
        return null;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return null;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return null;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.EXPRESSION;
    }

    public SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    public int getMaxVarcharLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxNVarcharLength() {
        return this.getMaxVarcharLength();
    }

    public int getMaxVarbinaryLength() {
        return this.getMaxVarcharLength();
    }

    public int getMaxVarcharCapacity() {
        return this.getMaxVarcharLength();
    }

    public int getMaxNVarcharCapacity() {
        return this.getMaxNVarcharLength();
    }

    public int getMaxVarbinaryCapacity() {
        return this.getMaxVarbinaryLength();
    }

    public long getDefaultLobLength() {
        return 0x100000L;
    }

    public int getDefaultDecimalPrecision() {
        return 38;
    }

    public int getDefaultTimestampPrecision() {
        return 6;
    }

    public int getDefaultIntervalSecondScale() {
        return 9;
    }

    public boolean doesRoundTemporalOnOverflow() {
        return true;
    }

    public int getFloatPrecision() {
        return 24;
    }

    public int getDoublePrecision() {
        return 53;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    public boolean supportsBitType() {
        return true;
    }

    protected boolean supportsPredicateAsExpression() {
        return true;
    }

    public RowLockStrategy getLockRowIdentifier(LockMode lockMode) {
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadRowLockStrategy();
            case LockMode.PESSIMISTIC_FORCE_INCREMENT, LockMode.UPGRADE_NOWAIT, LockMode.UPGRADE_SKIPLOCKED, LockMode.PESSIMISTIC_WRITE, LockMode.WRITE -> this.getWriteRowLockStrategy();
            default -> RowLockStrategy.NONE;
        };
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ") stored";
    }

    public boolean hasDataTypeBeforeGeneratedAs() {
        return true;
    }

    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new OptionalTableUpdateOperation(mutationTarget, optionalTableUpdate, factory);
    }

    public boolean canDisableConstraints() {
        return false;
    }

    public String getDisableConstraintsStatement() {
        return null;
    }

    public String getEnableConstraintsStatement() {
        return null;
    }

    public String getDisableConstraintStatement(String tableName, String name) {
        return null;
    }

    public String getEnableConstraintStatement(String tableName, String name) {
        return null;
    }

    public boolean canBatchTruncate() {
        return false;
    }

    public String[] getTruncateTableStatements(String[] tableNames) {
        if (this.canBatchTruncate()) {
            StringBuilder builder = new StringBuilder();
            for (String tableName : tableNames) {
                if (!builder.isEmpty()) {
                    builder.append(", ");
                }
                builder.append(tableName);
            }
            return new String[]{this.getTruncateTableStatement(builder.toString())};
        }
        String[] statements = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            statements[i] = this.getTruncateTableStatement(tableNames[i]);
        }
        return statements;
    }

    public String getTruncateTableStatement(String tableName) {
        return "truncate table " + tableName;
    }

    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return null;
    }

    public Boolean supportsBatchUpdates() {
        return true;
    }

    public Boolean supportsRefCursors() {
        return null;
    }

    public @Nullable String getDefaultOrdinalityColumnName() {
        return null;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, true, false).result());
    }

    public String translateExtractField(org.hibernate.query.common.TemporalUnit unit) {
        return switch (unit) {
            case org.hibernate.query.common.TemporalUnit.DAY_OF_MONTH -> "dd";
            case org.hibernate.query.common.TemporalUnit.DAY_OF_YEAR -> "dy";
            case org.hibernate.query.common.TemporalUnit.DAY_OF_WEEK -> "dw";
            case org.hibernate.query.common.TemporalUnit.OFFSET, org.hibernate.query.common.TemporalUnit.NATIVE, org.hibernate.query.common.TemporalUnit.NANOSECOND, org.hibernate.query.common.TemporalUnit.DATE, org.hibernate.query.common.TemporalUnit.TIME, org.hibernate.query.common.TemporalUnit.WEEK_OF_MONTH, org.hibernate.query.common.TemporalUnit.WEEK_OF_YEAR -> throw new IllegalArgumentException("illegal field: " + unit);
            default -> unit.toString();
        };
    }

    public String translateDurationField(org.hibernate.query.common.TemporalUnit unit) {
        return switch (unit) {
            case org.hibernate.query.common.TemporalUnit.NATIVE -> "nanosecond";
            case org.hibernate.query.common.TemporalUnit.DAY_OF_MONTH, org.hibernate.query.common.TemporalUnit.DAY_OF_YEAR, org.hibernate.query.common.TemporalUnit.DAY_OF_WEEK, org.hibernate.query.common.TemporalUnit.OFFSET, org.hibernate.query.common.TemporalUnit.DATE, org.hibernate.query.common.TemporalUnit.TIME, org.hibernate.query.common.TemporalUnit.WEEK_OF_MONTH, org.hibernate.query.common.TemporalUnit.WEEK_OF_YEAR, org.hibernate.query.common.TemporalUnit.TIMEZONE_HOUR, org.hibernate.query.common.TemporalUnit.TIMEZONE_MINUTE -> throw new IllegalArgumentException("illegal unit: " + unit);
            default -> unit.toString();
        };
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendIntervalLiteral(SqlAppender appender, Duration literal) {
        int nano = literal.getNano();
        int secondsPart = literal.toSecondsPart();
        int minutesPart = literal.toMinutesPart();
        int hoursPart = literal.toHoursPart();
        long daysPart = literal.toDaysPart();
        static enum Unit {
            day,
            hour,
            minute;

        }
        Unit unit = daysPart != 0L ? (hoursPart == 0 && minutesPart == 0 && secondsPart == 0 && nano == 0 ? Unit.day : null) : (hoursPart != 0 ? (minutesPart == 0 && secondsPart == 0 && nano == 0 ? Unit.hour : null) : (minutesPart != 0 ? (secondsPart == 0 && nano == 0 ? Unit.minute : null) : null));
        appender.appendSql("interval '");
        if (unit != null) {
            appender.appendSql(switch (unit) {
                default -> throw new IncompatibleClassChangeError();
                case Unit.day -> daysPart;
                case Unit.hour -> hoursPart;
                case Unit.minute -> minutesPart;
            });
            appender.appendSql("' ");
            appender.appendSql(unit.toString());
        } else {
            appender.appendSql("interval '");
            appender.appendSql(literal.getSeconds());
            if (nano > 0) {
                appender.appendSql('.');
                appender.appendSql(nano);
            }
            appender.appendSql("' second");
        }
    }

    public void appendIntervalLiteral(SqlAppender appender, TemporalAmount literal) {
        if (literal instanceof Duration) {
            Duration duration = (Duration)literal;
            this.appendIntervalLiteral(appender, duration);
        } else if (literal instanceof Period) {
            boolean parenthesis;
            Period period = (Period)literal;
            int years = period.getYears();
            int months = period.getMonths();
            int days = period.getDays();
            boolean bl = parenthesis = years != 0 && months != 0 || years != 0 && days != 0 || months != 0 && days != 0;
            if (parenthesis) {
                appender.appendSql('(');
            }
            boolean first = true;
            for (TemporalUnit unit : literal.getUnits()) {
                long value = literal.get(unit);
                if (value == 0L) continue;
                if (first) {
                    first = false;
                } else {
                    appender.appendSql("+");
                }
                appender.appendSql("interval '");
                appender.appendSql(value);
                appender.appendSql("' ");
                if (unit == ChronoUnit.YEARS) {
                    appender.appendSql("year");
                    continue;
                }
                if (unit == ChronoUnit.MONTHS) {
                    appender.appendSql("month");
                    continue;
                }
                assert (unit == ChronoUnit.DAYS);
                appender.appendSql("day");
            }
            if (parenthesis) {
                appender.appendSql(')');
            }
        } else {
            throw new IllegalArgumentException("Unsupported temporal amount type: " + literal);
        }
    }

    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("cast('");
        appender.appendSql(literal.toString());
        appender.appendSql("' as uuid)");
    }

    public boolean supportsTemporalLiteralOffset() {
        return false;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NONE;
    }

    public String rowId(String rowId) {
        return null;
    }

    public int rowIdSqlType() {
        return -8;
    }

    public String getRowIdColumnString(String rowId) {
        return null;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.NONE;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.NONE;
    }

    public String getCheckConstraintString(CheckConstraint checkConstraint) {
        String constraintName = checkConstraint.getName();
        String constraint = constraintName == null ? " check (" + checkConstraint.getConstraint() + ")" : " constraint " + constraintName + " check (" + checkConstraint.getConstraint() + ")";
        return this.appendCheckConstraintOptions(checkConstraint, constraint);
    }

    public String appendCheckConstraintOptions(CheckConstraint checkConstraint, String sqlCheckConstraint) {
        return sqlCheckConstraint;
    }

    public boolean supportsTableOptions() {
        return false;
    }

    public boolean supportsBindingNullSqlTypeForSetNull() {
        return false;
    }

    public boolean supportsBindingNullForSetObject() {
        return false;
    }

    public class SizeStrategyImpl
    implements SizeStrategy {
        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            Size size = new Size();
            int ddlTypeCode = jdbcType.getDdlTypeCode();
            if (length != null && length == 255L) {
                length = null;
            }
            switch (ddlTypeCode) {
                case 2003: {
                    break;
                }
                case -15: 
                case -9: 
                case -7: 
                case -3: 
                case -2: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case -16: 
                case -4: 
                case -1: {
                    size.setLength(javaType.getLongSqlLength());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    length = null;
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale != null && scale != 0) {
                        throw new IllegalArgumentException("scale has no meaning for SQL floating point types");
                    }
                    if (precision == null) break;
                    precision = (int)Math.ceil((double)precision.intValue() * LOG_BASE2OF10);
                    break;
                }
                case 92: 
                case 93: 
                case 2013: 
                case 2014: 
                case 3003: 
                case 3007: {
                    length = null;
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale == null || scale == 0) break;
                    throw new IllegalArgumentException("scale has no meaning for SQL time or timestamp types");
                }
                case 2: 
                case 3: 
                case 3100: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    size.setScale(javaType.getDefaultSqlScale(Dialect.this, jdbcType));
                }
            }
            if (precision != null) {
                size.setPrecision(precision);
            }
            if (scale != null) {
                size.setScale(scale);
            }
            if (length != null) {
                size.setLength(length);
            }
            return size;
        }
    }

    public static interface SizeStrategy {
        public Size resolveSize(JdbcType var1, JavaType<?> var2, Integer var3, Integer var4, Long var5);

        default public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Size size) {
            return this.resolveSize(jdbcType, javaType, size.getPrecision(), size.getScale(), size.getLength());
        }
    }
}

