/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.HANADialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class HANAServerConfiguration {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(HANAServerConfiguration.class);
    public static final int MAX_LOB_PREFETCH_SIZE_DEFAULT_VALUE = 1024;
    private final DatabaseVersion fullVersion;
    private final int maxLobPrefetchSize;

    public HANAServerConfiguration(DatabaseVersion fullVersion) {
        this(fullVersion, 1024);
    }

    public HANAServerConfiguration(DatabaseVersion fullVersion, int maxLobPrefetchSize) {
        this.fullVersion = fullVersion;
        this.maxLobPrefetchSize = maxLobPrefetchSize;
    }

    public DatabaseVersion getFullVersion() {
        return this.fullVersion;
    }

    public int getMaxLobPrefetchSize() {
        return this.maxLobPrefetchSize;
    }

    public static HANAServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Integer maxLobPrefetchSize = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();
                 ResultSet rs = statement.executeQuery("SELECT TOP 1 VALUE,MAP(LAYER_NAME,'DEFAULT',1,'SYSTEM',2,'DATABASE',3,4) AS LAYER FROM SYS.M_INIFILE_CONTENTS WHERE FILE_NAME='indexserver.ini' AND SECTION='session' AND KEY='max_lob_prefetch_size' ORDER BY LAYER DESC");){
                if (rs.next()) {
                    maxLobPrefetchSize = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                LOG.debug("An error occurred while trying to determine the value of the HANA parameter indexserver.ini / session / max_lob_prefetch_size.", e);
            }
        }
        if (maxLobPrefetchSize == null) {
            maxLobPrefetchSize = ConfigurationHelper.getInt("hibernate.dialect.hana.max_lob_prefetch_size", info.getConfigurationValues(), 1024);
        }
        return new HANAServerConfiguration(HANAServerConfiguration.staticDetermineDatabaseVersion(info), maxLobPrefetchSize);
    }

    static DatabaseVersion staticDetermineDatabaseVersion(DialectResolutionInfo info) {
        String versionString = info.getDatabaseVersion();
        int majorVersion = 1;
        int minorVersion = 0;
        int patchLevel = 0;
        if (versionString == null) {
            return HANADialect.MINIMUM_VERSION;
        }
        String[] components = StringHelper.split(".", versionString);
        if (components.length >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DatabaseVersion.make(majorVersion, minorVersion, patchLevel);
    }
}

