/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MyISAMStorageEngine;
import org.hibernate.dialect.MySQLCastingJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.MySQLCastingJsonJdbcType;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.MySQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.EnumJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.OrdinalEnumJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MySQLDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(8);
    private final MySQLStorageEngine storageEngine = this.createStorageEngine();
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            switch (jdbcType.getDdlTypeCode()) {
                case -7: {
                    if (length != null) {
                        return Size.length(Math.min(Math.max(length, 1L), 64L));
                    }
                }
                case 6: 
                case 7: 
                case 8: {
                    Size size = super.resolveSize(jdbcType, javaType, precision, scale, length);
                    size.setScale(Math.min(size.getPrecision(), 20));
                    return size;
                }
                case 2004: 
                case 2005: 
                case 2011: {
                    return super.resolveSize(jdbcType, javaType, precision, scale, length == null ? MySQLDialect.this.getDefaultLobLength() : length.longValue());
                }
            }
            return super.resolveSize(jdbcType, javaType, precision, scale, length);
        }
    };
    private final int maxVarcharLength;
    private final int maxVarbinaryLength;
    private final boolean noBackslashEscapesEnabled;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState != null) {
            return switch (Integer.parseInt(sqlState)) {
                case 23000 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" for key '", "'", sqle.getMessage());
                default -> null;
            };
        }
        return null;
    });

    public MySQLDialect() {
        this(MINIMUM_VERSION);
    }

    public MySQLDialect(DatabaseVersion version) {
        this(version, 4);
    }

    public MySQLDialect(DatabaseVersion version, int bytesPerCharacter) {
        this(version, bytesPerCharacter, false);
    }

    public MySQLDialect(DatabaseVersion version, MySQLServerConfiguration serverConfiguration) {
        this(version, serverConfiguration.getBytesPerCharacter(), serverConfiguration.isNoBackslashEscapesEnabled());
    }

    public MySQLDialect(DatabaseVersion version, int bytesPerCharacter, boolean noBackslashEscapes) {
        super(version);
        this.maxVarcharLength = MySQLDialect.maxVarcharLength(this.getMySQLVersion(), bytesPerCharacter);
        this.maxVarbinaryLength = MySQLDialect.maxVarbinaryLength(this.getMySQLVersion());
        this.noBackslashEscapesEnabled = noBackslashEscapes;
    }

    public MySQLDialect(DialectResolutionInfo info) {
        this(MySQLDialect.createVersion(info), MySQLServerConfiguration.fromDialectResolutionInfo(info));
        this.registerKeywords(info);
    }

    @Deprecated(since="6.6")
    protected static DatabaseVersion createVersion(DialectResolutionInfo info) {
        return MySQLDialect.createVersion(info, MINIMUM_VERSION);
    }

    protected static DatabaseVersion createVersion(DialectResolutionInfo info, DatabaseVersion defaultVersion) {
        String[] components;
        String versionString = info.getDatabaseVersion();
        if (versionString != null && (components = StringHelper.split(".-", versionString)).length >= 3) {
            try {
                int majorVersion = Integer.parseInt(components[0]);
                int minorVersion = Integer.parseInt(components[1]);
                int patchLevel = Integer.parseInt(components[2]);
                return DatabaseVersion.make(majorVersion, minorVersion, patchLevel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return info.makeCopyOrDefault(defaultVersion);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected void initDefaultProperties() {
        super.initDefaultProperties();
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
    }

    private MySQLStorageEngine createStorageEngine() {
        String storageEngine = Environment.getProperties().getProperty("hibernate.dialect.storage_engine");
        if (storageEngine == null) {
            storageEngine = System.getProperty("hibernate.dialect.storage_engine");
        }
        if (storageEngine == null) {
            return this.getDefaultMySQLStorageEngine();
        }
        if ("innodb".equalsIgnoreCase(storageEngine)) {
            return InnoDBStorageEngine.INSTANCE;
        }
        if ("myisam".equalsIgnoreCase(storageEngine)) {
            return MyISAMStorageEngine.INSTANCE;
        }
        throw new UnsupportedOperationException("The " + storageEngine + " storage engine is not supported");
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 16 -> "bit";
            case 93 -> "datetime($p)";
            case 2014 -> "timestamp($p)";
            case 2 -> this.columnType(3);
            case 1 -> "varchar($l)";
            case -15, -9 -> "varchar($l) character set utf8mb4";
            case 2004 -> "longblob";
            case 2011 -> "longtext character set utf8mb4";
            case 2005 -> "longtext";
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    public boolean stripsTrailingSpacesFromChar() {
        return true;
    }

    @Override
    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -7, 16 -> "unsigned";
            case -6, -5, 4, 5 -> "signed";
            case 6, 7, 8 -> {
                if (this.getMySQLVersion().isSameOrAfter(8, 0, 17)) {
                    yield super.castType(sqlTypeCode);
                }
                yield "decimal($p,$s)";
            }
            case 1, 12, 2005, 4001 -> "char";
            case -15, -9, 2011, 4002 -> "char character set utf8mb4";
            case -3, -2, 2004, 4003 -> "binary";
            default -> super.castType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        int maxTinyLobLen = 255;
        int maxLobLen = 65535;
        int maxMediumLobLen = 0xFFFFFF;
        CapacityDependentDdlType.Builder varcharBuilder = CapacityDependentDdlType.builder(12, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2005), this.columnType(1), this.castType(1), this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l)").withTypeCapacity(0xFFFFFFL, "mediumtext");
        if (this.getMaxVarcharLength() < 65535) {
            varcharBuilder.withTypeCapacity(65535L, "text");
        }
        ddlTypeRegistry.addDescriptor(varcharBuilder.build());
        CapacityDependentDdlType.Builder nvarcharBuilder = CapacityDependentDdlType.builder(-9, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2011), this.columnType(-15), this.castType(-15), this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l) character set utf8mb4").withTypeCapacity(0xFFFFFFL, "mediumtext character set utf8mb4");
        if (this.getMaxVarcharLength() < 65535) {
            nvarcharBuilder.withTypeCapacity(65535L, "text character set utf8mb4");
        }
        ddlTypeRegistry.addDescriptor(nvarcharBuilder.build());
        CapacityDependentDdlType.Builder varbinaryBuilder = CapacityDependentDdlType.builder(-3, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2004), this.columnType(-2), this.castType(-2), this).withTypeCapacity(this.getMaxVarbinaryLength(), "varbinary($l)").withTypeCapacity(0xFFFFFFL, "mediumblob");
        if (this.getMaxVarbinaryLength() < 65535) {
            varbinaryBuilder.withTypeCapacity(65535L, "blob");
        }
        ddlTypeRegistry.addDescriptor(varbinaryBuilder.build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4003, this.columnType(2004), this.castType(-2), this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4001, this.columnType(2005), this.castType(1), this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4002, this.columnType(2005), this.castType(1), this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2004, this.columnType(2004), this.castType(-2), (Dialect)this).withTypeCapacity(255L, "tinyblob").withTypeCapacity(0xFFFFFFL, "mediumblob").withTypeCapacity(65535L, "blob").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2005, this.columnType(2005), this.castType(1), (Dialect)this).withTypeCapacity(255L, "tinytext").withTypeCapacity(0xFFFFFFL, "mediumtext").withTypeCapacity(65535L, "text").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2011, this.columnType(2011), this.castType(-15), (Dialect)this).withTypeCapacity(255L, "tinytext character set utf8mb4").withTypeCapacity(0xFFFFFFL, "mediumtext character set utf8mb4").withTypeCapacity(65535L, "text character set utf8mb4").build());
        ddlTypeRegistry.addDescriptor(new NativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return MySQLAggregateSupport.forMySQL(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated(since="6.4")
    protected static int getCharacterSetBytesPerCharacter(DatabaseMetaData databaseMetaData) {
        if (databaseMetaData == null) return 4;
        try (Statement s = databaseMetaData.getConnection().createStatement();){
            ResultSet rs = s.executeQuery("SELECT @@character_set_database");
            if (!rs.next()) return 4;
            String characterSet = rs.getString(1);
            int collationIndex = characterSet.indexOf(95);
            int n = switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                case "utf16", "utf16le", "utf32", "utf8mb4", "gb18030" -> 4;
                case "utf8", "utf8mb3", "eucjpms", "ujis" -> 3;
                case "ucs2", "cp932", "big5", "euckr", "gb2312", "gbk", "sjis" -> 2;
                default -> 1;
            };
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 4;
    }

    private static int maxVarbinaryLength(DatabaseVersion version) {
        return 65535;
    }

    private static int maxVarcharLength(DatabaseVersion version, int bytesPerCharacter) {
        return switch (bytesPerCharacter) {
            case 1 -> 65535;
            case 2 -> Short.MAX_VALUE;
            case 3 -> 21844;
            default -> 16383;
        };
    }

    @Override
    public int getMaxVarcharLength() {
        return this.maxVarcharLength;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return this.maxVarbinaryLength;
    }

    public boolean isNoBackslashEscapesEnabled() {
        return this.noBackslashEscapesEnabled;
    }

    @Override
    public String getNullColumnString(String columnType) {
        return columnType.regionMatches(true, 0, "timestamp", 0, "timestamp".length()) ? " null" : super.getNullColumnString(columnType);
    }

    public DatabaseVersion getMySQLVersion() {
        return super.getVersion();
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case -7: {
                return jdbcTypeRegistry.getDescriptor(16);
            }
            case -2: {
                if (!"GEOMETRY".equals(columnTypeName)) break;
                jdbcTypeCode = 3200;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        return jdbcTypeCode == 1 && precision <= 4 ? displaySize : precision;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return 3018;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.cot();
        functionFactory.log();
        functionFactory.log2();
        functionFactory.log10();
        functionFactory.trim2();
        functionFactory.octetLength();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.pad_space();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.date();
        functionFactory.timestamp();
        this.time(functionContributions);
        functionFactory.utcDateTimeTimestamp();
        functionFactory.rand();
        functionFactory.crc32();
        functionFactory.sha1();
        functionFactory.sha2();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.nowCurdateCurtime();
        functionFactory.trunc_truncate();
        functionFactory.insert();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.datediff();
        functionFactory.adddateSubdateAddtimeSubtime();
        functionFactory.format_dateFormat();
        functionFactory.makedateMaketime();
        functionFactory.localtimeLocaltimestamp();
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.noArgsBuilder("localtime").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP)).setUseParenthesesWhenNoArgs(false).register();
        functionRegistry.patternDescriptorBuilder("pi", "cast(pi() as double)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(0).setArgumentListSignature("").register();
        functionRegistry.patternDescriptorBuilder("chr", "char(?1 using ascii)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionRegistry.registerAlternateKey("char", "chr");
        functionFactory.sysdateExplicitMicros();
        if (this.getMySQLVersion().isSameOrAfter(8, 0, 2)) {
            functionFactory.windowFunctions();
            if (this.getMySQLVersion().isSameOrAfter(8, 0, 11)) {
                functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
            }
        }
        functionFactory.listagg_groupConcat();
        functionFactory.jsonValue_mysql();
        functionFactory.jsonQuery_mysql();
        functionFactory.jsonExists_mysql();
        functionFactory.jsonObject_mysql();
        functionFactory.jsonArray_mysql();
        functionFactory.jsonArrayAgg_mysql();
        functionFactory.jsonObjectAgg_mysql();
        functionFactory.jsonSet_mysql();
        functionFactory.jsonRemove_mysql();
        functionFactory.jsonReplace_mysql();
        functionFactory.jsonInsert_mysql();
        functionFactory.jsonMergepatch_mysql();
        functionFactory.jsonArrayAppend_mysql();
        functionFactory.jsonArrayInsert_mysql();
        if (this.getMySQLVersion().isSameOrAfter(8)) {
            functionFactory.unnest_emulated();
            functionFactory.jsonTable_mysql();
        }
        if (this.supportsRecursiveCTE()) {
            functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, false);
        }
        functionFactory.hex("hex(?1)");
        functionFactory.sha("unhex(sha2(?1, 256))");
        functionFactory.md5("unhex(md5(?1))");
    }

    protected int getMaximumSeriesSize() {
        return 1000;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptorIfAbsent(3001, MySQLCastingJsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addTypeConstructorIfAbsent(MySQLCastingJsonArrayJdbcTypeConstructor.INSTANCE);
        typeContributions.contributeJdbcType(NullJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        jdbcTypeRegistry.addDescriptor(EnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(OrdinalEnumJdbcType.INSTANCE);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new MySQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.INTEGER_BOOLEAN) {
            switch (from) {
                case STRING: 
                case INTEGER: 
                case LONG: 
                case YN_BOOLEAN: 
                case TF_BOOLEAN: 
                case BOOLEAN: {
                    break;
                }
                default: {
                    return "abs(sign(?1))";
                }
            }
        }
        return super.castPattern(from, to);
    }

    private void time(FunctionContributions queryEngine) {
        queryEngine.getFunctionRegistry().namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).register();
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public String currentTimestamp() {
        return "current_timestamp(6)";
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.SECOND -> "(second(?2)+microsecond(?2)/1e6)";
            case TemporalUnit.WEEK -> "weekofyear(?2)";
            case TemporalUnit.DAY_OF_WEEK -> "dayofweek(?2)";
            case TemporalUnit.DAY_OF_MONTH -> "dayofmonth(?2)";
            case TemporalUnit.DAY_OF_YEAR -> "dayofyear(?2)";
            case TemporalUnit.EPOCH -> "unix_timestamp(?2)";
            default -> "?1(?2)";
        };
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "timestampadd(microsecond,(?2)/1e3,?3)";
            case TemporalUnit.NATIVE -> "timestampadd(microsecond,?2,?3)";
            default -> "timestampadd(?1,?2,?3)";
        };
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "timestampdiff(microsecond,?2,?3)*1e3";
            case TemporalUnit.NATIVE -> "timestampdiff(microsecond,?2,?3)";
            default -> "timestampdiff(?1,?2,?3)";
        };
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 19);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (temporalAccessor instanceof ZonedDateTime) {
                    temporalAccessor = ((ZonedDateTime)temporalAccessor).toOffsetDateTime();
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone, false);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 16);
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return MySQLDialect.addQueryHints(query, hints);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String cols = String.join((CharSequence)", ", foreignKey);
        String referencedCols = String.join((CharSequence)", ", primaryKey);
        return String.format(" add constraint %s foreign key (%s) references %s (%s)", constraintName, cols, referencedTable, referencedCols);
    }

    @Override
    public String getDropForeignKeyString() {
        return "drop foreign key";
    }

    @Override
    public String getDropUniqueKeyString() {
        return "drop index";
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify column " + columnName + " " + columnDefinition.trim();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean canCreateCatalog() {
        return true;
    }

    @Override
    public String[] getCreateCatalogCommand(String catalogName) {
        return new String[]{"create database " + catalogName};
    }

    @Override
    public String[] getDropCatalogCommand(String catalogName) {
        return new String[]{"drop database " + catalogName};
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid()";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public String getTableComment(String comment) {
        return " comment='" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create temporary table if not exists";
    }

    @Override
    public String getTemporaryTableDropCommand() {
        return "drop temporary table";
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.DROP;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public int getMaxAliasLength() {
        return 246;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 64;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (sqlException.getErrorCode()) {
                case 1205: 
                case 3572: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 1206: 
                case 1207: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1062: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
            }
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "41000": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "40001": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.CATALOG;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return MySQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean isJdbcLogWarningsEnabledByDefault() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return this.storageEngine.supportsCascadeDelete();
    }

    @Override
    public String getTableTypeString() {
        return this.storageEngine.getTableTypeString("engine");
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return this.storageEngine.hasSelfReferentialForeignKeyBug();
    }

    @Override
    public boolean dropConstraints() {
        return this.storageEngine.dropConstraints();
    }

    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (c) {
                case '\'': {
                    appender.appendSql('\'');
                    break;
                }
                case '\\': {
                    if (this.noBackslashEscapesEnabled) break;
                    appender.appendSql('\\');
                }
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(MySQLDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "%Y").replace("MMMM", "%M").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("ww", "%v").replace("w", "%v").replace("YYYY", "%x").replace("YYY", "%x").replace("YY", "%x").replace("Y", "%x").replace("EEEE", "%W").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("DDD", "%j").replace("DD", "%j").replace("D", "%j").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%l").replace("H", "%k").replace("mm", "%i").replace("m", "%i").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%f").replace("SSSSS", "%f").replace("SSSS", "%f").replace("SSS", "%f").replace("SS", "%f").replace("S", "%f");
    }

    private String withTimeout(String lockString, int timeout) {
        return switch (timeout) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            case -1 -> lockString;
            default -> this.supportsWait() ? lockString + " wait " + this.getTimeoutInSeconds(timeout) : lockString;
        };
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(this.supportsForShare() ? " for share" : " lock in share mode", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        if (this.supportsAliasLocks() && this.supportsForShare()) {
            return this.withTimeout(" for share of " + aliases, timeout);
        }
        return this.getReadLockString(timeout);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " skip locked" : this.getForUpdateSkipLockedString();
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " nowait" : this.getForUpdateNowaitString();
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.supportsAliasLocks() ? " for update of " + aliases : this.getForUpdateString();
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 2);
    }

    @Override
    public boolean supportsLateral() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 14);
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 14);
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.supportsAliasLocks() ? RowLockStrategy.TABLE : RowLockStrategy.NONE;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("key");
    }

    boolean supportsForShare() {
        return true;
    }

    boolean supportsAliasLocks() {
        return true;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP;
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getDisableConstraintsStatement() {
        return "set foreign_key_checks = 0";
    }

    @Override
    public String getEnableConstraintsStatement() {
        return "set foreign_key_checks = 1";
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public String appendCheckConstraintOptions(CheckConstraint checkConstraint, String sqlCheckConstraint) {
        return StringHelper.isNotEmpty(checkConstraint.getOptions()) ? sqlCheckConstraint + " " + checkConstraint.getOptions() : sqlCheckConstraint;
    }

    @Override
    public boolean supportsBindingNullSqlTypeForSetNull() {
        return true;
    }

    @Override
    public String getDual() {
        return "dual";
    }
}

