/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import oracle.jdbc.OracleConnection;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.mapping.UserDefinedArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayJdbcType
extends ArrayJdbcType
implements SqlTypedJdbcType {
    private final String typeName;
    private final String upperTypeName;

    public OracleArrayJdbcType(JdbcType elementJdbcType, String typeName) {
        super(elementJdbcType);
        this.typeName = typeName;
        this.upperTypeName = typeName == null ? null : typeName.toUpperCase(Locale.ROOT);
    }

    @Override
    public String getSqlTypeName() {
        return this.typeName;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        final ValueBinder elementBinder = this.getElementJdbcType().getBinder(pluralJavaType.getElementJavaType());
        return new BasicBinder<X>(javaTypeDescriptor, this){

            private String typeName(WrapperOptions options) {
                BasicPluralJavaType javaType = (BasicPluralJavaType)((Object)this.getJavaType());
                ArrayJdbcType jdbcType = (ArrayJdbcType)this.getJdbcType();
                return OracleArrayJdbcType.this.upperTypeName == null ? OracleArrayJdbcType.getTypeName(options, javaType, jdbcType).toUpperCase(Locale.ROOT) : OracleArrayJdbcType.this.upperTypeName;
            }

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 2003, this.typeName(options));
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 2003, this.typeName(options));
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, (Array)this.getBindValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Object arr = this.getBindValue(value, options);
                try {
                    st.setObject(name, arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            @Override
            public Array getBindValue(X value, WrapperOptions options) throws SQLException {
                OracleArrayJdbcType oracleArrayJdbcType = (OracleArrayJdbcType)this.getJdbcType();
                Object[] objects = oracleArrayJdbcType.getArray(this, elementBinder, value, options);
                String arrayTypeName = this.typeName(options);
                OracleConnection oracleConnection = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().unwrap(OracleConnection.class);
                try {
                    return oracleConnection.createOracleArray(arrayTypeName, (Object)objects);
                }
                catch (Exception e) {
                    throw new HibernateException("Couldn't create a java.sql.Array", e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return OracleArrayJdbcType.this.getArray(this, statement.getArray(name), options);
            }
        };
    }

    static String getTypeName(WrapperOptions options, BasicPluralJavaType<?> containerJavaType, ArrayJdbcType arrayJdbcType) {
        Dialect dialect = options.getSessionFactory().getJdbcServices().getDialect();
        return OracleArrayJdbcType.getTypeName(containerJavaType.getElementJavaType(), arrayJdbcType.getElementJdbcType(), dialect);
    }

    static String getTypeName(BasicType<?> elementType, Dialect dialect) {
        BasicValueConverter<?, ?> converter = elementType.getValueConverter();
        if (converter != null) {
            return dialect.getArrayTypeName(OracleArrayJdbcType.converterClassName(converter), null, null);
        }
        return OracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), elementType.getJdbcType(), dialect);
    }

    private static String converterClassName(BasicValueConverter<?, ?> converter) {
        if (converter instanceof JpaAttributeConverter) {
            JpaAttributeConverter jpaConverter = (JpaAttributeConverter)converter;
            return jpaConverter.getConverterJavaType().getJavaTypeClass().getSimpleName();
        }
        return converter.getClass().getSimpleName();
    }

    static String getTypeName(JavaType<?> elementJavaType, JdbcType elementJdbcType, Dialect dialect) {
        return dialect.getArrayTypeName(OracleArrayJdbcType.arrayClassName(elementJavaType, elementJdbcType, dialect), null, null);
    }

    private static String arrayClassName(JavaType<?> elementJavaType, JdbcType elementJdbcType, Dialect dialect) {
        Class<?> javaClass = elementJavaType.getJavaTypeClass();
        if (javaClass.isArray()) {
            return dialect.getArrayTypeName(javaClass.getComponentType().getSimpleName(), null, null);
        }
        if (elementJdbcType instanceof StructJdbcType) {
            return ((StructJdbcType)elementJdbcType).getStructTypeName();
        }
        Class<?> preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(null);
        if (preferredJavaTypeClass == javaClass) {
            return javaClass.getSimpleName();
        }
        if (preferredJavaTypeClass.isArray()) {
            return javaClass.getSimpleName() + dialect.getArrayTypeName(preferredJavaTypeClass.getComponentType().getSimpleName(), null, null);
        }
        return javaClass.getSimpleName() + preferredJavaTypeClass.getSimpleName();
    }

    @Override
    public void addAuxiliaryDatabaseObjects(JavaType<?> javaType, BasicValueConverter<?, ?> valueConverter, Size columnSize, Database database, JdbcTypeIndicators context) {
        JdbcType elementJdbcType = this.getElementJdbcType();
        if (elementJdbcType instanceof StructJdbcType) {
            return;
        }
        Dialect dialect = database.getDialect();
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        JavaType elementJavaType = pluralJavaType.getElementJavaType();
        String elementTypeName = OracleArrayJdbcType.elementType(elementJavaType, elementJdbcType, columnSize, context.getTypeConfiguration(), dialect);
        String arrayTypeName = this.arrayTypeName(elementJavaType, elementJdbcType, dialect);
        this.createUserDefinedArrayType(arrayTypeName, elementTypeName, columnSize, elementJdbcType, database);
    }

    private String arrayTypeName(JavaType<?> elementJavaType, JdbcType elementJdbcType, Dialect dialect) {
        return this.typeName == null ? OracleArrayJdbcType.getTypeName(elementJavaType, elementJdbcType, dialect) : this.typeName;
    }

    private void createUserDefinedArrayType(String arrayTypeName, String elementTypeName, Size columnSize, JdbcType elementJdbcType, Database database) {
        Namespace defaultNamespace = database.getDefaultNamespace();
        UserDefinedArrayType userDefinedArrayType = defaultNamespace.createUserDefinedArrayType(Identifier.toIdentifier(arrayTypeName), name -> new UserDefinedArrayType("orm", defaultNamespace, (Identifier)name));
        userDefinedArrayType.setArraySqlTypeCode(this.getDdlTypeCode());
        userDefinedArrayType.setElementTypeName(elementTypeName);
        userDefinedArrayType.setElementSqlTypeCode(elementJdbcType.getDefaultSqlTypeCode());
        userDefinedArrayType.setElementDdlTypeCode(elementJdbcType.getDdlTypeCode());
        userDefinedArrayType.setArrayLength(columnSize.getArrayLength() == null ? 127 : columnSize.getArrayLength());
    }

    private static String elementType(JavaType<?> elementJavaType, JdbcType elementJdbcType, Size columnSize, TypeConfiguration typeConfiguration, Dialect dialect) {
        return typeConfiguration.getDdlTypeRegistry().getTypeName(elementJdbcType.getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(elementJdbcType, elementJavaType, columnSize), new BasicTypeImpl(elementJavaType, elementJdbcType));
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, String name) throws SQLException {
        callableStatement.registerOutParameter(name, 2003, this.upperTypeName);
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        callableStatement.registerOutParameter(index, 2003, this.upperTypeName);
    }

    @Override
    public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
        return this.getElementJdbcType().getExtraCreateTableInfo(pluralJavaType.getElementJavaType(), columnName, tableName, database);
    }

    @Override
    public String getFriendlyName() {
        return this.typeName;
    }

    @Override
    public String toString() {
        return "OracleArrayTypeDescriptor(" + this.typeName + ")";
    }
}

