/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.GenerationType;
import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.OracleBooleanJdbcType;
import org.hibernate.dialect.OracleEnumJdbcType;
import org.hibernate.dialect.OracleJdbcHelper;
import org.hibernate.dialect.OracleJsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.OracleJsonJdbcType;
import org.hibernate.dialect.OracleOrdinalEnumJdbcType;
import org.hibernate.dialect.OracleReflectionStructJdbcType;
import org.hibernate.dialect.OracleServerConfiguration;
import org.hibernate.dialect.OracleSqlAstTranslator;
import org.hibernate.dialect.OracleUserDefinedTypeExporter;
import org.hibernate.dialect.OracleXmlArrayJdbcTypeConstructor;
import org.hibernate.dialect.OracleXmlJdbcType;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.OracleAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.ModeStatsModeEmulation;
import org.hibernate.dialect.function.OracleTruncFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Oracle12cIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.Oracle12LimitHandler;
import org.hibernate.dialect.sequence.OracleSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.OracleCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsNullTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.OracleJsonBlobJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleDialect
extends Dialect {
    private static final Pattern DISTINCT_KEYWORD_PATTERN = Pattern.compile("\\bdistinct\\b", 2);
    private static final Pattern GROUP_BY_KEYWORD_PATTERN = Pattern.compile("\\bgroup\\s+by\\b", 2);
    private static final Pattern ORDER_BY_KEYWORD_PATTERN = Pattern.compile("\\border\\s+by\\b", 2);
    private static final Pattern UNION_KEYWORD_PATTERN = Pattern.compile("\\bunion\\b", 2);
    private static final Pattern SQL_STATEMENT_TYPE_PATTERN = Pattern.compile("^(?:/\\*.*?\\*/)?\\s*(select|insert|update|delete)\\s+.*?", 2);
    private static final int PARAM_LIST_SIZE_LIMIT_1000 = 1000;
    private static final int PARAM_LIST_SIZE_LIMIT_65535 = 65535;
    public static final String PREFER_LONG_RAW = "hibernate.dialect.oracle.prefer_long_raw";
    private static final String yqmSelect = "(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH') + (least(extract(day from %2$s), extract(day from last_day(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH')))) - 1))";
    private static final String ADD_YEAR_EXPRESSION = String.format("(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH') + (least(extract(day from %2$s), extract(day from last_day(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH')))) - 1))", "?2*12", "?3");
    private static final String ADD_QUARTER_EXPRESSION = String.format("(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH') + (least(extract(day from %2$s), extract(day from last_day(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH')))) - 1))", "?2*3", "?3");
    private static final String ADD_MONTH_EXPRESSION = String.format("(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH') + (least(extract(day from %2$s), extract(day from last_day(trunc(%2$s, 'MONTH') + numtoyminterval(%1$s, 'MONTH')))) - 1))", "?2", "?3");
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(19);
    private final OracleUserDefinedTypeExporter userDefinedTypeExporter = new OracleUserDefinedTypeExporter(this);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    private final SequenceSupport oracleSequenceSupport = OracleSequenceSupport.getInstance(this);
    private final StandardTableExporter oracleTableExporter = new StandardTableExporter(this){

        @Override
        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (this.dialect.getVersion().isBefore(23, 6) && jdbcType.isXml()) {
                return;
            }
            super.applyAggregateColumnCheck(buf, aggregateColumn);
        }
    };
    protected final boolean autonomous;
    protected final boolean extended;
    protected final boolean applicationContinuity;
    protected final int driverMajorVersion;
    protected final int driverMinorVersion;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
        case 1, 2291, 2292 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("(", ")", sqle.getMessage());
        case 1400 -> null;
        default -> null;
    });

    public OracleDialect() {
        this(MINIMUM_VERSION);
    }

    public OracleDialect(DatabaseVersion version) {
        super(version);
        this.autonomous = false;
        this.extended = false;
        this.applicationContinuity = false;
        this.driverMajorVersion = 19;
        this.driverMinorVersion = 0;
    }

    public OracleDialect(DialectResolutionInfo info) {
        this(info, OracleServerConfiguration.fromDialectResolutionInfo(info));
    }

    public OracleDialect(DialectResolutionInfo info, OracleServerConfiguration serverConfiguration) {
        super(info);
        this.autonomous = serverConfiguration.isAutonomous();
        this.extended = serverConfiguration.isExtended();
        this.applicationContinuity = serverConfiguration.isApplicationContinuity();
        this.driverMinorVersion = serverConfiguration.getDriverMinorVersion();
        this.driverMajorVersion = serverConfiguration.getDriverMajorVersion();
    }

    @Deprecated(since="6.4")
    protected static boolean isExtended(DialectResolutionInfo info) {
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            boolean bl;
            block9: {
                Statement statement = databaseMetaData.getConnection().createStatement();
                try {
                    statement.execute("select cast('string' as varchar2(32000)) from dual");
                    bl = true;
                    if (statement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                statement.close();
            }
            return bl;
        }
        return ConfigurationHelper.getBoolean("hibernate.dialect.oracle.extended_string_size", info.getConfigurationValues(), false);
    }

    @Deprecated(since="6.4")
    protected static boolean isAutonomous(DialectResolutionInfo info) {
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            boolean bl;
            block9: {
                Statement statement = databaseMetaData.getConnection().createStatement();
                try {
                    bl = statement.executeQuery("select 1 from dual where sys_context('USERENV','CLOUD_SERVICE') in ('OLTP','DWCS','JSON')").next();
                    if (statement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                statement.close();
            }
            return bl;
        }
        return ConfigurationHelper.getBoolean("hibernate.dialect.oracle.is_autonomous", info.getConfigurationValues(), false);
    }

    public boolean isAutonomous() {
        return this.autonomous;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isApplicationContinuity() {
        return this.applicationContinuity;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isSameOrAfter(23) ? super.getPreferredSqlTypeCodeForBoolean() : -7;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isSameOrAfter(23)) {
            appender.appendSql(bool);
        } else {
            super.appendBooleanValueString(appender, bool);
        }
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.initcap();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.systimestamp();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.everyAny_minMaxCase();
        functionFactory.repeat_rpad();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionFactory.median();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.characterLength_length("dbms_lob.getlength(?1)");
        functionFactory.octetLength_pattern("lengthb(?1)", "dbms_lob.getlength(?1)*2");
        functionFactory.bitLength_pattern("lengthb(?1)*8", "dbms_lob.getlength(?1)*16");
        functionFactory.coalesce();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitor", "(?1+?2-bitand(?1,?2))").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1+?2-2*bitand(?1,?2))").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        functionFactory.listagg(null);
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionContributions.getFunctionRegistry().register("mode", new ModeStatsModeEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("trunc", new OracleTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionFactory.array_oracle();
        functionFactory.arrayAggregate_jsonArrayagg();
        functionFactory.arrayPosition_oracle();
        functionFactory.arrayPositions_oracle();
        functionFactory.arrayLength_oracle();
        functionFactory.arrayConcat_oracle();
        functionFactory.arrayPrepend_oracle();
        functionFactory.arrayAppend_oracle();
        functionFactory.arrayContains_oracle();
        functionFactory.arrayIntersects_oracle();
        functionFactory.arrayGet_oracle();
        functionFactory.arraySet_oracle();
        functionFactory.arrayRemove_oracle();
        functionFactory.arrayRemoveIndex_oracle();
        functionFactory.arraySlice_oracle();
        functionFactory.arrayReplace_oracle();
        functionFactory.arrayTrim_oracle();
        functionFactory.arrayFill_oracle();
        functionFactory.arrayToString_oracle();
        functionFactory.jsonValue_oracle();
        functionFactory.jsonQuery_oracle();
        functionFactory.jsonExists_oracle();
        functionFactory.jsonObject_oracle(this.getVersion().isSameOrAfter(19));
        functionFactory.jsonArray_oracle();
        functionFactory.jsonArrayAgg_oracle();
        functionFactory.jsonObjectAgg_oracle();
        functionFactory.jsonSet_oracle();
        functionFactory.jsonRemove_oracle();
        functionFactory.jsonReplace_oracle();
        functionFactory.jsonInsert_oracle();
        functionFactory.jsonMergepatch_oracle();
        functionFactory.jsonArrayAppend_oracle();
        functionFactory.jsonArrayInsert_oracle();
        functionFactory.xmlelement();
        functionFactory.xmlcomment();
        functionFactory.xmlforest();
        functionFactory.xmlconcat();
        functionFactory.xmlpi();
        functionFactory.xmlquery_oracle();
        functionFactory.xmlexists();
        functionFactory.xmlagg();
        functionFactory.xmltable_oracle();
        functionFactory.unnest_oracle();
        functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), true, false);
        functionFactory.jsonTable_oracle();
        functionFactory.hex("rawtohex(?1)");
        functionFactory.sha("standard_hash(?1, 'SHA256')");
        functionFactory.md5("standard_hash(?1, 'MD5')");
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    @Override
    public int getMaxVarcharLength() {
        return this.extended ? Short.MAX_VALUE : 4000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return this.extended ? Short.MAX_VALUE : 2000;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new OracleSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String currentDate() {
        return "current_date";
    }

    @Override
    public String currentTime() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestamp() {
        return this.currentTimestampWithTimeZone();
    }

    @Override
    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    @Override
    public String currentLocalTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public boolean supportsInsertReturningGeneratedKeys() {
        return true;
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger(from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean(from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean(from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("true", "false") : BooleanDecoder.toBoolean(from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean(from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case BOOLEAN: 
                    case INTEGER_BOOLEAN: 
                    case TF_BOOLEAN: 
                    case YN_BOOLEAN: {
                        return BooleanDecoder.toString(from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                    }
                    case OFFSET_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                    }
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                    }
                }
                break;
            }
            case CLOB: {
                return "to_clob(?1)";
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
            }
            case OFFSET_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
            }
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
            }
            case XML: {
                return "xmlparse(document ?1)";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.DAY_OF_WEEK -> "to_number(to_char(?2,'D'))";
            case TemporalUnit.DAY_OF_MONTH -> "to_number(to_char(?2,'DD'))";
            case TemporalUnit.DAY_OF_YEAR -> "to_number(to_char(?2,'DDD'))";
            case TemporalUnit.WEEK -> "to_number(to_char(?2,'IW'))";
            case TemporalUnit.WEEK_OF_YEAR -> "to_number(to_char(?2,'WW'))";
            case TemporalUnit.QUARTER -> "to_number(to_char(?2,'Q'))";
            case TemporalUnit.HOUR -> "to_number(to_char(?2,'HH24'))";
            case TemporalUnit.MINUTE -> "to_number(to_char(?2,'MI'))";
            case TemporalUnit.SECOND -> "to_number(to_char(?2,'SS'))";
            case TemporalUnit.EPOCH -> "trunc((cast(?2 at time zone 'UTC' as date) - date '1970-1-1')*86400)";
            default -> super.extractPattern(unit);
        };
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case YEAR: {
                pattern.append(ADD_YEAR_EXPRESSION);
                break;
            }
            case QUARTER: {
                pattern.append(ADD_QUARTER_EXPRESSION);
                break;
            }
            case MONTH: {
                pattern.append(ADD_MONTH_EXPRESSION);
                break;
            }
            case WEEK: {
                if (temporalType != TemporalType.DATE) {
                    pattern.append("(?3+numtodsinterval((?2)*7,'day'))");
                    break;
                }
                pattern.append("(?3+(?2)").append(unit.conversionFactor(TemporalUnit.DAY, this)).append(")");
                break;
            }
            case DAY: {
                if (temporalType == TemporalType.DATE) {
                    pattern.append("(?3+(?2))");
                    break;
                }
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                pattern.append("(?3+numtodsinterval(?2,'?1'))");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?3+numtodsinterval((?2)/1e9,'second'))");
                break;
            }
            case NATIVE: {
                pattern.append("(?3+numtodsinterval(?2,'second'))");
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean hasTimePart = toTemporalType != TemporalType.DATE || fromTemporalType != TemporalType.DATE;
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                break;
            }
            case QUARTER: 
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, unit);
                pattern.append(")");
                break;
            }
            case DAY: {
                if (hasTimePart) {
                    pattern.append("(cast(?3 as date)-cast(?2 as date))");
                    break;
                }
                pattern.append("(?3-?2)");
                break;
            }
            case WEEK: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                if (hasTimePart) {
                    pattern.append("((cast(?3 as date)-cast(?2 as date))");
                } else {
                    pattern.append("((?3-?2)");
                }
                pattern.append(TemporalUnit.DAY.conversionFactor(unit, this));
                pattern.append(")");
                break;
            }
            case NANOSECOND: 
            case NATIVE: {
                if (hasTimePart) {
                    if (this.supportsLateral()) {
                        pattern.append("(select extract(day from t.i)").append(TemporalUnit.DAY.conversionFactor(unit, this)).append("+extract(hour from t.i)").append(TemporalUnit.HOUR.conversionFactor(unit, this)).append("+extract(minute from t.i)").append(TemporalUnit.MINUTE.conversionFactor(unit, this)).append("+extract(second from t.i)").append(TemporalUnit.SECOND.conversionFactor(unit, this)).append(" from(select ?3-?2 i from dual)t");
                    } else {
                        pattern.append("(");
                        this.extractField(pattern, TemporalUnit.DAY, unit);
                        pattern.append("+");
                        this.extractField(pattern, TemporalUnit.HOUR, unit);
                        pattern.append("+");
                        this.extractField(pattern, TemporalUnit.MINUTE, unit);
                        pattern.append("+");
                        this.extractField(pattern, TemporalUnit.SECOND, unit);
                    }
                } else {
                    pattern.append("((?3-?2)");
                    pattern.append(TemporalUnit.DAY.conversionFactor(unit, this));
                }
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("Unrecognized field: " + unit);
            }
        }
        return pattern.toString();
    }

    private void extractField(StringBuilder pattern, TemporalUnit unit, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateExtractField(unit));
        pattern.append(" from (?3-?2)");
        switch (unit) {
            case YEAR: 
            case MONTH: {
                pattern.append(" year(9) to month");
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case DAY: {
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        pattern.append(")");
        pattern.append(unit.conversionFactor(toUnit, this));
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                if (this.getVersion().isSameOrAfter(23)) {
                    return super.columnType(sqlTypeCode);
                }
            }
            case -7: {
                return "number(1,0)";
            }
            case -6: {
                return "number(3,0)";
            }
            case 5: {
                return "number(5,0)";
            }
            case 4: {
                return "number(10,0)";
            }
            case -5: {
                return "number(19,0)";
            }
            case 7: {
                return "float(24)";
            }
            case 8: {
                return "float(53)";
            }
            case 2: 
            case 3: {
                return "number($p,$s)";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "timestamp($p)";
            }
            case 2013: {
                return "timestamp($p) with time zone";
            }
            case 12: {
                return "varchar2($l char)";
            }
            case -9: {
                return "nvarchar2($l)";
            }
            case -3: 
            case -2: {
                return "raw($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "SYS.XMLTYPE", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "MDSYS.SDO_GEOMETRY", this));
        if (this.getVersion().isSameOrAfter(21)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        } else {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "blob", this));
        }
        ddlTypeRegistry.addDescriptor(new ArrayDdlTypeImpl(this, false));
        ddlTypeRegistry.addDescriptor(4000, new ArrayDdlTypeImpl(this, false));
        if (this.getVersion().isSameOrAfter(23)) {
            ddlTypeRegistry.addDescriptor(new NamedNativeEnumDdlTypeImpl(this));
            ddlTypeRegistry.addDescriptor(new NamedNativeOrdinalEnumDdlTypeImpl(this));
        }
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(-7, "number(1,0)", this));
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    protected void initDefaultProperties() {
        super.initDefaultProperties();
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "true");
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public boolean getDefaultUseGetGeneratedKeys() {
        return true;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2016: {
                return jdbcTypeRegistry.getDescriptor(3001);
            }
            case 2002: {
                if ("MDSYS.SDO_GEOMETRY".equals(columnTypeName)) {
                    jdbcTypeCode = 3200;
                    break;
                }
                SqlTypedJdbcType descriptor = jdbcTypeRegistry.findSqlTypedDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (descriptor == null) break;
                return descriptor;
            }
            case 2003: {
                if ("MDSYS.SDO_ORDINATE_ARRAY".equals(columnTypeName)) {
                    return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(2), ColumnTypeInformation.EMPTY);
                }
                SqlTypedJdbcType descriptor = jdbcTypeRegistry.findSqlTypedDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (descriptor == null) break;
                return descriptor;
            }
            case 2: {
                if (precision > 8 && scale == -127) {
                    if (precision <= 24) {
                        return jdbcTypeRegistry.getDescriptor(6);
                    }
                    if (precision <= 53) {
                        return jdbcTypeRegistry.getDescriptor(8);
                    }
                }
            }
            case 3: {
                if (scale != 0 || precision == 0) break;
                if (precision <= 10) {
                    return jdbcTypeRegistry.getDescriptor(4);
                }
                if (precision > 19) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public boolean supportsBitType() {
        return false;
    }

    @Override
    public String getArrayTypeName(String javaElementTypeName, String elementTypeName, Integer maxLength) {
        return (javaElementTypeName == null ? elementTypeName : javaElementTypeName) + "Array";
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return 2003;
    }

    @Override
    public Exporter<UserDefinedType> getUserDefinedTypeExporter() {
        return this.userDefinedTypeExporter;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        if (ConfigurationHelper.getPreferredSqlTypeCodeForBoolean(serviceRegistry, this) == -7) {
            typeContributions.contributeJdbcType(OracleBooleanJdbcType.INSTANCE);
        }
        typeContributions.contributeJdbcType(OracleXmlJdbcType.INSTANCE);
        typeContributions.contributeJdbcTypeConstructor(OracleXmlArrayJdbcTypeConstructor.INSTANCE);
        if (OracleJdbcHelper.isUsable(serviceRegistry)) {
            typeContributions.contributeJdbcType(OracleJdbcHelper.getStructJdbcType(serviceRegistry));
        } else {
            typeContributions.contributeJdbcType(OracleReflectionStructJdbcType.INSTANCE);
        }
        boolean preferLong = serviceRegistry.requireService(ConfigurationService.class).getSetting(PREFER_LONG_RAW, StandardConverters.BOOLEAN, Boolean.valueOf(false));
        typeContributions.contributeJdbcType(preferLong ? BlobJdbcType.PRIMITIVE_ARRAY_BINDING : BlobJdbcType.DEFAULT);
        if (this.getVersion().isSameOrAfter(21)) {
            typeContributions.contributeJdbcType(OracleJsonJdbcType.INSTANCE);
            typeContributions.contributeJdbcTypeConstructor(OracleJsonArrayJdbcTypeConstructor.NATIVE_INSTANCE);
        } else {
            typeContributions.contributeJdbcType(OracleJsonBlobJdbcType.INSTANCE);
            typeContributions.contributeJdbcTypeConstructor(OracleJsonArrayJdbcTypeConstructor.BLOB_INSTANCE);
        }
        if (OracleJdbcHelper.isUsable(serviceRegistry)) {
            typeContributions.contributeJdbcTypeConstructor(OracleJdbcHelper.getArrayJdbcTypeConstructor(serviceRegistry));
            typeContributions.contributeJdbcTypeConstructor(OracleJdbcHelper.getNestedTableJdbcTypeConstructor(serviceRegistry));
        } else {
            typeContributions.contributeJdbcType(OracleReflectionStructJdbcType.INSTANCE);
        }
        typeContributions.contributeJdbcType(NullJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(ObjectNullAsNullTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        if (this.getVersion().isSameOrAfter(23)) {
            JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
            jdbcTypeRegistry.addDescriptor(OracleEnumJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(OracleOrdinalEnumJdbcType.INSTANCE);
        }
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return OracleAggregateSupport.valueOf(this);
    }

    @Override
    public GenerationType getNativeValueGenerationStrategy() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return Oracle12cIdentityColumnSupport.INSTANCE;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return Oracle12LimitHandler.INSTANCE;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return this.getVersion().isSameOrAfter(23) ? "select systimestamp" : "select systimestamp from dual";
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return this.getVersion().isSameOrAfter(23) ? SelectItemReferenceStrategy.ALIAS : SelectItemReferenceStrategy.EXPRESSION;
    }

    @Override
    public boolean supportsValuesList() {
        return this.getVersion().isSameOrAfter(23);
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(23);
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion().isSameOrAfter(23);
    }

    @Override
    public boolean supportsIfExistsBeforeTypeName() {
        return this.getVersion().isSameOrAfter(23);
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify " + columnName + " " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.oracleSequenceSupport;
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.oracleTableExporter;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return this.getVersion().isSameOrAfter(23) ? "select rawtohex(sys_guid())" : "select rawtohex(sys_guid()) from dual";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
            case 30006 -> new LockTimeoutException(message, sqlException, sql);
            case 54 -> new LockTimeoutException(message, sqlException, sql);
            case 4021 -> new LockTimeoutException(message, sqlException, sql);
            case 60 -> new LockAcquisitionException(message, sqlException, sql);
            case 4020 -> new LockAcquisitionException(message, sqlException, sql);
            case 1013 -> new QueryTimeoutException(message, sqlException, sql);
            case 1 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case 1407 -> new ConstraintViolationException(message, sqlException, sql, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            default -> null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, -10);
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return this.getVersion().isSameOrAfter(23) ? 65535 : 1000;
    }

    @Override
    public boolean forceLobAsLastValue() {
        return true;
    }

    @Override
    public boolean isEmptyStringTreatedAsNull() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    @Override
    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        if (StringHelper.isEmpty(sql) || queryOptions == null) {
            return true;
        }
        return DISTINCT_KEYWORD_PATTERN.matcher(sql).find() || GROUP_BY_KEYWORD_PATTERN.matcher(sql).find() || UNION_KEYWORD_PATTERN.matcher(sql).find() || ORDER_BY_KEYWORD_PATTERN.matcher(sql).find() && queryOptions.hasLimit() || queryOptions.hasLimit() && queryOptions.getLimit().getFirstRow() != null;
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        String statementType = this.statementType(sql);
        int start = sql.indexOf(statementType);
        if (start < 0) {
            return sql;
        }
        int end = start + statementType.length();
        return sql.substring(0, end) + " /*+ " + hints + " */" + sql.substring(end);
    }

    @Override
    public int getMaxAliasLength() {
        return 118;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 9;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return OracleCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return this.getVersion().isSameOrAfter(23) ? "select sys_context('USERENV','CURRENT_SCHEMA')" : "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL";
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    private String statementType(String sql) {
        Matcher matcher = SQL_STATEMENT_TYPE_PATTERN.matcher(sql);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't determine SQL statement type for statement: " + sql);
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return " for update of " + aliases;
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return " for update of " + aliases + " nowait";
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return " for update skip locked";
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return " for update of " + aliases + " skip locked";
    }

    private String withTimeout(String lockString, int timeout) {
        return switch (timeout) {
            case 0 -> {
                if (this.supportsNoWait()) {
                    yield lockString + " nowait";
                }
                yield lockString;
            }
            case -2 -> {
                if (this.supportsSkipLocked()) {
                    yield lockString + " skip locked";
                }
                yield lockString;
            }
            case -1 -> lockString;
            default -> this.supportsWait() ? lockString + " wait " + this.getTimeoutInSeconds(timeout) : lockString;
        };
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return false;
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            appender.appendSql("timestamp '");
            DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, true, jdbcTimeZone, false);
            appender.appendSql('\'');
        } else {
            super.appendDateTimeLiteral(appender, temporalAccessor, precision, jdbcTimeZone);
        }
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, true, true).result());
    }

    public static Replacer datetimeFormat(String format, boolean useFm, boolean resetFm) {
        String fm = useFm ? "fm" : "";
        String fmReset = resetFm ? fm : "";
        return new Replacer(format, "'", "\"").replace("GG", "AD").replace("G", "AD").replace("yyyy", "YYYY").replace("yyy", fm + "YYYY" + fmReset).replace("yy", "YY").replace("y", fm + "YYYY" + fmReset).replace("MMMM", fm + "Month" + fmReset).replace("MMM", "Mon").replace("MM", "MM").replace("M", fm + "MM" + fmReset).replace("ww", "IW").replace("w", fm + "IW" + fmReset).replace("YYYY", "IYYY").replace("YYY", fm + "IYYY" + fmReset).replace("YY", "IY").replace("Y", fm + "IYYY" + fmReset).replace("W", "W").replace("EEEE", fm + "Day" + fmReset).replace("EEE", "Dy").replace("ee", "D").replace("e", fm + "D" + fmReset).replace("dd", "DD").replace("d", fm + "DD" + fmReset).replace("DDD", "DDD").replace("DD", fm + "DDD" + fmReset).replace("D", fm + "DDD" + fmReset).replace("a", "AM").replace("hh", "HH12").replace("HH", "HH24").replace("h", fm + "HH12" + fmReset).replace("H", fm + "HH24" + fmReset).replace("mm", "MI").replace("m", fm + "MI" + fmReset).replace("ss", "SS").replace("s", fm + "SS" + fmReset).replace("SSSSSS", "FF6").replace("SSSSS", "FF5").replace("SSSS", "FF4").replace("SSS", "FF3").replace("SS", "FF2").replace("S", "FF1").replace("zzz", "TZR").replace("zz", "TZR").replace("z", "TZR").replace("ZZZ", "TZHTZM").replace("ZZ", "TZHTZM").replace("Z", "TZHTZM").replace("xxx", "TZH:TZM").replace("xx", "TZHTZM").replace("x", "TZH");
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("hextoraw('");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql("')");
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, -10);
        return 1;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getDisableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " disable constraint " + name;
    }

    @Override
    public String getEnableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " enable constraint " + name;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String getCreateUserDefinedTypeKindString() {
        return "object";
    }

    @Override
    public String rowId(String rowId) {
        return "rowid";
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        OracleSqlAstTranslator translator = new OracleSqlAstTranslator(factory, optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        return this.getVersion().isSameOrAfter(23) ? name : super.getEnumTypeDeclaration(name, values);
    }

    @Override
    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        StringBuilder domain = new StringBuilder();
        domain.append("create domain ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            domain.append(separator).append(value);
            separator = ", ";
        }
        domain.append(')');
        return new String[]{domain.toString()};
    }

    public static String[] getCreateVarcharEnumTypeCommand(String name, String[] values) {
        StringBuilder domain = new StringBuilder();
        domain.append("create domain ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            domain.append(separator).append(value).append("='").append(value).append("'");
            separator = ", ";
        }
        domain.append(')');
        return new String[]{domain.toString()};
    }

    @Override
    public String[] getDropEnumTypeCommand(String name) {
        return new String[]{"drop domain if exists " + name + " force"};
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public String appendCheckConstraintOptions(CheckConstraint checkConstraint, String sqlCheckConstraint) {
        return StringHelper.isNotEmpty(checkConstraint.getOptions()) ? sqlCheckConstraint + " " + checkConstraint.getOptions() : sqlCheckConstraint;
    }

    @Override
    public String getDual() {
        return "dual";
    }

    @Override
    public String getFromDualForSelectOnly() {
        return this.getVersion().isSameOrAfter(23) ? "" : " from " + this.getDual();
    }
}

