/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2StructJdbcType;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2AggregateSupport
extends AggregateSupportImpl {
    public static final AggregateSupport INSTANCE = new DB2AggregateSupport(false);
    public static final AggregateSupport JSON_INSTANCE = new DB2AggregateSupport(true);
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_JSON_END = "')";
    private static final String XML_EXTRACT_START = "xmlelement(name \"e\",xmlquery(";
    private static final String XML_EXTRACT_SEPARATOR = "/*' passing ";
    private static final String XML_EXTRACT_END = " as \"d\"))";
    private final boolean jsonSupport;

    public DB2AggregateSupport(boolean jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && aggregateParentReadExpression.endsWith(JSON_QUERY_JSON_END) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_JSON_END.length()) + "." : aggregateParentReadExpression + ",'$.";
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 16: {
                        if (SqlTypes.isNumericType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                            return template.replace(placeholder, "decode(json_value(" + parentPartExpression + columnExpression + "'),'true',1,'false',0)");
                        }
                        return template.replace(placeholder, "decode(json_value(" + parentPartExpression + columnExpression + "'),'true',true,'false',false)");
                    }
                    case 2014: 
                    case 3003: {
                        return template.replace(placeholder, "cast(trim(trailing 'Z' from json_value(" + parentPartExpression + columnExpression + "' returning varchar(35))) as " + column.getColumnDefinition() + ")");
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "hextoraw(json_value(" + parentPartExpression + columnExpression + "'))");
                    }
                    case 3000: {
                        return template.replace(placeholder, "hextoraw(replace(json_value(" + parentPartExpression + columnExpression + "'),'-',''))");
                    }
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, JSON_QUERY_START + parentPartExpression + columnExpression + JSON_QUERY_JSON_END);
                    }
                }
                return template.replace(placeholder, "json_value(" + parentPartExpression + columnExpression + "' returning " + column.getColumnDefinition() + ")");
            }
            case 2009: 
            case 3019: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 16: {
                        if (SqlTypes.isNumericType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                            return template.replace(placeholder, "decode(xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as varchar(5)),'true',1,'false',0)");
                        }
                        return template.replace(placeholder, "decode(xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as varchar(5)),'true',true,'false',false)");
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "hextoraw(xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as clob))");
                    }
                    case 2014: 
                    case 3003: {
                        return template.replace(placeholder, "cast(trim(trailing 'Z' from xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as varchar(35))) as " + column.getColumnDefinition() + ")");
                    }
                    case 2009: {
                        return template.replace(placeholder, XML_EXTRACT_START + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + "))");
                    }
                    case 3019: {
                        if (typeConfiguration.getCurrentBaseSqlTypeIndicators().isXmlFormatMapperLegacyFormatEnabled()) {
                            throw new IllegalArgumentException("XML array '" + columnExpression + "' in '" + aggregateParentReadExpression + "' is not supported with legacy format enabled.");
                        }
                        return template.replace(placeholder, "xmlelement(name \"Collection\",xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + "))");
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, "hextoraw(replace(xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as varchar(36)),'-',''))");
                    }
                }
                return template.replace(placeholder, "xmlcast(xmlquery(" + DB2AggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + ") as " + column.getColumnDefinition() + ")");
            }
            case 2002: {
                return template.replace(placeholder, aggregateParentReadExpression + ".." + columnExpression);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String xmlExtractArguments(String aggregateParentReadExpression, String xpathFragment) {
        Object extractArguments;
        int separatorIndex;
        if (aggregateParentReadExpression.startsWith(XML_EXTRACT_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_EXTRACT_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_EXTRACT_START.length() + xpathFragment.length());
            sb.append(aggregateParentReadExpression, XML_EXTRACT_START.length(), separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex + 2, aggregateParentReadExpression.length() - 2);
            extractArguments = sb.toString();
        } else {
            extractArguments = "'$d/e/" + xpathFragment + "' passing " + aggregateParentReadExpression + " as \"d\"";
        }
        return extractArguments;
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "hex(" + customWriteExpression + ")";
            }
            case 3000: {
                return "regexp_replace(lower(hex(" + customWriteExpression + ")),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','$1-$2-$3-$4-$5')";
            }
            case 2003: 
            case 3018: {
                return "(" + customWriteExpression + ") format json";
            }
            case 92: {
                return "varchar_format(timestamp('1970-01-01'," + customWriteExpression + "),'HH24:MI:SS')";
            }
            case 93: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')";
            }
            case 3003: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')||'Z'";
            }
        }
        return customWriteExpression;
    }

    private static String xmlCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "hex(" + customWriteExpression + ")";
            }
            case 3000: {
                return "regexp_replace(lower(hex(" + customWriteExpression + ")),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','$1-$2-$3-$4-$5')";
            }
            case 16: {
                return "decode(" + customWriteExpression + ",true,'true',false,'false')";
            }
            case 92: {
                return "varchar_format(timestamp('1970-01-01'," + customWriteExpression + "),'HH24:MI:SS')";
            }
            case 93: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')";
            }
            case 3003: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')||'Z'";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                return aggregateParentAssignmentExpression;
            }
            case 2009: 
            case 3019: {
                return aggregateParentAssignmentExpression;
            }
            case 2002: {
                return aggregateParentAssignmentExpression + ".." + columnExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public String aggregateCustomWriteExpression(AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int sqlTypeCode = aggregateColumn.getType().getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode == 2003 ? aggregateColumn.getTypeCode() : sqlTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                return null;
            }
            case 2009: 
            case 3019: {
                return null;
            }
            case 2002: {
                StringBuilder sb = new StringBuilder();
                DB2AggregateSupport.appendStructCustomWriteExpression(aggregateColumn, aggregatedColumns, sb);
                return sb.toString();
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumn.getTypeCode());
    }

    private static void appendStructCustomWriteExpression(ColumnTypeInformation aggregateColumnType, List<Column> aggregatedColumns, StringBuilder sb) {
        sb.append(aggregateColumnType.getTypeName()).append("()");
        for (Column udtColumn : aggregatedColumns) {
            sb.append("..").append(udtColumn.getName()).append('(');
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendStructCustomWriteExpression(aggregateColumn, aggregateColumn.getComponent().getAggregatedColumns(), sb);
            } else {
                sb.append("cast(? as ").append(udtColumn.getSqlType()).append(')');
            }
            sb.append(')');
        }
    }

    @Override
    public int aggregateComponentSqlTypeCode(int aggregateColumnSqlTypeCode, int columnSqlTypeCode) {
        return switch (aggregateColumnSqlTypeCode) {
            case 2002 -> {
                if (columnSqlTypeCode == 16) {
                    yield 5;
                }
                yield columnSqlTypeCode;
            }
            case 3001 -> {
                if (columnSqlTypeCode == 2003) {
                    yield 3018;
                }
                yield columnSqlTypeCode;
            }
            case 2009 -> {
                if (columnSqlTypeCode == 2003) {
                    yield 3019;
                }
                yield columnSqlTypeCode;
            }
            default -> columnSqlTypeCode;
        };
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 2002 || aggregateSqlTypeCode == 3001 || aggregateSqlTypeCode == 2009;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                if (!this.jsonSupport) break;
                return new RootJsonWriteExpression(aggregateColumn, columnsToUpdate);
            }
            case 2009: {
                return new RootXmlWriteExpression(aggregateColumn, columnsToUpdate);
            }
            case 2002: {
                return new RootStructWriteExpression(aggregateColumn, columnsToUpdate, typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private static String determineTypeName(SelectableMapping column, TypeConfiguration typeConfiguration) {
        if (column.getColumnDefinition() == null) {
            DdlType ddlType = typeConfiguration.getDdlTypeRegistry().getDescriptor(column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode());
            Size size = new Size();
            size.setLength(column.getLength());
            size.setPrecision(column.getPrecision());
            size.setScale(column.getScale());
            return ddlType.getCastTypeName(size, (SqlExpressible)((Object)column.getJdbcMapping()), typeConfiguration.getDdlTypeRegistry());
        }
        String typeName = column.getColumnDefinition();
        return typeName;
    }

    @Override
    public boolean preferSelectAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public boolean preferBindAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public List<AuxiliaryDatabaseObject> aggregateAuxiliaryDatabaseObjects(Namespace namespace, String aggregatePath, AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        if (aggregateColumn.getTypeCode() != 2002) {
            return Collections.emptyList();
        }
        String columnType = aggregateColumn.getTypeName();
        boolean legacyXmlFormatEnabled = aggregateColumn.getValue().getBuildingContext().getBuildingOptions().isXmlFormatMapperLegacyFormatEnabled();
        ArrayList<AuxiliaryDatabaseObject> list = new ArrayList<AuxiliaryDatabaseObject>(3);
        StringBuilder serializerSb = new StringBuilder();
        StringBuilder deserializerSb = new StringBuilder();
        serializerSb.append("create function ").append(columnType).append("_serializer(v ").append(columnType).append(") returns xml language sql ").append("return xmlelement(name \"").append("e").append("\"");
        DB2AggregateSupport.appendSerializer(aggregatedColumns, serializerSb, "v..", legacyXmlFormatEnabled);
        serializerSb.append(')');
        deserializerSb.append("create function ").append(columnType).append("_deserializer(v xml) returns ").append(columnType).append(" language sql ").append("return select ").append(columnType).append("()");
        DB2AggregateSupport.appendDeserializerConstructor(aggregatedColumns, deserializerSb, "", legacyXmlFormatEnabled);
        deserializerSb.append(" from xmltable('$").append("e").append("' passing v as \"").append("e").append("\" columns");
        DB2AggregateSupport.appendDeserializerColumns(aggregatedColumns, deserializerSb, ' ', "", legacyXmlFormatEnabled);
        deserializerSb.append(") as t");
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " serializer", namespace, serializerSb.toString(), "drop function " + columnType + "_serializer", Set.of(DB2Dialect.class.getName())));
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " deserializer", namespace, deserializerSb.toString(), "drop function " + columnType + "_deserializer", Set.of(DB2Dialect.class.getName())));
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " transform", namespace, "create transform for " + columnType + " db2_program (from sql with function " + columnType + "_serializer, to sql with function " + columnType + "_deserializer)", "drop transform db2_program for " + columnType, Set.of(DB2Dialect.class.getName())));
        return list;
    }

    private static void appendSerializer(List<Column> aggregatedColumns, StringBuilder serializerSb, String prefix, boolean legacyXmlFormatEnabled) {
        int sep;
        if (aggregatedColumns.size() > 1) {
            serializerSb.append(",xmlconcat");
            sep = 40;
        } else {
            sep = 44;
        }
        for (Column udtColumn : aggregatedColumns) {
            serializerSb.append((char)sep);
            serializerSb.append("xmlelement(name \"").append(udtColumn.getName()).append("\"");
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendSerializer(aggregateColumn.getComponent().getAggregatedColumns(), serializerSb, prefix + udtColumn.getName() + "..", legacyXmlFormatEnabled);
            } else if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                if (legacyXmlFormatEnabled) {
                    serializerSb.append(",cast(").append(prefix).append(udtColumn.getName()).append(" as ");
                    long binaryLength = udtColumn.getColumnSize(null, null).getLength();
                    long varcharLength = (binaryLength << 2) / 3L;
                    if (varcharLength < 32672L) {
                        serializerSb.append("varchar(").append(varcharLength).append(") for bit data)");
                    } else {
                        serializerSb.append("clob)");
                    }
                } else {
                    serializerSb.append(",hex(").append(prefix).append(udtColumn.getName()).append(")");
                }
            } else {
                serializerSb.append(',').append(prefix).append(udtColumn.getName());
            }
            serializerSb.append(')');
            sep = 44;
        }
        if (aggregatedColumns.size() > 1) {
            serializerSb.append(')');
        }
    }

    private static void appendDeserializerConstructor(List<Column> aggregatedColumns, StringBuilder deserializerSb, String prefix, boolean legacyXmlFormatEnabled) {
        for (Column udtColumn : aggregatedColumns) {
            deserializerSb.append("..").append(udtColumn.getName()).append('(');
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                deserializerSb.append(udtColumn.getSqlType()).append("()");
                DB2AggregateSupport.appendDeserializerConstructor(aggregateColumn.getComponent().getAggregatedColumns(), deserializerSb, udtColumn.getName() + "_", legacyXmlFormatEnabled);
                deserializerSb.append(')');
                continue;
            }
            if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                if (legacyXmlFormatEnabled) {
                    deserializerSb.append("cast(t.").append(prefix).append(udtColumn.getName()).append(" as ").append(udtColumn.getSqlType()).append("))");
                    continue;
                }
                deserializerSb.append("cast(hextoraw(t.").append(prefix).append(udtColumn.getName()).append(") as ").append(udtColumn.getSqlType()).append("))");
                continue;
            }
            deserializerSb.append("t.").append(prefix).append(udtColumn.getName()).append(')');
        }
    }

    private static void appendDeserializerColumns(List<Column> aggregatedColumns, StringBuilder deserializerSb, char sep, String prefix, boolean legacyXmlFormatEnabled) {
        for (Column udtColumn : aggregatedColumns) {
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendDeserializerColumns(aggregateColumn.getComponent().getAggregatedColumns(), deserializerSb, sep, udtColumn.getName() + "_", legacyXmlFormatEnabled);
            } else {
                deserializerSb.append(sep);
                deserializerSb.append(prefix).append(udtColumn.getName()).append(' ');
                if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                    long binaryLength = udtColumn.getColumnSize(null, null).getLength();
                    long varcharLength = legacyXmlFormatEnabled ? (binaryLength << 2) / 3L : binaryLength << 1;
                    if (varcharLength < 32672L) {
                        deserializerSb.append("varchar(").append(varcharLength).append(") for bit data");
                    } else {
                        deserializerSb.append("clob");
                    }
                } else {
                    deserializerSb.append(udtColumn.getSqlType());
                }
                deserializerSb.append(" path '/").append("e").append('/').append(udtColumn.getName()).append('\'');
            }
            sep = (char)44;
        }
    }

    private static boolean needsVarcharForBitDataCast(String columnType) {
        String columTypeLC = columnType.toLowerCase(Locale.ROOT).trim();
        return columTypeLC.contains("binary") || columTypeLC.startsWith("char") && columTypeLC.endsWith(" bit data");
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class RootXmlWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final SelectableMapping aggregateColumn;
        private final SelectableMapping[] columns;

        RootXmlWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.aggregateColumn = aggregateColumn;
            this.columns = columns;
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            sqlAppender.append("xmldocument(xmlquery('transform copy $d-out:=if(empty($d-in)) then <");
            sqlAppender.append("e");
            sqlAppender.append("/> else $d-in/");
            sqlAppender.append("e");
            sqlAppender.append(" modify ");
            int separator = 40;
            for (SelectableMapping column : this.columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                String tagXPath = this.columnXPath(selectablePath);
                String columnVariable = this.columnVariable(selectablePath);
                sqlAppender.append((char)separator);
                sqlAppender.append("if(empty($");
                sqlAppender.append(columnVariable);
                sqlAppender.append(")) then do delete $d-out");
                sqlAppender.append(tagXPath);
                sqlAppender.append(" else if(empty($d-out");
                sqlAppender.append(tagXPath);
                sqlAppender.append(")) then");
                SelectablePath parentPath = selectablePath.getParent();
                assert (parentPath != null);
                this.renderParentInserts(sqlAppender, parentPath, "{$" + columnVariable + "}");
                sqlAppender.append(" do insert $");
                sqlAppender.append(columnVariable);
                sqlAppender.append(" into $d-out");
                sqlAppender.append(this.columnXPath(selectablePath.getParent()));
                sqlAppender.append(" else do replace $d-out");
                sqlAppender.append(tagXPath);
                sqlAppender.append(" with $");
                sqlAppender.append(columnVariable);
                separator = 44;
            }
            sqlAppender.append(") return <");
            sqlAppender.append("e");
            sqlAppender.append(">{$d-out/*}</");
            sqlAppender.append("e");
            sqlAppender.append(">' passing ");
            if (qualifier != null && !qualifier.isBlank()) {
                sqlAppender.append(qualifier);
                sqlAppender.append('.');
            }
            sqlAppender.append(this.aggregateColumn.getSelectionExpression());
            sqlAppender.append(" as \"d-in\"");
            for (SelectableMapping column : this.columns) {
                sqlAppender.append(",xmlelement(name ");
                sqlAppender.appendDoubleQuoteEscapedString(column.getSelectableName());
                sqlAppender.append(',');
                this.appendColumn(sqlAppender, column, DB2AggregateSupport.xmlCustomWriteExpression(column.getCustomWriteExpression(), column.getJdbcMapping()), translator, aggregateColumnWriteExpression);
                sqlAppender.append(" option null on null) as ");
                sqlAppender.appendDoubleQuoteEscapedString(this.columnVariable(column.getSelectablePath()));
            }
            sqlAppender.append("))");
        }

        private void renderParentInserts(SqlAppender sqlAppender, SelectablePath parentPath, String parentContent) {
            if (!parentPath.isRoot()) {
                String newParentContent = "<" + parentPath.getSelectableName() + ">" + parentContent + "</" + parentPath.getSelectableName() + ">";
                SelectablePath grandParentPath = parentPath.getParent();
                assert (grandParentPath != null);
                sqlAppender.append(" if(empty($d-out");
                sqlAppender.append(this.columnXPath(parentPath));
                sqlAppender.append(")) then");
                this.renderParentInserts(sqlAppender, grandParentPath, newParentContent);
                sqlAppender.append(" do insert ");
                sqlAppender.append(newParentContent);
                sqlAppender.append(" into $d-out");
                sqlAppender.append(this.columnXPath(grandParentPath));
                sqlAppender.append(" else");
            }
        }

        private String columnXPath(SelectablePath selectablePath) {
            SelectablePath[] parts = selectablePath.getParts();
            StringBuilder xpath = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                xpath.append('/');
                xpath.append(parts[i].getSelectableName());
            }
            return xpath.toString();
        }

        private String columnVariable(SelectablePath selectablePath) {
            SelectablePath[] parts = selectablePath.getParts();
            StringBuilder variable = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                variable.append(parts[i].getSelectableName());
                variable.append('-');
            }
            variable.append("in");
            return variable.toString();
        }

        private void appendColumn(SqlAppender sb, SelectableMapping selectableMapping, String customWriteExpression, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            boolean isArray;
            String customWriteExpressionEnd;
            String customWriteExpressionStart;
            if (customWriteExpression.equals("?")) {
                customWriteExpressionStart = "";
                customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                customWriteExpressionStart = parts[0];
                customWriteExpressionEnd = parts[1];
            }
            boolean bl = isArray = selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 3019;
            if (isArray) {
                sb.append("xmlquery('$d/*/*' passing ");
            }
            sb.append(customWriteExpressionStart);
            translator.render(expression.getValueExpression(selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(customWriteExpressionEnd);
            if (isArray) {
                sb.append(" as \"d\")");
            }
        }
    }

    private static class RootStructWriteExpression
    extends AggregateStructWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String selectableName;

        RootStructWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            super(aggregateColumn);
            this.selectableName = aggregateColumn.getSelectableName();
            this.initializeSubExpressions(columns, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object path = qualifier == null || qualifier.isBlank() ? this.selectableName : qualifier + "." + this.selectableName;
            this.append(sqlAppender, (String)path, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughJsonWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("' value ");
            sb.append(path);
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("' value ");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, DB2AggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                JsonWriteExpression jsonWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (jsonWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughJsonWriteExpression(selectableMapping));
                    continue;
                }
                if (!(jsonWriteExpression instanceof AggregateJsonWriteExpression)) continue;
                AggregateJsonWriteExpression writeExpression = (AggregateJsonWriteExpression)jsonWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("json_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = DB2AggregateSupport.JSON_QUERY_START + path + ",'$." + column + "') format json";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("' value coalesce(");
                    value.append(sb, subPath, translator, expression);
                    sb.append(",json_object())");
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    private static class BasicStructWriteExpression
    implements AggregateWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String typeName;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicStructWriteExpression(SelectableMapping selectableMapping, String typeName, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            this.typeName = typeName;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("cast(");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.DEFAULT);
            sb.append(this.customWriteExpressionEnd);
            sb.append(" as ");
            sb.append(this.typeName);
            sb.append(')');
        }
    }

    private static class AggregateStructWriteExpression
    implements AggregateWriteExpression {
        private final LinkedHashMap<String, AggregateWriteExpression> subExpressions = new LinkedHashMap();
        protected final EmbeddableMappingType embeddableMappingType;
        protected final String structTypeName;
        protected final boolean nullable;

        public AggregateStructWriteExpression(SelectableMapping selectableMapping) {
            DB2StructJdbcType structJdbcType = (DB2StructJdbcType)selectableMapping.getJdbcMapping().getJdbcType();
            this.embeddableMappingType = structJdbcType.getEmbeddableMappingType();
            this.structTypeName = structJdbcType.getStructTypeName();
            this.nullable = selectableMapping.isNullable();
        }

        protected void initializeSubExpressions(SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                String typeName = DB2AggregateSupport.determineTypeName(column, typeConfiguration);
                AggregateStructWriteExpression currentAggregate = this;
                EmbeddableMappingType currentMappingType = this.embeddableMappingType;
                for (int i = 1; i < parts.length - 1; ++i) {
                    SelectableMapping selectableMapping = currentMappingType.getJdbcValueSelectable(currentMappingType.getSelectableIndex(parts[i].getSelectableName()));
                    currentAggregate = (AggregateStructWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateStructWriteExpression(selectableMapping));
                    currentMappingType = currentAggregate.embeddableMappingType;
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicStructWriteExpression(column, typeName, customWriteExpression));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            if (this.nullable) {
                sb.append("coalesce(");
                sb.append(path);
                sb.append(",");
                sb.append(this.structTypeName);
                sb.append("())");
            } else {
                sb.append(path);
            }
            for (Map.Entry<String, AggregateWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                AggregateWriteExpression value = entry.getValue();
                sb.append("..");
                sb.append(column);
                sb.append('(');
                value.append(sb, path + ".." + column, translator, expression);
                sb.append(')');
            }
        }
    }

    static interface AggregateWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

