/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.spi.TypeConfiguration;

public class MySQLAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport JSON_INSTANCE = new MySQLAggregateSupport(true, false);
    private static final AggregateSupport JSON_WITH_UUID_INSTANCE = new MySQLAggregateSupport(true, true);
    private static final AggregateSupport LONGTEXT_INSTANCE = new MySQLAggregateSupport(false, false);
    private final boolean jsonType;
    private final boolean uuidFunctions;

    private MySQLAggregateSupport(boolean jsonType, boolean uuidFunctions) {
        this.jsonType = jsonType;
        this.uuidFunctions = uuidFunctions;
    }

    public static AggregateSupport forMySQL(Dialect dialect) {
        return dialect.getVersion().isSameOrAfter(8) ? JSON_WITH_UUID_INSTANCE : (dialect.getVersion().isSameOrAfter(5, 7) ? JSON_INSTANCE : AggregateSupportImpl.INSTANCE);
    }

    public static AggregateSupport forTiDB(Dialect dialect) {
        return JSON_WITH_UUID_INSTANCE;
    }

    public static AggregateSupport forMariaDB(Dialect dialect) {
        return LONGTEXT_INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, this.queryExpression(aggregateParentReadExpression, columnExpression));
                    }
                    case 16: {
                        return template.replace(placeholder, this.jsonType ? "case " + this.queryExpression(aggregateParentReadExpression, columnExpression) + " when cast('true' as json) then true when cast('false' as json) then false end" : "case " + this.queryExpression(aggregateParentReadExpression, columnExpression) + " when 'true' then true when 'false' then false end");
                    }
                    case -3: 
                    case -2: 
                    case 4003: {
                        return template.replace(placeholder, "unhex(json_unquote(" + this.queryExpression(aggregateParentReadExpression, columnExpression) + "))");
                    }
                    case 3000: {
                        if (!column.getJdbcMapping().getJdbcType().isBinary()) break;
                        if (this.uuidFunctions) {
                            return template.replace(placeholder, "uuid_to_bin(json_unquote(" + this.queryExpression(aggregateParentReadExpression, columnExpression) + "))");
                        }
                        return template.replace(placeholder, "unhex(replace(json_unquote(" + this.queryExpression(aggregateParentReadExpression, columnExpression) + "),'-',''))");
                    }
                }
                return template.replace(placeholder, this.valueExpression(aggregateParentReadExpression, columnExpression, this.columnCastType(column)));
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private String columnCastType(SqlTypedMapping column) {
        return switch (column.getJdbcMapping().getJdbcType().getDdlTypeCode()) {
            case -7, 16 -> "unsigned";
            case -6, -5, 4, 5 -> "signed";
            case 7 -> "float";
            case 8 -> "double";
            case 6 -> {
                if (this.jsonType) {
                    yield column.getColumnDefinition();
                }
                if (column.getPrecision() == null || column.getPrecision() == 53) {
                    yield "double";
                }
                yield "float";
            }
            case 1, 12, 2005, 4001, 6000 -> "char";
            case -15, -9, 2011, 4002 -> "char character set utf8mb4";
            case -3, -2, 2004, 4003 -> "binary";
            default -> column.getColumnDefinition();
        };
    }

    private String valueExpression(String aggregateParentReadExpression, String columnExpression, String columnType) {
        return "cast(json_unquote(" + this.queryExpression(aggregateParentReadExpression, columnExpression) + ") as " + columnType + ")";
    }

    private String queryExpression(String aggregateParentReadExpression, String columnExpression) {
        if (this.jsonType) {
            return "nullif(json_extract(" + aggregateParentReadExpression + ",'$." + columnExpression + "'),cast('null' as json))";
        }
        return "nullif(json_extract(" + aggregateParentReadExpression + ",'$." + columnExpression + "'),'null')";
    }

    private String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "hex(" + customWriteExpression + ")";
            }
            case 16: {
                return "(" + customWriteExpression + ")=true";
            }
            case 93: {
                return "date_format(" + customWriteExpression + ",'%Y-%m-%dT%T.%f')";
            }
            case 3003: {
                return "date_format(" + customWriteExpression + ",'%Y-%m-%dT%T.%fZ')";
            }
            case 3000: {
                if (!jdbcMapping.getJdbcType().isBinary()) break;
                if (this.uuidFunctions) {
                    return "bin_to_uuid(" + customWriteExpression + ")";
                }
                return "regexp_replace(lower(hex(" + customWriteExpression + ")),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','$1-$2-$3-$4-$5')";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return true;
            }
        }
        return false;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
        return new RootJsonWriteExpression(aggregateColumn, columns);
    }

    private class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            sqlAppender.appendSql("json_set(");
            if (this.nullable) {
                sqlAppender.append("coalesce(");
                sqlAppender.append((CharSequence)basePath);
                sqlAppender.append(",json_object())");
            } else {
                sqlAppender.append((CharSequence)basePath);
            }
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
            sqlAppender.append(')');
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("'$.");
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("',");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, MySQLAggregateSupport.this.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = MySQLAggregateSupport.this.queryExpression(path, column);
                sb.append(',');
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append("'$.");
                    sb.append(column);
                    sb.append("',json_set(coalesce(");
                    sb.append(subPath);
                    sb.append(",json_object())");
                    value.append(sb, subPath, translator, expression);
                    sb.append(')');
                    continue;
                }
                value.append(sb, subPath, translator, expression);
            }
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

