/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleArrayJdbcType;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UserDefinedArrayType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.TypeConfigurationWrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport V23_INSTANCE = new OracleAggregateSupport(true, JsonSupport.OSON);
    private static final AggregateSupport V21_INSTANCE = new OracleAggregateSupport(false, JsonSupport.OSON);
    private static final AggregateSupport V19_INSTANCE = new OracleAggregateSupport(false, JsonSupport.MERGEPATCH);
    private static final AggregateSupport V18_INSTANCE = new OracleAggregateSupport(false, JsonSupport.QUERY_AND_PATH);
    private static final AggregateSupport V12_INSTANCE = new OracleAggregateSupport(false, JsonSupport.QUERY);
    private static final AggregateSupport LEGACY_INSTANCE = new OracleAggregateSupport(false, JsonSupport.NONE);
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_JSON_END = "' returning json)";
    private static final String JSON_QUERY_BLOB_END = "' returning blob)";
    private static final String XML_EXTRACT_START = "xmlelement(\"e\",xmlquery(";
    private static final String XML_EXTRACT_SEPARATOR = "/*' passing ";
    private static final String XML_EXTRACT_END = " returning content))";
    private static final String XML_QUERY_START = "xmlquery(";
    private static final String XML_QUERY_SEPARATOR = "' passing ";
    private static final String XML_QUERY_END = " returning content)";
    private final boolean checkConstraintSupport;
    private final JsonSupport jsonSupport;

    private OracleAggregateSupport(boolean checkConstraintSupport, JsonSupport jsonSupport) {
        this.checkConstraintSupport = checkConstraintSupport;
        this.jsonSupport = jsonSupport;
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        DatabaseVersion version = dialect.getVersion();
        switch (version.getMajor()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return V12_INSTANCE;
            }
            case 18: {
                return V18_INSTANCE;
            }
            case 19: 
            case 20: {
                return V19_INSTANCE;
            }
            case 21: 
            case 22: {
                return V21_INSTANCE;
            }
        }
        return version.isSameOrAfter(23) ? V23_INSTANCE : LEGACY_INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                String jsonTypeName = "json";
                switch (this.jsonSupport) {
                    case MERGEPATCH: 
                    case QUERY_AND_PATH: 
                    case QUERY: {
                        jsonTypeName = "blob";
                    }
                    case OSON: {
                        String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && (aggregateParentReadExpression.endsWith(JSON_QUERY_JSON_END) || aggregateParentReadExpression.endsWith(JSON_QUERY_BLOB_END)) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_JSON_END.length()) + "." : aggregateParentReadExpression + ",'$.";
                        switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                            case -7: 
                            case 16: {
                                JdbcLiteralFormatter<?> jdbcLiteralFormatter = column.getJdbcMapping().getJdbcType().getJdbcLiteralFormatter(column.getJdbcMapping().getMappedJavaType());
                                Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
                                TypeConfigurationWrapperOptions wrapperOptions = new TypeConfigurationWrapperOptions(typeConfiguration);
                                String trueLiteral = jdbcLiteralFormatter.toJdbcLiteral(true, dialect, wrapperOptions);
                                String falseLiteral = jdbcLiteralFormatter.toJdbcLiteral(false, dialect, wrapperOptions);
                                return template.replace(placeholder, "decode(json_value(" + parentPartExpression + columnExpression + "'),'true'," + trueLiteral + ",'false'," + falseLiteral + ",null)");
                            }
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: 
                            case 2005: 
                            case 2011: {
                                return template.replace(placeholder, "json_value(" + parentPartExpression + columnExpression + "' returning " + column.getColumnDefinition() + ")");
                            }
                            case 91: {
                                return template.replace(placeholder, "to_date(json_value(" + parentPartExpression + columnExpression + "'),'YYYY-MM-DD')");
                            }
                            case 92: {
                                return template.replace(placeholder, "to_timestamp(json_value(" + parentPartExpression + columnExpression + "'),'hh24:mi:ss')");
                            }
                            case 93: {
                                return template.replace(placeholder, "to_timestamp(json_value(" + parentPartExpression + columnExpression + "'),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9')");
                            }
                            case 2014: 
                            case 3003: {
                                return template.replace(placeholder, "to_timestamp_tz(json_value(" + parentPartExpression + columnExpression + "'),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9TZH:TZM')");
                            }
                            case 3000: {
                                return template.replace(placeholder, "hextoraw(replace(json_value(" + parentPartExpression + columnExpression + "'),'-',''))");
                            }
                            case -3: 
                            case -2: 
                            case 4003: {
                                if (OracleAggregateSupport.determineLength(column) * 2L < 4000L) {
                                    return template.replace(placeholder, "hextoraw(json_value(" + parentPartExpression + columnExpression + "'))");
                                }
                            }
                            case 2004: {
                                return template.replace(placeholder, "xmlcast(xmlcdata(json_value(" + parentPartExpression + columnExpression + "' returning clob))) as " + column.getColumnDefinition() + ")");
                            }
                            case 2003: {
                                BasicPluralType pluralType = (BasicPluralType)column.getJdbcMapping();
                                OracleArrayJdbcType jdbcType = (OracleArrayJdbcType)pluralType.getJdbcType();
                                switch (jdbcType.getElementJdbcType().getDefaultSqlTypeCode()) {
                                    case -3: 
                                    case -2: 
                                    case 16: 
                                    case 91: 
                                    case 92: 
                                    case 93: 
                                    case 2014: 
                                    case 3000: 
                                    case 3003: 
                                    case 4003: {
                                        return template.replace(placeholder, jdbcType.getSqlTypeName() + "_from_json(json_query(" + parentPartExpression + columnExpression + "' returning " + jsonTypeName + "))");
                                    }
                                }
                                return template.replace(placeholder, "json_value(" + parentPartExpression + columnExpression + "' returning " + column.getColumnDefinition() + ")");
                            }
                            case 3001: 
                            case 3018: {
                                return template.replace(placeholder, JSON_QUERY_START + parentPartExpression + columnExpression + "' returning " + jsonTypeName + ")");
                            }
                        }
                        return template.replace(placeholder, "cast(json_value(" + parentPartExpression + columnExpression + "') as " + column.getColumnDefinition() + ")");
                    }
                    case NONE: {
                        throw new UnsupportedOperationException("The Oracle version doesn't support JSON aggregates!");
                    }
                }
            }
            case 2009: 
            case 3019: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case -7: 
                    case 16: {
                        JdbcLiteralFormatter<?> jdbcLiteralFormatter = column.getJdbcMapping().getJdbcType().getJdbcLiteralFormatter(column.getJdbcMapping().getMappedJavaType());
                        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
                        TypeConfigurationWrapperOptions wrapperOptions = new TypeConfigurationWrapperOptions(typeConfiguration);
                        String trueLiteral = jdbcLiteralFormatter.toJdbcLiteral(true, dialect, wrapperOptions);
                        String falseLiteral = jdbcLiteralFormatter.toJdbcLiteral(false, dialect, wrapperOptions);
                        return template.replace(placeholder, "decode(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(5)),'true'," + trueLiteral + ",'false'," + falseLiteral + ",null)");
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return template.replace(placeholder, "cast(replace(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar2(255)),'.',substr(to_char(0.1),1,1)) as " + column.getColumnDefinition() + ")");
                    }
                    case 91: {
                        return template.replace(placeholder, "to_date(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(35)),'YYYY-MM-DD')");
                    }
                    case 92: {
                        return template.replace(placeholder, "to_timestamp(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(35)),'hh24:mi:ss')");
                    }
                    case 93: {
                        return template.replace(placeholder, "to_timestamp(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(35)),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9')");
                    }
                    case 2014: 
                    case 3003: {
                        return template.replace(placeholder, "to_timestamp_tz(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(35)),'YYYY-MM-DD\"T\"hh24:mi:ss.FF9TZH:TZM')");
                    }
                    case 2003: {
                        throw new UnsupportedOperationException("Transforming XML_ARRAY to native arrays is not supported on Oracle!");
                    }
                    case 2009: {
                        return template.replace(placeholder, XML_EXTRACT_START + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + "))");
                    }
                    case 3019: {
                        if (typeConfiguration.getCurrentBaseSqlTypeIndicators().isXmlFormatMapperLegacyFormatEnabled()) {
                            throw new IllegalArgumentException("XML array '" + columnExpression + "' in '" + aggregateParentReadExpression + "' is not supported with legacy format enabled.");
                        }
                        return template.replace(placeholder, "xmlelement(\"Collection\",xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + "))");
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, "hextoraw(replace(xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as varchar(36)),'-',''))");
                    }
                }
                return template.replace(placeholder, "xmlcast(xmlquery(" + OracleAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/text()") + ") as " + column.getColumnDefinition() + ")");
            }
            case 2002: 
            case 3016: 
            case 3017: {
                return template.replace(placeholder, aggregateParentReadExpression + "." + columnExpression);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String xmlExtractArguments(String aggregateParentReadExpression, String xpathFragment) {
        Object extractArguments;
        int separatorIndex;
        if (aggregateParentReadExpression.startsWith(XML_EXTRACT_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_EXTRACT_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_EXTRACT_START.length() + xpathFragment.length());
            sb.append(aggregateParentReadExpression, XML_EXTRACT_START.length(), separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex + 2, aggregateParentReadExpression.length() - 2);
            extractArguments = sb.toString();
        } else if (aggregateParentReadExpression.startsWith(XML_QUERY_START) && aggregateParentReadExpression.endsWith(XML_QUERY_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_QUERY_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_QUERY_START.length() + xpathFragment.length());
            sb.append(aggregateParentReadExpression, XML_QUERY_START.length(), separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex, aggregateParentReadExpression.length() - 1);
            extractArguments = sb.toString();
        } else {
            extractArguments = "'/e/" + xpathFragment + XML_QUERY_SEPARATOR + aggregateParentReadExpression + " returning content";
        }
        return extractArguments;
    }

    private static long determineLength(SqlTypedMapping column) {
        Long length = column.getLength();
        if (length != null) {
            return length;
        }
        String columnDefinition = column.getColumnDefinition();
        assert (columnDefinition != null);
        int parenthesisIndex = columnDefinition.indexOf(40);
        if (parenthesisIndex != -1) {
            int end;
            for (end = parenthesisIndex + 1; end < columnDefinition.length() && Character.isDigit(columnDefinition.charAt(end)); ++end) {
            }
            return Long.parseLong(columnDefinition.substring(parenthesisIndex + 1, end));
        }
        return 4000L;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 2009: 
            case 3001: 
            case 3018: 
            case 3019: {
                return aggregateParentAssignmentExpression;
            }
            case 2002: 
            case 3016: 
            case 3017: {
                return aggregateParentAssignmentExpression + "." + columnExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping, SelectableMapping column, TypeConfiguration typeConfiguration) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (this.jsonSupport) {
            case MERGEPATCH: 
            case QUERY_AND_PATH: 
            case QUERY: 
            case OSON: {
                switch (sqlTypeCode) {
                    case 2005: {
                        return "to_clob(" + customWriteExpression + ")";
                    }
                    case 3000: {
                        return "regexp_replace(lower(rawtohex(" + customWriteExpression + ")),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','\\1-\\2-\\3-\\4-\\5')";
                    }
                    case 2003: {
                        BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
                        OracleArrayJdbcType jdbcType = (OracleArrayJdbcType)pluralType.getJdbcType();
                        switch (jdbcType.getElementJdbcType().getDefaultSqlTypeCode()) {
                            case 2005: {
                                return "(select json_arrayagg(to_clob(t.column_value)) from table(" + customWriteExpression + ") t)";
                            }
                            case 3000: {
                                return "(select json_arrayagg(regexp_replace(lower(rawtohex(t.column_value)),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','\\1-\\2-\\3-\\4-\\5')) from table(" + customWriteExpression + ") t)";
                            }
                            case -7: {
                                return "decode(" + customWriteExpression + ",1,'true',0,'false',null)";
                            }
                            case 16: {
                                String elementTypeName = OracleAggregateSupport.determineElementTypeName(column.toSize(), pluralType, typeConfiguration);
                                if (!elementTypeName.toLowerCase(Locale.ROOT).trim().startsWith("number")) break;
                                return "(select json_arrayagg(decode(t.column_value,1,'true',0,'false',null)) from table(" + customWriteExpression + ") t)";
                            }
                        }
                        return customWriteExpression;
                    }
                    case -7: {
                        return "decode(" + customWriteExpression + ",1,'true',0,'false',null)";
                    }
                    case 16: {
                        JdbcLiteralFormatter<?> jdbcLiteralFormatter = jdbcMapping.getJdbcType().getJdbcLiteralFormatter(jdbcMapping.getMappedJavaType());
                        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
                        TypeConfigurationWrapperOptions wrapperOptions = new TypeConfigurationWrapperOptions(typeConfiguration);
                        String trueLiteral = jdbcLiteralFormatter.toJdbcLiteral(true, dialect, wrapperOptions);
                        String falseLiteral = jdbcLiteralFormatter.toJdbcLiteral(false, dialect, wrapperOptions);
                        return "decode(" + customWriteExpression + "," + trueLiteral + ",'true'," + falseLiteral + ",'false')";
                    }
                }
                return customWriteExpression;
            }
        }
        throw new IllegalStateException("JSON not supported!");
    }

    private static String xmlCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping, TypeConfiguration typeConfiguration) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case 3000: {
                return "regexp_replace(lower(rawtohex(" + customWriteExpression + ")),'^(.{8})(.{4})(.{4})(.{4})(.{12})$','\\1-\\2-\\3-\\4-\\5')";
            }
            case 16: {
                JdbcLiteralFormatter<?> jdbcLiteralFormatter = jdbcMapping.getJdbcType().getJdbcLiteralFormatter(jdbcMapping.getMappedJavaType());
                Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
                TypeConfigurationWrapperOptions wrapperOptions = new TypeConfigurationWrapperOptions(typeConfiguration);
                String trueLiteral = jdbcLiteralFormatter.toJdbcLiteral(true, dialect, wrapperOptions);
                String falseLiteral = jdbcLiteralFormatter.toJdbcLiteral(false, dialect, wrapperOptions);
                return "decode(" + customWriteExpression + "," + trueLiteral + ",'true'," + falseLiteral + ",'false')";
            }
        }
        return customWriteExpression;
    }

    private static String determineElementTypeName(Size castTargetSize, BasicPluralType<?, ?> pluralType, TypeConfiguration typeConfiguration) {
        BasicType<?> expressionType;
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor((expressionType = pluralType.getElementType()).getJdbcType().getDdlTypeCode());
        if (ddlType == null) {
            ddlType = ddlTypeRegistry.getDescriptor(4);
        }
        return ddlType.getTypeName(castTargetSize, expressionType, ddlTypeRegistry);
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 3001 || aggregateSqlTypeCode == 2009;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return new RootJsonWriteExpression(aggregateColumn, columnsToUpdate, this, typeConfiguration);
            }
            case 2009: {
                return new RootXmlWriteExpression(aggregateColumn, columnsToUpdate, typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    @Override
    public boolean supportsComponentCheckConstraints() {
        return this.checkConstraintSupport;
    }

    @Override
    public List<AuxiliaryDatabaseObject> aggregateAuxiliaryDatabaseObjects(Namespace namespace, String aggregatePath, AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int typeCode = aggregateColumn.getTypeCode();
        if (typeCode == 3016 || typeCode == 3017) {
            UserDefinedArrayType arrayType = namespace.createUserDefinedArrayType(Identifier.toIdentifier(aggregateColumn.getSqlType()), name -> new UserDefinedArrayType("orm", namespace, (Identifier)name));
            ArrayJdbcType jdbcType = (ArrayJdbcType)((BasicType)aggregateColumn.getValue().getType()).getJdbcType();
            StructJdbcType elementJdbcType = (StructJdbcType)jdbcType.getElementJdbcType();
            if (typeCode == 3016) {
                arrayType.setArraySqlTypeCode(2003);
                arrayType.setArrayLength(aggregateColumn.getArrayLength() == null ? 127 : aggregateColumn.getArrayLength());
            } else {
                arrayType.setArraySqlTypeCode(4000);
            }
            arrayType.setElementTypeName(elementJdbcType.getStructTypeName());
            arrayType.setElementSqlTypeCode(elementJdbcType.getDefaultSqlTypeCode());
            arrayType.setElementDdlTypeCode(elementJdbcType.getDdlTypeCode());
        }
        return super.aggregateAuxiliaryDatabaseObjects(namespace, aggregatePath, aggregateColumn, aggregatedColumns);
    }

    private String determineJsonTypeName(SelectableMapping aggregateColumn) {
        String columnDefinition = aggregateColumn.getColumnDefinition();
        if (columnDefinition == null) {
            assert (aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 3001);
            switch (this.jsonSupport) {
                case OSON: {
                    return "json";
                }
                case MERGEPATCH: 
                case QUERY_AND_PATH: 
                case QUERY: {
                    return "blob";
                }
                case NONE: {
                    return "clob";
                }
            }
        }
        return columnDefinition;
    }

    static enum JsonSupport {
        OSON,
        MERGEPATCH,
        QUERY_AND_PATH,
        QUERY,
        NONE;

    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, OracleAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            super(aggregateColumn, aggregateSupport);
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns, aggregateSupport, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            sqlAppender.append("json_mergepatch(");
            if (this.nullable) {
                sqlAppender.append("coalesce(");
                sqlAppender.append((CharSequence)basePath);
                sqlAppender.append(",json_object(returning ");
                sqlAppender.append(this.ddlTypeName);
                sqlAppender.append("))");
            } else {
                sqlAppender.append((CharSequence)basePath);
            }
            sqlAppender.append(',');
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
            sqlAppender.append(" returning ");
            sqlAppender.append(this.ddlTypeName);
            sqlAppender.append(')');
        }
    }

    private static class RootXmlWriteExpression
    extends AggregateXmlWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootXmlWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns, typeConfiguration);
        }

        @Override
        protected String getTagName() {
            return "e";
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, "xmlquery('/" + this.getTagName() + OracleAggregateSupport.XML_QUERY_SEPARATOR + (String)basePath + OracleAggregateSupport.XML_QUERY_END, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughXmlWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(OracleAggregateSupport.XML_QUERY_START);
            sb.append(OracleAggregateSupport.xmlExtractArguments(path, this.selectableMapping.getSelectableName()));
            sb.append(")");
        }
    }

    private static class BasicXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String[] customWriteExpressionParts;

        BasicXmlWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionParts = new String[]{"", ""};
            } else {
                assert (!customWriteExpression.startsWith("?"));
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2 || (parts.length & 1) == 1);
                this.customWriteExpressionParts = parts;
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            JdbcType jdbcType = this.selectableMapping.getJdbcMapping().getJdbcType();
            boolean isArray = jdbcType.getDefaultSqlTypeCode() == 3019;
            sb.append("xmlelement(");
            sb.appendDoubleQuoteEscapedString(this.selectableMapping.getSelectableName());
            sb.append(',');
            if (isArray) {
                sb.append("xmlquery('/Collection/*' passing ");
            }
            sb.append(this.customWriteExpressionParts[0]);
            for (int i = 1; i < this.customWriteExpressionParts.length; ++i) {
                translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
                sb.append(this.customWriteExpressionParts[i]);
            }
            if (isArray) {
                sb.append(OracleAggregateSupport.XML_QUERY_END);
            }
            sb.append(')');
        }
    }

    private static class AggregateXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, XmlWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateXmlWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateXmlWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateXmlWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateXmlWriteExpression(embeddableMappingType.getJdbcValueSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicXmlWriteExpression(column, OracleAggregateSupport.xmlCustomWriteExpression(customWriteExpression, column.getJdbcMapping(), typeConfiguration)));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                XmlWriteExpression xmlWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (xmlWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughXmlWriteExpression(selectableMapping));
                    continue;
                }
                if (!(xmlWriteExpression instanceof AggregateXmlWriteExpression)) continue;
                AggregateXmlWriteExpression writeExpression = (AggregateXmlWriteExpression)xmlWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        protected String getTagName() {
            return this.selectableMapping.getSelectableName();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("xmlelement(");
            sb.appendDoubleQuoteEscapedString(this.getTagName());
            sb.append(",xmlconcat");
            int separator = 40;
            for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                sb.append((char)separator);
                XmlWriteExpression value = entry.getValue();
                if (value instanceof AggregateXmlWriteExpression) {
                    String subPath = OracleAggregateSupport.XML_QUERY_START + OracleAggregateSupport.xmlExtractArguments(path, entry.getKey()) + ")";
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, path, translator, expression);
                }
                separator = 44;
            }
            sb.append("))");
        }
    }

    static interface XmlWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final boolean colonSyntax;
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression, boolean colonSyntax) {
            this.selectableMapping = selectableMapping;
            this.colonSyntax = colonSyntax;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            Literal literal;
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            if (this.colonSyntax) {
                sb.append("':");
            } else {
                sb.append("' value ");
            }
            sb.append(this.customWriteExpressionStart);
            Expression valueExpression = expression.getValueExpression(this.selectableMapping);
            if (valueExpression instanceof Literal && (literal = (Literal)valueExpression).getLiteralValue() == null) {
                sb.append("null");
            } else {
                translator.render(valueExpression, SqlAstNodeRenderingMode.NO_UNTYPED);
            }
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final boolean colonSyntax;
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();
        protected final EmbeddableMappingType embeddableMappingType;
        protected final String ddlTypeName;

        public AggregateJsonWriteExpression(SelectableMapping selectableMapping, OracleAggregateSupport aggregateSupport) {
            this.colonSyntax = aggregateSupport.jsonSupport == JsonSupport.OSON || aggregateSupport.jsonSupport == JsonSupport.MERGEPATCH;
            this.embeddableMappingType = ((AggregateJdbcType)selectableMapping.getJdbcMapping().getJdbcType()).getEmbeddableMappingType();
            this.ddlTypeName = aggregateSupport.determineJsonTypeName(selectableMapping);
        }

        protected void initializeSubExpressions(SelectableMapping[] columns, OracleAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                EmbeddableMappingType currentMappingType = this.embeddableMappingType;
                for (int i = 1; i < parts.length - 1; ++i) {
                    SelectableMapping selectableMapping = currentMappingType.getJdbcValueSelectable(currentMappingType.getSelectableIndex(parts[i].getSelectableName()));
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression(selectableMapping, aggregateSupport));
                    currentMappingType = currentAggregate.embeddableMappingType;
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, aggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping(), column, typeConfiguration), this.colonSyntax));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("json_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = path + "->'" + column + "'";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    if (this.colonSyntax) {
                        sb.append("':");
                    } else {
                        sb.append("' value ");
                    }
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(" returning ");
            sb.append(this.ddlTypeName);
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

