/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class UnnestSetReturningFunctionTypeResolver
implements SetReturningFunctionTypeResolver {
    protected final @Nullable String defaultBasicArrayColumnName;
    protected final String defaultIndexSelectionExpression;

    public UnnestSetReturningFunctionTypeResolver(@Nullable String defaultBasicArrayColumnName, String defaultIndexSelectionExpression) {
        this.defaultBasicArrayColumnName = defaultBasicArrayColumnName;
        this.defaultIndexSelectionExpression = defaultIndexSelectionExpression;
    }

    @Override
    public AnonymousTupleType<?> resolveTupleType(List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        String[] componentNames;
        SqmExpressible<?>[] componentTypes;
        AggregateJdbcType aggregateJdbcType;
        SqmTypedNode<?> arrayArgument = arguments.get(0);
        SqmExpressible<?> expressible = arrayArgument.getExpressible();
        if (expressible == null) {
            throw new IllegalArgumentException("Couldn't determine array type of argument to function 'unnest'");
        }
        DomainType<?> domainType = expressible.getSqmType();
        if (!(domainType instanceof BasicPluralType)) {
            throw new IllegalArgumentException("Argument passed to function 'unnest' is not a BasicPluralType. Found: " + expressible);
        }
        BasicPluralType pluralType = (BasicPluralType)domainType;
        BasicType elementType = pluralType.getElementType();
        JdbcType jdbcType = elementType.getJdbcType();
        if (jdbcType instanceof AggregateJdbcType && (aggregateJdbcType = (AggregateJdbcType)jdbcType).getEmbeddableMappingType() != null) {
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            componentTypes = UnnestSetReturningFunctionTypeResolver.determineComponentTypes(embeddableMappingType);
            componentNames = new String[componentTypes.length];
            int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
            int index = 0;
            for (int i = 0; i < numberOfAttributeMappings; ++i) {
                AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
                if (!(attributeMapping.getMappedType() instanceof SqmExpressible)) continue;
                componentNames[index++] = attributeMapping.getAttributeName();
            }
            assert (index == componentNames.length - 1);
            componentTypes[index] = typeConfiguration.getBasicTypeForJavaType(Long.class);
            componentNames[index] = CollectionPart.Nature.INDEX.getName();
        } else {
            componentTypes = new SqmExpressible[]{elementType, typeConfiguration.getBasicTypeForJavaType(Long.class)};
            componentNames = new String[]{CollectionPart.Nature.ELEMENT.getName(), CollectionPart.Nature.INDEX.getName()};
        }
        return new AnonymousTupleType(componentTypes, componentNames);
    }

    @Override
    public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
        SelectableMapping[] returnType;
        AggregateJdbcType aggregateJdbcType;
        Expression expression = (Expression)arguments.get(0);
        JdbcMappingContainer expressionType = expression.getExpressionType();
        if (expressionType == null) {
            throw new IllegalArgumentException("Couldn't determine array type of argument to function 'unnest'");
        }
        JdbcMapping jdbcMapping = expressionType.getSingleJdbcMapping();
        if (!(jdbcMapping instanceof BasicPluralType)) {
            throw new IllegalArgumentException("Argument passed to function 'unnest' is not a BasicPluralType. Found: " + expressionType);
        }
        BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
        SelectableMappingImpl indexMapping = withOrdinality ? new SelectableMappingImpl("", this.defaultIndexSelectionExpression, new SelectablePath(CollectionPart.Nature.INDEX.getName()), null, null, null, null, null, null, null, false, false, false, false, false, false, converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class)) : null;
        BasicType elementType = pluralType.getElementType();
        JdbcType jdbcType = elementType.getJdbcType();
        if (jdbcType instanceof AggregateJdbcType && (aggregateJdbcType = (AggregateJdbcType)jdbcType).getEmbeddableMappingType() != null) {
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            returnType = new SelectableMapping[jdbcValueCount + (indexMapping == null ? 0 : 1)];
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                String selectableName = selectableMapping.getSelectableName();
                returnType[i] = new SelectableMappingImpl(selectableMapping.getContainingTableExpression(), selectableName, new SelectablePath(selectableName), null, null, selectableMapping.getColumnDefinition(), selectableMapping.getLength(), selectableMapping.getPrecision(), selectableMapping.getScale(), selectableMapping.getTemporalPrecision(), selectableMapping.isLob(), true, false, false, false, selectableMapping.isFormula(), selectableMapping.getJdbcMapping());
                if (indexMapping == null) continue;
                returnType[jdbcValueCount] = indexMapping;
            }
        } else {
            SelectableMappingImpl elementMapping;
            String elementSelectionExpression;
            String string = elementSelectionExpression = this.defaultBasicArrayColumnName == null ? tableIdentifierVariable : this.defaultBasicArrayColumnName;
            if (expressionType instanceof SqlTypedMapping) {
                SqlTypedMapping typedMapping = (SqlTypedMapping)((Object)expressionType);
                elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), null, null, typedMapping.getColumnDefinition(), typedMapping.getLength(), typedMapping.getPrecision(), typedMapping.getScale(), typedMapping.getTemporalPrecision(), typedMapping.isLob(), true, false, false, false, false, elementType);
            } else {
                elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), null, null, null, null, null, null, null, false, true, false, false, false, false, elementType);
            }
            returnType = indexMapping == null ? new SelectableMapping[]{elementMapping} : new SelectableMapping[]{elementMapping, indexMapping};
        }
        return returnType;
    }

    private static SqmExpressible<?>[] determineComponentTypes(EmbeddableMappingType embeddableMappingType) {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        ArrayList<SqmExpressible> expressibles = new ArrayList<SqmExpressible>(numberOfAttributeMappings + 1);
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
            MappingType mappedType = attributeMapping.getMappedType();
            if (!(mappedType instanceof SqmExpressible)) continue;
            expressibles.add((SqmExpressible)((Object)mappedType));
        }
        return expressibles.toArray(new SqmExpressible[expressibles.size() + 1]);
    }
}

