/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentTypeResolver;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayToStringFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public ArrayToStringFunction(TypeConfiguration typeConfiguration) {
        super("array_to_string", FunctionKind.NORMAL, StandardArgumentsValidators.composite(new ArgumentTypesValidator(StandardArgumentsValidators.between(2, 3), FunctionParameterType.ANY, FunctionParameterType.STRING, FunctionParameterType.ANY)), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.composite(new ArrayAndElementArgumentTypeResolver(0, 2), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.ANY, FunctionParameterType.STRING)));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression separatorExpression = (Expression)sqlAstArguments.get(1);
        Expression defaultExpression = sqlAstArguments.size() > 2 ? (Expression)sqlAstArguments.get(2) : null;
        BasicPluralType pluralType = (BasicPluralType)arrayExpression.getExpressionType().getSingleJdbcMapping();
        int ddlTypeCode = pluralType.getElementType().getJdbcType().getDdlTypeCode();
        if (ddlTypeCode == 16) {
            sqlAppender.append("case when ");
            arrayExpression.accept(walker);
            sqlAppender.append(" is not null then coalesce((select string_agg(");
            if (defaultExpression != null) {
                sqlAppender.append("coalesce(");
            }
            sqlAppender.append("cast(t.v as varchar)");
            if (defaultExpression != null) {
                sqlAppender.append(",");
                defaultExpression.accept(walker);
                sqlAppender.append(")");
            }
            sqlAppender.appendSql(',');
            separatorExpression.accept(walker);
            sqlAppender.append(" order by t.i) from unnest(");
            arrayExpression.accept(walker);
            sqlAppender.append(") with ordinality t(v,i)),'') end");
        } else {
            sqlAppender.appendSql("array_to_string(");
            arrayExpression.accept(walker);
            sqlAppender.appendSql(',');
            separatorExpression.accept(walker);
            if (defaultExpression != null) {
                sqlAppender.appendSql(',');
                defaultExpression.accept(walker);
            }
            sqlAppender.appendSql(')');
        }
    }
}

