/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayToStringFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayToStringFunction
extends ArrayToStringFunction {
    private final int maximumArraySize;

    public H2ArrayToStringFunction(int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression separatorExpression = (Expression)sqlAstArguments.get(1);
        Expression defaultExpression = sqlAstArguments.size() > 2 ? (Expression)sqlAstArguments.get(2) : null;
        BasicPluralType pluralType = (BasicPluralType)arrayExpression.getExpressionType().getSingleJdbcMapping();
        int ddlTypeCode = pluralType.getElementType().getJdbcType().getDdlTypeCode();
        boolean needsCast = !SqlTypes.isStringType(ddlTypeCode);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then coalesce((select listagg(");
        if (defaultExpression != null) {
            sqlAppender.append("coalesce(");
        }
        if (needsCast) {
            if (ddlTypeCode == 16) {
                sqlAppender.append("lower(");
            }
            sqlAppender.append("cast(");
        }
        sqlAppender.append("array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx)");
        if (needsCast) {
            sqlAppender.append(" as varchar)");
            if (ddlTypeCode == 16) {
                sqlAppender.append(')');
            }
        }
        if (defaultExpression != null) {
            sqlAppender.append(',');
            defaultExpression.accept(walker);
            sqlAppender.append(')');
        }
        sqlAppender.append(",");
        separatorExpression.accept(walker);
        sqlAppender.append(") within group (order by i.idx) from system_range(1,");
        sqlAppender.append(Integer.toString(this.maximumArraySize));
        sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append("),0)),'') end");
    }
}

