/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.XmlHelper;
import org.hibernate.dialect.function.UnnestSetReturningFunctionTypeResolver;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;

public class UnnestFunction
extends AbstractSqmSelfRenderingSetReturningFunctionDescriptor {
    public UnnestFunction(@Nullable String defaultBasicArrayColumnName, String defaultIndexSelectionExpression) {
        this(new UnnestSetReturningFunctionTypeResolver(defaultBasicArrayColumnName, defaultIndexSelectionExpression));
    }

    protected UnnestFunction(SetReturningFunctionTypeResolver setReturningFunctionTypeResolver) {
        super("unnest", ArrayArgumentValidator.DEFAULT_INSTANCE, setReturningFunctionTypeResolver, null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        Expression array = (Expression)sqlAstArguments.get(0);
        SqlTypedMapping sqlTypedMapping = array.getExpressionType() instanceof SqlTypedMapping ? (SqlTypedMapping)((Object)array.getExpressionType()) : null;
        BasicPluralType pluralType = (BasicPluralType)array.getExpressionType().getSingleJdbcMapping();
        int ddlTypeCode = pluralType.getJdbcType().getDefaultSqlTypeCode();
        if (ddlTypeCode == 3018) {
            this.renderJsonTable(sqlAppender, array, pluralType, sqlTypedMapping, tupleType, tableIdentifierVariable, walker);
        } else if (ddlTypeCode == 3019) {
            this.renderXmlTable(sqlAppender, array, pluralType, sqlTypedMapping, tupleType, tableIdentifierVariable, walker);
        } else {
            this.renderUnnest(sqlAppender, array, pluralType, sqlTypedMapping, tupleType, tableIdentifierVariable, walker);
        }
    }

    protected String getDdlType(SqlTypedMapping sqlTypedMapping, int containerSqlTypeCode, SqlAstTranslator<?> translator) {
        String columnDefinition = sqlTypedMapping.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition;
        }
        return translator.getSessionFactory().getTypeConfiguration().getDdlTypeRegistry().getTypeName(sqlTypedMapping.getJdbcMapping().getJdbcType().getDdlTypeCode(), sqlTypedMapping.toSize(), (Type)((Object)sqlTypedMapping.getJdbcMapping()));
    }

    protected void renderJsonTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_table(");
        array.accept(walker);
        sqlAppender.appendSql(",'$[*]' columns");
        this.renderJsonTableColumns(sqlAppender, tupleType, walker, false);
        sqlAppender.appendSql(')');
    }

    protected void renderJsonTableColumns(SqlAppender sqlAppender, AnonymousTupleTableGroupProducer tupleType, SqlAstTranslator<?> walker, boolean errorOnError) {
        if (tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null) == null) {
            tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append('(');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                sqlAppender.append(' ');
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(this.getDdlType(selectableMapping, 3018, walker));
                    sqlAppender.appendSql(" path '$.");
                    sqlAppender.append(selectableMapping.getSelectableName());
                    sqlAppender.appendSql('\'');
                    if (errorOnError) {
                        sqlAppender.appendSql(" error on error");
                    }
                }
            });
        } else {
            tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append('(');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3018, walker));
                    sqlAppender.appendSql(" path '$'");
                    if (errorOnError) {
                        sqlAppender.appendSql(" error on error");
                    }
                }
            });
        }
        sqlAppender.appendSql(')');
    }

    protected void renderXmlTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        XmlHelper.CollectionTags collectionTags = XmlHelper.determineCollectionTags((BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor()), walker.getSessionFactory());
        sqlAppender.appendSql("xmltable('$d/");
        sqlAppender.appendSql(collectionTags.rootName());
        sqlAppender.appendSql('/');
        sqlAppender.appendSql(collectionTags.elementName());
        sqlAppender.appendSql("' passing ");
        array.accept(walker);
        sqlAppender.appendSql(" as \"d\" columns");
        this.renderXmlTableColumns(sqlAppender, tupleType, walker);
        sqlAppender.appendSql(')');
    }

    protected void renderXmlTableColumns(SqlAppender sqlAppender, AnonymousTupleTableGroupProducer tupleType, SqlAstTranslator<?> walker) {
        if (tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null) == null) {
            tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append(' ');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3019, walker));
                    sqlAppender.appendSql(" path '");
                    sqlAppender.appendSql(selectableMapping.getSelectableName());
                    sqlAppender.appendSql("/text()");
                    sqlAppender.appendSql("'");
                }
            });
        } else {
            tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append(' ');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3019, walker));
                    sqlAppender.appendSql(" path '");
                    sqlAppender.appendSql("text()");
                    sqlAppender.appendSql("'");
                }
            });
        }
    }

    protected void renderUnnest(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("unnest(");
        array.accept(walker);
        sqlAppender.appendSql(')');
        if (tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null) != null) {
            sqlAppender.append(" with ordinality");
        }
    }
}

