/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmJsonNullBehavior;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonObjectArgumentsValidator
implements ArgumentsValidator {
    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        if (!arguments.isEmpty()) {
            SqmTypedNode<?> lastArgument = arguments.get(arguments.size() - 1);
            int argumentsCount = lastArgument instanceof SqmJsonNullBehavior ? arguments.size() - 1 : arguments.size();
            this.checkArgumentsCount(argumentsCount);
            for (int i = 0; i < argumentsCount; i += 2) {
                DomainType<?> domainType;
                JavaType<?> javaType;
                SqmTypedNode<?> key = arguments.get(i);
                SqmExpressible<?> nodeType = key.getNodeType();
                JavaType<?> javaType2 = javaType = nodeType == null ? null : nodeType.getRelationalJavaType();
                if (JavaTypeHelper.isUnknown(javaType) || !((domainType = key.getExpressible().getSqmType()) instanceof JdbcMapping)) continue;
                JdbcMapping jdbcMapping = (JdbcMapping)((Object)domainType);
                ArgumentTypesValidator.checkArgumentType(i, functionName, FunctionParameterType.STRING, jdbcMapping.getJdbcType(), javaType.getJavaTypeClass());
            }
        }
    }

    @Override
    public void validateSqlTypes(List<? extends SqlAstNode> arguments, String functionName) {
        if (!arguments.isEmpty()) {
            SqlAstNode lastArgument = arguments.get(arguments.size() - 1);
            int argumentsCount = lastArgument instanceof JsonNullBehavior ? arguments.size() - 1 : arguments.size();
            this.checkArgumentsCount(argumentsCount);
            for (int i = 0; i < argumentsCount; i += 2) {
                Expression expression;
                JdbcMappingContainer expressionType;
                SqlAstNode argument = arguments.get(i);
                if (!(argument instanceof Expression) || (expressionType = (expression = (Expression)argument).getExpressionType()) == null || ArgumentTypesValidator.isUnknownExpressionType(expressionType)) continue;
                JdbcMapping mapping = expressionType.getSingleJdbcMapping();
                ArgumentTypesValidator.checkArgumentType(i, functionName, FunctionParameterType.STRING, mapping.getJdbcType(), mapping.getJavaTypeDescriptor().getJavaType());
            }
        }
    }

    private void checkArgumentsCount(int size) {
        if ((size & 1) == 1) {
            throw new FunctionArgumentException(String.format("json_object must have an even number of arguments, but found %d", size));
        }
    }
}

