/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.json.CastTargetReturnTypeResolver;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmJsonValueExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonValueFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    protected final boolean supportsJsonPathExpression;
    protected final boolean supportsJsonPathPassingClause;

    public JsonValueFunction(TypeConfiguration typeConfiguration, boolean supportsJsonPathExpression, boolean supportsJsonPathPassingClause) {
        super("json_value", FunctionKind.NORMAL, StandardArgumentsValidators.composite(new ArgumentTypesValidator(StandardArgumentsValidators.between(2, 3), FunctionParameterType.IMPLICIT_JSON, FunctionParameterType.STRING, FunctionParameterType.ANY)), new CastTargetReturnTypeResolver(typeConfiguration), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.JSON, FunctionParameterType.STRING));
        this.supportsJsonPathExpression = supportsJsonPathExpression;
        this.supportsJsonPathPassingClause = supportsJsonPathPassingClause;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new SqmJsonValueExpression<T>(this, this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, JsonValueArguments.extract(sqlAstArguments), returnType, walker);
    }

    protected void render(SqlAppender sqlAppender, JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression defaultExpression;
        sqlAppender.appendSql("json_value(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(',');
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (this.supportsJsonPathPassingClause || passingClause == null) {
            if (this.supportsJsonPathExpression) {
                arguments.jsonPath().accept(walker);
            } else {
                walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, (String)walker.getLiteralValue(arguments.jsonPath()));
            }
            if (passingClause != null) {
                sqlAppender.appendSql(" passing ");
                Map<String, Expression> passingExpressions = passingClause.getPassingExpressions();
                Iterator<Map.Entry<String, Expression>> iterator = passingExpressions.entrySet().iterator();
                Map.Entry<String, Expression> entry = iterator.next();
                entry.getValue().accept(walker);
                sqlAppender.appendSql(" as ");
                sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sqlAppender.appendSql(',');
                    entry.getValue().accept(walker);
                    sqlAppender.appendSql(" as ");
                    sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                }
            }
        } else {
            JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
        }
        this.renderReturningClause(sqlAppender, arguments, walker);
        if (arguments.errorBehavior() != null) {
            if (arguments.errorBehavior() == JsonValueErrorBehavior.ERROR) {
                sqlAppender.appendSql(" error on error");
            } else if (arguments.errorBehavior() != JsonValueErrorBehavior.NULL) {
                defaultExpression = arguments.errorBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on error");
            }
        }
        if (arguments.emptyBehavior() != null) {
            if (arguments.emptyBehavior() == JsonValueEmptyBehavior.ERROR) {
                sqlAppender.appendSql(" error on empty");
            } else if (arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
                defaultExpression = arguments.emptyBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on empty");
            }
        }
        sqlAppender.appendSql(')');
    }

    protected void renderReturningClause(SqlAppender sqlAppender, JsonValueArguments arguments, SqlAstTranslator<?> walker) {
        if (arguments.returningType() != null) {
            sqlAppender.appendSql(" returning ");
            arguments.returningType().accept(walker);
        }
    }

    protected record JsonValueArguments(Expression jsonDocument, Expression jsonPath, boolean isJsonType, @Nullable JsonPathPassingClause passingClause, @Nullable CastTarget returningType, @Nullable JsonValueErrorBehavior errorBehavior, @Nullable JsonValueEmptyBehavior emptyBehavior) {
        public static JsonValueArguments extract(List<? extends SqlAstNode> sqlAstArguments) {
            SqlAstNode node;
            int nextIndex = 2;
            JsonPathPassingClause passingClause = null;
            CastTarget castTarget = null;
            JsonValueErrorBehavior errorBehavior = null;
            JsonValueEmptyBehavior emptyBehavior = null;
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof CastTarget) {
                castTarget = (CastTarget)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonPathPassingClause) {
                passingClause = (JsonPathPassingClause)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonValueErrorBehavior) {
                errorBehavior = (JsonValueErrorBehavior)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonValueEmptyBehavior) {
                emptyBehavior = (JsonValueEmptyBehavior)node;
            }
            Expression jsonDocument = (Expression)sqlAstArguments.get(0);
            return new JsonValueArguments(jsonDocument, (Expression)sqlAstArguments.get(1), jsonDocument.getExpressionType() != null && jsonDocument.getExpressionType().getSingleJdbcMapping().getJdbcType().isJson(), passingClause, castTarget, errorBehavior, emptyBehavior);
        }
    }
}

