/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.AbstractJsonArrayAppendFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonArrayAppendFunction
extends AbstractJsonArrayAppendFunction {
    private final boolean supportsLax;

    public PostgreSQLJsonArrayAppendFunction(boolean supportsLax, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.supportsLax = supportsLax;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        boolean needsCast;
        Expression json = (Expression)arguments.get(0);
        Expression jsonPath = (Expression)arguments.get(1);
        SqlAstNode value = arguments.get(2);
        sqlAppender.appendSql("(select ");
        if (this.supportsLax) {
            sqlAppender.appendSql("jsonb_set_lax");
        } else {
            sqlAppender.appendSql("case when (t.d)#>t.p is not null then jsonb_set");
        }
        sqlAppender.appendSql("(t.d,t.p,(t.d)#>t.p||");
        if (value instanceof Literal && ((Literal)value).getLiteralValue() == null) {
            sqlAppender.appendSql("null::jsonb");
        } else {
            Literal literal;
            sqlAppender.appendSql("to_jsonb(");
            value.accept(translator);
            if (value instanceof Literal && (literal = (Literal)value).getJdbcMapping().getJdbcType().isString()) {
                sqlAppender.appendSql("::text");
            }
            sqlAppender.appendSql(')');
        }
        sqlAppender.appendSql(",false");
        if (this.supportsLax) {
            sqlAppender.appendSql(",'return_target')");
        } else {
            sqlAppender.appendSql(") else t.d end");
        }
        sqlAppender.appendSql(" from (values(");
        boolean bl = needsCast = !PostgreSQLJsonArrayAppendFunction.isJsonType(json);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        json.accept(translator);
        if (needsCast) {
            sqlAppender.appendSql(" as jsonb)");
        }
        sqlAppender.appendSql(',');
        List<JsonPathHelper.JsonPathElement> jsonPathElements = JsonPathHelper.parseJsonPathElements((String)translator.getLiteralValue(jsonPath));
        sqlAppender.appendSql("array");
        int separator = 91;
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql((char)separator);
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
            } else {
                if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                    String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)pathElement).parameterName();
                    throw new QueryException("JSON path [" + jsonPath + "] uses parameter [" + parameterName + "] that is not passed");
                }
                sqlAppender.appendSql('\'');
                sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index() + 1);
                sqlAppender.appendSql('\'');
            }
            separator = 44;
        }
        sqlAppender.appendSql("]::text[]");
        sqlAppender.appendSql(")) t(d,p))");
    }

    private static boolean isJsonType(Expression expression) {
        JdbcMappingContainer expressionType = expression.getExpressionType();
        return expressionType != null && expressionType.getSingleJdbcMapping().getJdbcType().isJson();
    }
}

