/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonObjectFunction
extends JsonObjectFunction {
    public PostgreSQLJsonObjectFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, false);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("jsonb_build_object()");
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            SqlAstNode lastArgument = sqlAstArguments.get(sqlAstArguments.size() - 1);
            if (lastArgument instanceof JsonNullBehavior) {
                nullBehavior = (JsonNullBehavior)lastArgument;
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.NULL;
                argumentsCount = sqlAstArguments.size();
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                sqlAppender.appendSql("(select jsonb_object_agg(t.k,t.v) from (values");
                int separator = 32;
                for (int i = 0; i < argumentsCount; i += 2) {
                    SqlAstNode key = sqlAstArguments.get(i);
                    SqlAstNode value = sqlAstArguments.get(i + 1);
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql('(');
                    key.accept(walker);
                    sqlAppender.appendSql(',');
                    if (value instanceof Literal && ((Literal)value).getLiteralValue() == null) {
                        sqlAppender.appendSql("null::jsonb");
                    } else {
                        Literal literal;
                        sqlAppender.appendSql("to_jsonb(");
                        value.accept(walker);
                        if (value instanceof Literal && (literal = (Literal)value).getJdbcMapping().getJdbcType().isString()) {
                            sqlAppender.appendSql("::text");
                        }
                        sqlAppender.appendSql(')');
                    }
                    sqlAppender.appendSql(')');
                    separator = 44;
                }
                sqlAppender.appendSql(") t(k,v) where t.v is not null)");
            } else {
                sqlAppender.appendSql("jsonb_build_object");
                int separator = 40;
                for (int i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql((char)separator);
                    sqlAstArguments.get(i).accept(walker);
                    separator = 44;
                }
                sqlAppender.appendSql(')');
            }
        }
    }
}

