/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.xml.XmlQueryFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class LegacyDB2XmlQueryFunction
extends XmlQueryFunction {
    public LegacyDB2XmlQueryFunction(TypeConfiguration typeConfiguration) {
        super(false, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String xquery = (String)walker.getLiteralValue((Expression)sqlAstArguments.get(0));
        Expression xmlDocument = (Expression)sqlAstArguments.get(1);
        boolean needsCast = !ExpressionTypeHelper.isXml(xmlDocument);
        sqlAppender.appendSql("xmlquery(");
        sqlAppender.appendSingleQuoteEscapedString("$d" + xquery);
        sqlAppender.appendSql(" passing ");
        if (needsCast) {
            sqlAppender.appendSql("xmlparse(document ");
        }
        sqlAstArguments.get(1).accept(walker);
        if (needsCast) {
            sqlAppender.appendSql(')');
        }
        sqlAppender.appendSql(" as \"d\")");
    }
}

