/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmXmlTableFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.XmlTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.spi.TypeConfiguration;

public class XmlTableSetReturningFunctionTypeResolver
implements SetReturningFunctionTypeResolver {
    @Override
    public AnonymousTupleType<?> resolveTupleType(List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        SqmXmlTableFunction.Columns columns = (SqmXmlTableFunction.Columns)arguments.get(arguments.size() - 1);
        return columns.createTupleType();
    }

    @Override
    public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
        XmlTableColumnsClause columnsClause = null;
        for (SqlAstNode sqlAstNode : arguments) {
            if (!(sqlAstNode instanceof XmlTableColumnsClause)) continue;
            columnsClause = (XmlTableColumnsClause)sqlAstNode;
            break;
        }
        assert (columnsClause != null);
        List<XmlTableColumnDefinition> columnDefinitions = columnsClause.getColumnDefinitions();
        ArrayList<SelectableMapping> arrayList = new ArrayList<SelectableMapping>(columnDefinitions.size());
        this.addSelectableMappings(arrayList, columnsClause, converter);
        return arrayList.toArray(new SelectableMapping[0]);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableColumnsClause columnsClause, SqmToSqlAstConverter converter) {
        for (XmlTableColumnDefinition columnDefinition : columnsClause.getColumnDefinitions()) {
            if (columnDefinition instanceof XmlTableQueryColumnDefinition) {
                XmlTableQueryColumnDefinition definition = (XmlTableQueryColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            if (columnDefinition instanceof XmlTableValueColumnDefinition) {
                XmlTableValueColumnDefinition definition = (XmlTableValueColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            XmlTableOrdinalityColumnDefinition definition = (XmlTableOrdinalityColumnDefinition)columnDefinition;
            this.addSelectableMappings(selectableMappings, definition, converter);
        }
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableOrdinalityColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableValueColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), definition.type().getJdbcMapping(), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, XmlTableQueryColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 2009), converter);
    }

    protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
        selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), null, null, null, null, null, null, null, false, false, false, false, false, false, type));
    }
}

