/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public final class Cascade {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(Cascade.class);

    private Cascade() {
    }

    public static <T> void cascade(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, EntityPersister persister, Object parent) throws HibernateException {
        Cascade.cascade(action, cascadePoint, eventSource, persister, parent, null);
    }

    public static <T> void cascade(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, EntityPersister persister, Object parent, T anything) throws HibernateException {
        if (persister.hasCascades() || action == CascadingActions.CHECK_ON_FLUSH) {
            EntityEntry entry;
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Processing cascade {0} for: {1}", action, persister.getEntityName());
            }
            PersistenceContext persistenceContext = eventSource.getPersistenceContextInternal();
            boolean enhancedForLazyLoading = persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
            if (enhancedForLazyLoading) {
                entry = persistenceContext.getEntry(parent);
                if (entry != null && entry.getLoadedState() == null && entry.getStatus() == Status.MANAGED) {
                    return;
                }
            } else {
                entry = null;
            }
            Type[] types = persister.getPropertyTypes();
            String[] propertyNames = persister.getPropertyNames();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            boolean hasUninitializedLazyProperties = persister.hasUninitializedLazyProperties(parent);
            for (int i = 0; i < types.length; ++i) {
                boolean isUninitializedProperty;
                CascadeStyle style = cascadeStyles[i];
                String propertyName = propertyNames[i];
                Type type = types[i];
                boolean bl = isUninitializedProperty = hasUninitializedLazyProperties && !persister.getBytecodeEnhancementMetadata().isAttributeLoaded(parent, propertyName);
                if (style.doCascade(action)) {
                    Object child;
                    if (isUninitializedProperty) {
                        assert (enhancedForLazyLoading);
                        if (entry == null) continue;
                        if (type instanceof CollectionType) {
                            CollectionType collectionType = (CollectionType)type;
                            child = collectionType.getCollection(collectionType.getKeyOfOwner(parent, eventSource), eventSource, parent, null);
                        } else {
                            if (type instanceof AnyType || type instanceof ComponentType) {
                                throw new UnsupportedOperationException("Lazy embeddables are not supported");
                            }
                            if (!action.performOnLazyProperty() || !(type instanceof EntityType)) continue;
                            LazyAttributeLoadingInterceptor interceptor = persister.getBytecodeEnhancementMetadata().extractInterceptor(parent);
                            child = interceptor.fetchAttribute(parent, propertyName);
                        }
                    } else {
                        child = persister.getValue(parent, i);
                    }
                    Cascade.cascadeProperty(action, cascadePoint, eventSource, null, parent, child, type, style, propertyName, anything, false);
                    continue;
                }
                if (!action.deleteOrphans() || isUninitializedProperty || !Cascade.isLogicalOneToOne(type)) continue;
                Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, null, parent, persister.getValue(parent, i), type, style, propertyName, false);
            }
            if (traceEnabled) {
                LOG.tracev("Done processing cascade {0} for: {1}", action, persister.getEntityName());
            }
        }
    }

    private static <T> void cascadeProperty(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, String propertyName, T anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            if (type instanceof EntityType || type instanceof CollectionType || type instanceof AnyType) {
                AssociationType associationType = (AssociationType)type;
                boolean unownedTransient = eventSource.getSessionFactory().getSessionFactoryOptions().isUnownedAssociationTransientCheck();
                if (Cascade.cascadeAssociationNow(action, cascadePoint, associationType, (SessionFactoryImplementor)eventSource.getFactory(), unownedTransient)) {
                    Cascade.cascadeAssociation(action, cascadePoint, eventSource, componentPath, parent, child, type, style, anything, isCascadeDeleteEnabled);
                }
            } else if (type instanceof ComponentType) {
                ComponentType componentType = (ComponentType)type;
                if (componentPath == null && propertyName != null) {
                    componentPath = new ArrayList<String>();
                }
                if (componentPath != null) {
                    componentPath.add(propertyName);
                }
                Cascade.cascadeComponent(action, cascadePoint, eventSource, componentPath, parent, child, componentType, anything);
                if (componentPath != null) {
                    componentPath.remove(componentPath.size() - 1);
                }
            }
        }
        if (Cascade.isLogicalOneToOne(type)) {
            Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, componentPath, parent, child, type, style, propertyName, isCascadeDeleteEnabled);
        }
    }

    private static <T> void cascadeLogicalOneToOneOrphanRemoval(CascadingAction<T> action, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entry;
        if (style.hasOrphanDelete() && action.deleteOrphans() && (entry = (persistenceContext = eventSource.getPersistenceContextInternal()).getEntry(parent)) != null && entry.getStatus() != Status.SAVING) {
            Object loadedValue;
            if (componentPath == null) {
                loadedValue = entry.getLoadedValue(propertyName);
            } else {
                Type propertyType = entry.getPersister().getPropertyType(componentPath.get(0));
                if (propertyType instanceof ComponentType) {
                    loadedValue = entry.getLoadedValue(componentPath.get(0));
                    ComponentType componentType = (ComponentType)propertyType;
                    if (componentPath.size() != 1) {
                        for (int i = 1; i < componentPath.size(); ++i) {
                            int subPropertyIndex = componentType.getPropertyIndex(componentPath.get(i));
                            loadedValue = componentType.getPropertyValue(loadedValue, subPropertyIndex);
                            componentType = (ComponentType)componentType.getSubtypes()[subPropertyIndex];
                        }
                    }
                    loadedValue = componentType.getPropertyValue(loadedValue, componentType.getPropertyIndex(propertyName));
                } else {
                    loadedValue = null;
                }
            }
            if (child == null || loadedValue != null && child != loadedValue) {
                EntityEntry valueEntry = persistenceContext.getEntry(loadedValue);
                if (valueEntry == null && ManagedTypeHelper.isHibernateProxy(loadedValue)) {
                    loadedValue = persistenceContext.unproxyAndReassociate(loadedValue);
                    valueEntry = persistenceContext.getEntry(loadedValue);
                    if (child == loadedValue) {
                        return;
                    }
                }
                if (valueEntry != null) {
                    EntityPersister persister = valueEntry.getPersister();
                    String entityName = persister.getEntityName();
                    if (LOG.isTraceEnabled()) {
                        LOG.tracev("Deleting orphaned entity instance: {0}", MessageHelper.infoString(entityName, persister.getIdentifier(loadedValue, eventSource)));
                    }
                    if (Cascade.isForeignKeyToParent(type)) {
                        eventSource.removeOrphanBeforeUpdates(entityName, loadedValue);
                    } else {
                        eventSource.delete(entityName, loadedValue, isCascadeDeleteEnabled, DeleteContext.create());
                    }
                }
            }
        }
    }

    private static boolean isForeignKeyToParent(Type type) {
        OneToOneType oneToOneType;
        return type instanceof CollectionType || type instanceof OneToOneType && (oneToOneType = (OneToOneType)type).getForeignKeyDirection() == ForeignKeyDirection.TO_PARENT;
    }

    private static boolean isLogicalOneToOne(Type type) {
        EntityType entityType;
        return type instanceof EntityType && (entityType = (EntityType)type).isLogicalOneToOne();
    }

    private static boolean cascadeAssociationNow(CascadingAction<?> action, CascadePoint cascadePoint, AssociationType associationType, SessionFactoryImplementor factory, boolean unownedTransient) {
        return associationType.getForeignKeyDirection().cascadeNow(cascadePoint) && (action != CascadingActions.CHECK_ON_FLUSH || unownedTransient || !Cascade.isUnownedAssociation(associationType, factory));
    }

    private static boolean isUnownedAssociation(AssociationType associationType, SessionFactoryImplementor factory) {
        if (associationType instanceof ManyToOneType) {
            ManyToOneType manyToOne = (ManyToOneType)associationType;
            return manyToOne.isLogicalOneToOne() && manyToOne.getRHSUniqueKeyPropertyName() != null;
        }
        if (associationType instanceof OneToOneType) {
            OneToOneType oneToOne = (OneToOneType)associationType;
            return oneToOne.isNullable() && oneToOne.getRHSUniqueKeyPropertyName() != null;
        }
        if (associationType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)associationType;
            return collectionType.isInverse(factory);
        }
        return false;
    }

    private static <T> void cascadeComponent(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CompositeType componentType, T anything) {
        Object[] children = null;
        Type[] types = componentType.getSubtypes();
        String[] propertyNames = componentType.getPropertyNames();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
            String subPropertyName = propertyNames[i];
            if (!componentPropertyStyle.doCascade(action) && (!componentPropertyStyle.hasOrphanDelete() || !action.deleteOrphans())) continue;
            if (children == null) {
                children = componentType.getPropertyValues(child, eventSource);
            }
            Cascade.cascadeProperty(action, cascadePoint, eventSource, componentPath, parent, children[i], types[i], componentPropertyStyle, subPropertyName, anything, false);
        }
    }

    private static <T> void cascadeAssociation(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, T anything, boolean isCascadeDeleteEnabled) {
        if (type instanceof EntityType || type instanceof AnyType) {
            Cascade.cascadeToOne(action, eventSource, parent, child, type, style, anything, isCascadeDeleteEnabled);
        } else if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Cascade.cascadeCollection(action, cascadePoint, eventSource, componentPath, parent, child, style, anything, collectionType);
        }
    }

    private static <T> void cascadeCollection(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CascadeStyle style, T anything, CollectionType type) {
        CollectionPersister persister = eventSource.getFactory().getMappingMetamodel().getCollectionDescriptor(type.getRole());
        Type elemType = persister.getElementType();
        if (elemType instanceof EntityType || elemType instanceof AnyType || elemType instanceof ComponentType) {
            Cascade.cascadeCollectionElements(action, cascadePoint == CascadePoint.AFTER_INSERT_BEFORE_DELETE ? CascadePoint.AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION : cascadePoint, eventSource, componentPath, parent, child, type, style, elemType, anything, persister.isCascadeDeleteEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void cascadeToOne(CascadingAction<T> action, EventSource eventSource, Object parent, Object child, Type type, CascadeStyle style, T anything, boolean isCascadeDeleteEnabled) {
        String entityName;
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            v0 = entityType.getAssociatedEntityName();
        } else {
            v0 = entityName = null;
        }
        if (style.reallyDoCascade(action)) {
            PersistenceContext persistenceContext = eventSource.getPersistenceContextInternal();
            persistenceContext.addChildParent(child, parent);
            try {
                action.cascade(eventSource, child, entityName, anything, isCascadeDeleteEnabled);
            }
            finally {
                persistenceContext.removeChildParent(child);
            }
        }
    }

    private static <T> void cascadeCollectionElements(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CollectionType collectionType, CascadeStyle style, Type elemType, T anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean deleteOrphans;
        PersistentCollection<?> pc;
        boolean reallyDoCascade;
        boolean bl = reallyDoCascade = style.reallyDoCascade(action) && child != CollectionType.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Cascade {0} for collection: {1}", action, collectionType.getRole());
            }
            Iterator<?> iterator = action.getCascadableChildrenIterator(eventSource, collectionType, child);
            while (iterator.hasNext()) {
                Cascade.cascadeProperty(action, cascadePoint, eventSource, componentPath, parent, iterator.next(), elemType, style, collectionType.getRole().substring(collectionType.getRole().lastIndexOf(46) + 1), anything, isCascadeDeleteEnabled);
            }
            if (traceEnabled) {
                LOG.tracev("Done cascade {0} for collection: {1}", action, collectionType.getRole());
            }
        }
        PersistentCollection<?> persistentCollection = child instanceof PersistentCollection ? (pc = (PersistentCollection<?>)child) : eventSource.getPersistenceContext().getCollectionHolder(child);
        boolean bl2 = deleteOrphans = style.hasOrphanDelete() && action.deleteOrphans() && elemType instanceof EntityType && persistentCollection != null && !persistentCollection.isNewlyInstantiated();
        if (deleteOrphans) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Deleting orphans for collection: {0}", collectionType.getRole());
            }
            String entityName = collectionType.getAssociatedEntityName((SessionFactoryImplementor)eventSource.getFactory());
            Cascade.deleteOrphans(eventSource, entityName, persistentCollection);
            if (traceEnabled) {
                LOG.tracev("Done deleting orphans for collection: {0}", collectionType.getRole());
            }
        }
    }

    private static void deleteOrphans(EventSource eventSource, String entityName, PersistentCollection<?> pc) {
        CollectionEntry entry;
        Collection<Object> orphans = pc.wasInitialized() ? ((entry = eventSource.getPersistenceContextInternal().getCollectionEntry(pc)) == null ? Collections.EMPTY_LIST : entry.getOrphans(entityName, pc)) : pc.getQueuedOrphans(entityName);
        for (Object orphan : orphans) {
            if (orphan == null) continue;
            LOG.tracev("Deleting orphaned entity instance: {0}", entityName);
            eventSource.delete(entityName, orphan, false, DeleteContext.create());
        }
    }
}

