/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.batch.JdbcBatchLogging;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.batch.spi.BatchObserver;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.resource.jdbc.spi.JdbcEventHandler;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.sql.model.ModelMutationLogging;

public class BatchImpl
implements Batch {
    private final BatchKey key;
    private final int batchSizeToUse;
    private final PreparedStatementGroup statementGroup;
    private final JdbcCoordinator jdbcCoordinator;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final LinkedHashSet<BatchObserver> observers = new LinkedHashSet();
    private int batchPosition;
    private boolean batchExecuted;
    private Batch.StaleStateMapper[] staleStateMappers;

    public BatchImpl(BatchKey key, PreparedStatementGroup statementGroup, int batchSizeToUse, JdbcCoordinator jdbcCoordinator) {
        if (key == null) {
            throw new IllegalArgumentException("Batch key cannot be null");
        }
        if (jdbcCoordinator == null) {
            throw new IllegalArgumentException("JDBC coordinator cannot be null");
        }
        this.batchSizeToUse = batchSizeToUse;
        this.key = key;
        this.jdbcCoordinator = jdbcCoordinator;
        this.statementGroup = statementGroup;
        JdbcServices jdbcServices = jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getJdbcServices();
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.sqlExceptionHelper = jdbcServices.getSqlExceptionHelper();
        if (JdbcBatchLogging.BATCH_LOGGER.isTraceEnabled()) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.createBatch(batchSizeToUse, key.toLoggableString());
        }
    }

    @Override
    public final BatchKey getKey() {
        return this.key;
    }

    @Override
    public PreparedStatementGroup getStatementGroup() {
        return this.statementGroup;
    }

    @Override
    public void addObserver(BatchObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void addToBatch(JdbcValueBindings jdbcValueBindings, TableInclusionChecker inclusionChecker, Batch.StaleStateMapper staleStateMapper) {
        if (staleStateMapper != null) {
            if (this.staleStateMappers == null) {
                this.staleStateMappers = new Batch.StaleStateMapper[this.batchSizeToUse];
            }
            this.staleStateMappers[this.batchPosition] = staleStateMapper;
        }
        this.addToBatch(jdbcValueBindings, inclusionChecker);
    }

    @Override
    public void addToBatch(JdbcValueBindings jdbcValueBindings, TableInclusionChecker inclusionChecker) {
        boolean loggerTraceEnabled = JdbcBatchLogging.BATCH_LOGGER.isTraceEnabled();
        if (loggerTraceEnabled) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.addToBatch(this.batchPosition + 1, this.batchSizeToUse, this.getKey().toLoggableString());
        }
        try {
            this.getStatementGroup().forEachStatement((tableName, statementDetails) -> {
                if (inclusionChecker != null && !inclusionChecker.include(statementDetails.getMutatingTableDetails())) {
                    if (loggerTraceEnabled) {
                        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping addBatch for table : %s (batch-position=%s)", (Object)statementDetails.getMutatingTableDetails().getTableName(), (Object)(this.batchPosition + 1));
                    }
                } else {
                    PreparedStatement statement = statementDetails.resolveStatement();
                    this.sqlStatementLogger.logStatement(statementDetails.getSqlString());
                    jdbcValueBindings.beforeStatement((PreparedStatementDetails)statementDetails);
                    try {
                        statement.addBatch();
                    }
                    catch (SQLException e) {
                        JdbcBatchLogging.BATCH_LOGGER.debug((Object)"SQLException escaped proxy", (Throwable)e);
                        throw this.sqlExceptionHelper.convert(e, "Could not perform addBatch", statementDetails.getSqlString());
                    }
                    finally {
                        jdbcValueBindings.afterStatement(statementDetails.getMutatingTableDetails());
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.abortBatch(e);
            throw e;
        }
        ++this.batchPosition;
        if (this.batchPosition == this.batchSizeToUse) {
            this.notifyObserversImplicitExecution();
            this.performExecution();
        }
    }

    protected void releaseStatements() {
        this.statementGroup.release();
    }

    protected void clearBatch(PreparedStatementDetails statementDetails) {
        PreparedStatement statement = statementDetails.getStatement();
        assert (statement != null);
        try {
            if (!statement.isClosed()) {
                statement.clearBatch();
            }
        }
        catch (SQLException e) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.unableToReleaseBatchStatement();
        }
    }

    protected final void notifyObserversExplicitExecution() {
        for (BatchObserver observer : this.observers) {
            observer.batchExplicitlyExecuted();
        }
    }

    protected final void notifyObserversImplicitExecution() {
        for (BatchObserver observer : this.observers) {
            observer.batchImplicitlyExecuted();
        }
    }

    protected void abortBatch(Exception cause) {
        try {
            this.jdbcCoordinator.abortBatch();
        }
        catch (RuntimeException e) {
            cause.addSuppressed(e);
        }
    }

    @Override
    public void execute() {
        this.notifyObserversExplicitExecution();
        if (this.getStatementGroup().getNumberOfStatements() != 0) {
            try {
                if (this.batchPosition == 0) {
                    if (!this.batchExecuted && JdbcBatchLogging.BATCH_LOGGER.isDebugEnabled()) {
                        JdbcBatchLogging.BATCH_LOGGER.debugf("No batched statements to execute - %s", (Object)this.getKey().toLoggableString());
                    }
                } else {
                    this.performExecution();
                }
            }
            finally {
                this.releaseStatements();
            }
        }
    }

    protected void performExecution() {
        if (JdbcBatchLogging.BATCH_LOGGER.isTraceEnabled()) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.executeBatch(this.batchPosition, this.batchSizeToUse, this.getKey().toLoggableString());
        }
        JdbcSessionOwner jdbcSessionOwner = this.jdbcCoordinator.getJdbcSessionOwner();
        JdbcEventHandler eventHandler = jdbcSessionOwner.getJdbcSessionContext().getEventHandler();
        try {
            this.getStatementGroup().forEachStatement((tableName, statementDetails) -> {
                block9: {
                    String sql = statementDetails.getSqlString();
                    PreparedStatement statement = statementDetails.getStatement();
                    if (statement != null) {
                        try {
                            if (statementDetails.getMutatingTableDetails().isIdentifierTable()) {
                                int[] rowCounts;
                                EventManager eventManager = jdbcSessionOwner.getEventManager();
                                HibernateMonitoringEvent executionEvent = eventManager.beginJdbcBatchExecutionEvent();
                                try {
                                    eventHandler.jdbcExecuteBatchStart();
                                    rowCounts = statement.executeBatch();
                                }
                                finally {
                                    eventManager.completeJdbcBatchExecutionEvent(executionEvent, sql);
                                    eventHandler.jdbcExecuteBatchEnd();
                                }
                                this.checkRowCounts(rowCounts, (PreparedStatementDetails)statementDetails);
                                break block9;
                            }
                            statement.executeBatch();
                        }
                        catch (SQLException e) {
                            this.abortBatch(e);
                            throw this.sqlExceptionHelper.convert(e, "could not execute batch", sql);
                        }
                        catch (RuntimeException re) {
                            this.abortBatch(re);
                            throw re;
                        }
                    }
                }
            });
            this.batchExecuted = true;
        }
        finally {
            this.jdbcCoordinator.afterStatementExecution();
            this.batchPosition = 0;
        }
    }

    private void checkRowCounts(int[] rowCounts, PreparedStatementDetails statementDetails) throws SQLException, HibernateException {
        int numberOfRowCounts = rowCounts.length;
        if (this.batchPosition != 0 && numberOfRowCounts != this.batchPosition) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.unexpectedRowCounts(statementDetails.getMutatingTableDetails().getTableName(), numberOfRowCounts, this.batchPosition);
        }
        for (int i = 0; i < numberOfRowCounts; ++i) {
            try {
                statementDetails.getExpectation().verifyOutcome(rowCounts[i], statementDetails.getStatement(), i, statementDetails.getSqlString());
                continue;
            }
            catch (StaleStateException staleStateException) {
                if (this.staleStateMappers == null) continue;
                throw this.staleStateMappers[i].map(staleStateException);
            }
        }
    }

    @Override
    public void release() {
        PreparedStatementGroup statementGroup;
        if (JdbcBatchLogging.BATCH_MESSAGE_LOGGER.isInfoEnabled() && (statementGroup = this.getStatementGroup()).getNumberOfStatements() != 0 && statementGroup.hasMatching(statementDetails -> statementDetails.getStatement() != null)) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.batchContainedStatementsOnRelease();
        }
        this.releaseStatements();
        this.observers.clear();
    }

    public String toString() {
        return "BatchImpl(" + this.getKey().toLoggableString() + ")";
    }
}

