/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.engine.jdbc.internal.Formatter;

public class BasicFormatterImpl
implements Formatter {
    private static final Set<String> NON_FUNCTION_NAMES = Set.of("select", "from", "on", "set", "and", "or", "where", "having", "by", "using");
    private static final String INDENT_STRING = "    ";
    private static final String INITIAL = System.lineSeparator() + "    ";

    @Override
    public String format(String source) {
        return new FormatProcess(source).perform();
    }

    private static class FormatProcess {
        boolean beginLine = true;
        boolean afterBeginBeforeEnd;
        boolean afterByOrSetOrFromOrSelect;
        int afterOn;
        boolean afterBetween;
        boolean afterExtract;
        boolean afterInsert;
        int inFunction;
        int parensSinceSelect;
        int valuesParenCount;
        private final LinkedList<Integer> parenCounts = new LinkedList();
        private final LinkedList<Boolean> afterByOrFromOrSelects = new LinkedList();
        int indent = 1;
        StringBuilder result = new StringBuilder();
        StringTokenizer tokens;
        String lastToken;
        String token;
        String lcToken;

        public FormatProcess(String sql) {
            assert (sql != null) : "SQL to format should not be null";
            this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[], \n\r\f\t", true);
        }

        public String perform() {
            this.result.append(INITIAL);
            while (this.tokens.hasMoreTokens()) {
                this.token = this.tokens.nextToken();
                if ("-".equals(this.token) && this.result.toString().endsWith("-")) {
                    do {
                        this.result.append(this.token);
                        this.token = this.tokens.nextToken();
                    } while (!"\n".equals(this.token) && this.tokens.hasMoreTokens());
                }
                switch (this.lcToken = this.token.toLowerCase(Locale.ROOT)) {
                    case "'": 
                    case "`": 
                    case "\"": {
                        String t;
                        do {
                            t = this.tokens.nextToken();
                            this.token = this.token + t;
                        } while (!this.lcToken.equals(t) && this.tokens.hasMoreTokens());
                        this.lcToken = this.token;
                        this.misc();
                        break;
                    }
                    case "[": {
                        String tt;
                        do {
                            tt = this.tokens.nextToken();
                            this.token = this.token + tt;
                        } while (!"]".equals(tt) && this.tokens.hasMoreTokens());
                        this.lcToken = this.token;
                        this.misc();
                        break;
                    }
                    case ",": {
                        this.comma();
                        break;
                    }
                    case "(": {
                        this.openParen();
                        break;
                    }
                    case ")": {
                        this.closeParen();
                        break;
                    }
                    case "select": {
                        this.select();
                        break;
                    }
                    case "merge": 
                    case "insert": 
                    case "update": 
                    case "delete": {
                        this.updateOrInsertOrDelete();
                        break;
                    }
                    case "values": {
                        this.values();
                        break;
                    }
                    case "on": {
                        this.on();
                        break;
                    }
                    case "between": {
                        this.afterBetween = true;
                        this.misc();
                        break;
                    }
                    case "trim": 
                    case "extract": {
                        this.afterExtract = true;
                        this.misc();
                        break;
                    }
                    case "left": 
                    case "right": 
                    case "full": 
                    case "inner": 
                    case "outer": 
                    case "cross": 
                    case "group": 
                    case "order": 
                    case "returning": 
                    case "using": {
                        this.beginNewClause();
                        break;
                    }
                    case "from": {
                        this.from();
                        break;
                    }
                    case "where": 
                    case "set": 
                    case "having": 
                    case "by": 
                    case "join": 
                    case "into": 
                    case "union": 
                    case "intersect": 
                    case "offset": 
                    case "limit": 
                    case "fetch": {
                        this.endNewClause();
                        break;
                    }
                    case "case": {
                        this.beginCase();
                        break;
                    }
                    case "end": {
                        this.endCase();
                        break;
                    }
                    case "when": 
                    case "else": {
                        this.when();
                        break;
                    }
                    case "then": {
                        this.then();
                        break;
                    }
                    case "and": {
                        this.and();
                        break;
                    }
                    case "or": {
                        this.or();
                        break;
                    }
                    default: {
                        if (FormatProcess.isWhitespace(this.token)) {
                            this.white();
                            break;
                        }
                        this.misc();
                    }
                }
                if (FormatProcess.isWhitespace(this.token)) continue;
                this.lastToken = this.lcToken;
            }
            return this.result.toString();
        }

        private void or() {
            this.logical();
        }

        private void and() {
            if (this.afterBetween) {
                this.misc();
                this.afterBetween = false;
            } else {
                this.logical();
            }
        }

        private void from() {
            if (this.afterExtract) {
                this.misc();
                this.afterExtract = false;
            } else {
                this.endNewClause();
            }
        }

        private void comma() {
            if (this.afterByOrSetOrFromOrSelect && this.inFunction == 0) {
                this.commaAfterByOrFromOrSelect();
            } else {
                this.misc();
            }
        }

        private void then() {
            this.incrementIndent();
            this.newline();
            this.misc();
        }

        private void when() {
            this.decrementIndent();
            this.newline();
            this.out();
            this.beginLine = false;
            this.afterBeginBeforeEnd = true;
        }

        private void commaAfterByOrFromOrSelect() {
            this.out();
            this.newline();
        }

        private void logical() {
            this.newline();
            this.out();
            this.beginLine = false;
        }

        private void endCase() {
            this.afterBeginBeforeEnd = false;
            this.decrementIndent();
            this.decrementIndent();
            this.logical();
        }

        private void on() {
            if (this.afterOn == 0) {
                this.incrementIndent();
            } else if (this.afterOn == 1) {
                this.decrementIndent();
            }
            ++this.afterOn;
            this.newline();
            this.out();
            this.beginLine = false;
        }

        private void beginCase() {
            this.out();
            this.beginLine = false;
            this.incrementIndent();
            this.incrementIndent();
            this.afterBeginBeforeEnd = true;
        }

        private void misc() {
            this.out();
            if (this.afterInsert && this.inFunction == 0) {
                this.newline();
                this.afterInsert = false;
            } else {
                this.beginLine = false;
            }
        }

        private void white() {
            if (!this.beginLine) {
                this.result.append(" ");
            }
        }

        private void updateOrInsertOrDelete() {
            if (this.indent > 1) {
                this.out();
            } else {
                this.out();
                this.incrementIndent();
                this.beginLine = false;
                if ("update".equals(this.lcToken)) {
                    this.newline();
                }
                if ("insert".equals(this.lcToken)) {
                    this.afterInsert = true;
                }
            }
        }

        private void select() {
            this.out();
            this.incrementIndent();
            this.newline();
            this.parenCounts.addLast(this.parensSinceSelect);
            this.afterByOrFromOrSelects.addLast(this.afterByOrSetOrFromOrSelect);
            this.parensSinceSelect = 0;
            this.afterByOrSetOrFromOrSelect = true;
        }

        private void out() {
            if (this.result.charAt(this.result.length() - 1) == ',') {
                this.result.append(" ");
            }
            this.result.append(this.token);
        }

        private void endNewClause() {
            if (!this.afterBeginBeforeEnd) {
                this.decrementIndent();
                if (this.afterOn == 1) {
                    this.decrementIndent();
                }
                if (this.afterOn > 0) {
                    this.afterOn = 0;
                }
                this.newline();
            }
            this.out();
            if (!"union".equals(this.lcToken) && !"intersect".equals(this.lcToken)) {
                this.incrementIndent();
            }
            this.newline();
            this.afterBeginBeforeEnd = false;
            this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
        }

        private void beginNewClause() {
            if (!this.afterBeginBeforeEnd) {
                if (this.afterOn == 1) {
                    this.decrementIndent();
                }
                if (this.afterOn > 0) {
                    this.afterOn = 0;
                }
                this.decrementIndent();
                this.newline();
            }
            this.out();
            this.beginLine = false;
            this.afterBeginBeforeEnd = true;
        }

        private void values() {
            if (this.parensSinceSelect == 0) {
                if (!this.afterBeginBeforeEnd) {
                    this.decrementIndent();
                }
                this.newline();
                this.out();
                this.incrementIndent();
                this.newline();
                this.valuesParenCount = this.parensSinceSelect + 1;
            } else {
                this.out();
            }
        }

        private void closeParen() {
            if (this.parensSinceSelect == 0) {
                this.decrementIndent();
                this.parensSinceSelect = this.parenCounts.removeLast();
                this.afterByOrSetOrFromOrSelect = this.afterByOrFromOrSelects.removeLast();
            } else if (this.valuesParenCount == this.parensSinceSelect) {
                this.valuesParenCount = 0;
                if (this.afterBeginBeforeEnd) {
                    this.decrementIndent();
                }
            }
            --this.parensSinceSelect;
            if (this.inFunction > 0) {
                --this.inFunction;
                this.out();
            } else if (this.afterOn > 0) {
                this.out();
            } else {
                if (!this.afterByOrSetOrFromOrSelect) {
                    this.decrementIndent();
                    this.newline();
                }
                this.out();
            }
            this.beginLine = false;
        }

        private void openParen() {
            if (FormatProcess.isFunctionName(this.lastToken) || this.inFunction > 0) {
                ++this.inFunction;
            }
            this.beginLine = false;
            if (this.afterOn > 0 || this.inFunction > 0) {
                this.out();
            } else {
                this.out();
                if (!this.afterByOrSetOrFromOrSelect) {
                    this.incrementIndent();
                    this.newline();
                    this.beginLine = true;
                }
            }
            ++this.parensSinceSelect;
        }

        private void incrementIndent() {
            ++this.indent;
        }

        private void decrementIndent() {
            if (this.indent > 0) {
                --this.indent;
            }
        }

        private static boolean isFunctionName(String tok) {
            if (tok == null || tok.length() == 0) {
                return false;
            }
            char begin = tok.charAt(0);
            boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
            return isIdentifier && !NON_FUNCTION_NAMES.contains(tok);
        }

        private static boolean isWhitespace(String token) {
            return " \n\r\f\t".contains(token);
        }

        private void newline() {
            this.result.append(System.lineSeparator()).append(BasicFormatterImpl.INDENT_STRING.repeat(this.indent));
            this.beginLine = true;
        }
    }
}

