/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.TimeZone;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.engine.spi.AbstractDelegatingWrapperOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

@Internal
public class LazySessionWrapperOptions
extends AbstractDelegatingWrapperOptions {
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory;
    private @Nullable @UnknownKeyFor @Initialized SessionImplementor session;

    public LazySessionWrapperOptions(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void cleanup() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SessionImplementor delegate() {
        if (this.session == null) {
            this.session = this.sessionFactory.openTemporarySession();
        }
        return this.session;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor getSession() {
        return this.delegate();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean useStreamForLobBinding() {
        return this.sessionFactory.getFastSessionServices().useStreamForLobBinding();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForBoolean() {
        return this.sessionFactory.getFastSessionServices().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TimeZone getJdbcTimeZone() {
        return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
    }
}

