/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import jakarta.transaction.Synchronization;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jboss.logging.Logger;

public class TransactionImpl
implements TransactionImplementor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = CoreLogging.logger(TransactionImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized TransactionCoordinator transactionCoordinator;
    private final @UnknownKeyFor @NonNull @Initialized boolean jpaCompliance;
    private final @UnknownKeyFor @NonNull @Initialized AbstractSharedSessionContract session;
    private @UnknownKeyFor @NonNull @Initialized TransactionCoordinator.TransactionDriver transactionDriverControl;

    public TransactionImpl(@UnknownKeyFor @NonNull @Initialized TransactionCoordinator transactionCoordinator, @UnknownKeyFor @NonNull @Initialized AbstractSharedSessionContract session) {
        this.transactionCoordinator = transactionCoordinator;
        this.jpaCompliance = session.getFactory().getSessionFactoryOptions().getJpaCompliance().isJpaTransactionComplianceEnabled();
        this.session = session;
        if (session.isOpen() && transactionCoordinator.isActive()) {
            this.transactionDriverControl = transactionCoordinator.getTransactionDriverControl();
        } else {
            LOG.debug((Object)"TransactionImpl created on closed Session/EntityManager");
        }
        if (LOG.isDebugEnabled() && this.jpaCompliance) {
            LOG.debugf("TransactionImpl created in JPA compliant mode", new Object[0]);
        }
    }

    public void begin() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("Cannot begin Transaction on closed Session/EntityManager");
        }
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        if (this.isActive()) {
            if (this.jpaCompliance) {
                throw new IllegalStateException("Transaction already active (in JPA compliant mode)");
            }
            if (!this.transactionCoordinator.getTransactionCoordinatorBuilder().isJta()) {
                throw new IllegalStateException("Resource-local transaction already active");
            }
        } else {
            LOG.debug((Object)"begin transaction");
            this.transactionDriverControl.begin();
        }
    }

    public void commit() {
        if (!this.isActive(true)) {
            throw new IllegalStateException("Transaction not successfully started");
        }
        LOG.debug((Object)"committing transaction");
        try {
            this.internalGetTransactionDriverControl().commit();
        }
        catch (RuntimeException e) {
            throw this.session.getExceptionConverter().convertCommitException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized TransactionCoordinator.TransactionDriver internalGetTransactionDriverControl() {
        if (this.transactionDriverControl == null) {
            throw new IllegalStateException("Transaction was not properly begun/started");
        }
        return this.transactionDriverControl;
    }

    public void rollback() {
        if (!this.isActive() && this.jpaCompliance) {
            throw new IllegalStateException("rollback() called on inactive transaction (in JPA compliant mode)");
        }
        TransactionStatus status = this.getStatus();
        if (status == TransactionStatus.ROLLED_BACK || status == TransactionStatus.NOT_ACTIVE) {
            LOG.debug((Object)"rollback() called on an inactive transaction");
        } else {
            if (!status.canRollback()) {
                throw new TransactionException("Cannot roll back transaction in current status [" + status.name() + "]");
            }
            if (status != TransactionStatus.FAILED_COMMIT || this.allowFailedCommitToPhysicallyRollback()) {
                LOG.debug((Object)"rolling back transaction");
                this.internalGetTransactionDriverControl().rollback();
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isActive() {
        return this.isActive(true);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isActive(@UnknownKeyFor @NonNull @Initialized boolean isMarkedForRollbackConsideredActive) {
        if (this.transactionDriverControl == null) {
            if (this.session.isOpen()) {
                this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
            } else {
                return false;
            }
        }
        return this.transactionDriverControl.isActive(isMarkedForRollbackConsideredActive);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransactionStatus getStatus() {
        if (this.transactionDriverControl == null) {
            if (this.session.isOpen()) {
                this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
            } else {
                return TransactionStatus.NOT_ACTIVE;
            }
        }
        return this.transactionDriverControl.getStatus();
    }

    @Override
    public void registerSynchronization(@UnknownKeyFor @NonNull @Initialized Synchronization synchronization) throws @UnknownKeyFor @NonNull @Initialized HibernateException {
        this.transactionCoordinator.getLocalSynchronizations().registerSynchronization(synchronization);
    }

    @Override
    public void setTimeout(@UnknownKeyFor @NonNull @Initialized int seconds) {
        this.transactionCoordinator.setTimeOut(seconds);
    }

    public void setTimeout(@Nullable @UnknownKeyFor @Initialized Integer seconds) {
        this.transactionCoordinator.setTimeOut(seconds == null ? -1 : seconds);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Integer getTimeout() {
        int timeout = this.transactionCoordinator.getTimeOut();
        return timeout == -1 ? null : Integer.valueOf(timeout);
    }

    @Override
    public void markRollbackOnly() {
        if (this.isActive()) {
            this.internalGetTransactionDriverControl().markRollbackOnly();
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            if (this.jpaCompliance) {
                throw new IllegalStateException("setRollbackOnly() called on inactive transaction (in JPA compliant mode)");
            }
            LOG.debug((Object)"setRollbackOnly() called on a inactive transaction");
        } else {
            this.markRollbackOnly();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean getRollbackOnly() {
        if (this.jpaCompliance && !this.isActive()) {
            throw new IllegalStateException("getRollbackOnly() called on inactive transaction (in JPA compliant mode)");
        }
        return this.getStatus() == TransactionStatus.MARKED_ROLLBACK;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean allowFailedCommitToPhysicallyRollback() {
        return false;
    }
}

