/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.util.List;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.EventType;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.insert.BasicSelectingDelegate;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;

public class IdentityGenerator
implements PostInsertIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator {
    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return dialect.getIdentityColumnSupport().hasIdentityInsertKeyword();
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.getIdentityColumnSupport().getIdentityInsertString()};
    }

    @Override
    public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(EntityPersister persister) {
        Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
        SessionFactoryOptions sessionFactoryOptions = persister.getFactory().getSessionFactoryOptions();
        List<? extends ModelPart> generatedProperties = persister.getGeneratedProperties(EventType.INSERT);
        if (generatedProperties.size() == 1 && sessionFactoryOptions.isGetGeneratedKeysEnabled()) {
            assert (generatedProperties.get(0).isEntityIdentifierMapping());
            return dialect.getIdentityColumnSupport().buildGetGeneratedKeysDelegate(persister);
        }
        if (dialect.supportsInsertReturningGeneratedKeys() && sessionFactoryOptions.isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate(persister, false, EventType.INSERT);
        }
        if (dialect.supportsInsertReturning() && GeneratedValuesHelper.noCustomSql(persister, EventType.INSERT)) {
            return new InsertReturningDelegate(persister, EventType.INSERT);
        }
        if (sessionFactoryOptions.isGetGeneratedKeysEnabled()) {
            return dialect.getIdentityColumnSupport().buildGetGeneratedKeysDelegate(persister);
        }
        if (persister.getNaturalIdentifierProperties() != null && !persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            return new UniqueKeySelectingDelegate(persister, NaturalIdHelper.getNaturalIdPropertyNames(persister), EventType.INSERT);
        }
        return new BasicSelectingDelegate(persister);
    }
}

