/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.ManagedType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.CacheMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.internal.SessionEventListenerManagerImpl;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.ContextualJdbcConnectionAccess;
import org.hibernate.internal.CoordinatingEntityNameResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.internal.ExceptionConverterImpl;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.JdbcSessionContextImpl;
import org.hibernate.internal.NonContextualJdbcConnectionAccess;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SharedSessionCreationOptions;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.spi.NativeQueryConstructorTransformer;
import org.hibernate.jpa.spi.NativeQueryListTransformer;
import org.hibernate.jpa.spi.NativeQueryMapTransformer;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.IllegalMutationQueryException;
import org.hibernate.query.IllegalNamedQueryOptionsException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.UnknownNamedQueryException;
import org.hibernate.query.criteria.CriteriaDefinition;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaInsert;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SqmSelectionQueryImpl;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.resource.jdbc.internal.EmptyStatementInspector;
import org.hibernate.resource.jdbc.spi.JdbcEventHandler;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.TransactionRequiredForJoinException;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;

public abstract class AbstractSharedSessionContract
implements SharedSessionContractImplementor {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SessionImpl.class);
    private transient SessionFactoryImpl factory;
    protected transient FastSessionServices fastSessionServices;
    private UUID sessionIdentifier;
    private Object sessionToken;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private transient JdbcSessionContext jdbcSessionContext;
    private transient JdbcCoordinator jdbcCoordinator;
    private transient TransactionImplementor currentHibernateTransaction;
    private transient TransactionCoordinator transactionCoordinator;
    private transient CacheTransactionSynchronization cacheTransactionSync;
    private final boolean autoJoinTransactions;
    private final boolean isTransactionCoordinatorShared;
    private final PhysicalConnectionHandlingMode connectionHandlingMode;
    private final Interceptor interceptor;
    private final Object tenantIdentifier;
    private final TimeZone jdbcTimeZone;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private Integer jdbcBatchSize;
    private boolean criteriaCopyTreeEnabled;
    private boolean nativeJdbcParametersIgnored;
    protected boolean closed;
    protected boolean waitingForAutoClose;
    private transient SessionEventListenerManager sessionEventsManager;
    private transient EntityNameResolver entityNameResolver;
    private transient ExceptionConverter exceptionConverter;

    public AbstractSharedSessionContract(SessionFactoryImpl factory, SessionCreationOptions options) {
        this.factory = factory;
        this.fastSessionServices = factory.getFastSessionServices();
        this.cacheTransactionSync = factory.getCache().getRegionFactory().createTransactionContext(this);
        this.flushMode = options.getInitialSessionFlushMode();
        this.tenantIdentifier = this.getTenantId(factory, options);
        this.interceptor = this.interpret(options.getInterceptor());
        this.jdbcTimeZone = options.getJdbcTimeZone();
        this.sessionEventsManager = this.createSessionEventsManager(options);
        this.entityNameResolver = new CoordinatingEntityNameResolver(factory, this.interceptor);
        this.setCriteriaCopyTreeEnabled(factory.getSessionFactoryOptions().isCriteriaCopyTreeEnabled());
        this.setNativeJdbcParametersIgnored(factory.getSessionFactoryOptions().getNativeJdbcParametersIgnored());
        StatementInspector statementInspector = this.interpret(options.getStatementInspector());
        this.isTransactionCoordinatorShared = AbstractSharedSessionContract.isTransactionCoordinatorShared(options);
        if (this.isTransactionCoordinatorShared) {
            SharedSessionCreationOptions sharedOptions = (SharedSessionCreationOptions)options;
            if (options.getConnection() != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.transactionCoordinator = sharedOptions.getTransactionCoordinator();
            this.jdbcCoordinator = sharedOptions.getJdbcCoordinator();
            this.currentHibernateTransaction = sharedOptions.getTransaction();
            this.connectionHandlingMode = this.jdbcCoordinator.getLogicalConnection().getConnectionHandlingMode();
            this.autoJoinTransactions = false;
            this.jdbcSessionContext = this.createJdbcSessionContext(statementInspector);
            this.logInconsistentOptions(sharedOptions);
            this.addSharedSessionTransactionObserver(this.transactionCoordinator);
        } else {
            this.autoJoinTransactions = options.shouldAutoJoinTransactions();
            this.connectionHandlingMode = options.getPhysicalConnectionHandlingMode();
            this.jdbcSessionContext = this.createJdbcSessionContext(statementInspector);
            this.jdbcCoordinator = this.createJdbcCoordinator(options);
            this.transactionCoordinator = this.fastSessionServices.transactionCoordinatorBuilder.buildTransactionCoordinator(this.jdbcCoordinator, this);
        }
    }

    private static boolean isTransactionCoordinatorShared(SessionCreationOptions options) {
        SharedSessionCreationOptions sharedSessionCreationOptions;
        return options instanceof SharedSessionCreationOptions && (sharedSessionCreationOptions = (SharedSessionCreationOptions)options).isTransactionCoordinatorShared();
    }

    protected final void setUpMultitenancy(SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        if (factory.getDefinedFilterNames().contains("_tenantId")) {
            Object tenantIdentifier = this.getTenantIdentifierValue();
            if (tenantIdentifier == null) {
                throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
            }
            CurrentTenantIdentifierResolver<Object> resolver = factory.getCurrentTenantIdentifierResolver();
            if (resolver == null || !resolver.isRoot(tenantIdentifier)) {
                loadQueryInfluencers.enableFilter("_tenantId").setParameter("tenantId", tenantIdentifier);
            }
        }
    }

    private void logInconsistentOptions(SharedSessionCreationOptions sharedOptions) {
        if (sharedOptions.shouldAutoJoinTransactions()) {
            log.debug("Session creation specified 'autoJoinTransactions', which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
        }
        if (sharedOptions.getPhysicalConnectionHandlingMode() != this.connectionHandlingMode) {
            log.debug("Session creation specified 'PhysicalConnectionHandlingMode' which is invalid in conjunction with sharing JDBC connection between sessions; ignoring");
        }
    }

    private JdbcCoordinatorImpl createJdbcCoordinator(SessionCreationOptions options) {
        return new JdbcCoordinatorImpl(options.getConnection(), this, this.fastSessionServices.jdbcServices);
    }

    private JdbcSessionContextImpl createJdbcSessionContext(StatementInspector statementInspector) {
        return new JdbcSessionContextImpl(this.factory, statementInspector, this.connectionHandlingMode, this.fastSessionServices.jdbcServices, this.fastSessionServices.batchBuilder, new JdbcEventHandler(this.factory.getStatistics(), this.sessionEventsManager, () -> this.jdbcCoordinator));
    }

    private Object getTenantId(SessionFactoryImpl factory, SessionCreationOptions options) {
        Object tenantIdentifier = options.getTenantIdentifierValue();
        if (factory.getSessionFactoryOptions().isMultiTenancyEnabled() && tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
        return tenantIdentifier;
    }

    private SessionEventListenerManager createSessionEventsManager(SessionCreationOptions options) {
        List<SessionEventListener> customSessionEventListener = options.getCustomSessionEventListener();
        return customSessionEventListener == null ? new SessionEventListenerManagerImpl(this.fastSessionServices.defaultSessionEventListeners.buildBaseline()) : new SessionEventListenerManagerImpl(customSessionEventListener.toArray(new SessionEventListener[0]));
    }

    @Override
    public Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.jdbcBatchSize;
        return sessionJdbcBatchSize == null ? this.fastSessionServices.defaultJdbcBatchSize : sessionJdbcBatchSize;
    }

    void afterTransactionBeginEvents() {
        this.getInterceptor().afterTransactionBegin(this.getTransactionIfAccessible());
    }

    void beforeTransactionCompletionEvents() {
        try {
            this.getInterceptor().beforeTransactionCompletion(this.getTransactionIfAccessible());
        }
        catch (Throwable t) {
            log.exceptionInBeforeTransactionCompletionInterceptor(t);
        }
    }

    void afterTransactionCompletionEvents(boolean successful) {
        this.getEventListenerManager().transactionCompletion(successful);
        StatisticsImplementor statistics = this.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.endTransaction(successful);
        }
        try {
            this.getInterceptor().afterTransactionCompletion(this.getTransactionIfAccessible());
        }
        catch (Throwable t) {
            log.exceptionInAfterTransactionCompletionInterceptor(t);
        }
    }

    private Transaction getTransactionIfAccessible() {
        return this.fastSessionServices.isJtaTransactionAccessible ? this.accessTransaction() : null;
    }

    protected void addSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
    }

    protected void removeSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        transactionCoordinator.invalidate();
    }

    protected void prepareForAutoClose() {
        this.waitingForAutoClose = true;
        this.closed = true;
        if (!this.isTransactionCoordinatorShared) {
            this.addSharedSessionTransactionObserver(this.transactionCoordinator);
        }
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    private Interceptor interpret(Interceptor interceptor) {
        return interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
    }

    private StatementInspector interpret(StatementInspector statementInspector) {
        return statementInspector == null ? EmptyStatementInspector.INSTANCE : statementInspector;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionContext;
    }

    public EntityNameResolver getEntityNameResolver() {
        return this.entityNameResolver;
    }

    @Override
    public SessionEventListenerManager getEventListenerManager() {
        return this.sessionEventsManager;
    }

    @Override
    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(null);
        }
        return this.sessionIdentifier;
    }

    @Override
    public Object getSessionToken() {
        if (this.sessionToken == null) {
            this.sessionToken = new Object();
        }
        return this.sessionToken;
    }

    @Override
    public String getTenantIdentifier() {
        if (this.tenantIdentifier == null) {
            return null;
        }
        return this.factory.getTenantIdentifierJavaType().toString(this.tenantIdentifier);
    }

    @Override
    public Object getTenantIdentifierValue() {
        return this.tenantIdentifier;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.factory.isClosed();
    }

    @Override
    public void close() {
        if (this.closed && !this.waitingForAutoClose) {
            return;
        }
        try {
            this.delayedAfterCompletion();
        }
        catch (HibernateException e) {
            if (this.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw this.getExceptionConverter().convert(e);
            }
            throw e;
        }
        if (this.sessionEventsManager != null) {
            this.sessionEventsManager.end();
        }
        if (this.transactionCoordinator != null) {
            this.removeSharedSessionTransactionObserver(this.transactionCoordinator);
        }
        try {
            if (this.shouldCloseJdbcCoordinatorOnClose(this.isTransactionCoordinatorShared)) {
                this.jdbcCoordinator.close();
            }
        }
        finally {
            this.setClosed();
        }
    }

    protected void setClosed() {
        this.closed = true;
        this.waitingForAutoClose = false;
        this.cleanupOnClose();
    }

    protected boolean shouldCloseJdbcCoordinatorOnClose(boolean isTransactionCoordinatorShared) {
        return true;
    }

    protected void cleanupOnClose() {
    }

    @Override
    public boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed() || this.waitingForAutoClose;
    }

    @Override
    public void checkOpen(boolean markForRollbackIfClosed) {
        if (this.isClosed()) {
            if (markForRollbackIfClosed && this.transactionCoordinator.isTransactionActive()) {
                this.markForRollbackOnly();
            }
            throw new IllegalStateException("Session/EntityManager is closed");
        }
    }

    @Override
    public void prepareForQueryExecution(boolean requiresTxn) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        if (requiresTxn && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("Query requires transaction be in progress, but no transaction is known to be in progress");
        }
    }

    protected void checkOpenOrWaitingForAutoClose() {
        if (!this.waitingForAutoClose) {
            this.checkOpen();
        }
    }

    @Override
    public void markForRollbackOnly() {
        try {
            this.accessTransaction().markRollbackOnly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        if (this.waitingForAutoClose) {
            return this.factory.isOpen() && this.transactionCoordinator.isTransactionActive();
        }
        return !this.isClosed() && this.transactionCoordinator.isTransactionActive();
    }

    @Override
    public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
        if (this.fastSessionServices.disallowOutOfTransactionUpdateOperations && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException(exceptionMessage);
        }
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        if (!this.fastSessionServices.isJtaTransactionAccessible) {
            throw new IllegalStateException("Transaction is not accessible when using JTA with JPA-compliant transaction access enabled");
        }
        return this.accessTransaction();
    }

    @Override
    public Transaction accessTransaction() {
        if (this.currentHibernateTransaction == null) {
            this.currentHibernateTransaction = new TransactionImpl(this.getTransactionCoordinator(), this);
        }
        if (!this.isClosed() || this.waitingForAutoClose && this.factory.isOpen()) {
            this.getTransactionCoordinator().pulse();
        }
        return this.currentHibernateTransaction;
    }

    @Override
    public void startTransactionBoundary() {
        this.getCacheTransactionSynchronization().transactionJoined();
    }

    @Override
    public void beforeTransactionCompletion() {
        this.getCacheTransactionSynchronization().transactionCompleting();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        this.getCacheTransactionSynchronization().transactionCompleted(successful);
    }

    @Override
    public CacheTransactionSynchronization getCacheTransactionSynchronization() {
        return this.cacheTransactionSync;
    }

    @Override
    public Transaction beginTransaction() {
        this.checkOpen();
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    protected void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    protected void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            try {
                this.transactionCoordinator.pulse();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new HibernateException("Exception pulsing TransactionCoordinator", e);
            }
        }
    }

    @Override
    public void joinTransaction() {
        this.checkOpen();
        if (!this.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta()) {
            log.callingJoinTransactionOnNonJtaEntityManager();
            return;
        }
        try {
            this.getTransactionCoordinator().explicitJoin();
        }
        catch (TransactionRequiredForJoinException e) {
            throw new TransactionRequiredException(e.getMessage());
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Override
    public boolean isJoinedToTransaction() {
        this.checkOpen();
        return this.getTransactionCoordinator().isJoined();
    }

    protected void delayedAfterCompletion() {
        if (this.transactionCoordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)this.transactionCoordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    protected TransactionImplementor getCurrentTransaction() {
        return this.currentHibernateTransaction;
    }

    @Override
    public boolean isConnected() {
        this.pulseTransactionCoordinator();
        return this.jdbcCoordinator.getLogicalConnection().isOpen();
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = !this.fastSessionServices.requiresMultiTenantConnectionProvider ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.fastSessionServices.connectionProvider, this) : new ContextualJdbcConnectionAccess(this.getTenantIdentifierValue(), this.getEventListenerManager(), this.fastSessionServices.multiTenantConnectionProvider, this);
        }
        return this.jdbcConnectionAccess;
    }

    @Override
    public EntityKey generateEntityKey(Object id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public boolean useStreamForLobBinding() {
        return this.fastSessionServices.useStreamForLobBinding;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.fastSessionServices.preferredSqlTypeCodeForBoolean;
    }

    @Override
    public LobCreator getLobCreator() {
        return this.getFactory().getFastSessionServices().jdbcServices.getLobCreator(this);
    }

    @Override
    public <T> T execute(LobCreationContext.Callback<T> callback) {
        return (T)this.getJdbcCoordinator().coordinateWork((workExecutor, connection) -> {
            try {
                return callback.executeOnConnection(connection);
            }
            catch (SQLException e) {
                throw this.getExceptionConverter().convert(e, "Error creating contextual LOB : " + e.getMessage());
            }
        });
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.jdbcTimeZone;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.getFactory().getJdbcServices();
    }

    @Override
    public FlushModeType getFlushMode() {
        this.checkOpen();
        return FlushModeTypeHelper.getFlushModeType(this.flushMode);
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Override
    public void setCriteriaCopyTreeEnabled(boolean jpaCriteriaCopyComplianceEnabled) {
        this.criteriaCopyTreeEnabled = jpaCriteriaCopyComplianceEnabled;
    }

    @Override
    public boolean isCriteriaCopyTreeEnabled() {
        return this.criteriaCopyTreeEnabled;
    }

    @Override
    public boolean getNativeJdbcParametersIgnored() {
        return this.nativeJdbcParametersIgnored;
    }

    @Override
    public void setNativeJdbcParametersIgnored(boolean nativeJdbcParametersIgnored) {
        this.nativeJdbcParametersIgnored = nativeJdbcParametersIgnored;
    }

    @Override
    public QueryImplementor createQuery(String queryString) {
        return this.createQuery(queryString, (Class)null);
    }

    @Override
    public SelectionQuery<?> createSelectionQuery(String hqlString) {
        return this.interpretAndCreateSelectionQuery(hqlString, null);
    }

    private <R> SelectionQuery<R> interpretAndCreateSelectionQuery(String hql, Class<R> resultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation<R> interpretation = this.interpretHql(hql, resultType);
            AbstractSharedSessionContract.checkSelectionQuery(hql, interpretation);
            return this.createSelectionQuery(hql, resultType, interpretation);
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw e;
        }
    }

    private <R> SelectionQuery<R> createSelectionQuery(String hql, Class<R> resultType, HqlInterpretation<R> interpretation) {
        SqmSelectionQueryImpl<R> query = new SqmSelectionQueryImpl<R>(hql, interpretation, resultType, this);
        if (resultType != null) {
            AbstractSharedSessionContract.checkResultType(resultType, query);
        }
        query.setComment(hql);
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    protected <R> HqlInterpretation<R> interpretHql(String hql, Class<R> resultType) {
        return this.getFactory().getQueryEngine().interpretHql(hql, resultType);
    }

    protected static void checkSelectionQuery(String hql, HqlInterpretation<?> hqlInterpretation) {
        if (!(hqlInterpretation.getSqmStatement() instanceof SqmSelectStatement)) {
            throw new IllegalSelectQueryException("Expecting a selection query, but found `" + hql + "`", hql);
        }
    }

    protected static <R> void checkResultType(Class<R> expectedResultType, SqmSelectionQueryImpl<R> query) {
        Class<?> resultType = query.getResultType();
        if (!expectedResultType.isAssignableFrom(resultType)) {
            throw new QueryTypeMismatchException(String.format(Locale.ROOT, "Incorrect query result type: query produces '%s' but type '%s' was given", expectedResultType.getName(), resultType.getName()));
        }
    }

    @Override
    public <R> SelectionQuery<R> createSelectionQuery(String hqlString, Class<R> expectedResultType) {
        return this.interpretAndCreateSelectionQuery(hqlString, expectedResultType);
    }

    @Override
    public <R> SelectionQuery<R> createSelectionQuery(CriteriaQuery<R> criteria) {
        if (criteria instanceof CriteriaDefinition) {
            CriteriaDefinition criteriaDefinition = (CriteriaDefinition)criteria;
            return criteriaDefinition.createSelectionQuery(this);
        }
        SqmUtil.verifyIsSelectStatement((SqmStatement)criteria, null);
        return new SqmSelectionQueryImpl((SqmSelectStatement)criteria, criteria.getResultType(), (SharedSessionContractImplementor)this);
    }

    public <T> QueryImplementor<T> createQuery(String queryString, Class<T> expectedResultType) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            HqlInterpretation<T> interpretation = this.interpretHql(queryString, expectedResultType);
            QuerySqmImpl<T> query = new QuerySqmImpl<T>(queryString, interpretation, expectedResultType, this);
            this.applyQuerySettingsAndHints((Query<?>)query);
            query.setComment(queryString);
            return query;
        }
        catch (RuntimeException e) {
            this.markForRollbackOnly();
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <R> QueryImplementor<R> createQuery(TypedQueryReference<R> typedQueryReference) {
        Query query = this.createNamedQuery(typedQueryReference.getName(), typedQueryReference.getResultType());
        for (Map.Entry entry : typedQueryReference.getHints().entrySet()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        return query;
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString) {
        return this.createNativeQuery(sqlString, (Class)null);
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, String resultSetMappingName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            return StringHelper.isNotEmpty(resultSetMappingName) ? new NativeQueryImpl(sqlString, this.getResultSetMappingMemento(resultSetMappingName), this) : new NativeQueryImpl(sqlString, (SharedSessionContractImplementor)this);
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected NamedResultSetMappingMemento getResultSetMappingMemento(String resultSetMappingName) {
        NamedResultSetMappingMemento resultSetMappingMemento = this.namedObjectRepository().getResultSetMappingMemento(resultSetMappingName);
        if (resultSetMappingMemento == null) {
            throw new HibernateException("Could not resolve specified result-set mapping name: " + resultSetMappingName);
        }
        return resultSetMappingMemento;
    }

    @Override
    public NativeQueryImplementor createNativeQuery(String sqlString, @Nullable Class resultClass) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        try {
            NativeQueryImpl query = new NativeQueryImpl(sqlString, resultClass, (SharedSessionContractImplementor)this);
            if (StringHelper.isEmpty(query.getComment())) {
                query.setComment("dynamic native SQL query");
            }
            this.applyQuerySettingsAndHints(query);
            return query;
        }
        catch (RuntimeException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    @Deprecated(forRemoval=true)
    protected <T> void addResultType(Class<T> resultClass, NativeQueryImplementor<T> query) {
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryTupleTransformer.INSTANCE);
        } else if (Map.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryMapTransformer.INSTANCE);
        } else if (List.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryListTransformer.INSTANCE);
        } else if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity(resultClass, LockMode.READ);
        } else if (resultClass != Object.class && resultClass != Object[].class) {
            if (ReflectHelper.isClass(resultClass) && !this.hasJavaTypeDescriptor(resultClass)) {
                query.setTupleTransformer((TupleTransformer)new NativeQueryConstructorTransformer<T>(resultClass));
            } else {
                query.addResultTypeClass(resultClass);
            }
        }
    }

    private <T> boolean hasJavaTypeDescriptor(Class<T> resultClass) {
        JavaType descriptor = this.getTypeConfiguration().getJavaTypeRegistry().findDescriptor(resultClass);
        return descriptor != null && descriptor.getClass() != UnknownBasicJavaType.class;
    }

    public <T> NativeQueryImplementor<T> createNativeQuery(String sqlString, Class<T> resultClass, String tableAlias) {
        NativeQueryImplementor query = this.createNativeQuery(sqlString);
        if (this.getFactory().getMappingMetamodel().isEntityClass(resultClass)) {
            query.addEntity(tableAlias, resultClass.getName(), LockMode.READ);
            return query;
        }
        throw new UnknownEntityTypeException("unable to locate persister: " + resultClass.getName());
    }

    public <T> NativeQueryImplementor<T> createNativeQuery(String sqlString, String resultSetMappingName, Class<T> resultClass) {
        NativeQueryImplementor query = this.createNativeQuery(sqlString, resultSetMappingName);
        if (Tuple.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryTupleTransformer.INSTANCE);
        } else if (Map.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryMapTransformer.INSTANCE);
        } else if (List.class.equals(resultClass)) {
            query.setTupleTransformer((TupleTransformer)NativeQueryListTransformer.INSTANCE);
        }
        return query;
    }

    @Override
    public QueryImplementor getNamedQuery(String queryName) {
        return this.buildNamedQuery(queryName, null);
    }

    @Override
    public QueryImplementor createNamedQuery(String name) {
        return this.buildNamedQuery(name, null);
    }

    @Override
    public <R> QueryImplementor<R> createNamedQuery(String name, Class<R> resultClass) {
        return this.buildNamedQuery(name, resultClass);
    }

    @Override
    public SelectionQuery<?> createNamedSelectionQuery(String queryName) {
        return this.createNamedSelectionQuery(queryName, null);
    }

    @Override
    public <R> SelectionQuery<R> createNamedSelectionQuery(String queryName, Class<R> expectedResultType) {
        return this.buildNamedQuery(queryName, memento -> this.createNamedSqmSelectionQuery((NamedSqmQueryMemento)memento, expectedResultType), memento -> this.createNamedNativeSelectionQuery((NamedNativeQueryMemento)memento, expectedResultType));
    }

    private NamedObjectRepository namedObjectRepository() {
        return this.getFactory().getQueryEngine().getNamedObjectRepository();
    }

    private NamedSqmQueryMemento getSqmQueryMemento(String queryName) {
        return this.namedObjectRepository().getSqmQueryMemento(queryName);
    }

    private NamedNativeQueryMemento getNativeQueryMemento(String queryName) {
        return this.namedObjectRepository().getNativeQueryMemento(queryName);
    }

    private <R> SelectionQuery<R> createNamedNativeSelectionQuery(NamedNativeQueryMemento memento, Class<R> expectedResultType) {
        return memento.toQuery((SharedSessionContractImplementor)this, (Class)expectedResultType);
    }

    private <R> SqmSelectionQuery<R> createNamedSqmSelectionQuery(NamedSqmQueryMemento memento, Class<R> expectedResultType) {
        SqmSelectionQuery<R> selectionQuery = memento.toSelectionQuery(expectedResultType, this);
        String comment = memento.getComment();
        selectionQuery.setComment((String)(StringHelper.isEmpty(comment) ? "Named query : " + memento.getRegistrationName() : comment));
        this.applyQuerySettingsAndHints(selectionQuery);
        LockOptions lockOptions = memento.getLockOptions();
        if (lockOptions != null) {
            selectionQuery.getLockOptions().overlay(lockOptions);
        }
        return selectionQuery;
    }

    @Override
    public void doWork(Work work) throws HibernateException {
        this.doWork((WorkExecutor<T> workExecutor, Connection connection) -> {
            workExecutor.executeWork(work, connection);
            return null;
        });
    }

    @Override
    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.doWork((WorkExecutor<T> workExecutor, Connection connection) -> workExecutor.executeReturningWork(work, connection));
    }

    private <T> T doWork(WorkExecutorVisitable<T> work) throws HibernateException {
        return this.getJdbcCoordinator().coordinateWork(work);
    }

    protected void applyQuerySettingsAndHints(SelectionQuery<?> query) {
    }

    protected void applyQuerySettingsAndHints(Query<?> query) {
    }

    protected <Q> Q buildNamedQuery(String queryName, Function<NamedSqmQueryMemento, Q> sqlCreator, Function<NamedNativeQueryMemento, Q> nativeCreator) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
        NamedSqmQueryMemento namedSqmQueryMemento = this.getSqmQueryMemento(queryName);
        if (namedSqmQueryMemento != null) {
            return sqlCreator.apply(namedSqmQueryMemento);
        }
        NamedNativeQueryMemento namedNativeDescriptor = this.getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return nativeCreator.apply(namedNativeDescriptor);
        }
        throw new UnknownNamedQueryException(queryName);
    }

    protected <T> QueryImplementor<T> buildNamedQuery(String queryName, Class<T> resultType) {
        try {
            return this.buildNamedQuery(queryName, memento -> this.createSqmQueryImplementor(resultType, (NamedSqmQueryMemento)memento), memento -> this.createNativeQueryImplementor(resultType, (NamedNativeQueryMemento)memento));
        }
        catch (UnknownNamedQueryException e) {
            this.transactionCoordinator.getTransactionDriverControl().markRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    protected <T> NativeQueryImplementor<T> createNativeQueryImplementor(Class<T> resultType, NamedNativeQueryMemento memento) {
        QueryImplementor query;
        QueryImplementor queryImplementor = query = resultType == null ? memento.toQuery(this) : memento.toQuery((SharedSessionContractImplementor)this, (Class)resultType);
        if (StringHelper.isEmpty(query.getComment())) {
            query.setComment("dynamic native-SQL query");
        }
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    protected <T> SqmQueryImplementor<T> createSqmQueryImplementor(Class<T> resultType, NamedSqmQueryMemento memento) {
        QueryImplementor query = memento.toQuery((SharedSessionContractImplementor)this, (Class)resultType);
        if (StringHelper.isEmpty(query.getComment())) {
            query.setComment("dynamic query");
        }
        this.applyQuerySettingsAndHints(query);
        if (memento.getLockOptions() != null) {
            query.setLockOptions(memento.getLockOptions());
        }
        return query;
    }

    @Override
    public NativeQueryImplementor getNamedNativeQuery(String queryName) {
        NamedNativeQueryMemento namedNativeDescriptor = this.getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return namedNativeDescriptor.toQuery(this);
        }
        throw this.noQueryForNameException(queryName);
    }

    @Override
    public NativeQueryImplementor getNamedNativeQuery(String queryName, String resultSetMapping) {
        NamedNativeQueryMemento namedNativeDescriptor = this.getNativeQueryMemento(queryName);
        if (namedNativeDescriptor != null) {
            return namedNativeDescriptor.toQuery((SharedSessionContractImplementor)this, resultSetMapping);
        }
        throw this.noQueryForNameException(queryName);
    }

    private RuntimeException noQueryForNameException(String queryName) {
        return this.getExceptionConverter().convert(new IllegalArgumentException("No query defined for that name [" + queryName + "]"));
    }

    @Override
    public MutationQuery createMutationQuery(String hqlString) {
        QueryImplementor query = this.createQuery(hqlString);
        SqmStatement sqmStatement = ((SqmQueryImplementor)query).getSqmStatement();
        AbstractSharedSessionContract.checkMutationQuery(hqlString, sqmStatement);
        return query;
    }

    protected static void checkMutationQuery(String hqlString, SqmStatement<?> sqmStatement) {
        if (!(sqmStatement instanceof SqmDmlStatement)) {
            throw new IllegalMutationQueryException("Expecting a mutation query, but found `" + hqlString + "`");
        }
    }

    @Override
    public MutationQuery createNativeMutationQuery(String sqlString) {
        NativeQueryImplementor query = this.createNativeQuery(sqlString);
        if (query.isSelectQuery() == Boolean.TRUE) {
            throw new IllegalMutationQueryException("Expecting a native mutation query, but found `" + sqlString + "`");
        }
        return query;
    }

    @Override
    public MutationQuery createNamedMutationQuery(String queryName) {
        return this.buildNamedQuery(queryName, memento -> this.createSqmQueryImplementor(queryName, (NamedSqmQueryMemento)memento), memento -> this.createNativeQueryImplementor(queryName, (NamedNativeQueryMemento)memento));
    }

    protected NativeQueryImplementor<?> createNativeQueryImplementor(String queryName, NamedNativeQueryMemento memento) {
        QueryImplementor query = memento.toQuery(this);
        Boolean isUnequivocallySelect = query.isSelectQuery();
        if (isUnequivocallySelect == Boolean.TRUE) {
            throw new IllegalMutationQueryException("Expecting named native query (" + queryName + ") to be a mutation query, but found `" + memento.getSqlString() + "`");
        }
        if (StringHelper.isEmpty(query.getComment())) {
            query.setComment("dynamic native-SQL query");
        }
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    protected SqmQueryImplementor<?> createSqmQueryImplementor(String queryName, NamedSqmQueryMemento memento) {
        QueryImplementor query = memento.toQuery(this);
        SqmStatement sqmStatement = query.getSqmStatement();
        if (!(sqmStatement instanceof SqmDmlStatement)) {
            throw new IllegalMutationQueryException("Expecting a named mutation query (" + queryName + "), but found a select statement");
        }
        if (memento.getLockOptions() != null && !memento.getLockOptions().isEmpty()) {
            throw new IllegalNamedQueryOptionsException("Named mutation query `" + queryName + "` specified lock-options");
        }
        if (StringHelper.isEmpty(query.getComment())) {
            query.setComment("dynamic HQL query");
        }
        this.applyQuerySettingsAndHints(query);
        return query;
    }

    @Override
    public MutationQuery createMutationQuery(CriteriaUpdate updateQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmUpdateStatement)updateQuery, null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public MutationQuery createMutationQuery(CriteriaDelete deleteQuery) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmDeleteStatement)deleteQuery, null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public MutationQuery createMutationQuery(JpaCriteriaInsertSelect insertSelect) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmInsertSelectStatement)insertSelect, null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public MutationQuery createMutationQuery(JpaCriteriaInsert insertSelect) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmInsertStatement)insertSelect, null);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall getNamedProcedureCall(String name) {
        this.checkOpen();
        NamedCallableQueryMemento memento = this.factory.getQueryEngine().getNamedObjectRepository().getCallableQueryMemento(name);
        if (memento == null) {
            throw new IllegalArgumentException("Could not find named stored procedure call with that registration name : " + name);
        }
        ProcedureCall procedureCall = memento.makeProcedureCall(this);
        return procedureCall;
    }

    @Override
    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        return this.getNamedProcedureCall(name);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SharedSessionContractImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    @Override
    public ExceptionConverter getExceptionConverter() {
        if (this.exceptionConverter == null) {
            this.exceptionConverter = new ExceptionConverterImpl(this);
        }
        return this.exceptionConverter;
    }

    @Override
    public Integer getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
    }

    @Override
    public EventManager getEventManager() {
        return this.fastSessionServices.getEventManager();
    }

    @Override
    public HibernateCriteriaBuilder getCriteriaBuilder() {
        this.checkOpen();
        return this.getFactory().getCriteriaBuilder();
    }

    public <T> QueryImplementor<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkOpen();
        if (criteriaQuery instanceof CriteriaDefinition) {
            CriteriaDefinition criteriaDefinition = (CriteriaDefinition)criteriaQuery;
            return (QueryImplementor)criteriaDefinition.createSelectionQuery(this);
        }
        try {
            JpaQueryStructure querySpec;
            SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
            if (!(selectStatement.getQueryPart() instanceof SqmQueryGroup) && ((SqmQuerySpec)(querySpec = selectStatement.getQuerySpec())).getSelectClause().getSelections().isEmpty() && ((SqmQuerySpec)querySpec).getFromClause().getRoots().size() == 1) {
                ((SqmQuerySpec)querySpec).getSelectClause().setSelection((SqmSelectableNode)((SqmQuerySpec)querySpec).getFromClause().getRoots().get(0));
            }
            return this.createCriteriaQuery(selectStatement, criteriaQuery.getResultType());
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public QueryImplementor createQuery(CriteriaUpdate criteriaUpdate) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmUpdateStatement)criteriaUpdate, null);
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public QueryImplementor createQuery(CriteriaDelete criteriaDelete) {
        this.checkOpen();
        try {
            return this.createCriteriaQuery((SqmDeleteStatement)criteriaDelete, null);
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    protected <T> QueryImplementor<T> createCriteriaQuery(SqmStatement<T> criteria, Class<T> resultType) {
        QuerySqmImpl<T> query = new QuerySqmImpl<T>(criteria, resultType, (SharedSessionContractImplementor)this);
        this.applyQuerySettingsAndHints((Query<?>)query);
        return query;
    }

    public <T> RootGraphImplementor<T> createEntityGraph(Class<T> rootType) {
        this.checkOpen();
        return new RootGraphImpl(null, this.getFactory().getJpaMetamodel().entity(rootType));
    }

    @Override
    public <T> RootGraph<T> createEntityGraph(Class<T> rootType, String graphName) {
        RootGraph entityGraph = this.createEntityGraph(graphName);
        if (entityGraph == null) {
            return null;
        }
        ManagedType type = this.getFactory().getJpaMetamodel().managedType(rootType);
        ManagedDomainType graphedType = entityGraph.getGraphedType();
        if (!Objects.equals(graphedType.getTypeName(), type.getTypeName())) {
            throw new IllegalArgumentException("Named entity graph '" + graphName + "' is for type '" + graphedType.getTypeName() + "'");
        }
        return entityGraph;
    }

    public RootGraphImplementor<?> createEntityGraph(String graphName) {
        this.checkOpen();
        RootGraph named = this.getFactory().findEntityGraphByName(graphName);
        if (named == null) {
            return null;
        }
        return named.makeRootGraph(graphName, true);
    }

    public RootGraphImplementor<?> getEntityGraph(String graphName) {
        this.checkOpen();
        RootGraph named = this.getFactory().findEntityGraphByName(graphName);
        if (named == null) {
            throw new IllegalArgumentException("Could not locate EntityGraph with given name : " + graphName);
        }
        return named;
    }

    @Override
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        this.checkOpen();
        return this.getFactory().findEntityGraphsByType(entityClass);
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        this.pulseTransactionCoordinator();
        return this.getLoadQueryInfluencers().getEnabledFilter(filterName);
    }

    @Override
    public Filter enableFilter(String filterName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        return this.getLoadQueryInfluencers().enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.getLoadQueryInfluencers().disableFilter(filterName);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Serializing " + this.getClass().getSimpleName() + " [");
        }
        if (!this.jdbcCoordinator.isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] while connected");
        }
        if (this.isTransactionCoordinatorShared) {
            throw new IllegalStateException("Cannot serialize " + this.getClass().getSimpleName() + " [" + this.getSessionIdentifier() + "] as it has a shared TransactionCoordinator");
        }
        oos.defaultWriteObject();
        this.factory.serialize(oos);
        oos.writeObject(this.jdbcSessionContext.getStatementInspector());
        this.jdbcCoordinator.serialize(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace("Deserializing " + this.getClass().getSimpleName());
        }
        ois.defaultReadObject();
        this.factory = SessionFactoryImpl.deserialize(ois);
        this.fastSessionServices = this.factory.getFastSessionServices();
        this.sessionEventsManager = new SessionEventListenerManagerImpl(this.fastSessionServices.defaultSessionEventListeners.buildBaseline());
        this.jdbcSessionContext = this.createJdbcSessionContext((StatementInspector)ois.readObject());
        this.jdbcCoordinator = JdbcCoordinatorImpl.deserialize(ois, this);
        this.cacheTransactionSync = this.factory.getCache().getRegionFactory().createTransactionContext(this);
        this.transactionCoordinator = this.factory.getServiceRegistry().requireService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(this.jdbcCoordinator, this);
        this.entityNameResolver = new CoordinatingEntityNameResolver(this.factory, this.interceptor);
    }
}

