/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.internal.StatisticalLoggingSessionEventListener;

public class BaselineSessionEventsListenerBuilder {
    private static final SessionEventListener[] EMPTY = new SessionEventListener[0];
    private final Class<? extends SessionEventListener> autoListener;

    public BaselineSessionEventsListenerBuilder(Class<? extends SessionEventListener> autoListener) {
        this.autoListener = autoListener;
    }

    public Class<? extends SessionEventListener> getAutoListener() {
        return this.autoListener;
    }

    public List<SessionEventListener> buildBaselineList() {
        SessionEventListener[] sessionEventListeners = this.buildBaseline();
        ArrayList<SessionEventListener> list = new ArrayList<SessionEventListener>(sessionEventListeners.length + 3);
        Collections.addAll(list, sessionEventListeners);
        return list;
    }

    public SessionEventListener[] buildBaseline() {
        SessionEventListener[] arr = this.autoListener != null ? (StatisticalLoggingSessionEventListener.isLoggingEnabled() ? new SessionEventListener[]{BaselineSessionEventsListenerBuilder.buildStatsListener(), BaselineSessionEventsListenerBuilder.buildAutoListener(this.autoListener)} : new SessionEventListener[]{BaselineSessionEventsListenerBuilder.buildAutoListener(this.autoListener)}) : (StatisticalLoggingSessionEventListener.isLoggingEnabled() ? new SessionEventListener[]{BaselineSessionEventsListenerBuilder.buildStatsListener()} : EMPTY);
        return arr;
    }

    private static SessionEventListener buildAutoListener(Class<? extends SessionEventListener> autoListener) {
        try {
            return autoListener.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate specified auto SessionEventListener: " + autoListener.getName(), e);
        }
    }

    private static SessionEventListener buildStatsListener() {
        return new StatisticalLoggingSessionEventListener();
    }
}

