/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.ProviderUtil;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceConfigurationDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.ProviderChecker;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;

public class HibernatePersistenceProvider
implements PersistenceProvider {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(HibernatePersistenceProvider.class);
    private final PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private final ProviderUtil providerUtil = new ProviderUtil(){

        public LoadState isLoadedWithoutReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithoutReference(proxy, property, HibernatePersistenceProvider.this.cache);
        }

        public LoadState isLoadedWithReference(Object proxy, String property) {
            return PersistenceUtilHelper.isLoadedWithReference(proxy, property, HibernatePersistenceProvider.this.cache);
        }

        public LoadState isLoaded(Object object) {
            return PersistenceUtilHelper.getLoadState(object);
        }
    };

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        log.tracef("Starting createEntityManagerFactory for persistenceUnitName %s", persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties);
        if (builder == null) {
            log.trace("Could not obtain matching EntityManagerFactoryBuilder, returning null");
            return null;
        }
        return builder.build();
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map<?, ?> properties) {
        return this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties, null, null);
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map<?, ?> properties, ClassLoader providedClassLoader) {
        return this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties, providedClassLoader, null);
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map<?, ?> properties, ClassLoaderService providedClassLoaderService) {
        return this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties, null, providedClassLoaderService);
    }

    private EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map<?, ?> properties, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        log.tracef("Attempting to obtain correct EntityManagerFactoryBuilder for persistenceUnitName : %s", persistenceUnitName);
        Map<?, ?> integration = HibernatePersistenceProvider.wrap(properties);
        Collection<PersistenceUnitDescriptor> units = this.locatePersistenceUnits(integration, providedClassLoader, providedClassLoaderService);
        log.debugf("Located and parsed %s persistence units; checking each", units.size());
        if (persistenceUnitName == null && units.size() > 1) {
            throw new PersistenceException("No name provided and multiple persistence units found");
        }
        for (PersistenceUnitDescriptor persistenceUnit : units) {
            boolean matches;
            if (log.isDebugEnabled()) {
                log.debugf("Checking persistence-unit [name=%s, explicit-provider=%s] against incoming persistence unit name [%s]", persistenceUnit.getName(), persistenceUnit.getProviderClassName(), persistenceUnitName);
            }
            boolean bl = matches = persistenceUnitName == null || persistenceUnit.getName().equals(persistenceUnitName);
            if (!matches) {
                log.debug("Excluding from consideration due to name mis-match");
                continue;
            }
            if (!ProviderChecker.isProvider(persistenceUnit, properties)) {
                log.debug("Excluding from consideration due to provider mis-match");
                continue;
            }
            if (providedClassLoaderService != null) {
                return this.getEntityManagerFactoryBuilder(persistenceUnit, integration, providedClassLoaderService);
            }
            return this.getEntityManagerFactoryBuilder(persistenceUnit, integration, providedClassLoader);
        }
        log.debug("Found no matching persistence units");
        return null;
    }

    protected static Map<?, ?> wrap(Map<?, ?> properties) {
        return properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    protected Collection<PersistenceUnitDescriptor> locatePersistenceUnits(Map<?, ?> integration, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        List<PersistenceUnitDescriptor> units;
        try {
            PersistenceXmlParser parser = PersistenceXmlParser.create(integration, providedClassLoader, providedClassLoaderService);
            List<URL> xmlUrls = parser.getClassLoaderService().locateResources("META-INF/persistence.xml");
            if (xmlUrls.isEmpty()) {
                log.unableToFindPersistenceXmlInClasspath();
                units = List.of();
            } else {
                units = parser.parse(xmlUrls).values();
            }
        }
        catch (Exception e) {
            log.debug("Unable to locate persistence units", e);
            throw new PersistenceException("Unable to locate persistence units", (Throwable)e);
        }
        return units;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting createContainerEntityManagerFactory : %s", info.getPersistenceUnitName());
        }
        return this.getEntityManagerFactoryBuilder(info, properties).build();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting generateSchema : PUI.name=%s", info.getPersistenceUnitName());
        }
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder(info, map);
        builder.generateSchema();
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        log.tracef("Starting generateSchema for persistenceUnitName %s", persistenceUnitName);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, map);
        if (builder == null) {
            log.trace("Could not obtain matching EntityManagerFactoryBuilder, returning false");
            return false;
        }
        builder.generateSchema();
        return true;
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitInfo info, Map<?, ?> integration) {
        return Bootstrap.getEntityManagerFactoryBuilder(info, integration);
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitDescriptor persistenceUnitDescriptor, Map<?, ?> integration, ClassLoader providedClassLoader) {
        return Bootstrap.getEntityManagerFactoryBuilder(persistenceUnitDescriptor, integration, providedClassLoader);
    }

    protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitDescriptor persistenceUnitDescriptor, Map<?, ?> integration, ClassLoaderService providedClassLoaderService) {
        return Bootstrap.getEntityManagerFactoryBuilder(persistenceUnitDescriptor, integration, providedClassLoaderService);
    }

    public EntityManagerFactory createEntityManagerFactory(PersistenceConfiguration configuration) {
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)new PersistenceConfigurationDescriptor(configuration), Collections.emptyMap(), HibernatePersistenceProvider.class.getClassLoader());
        return builder.build();
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }
}

