/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.FlushModeType;
import java.util.Locale;
import org.hibernate.FlushMode;
import org.hibernate.MappingException;
import org.hibernate.query.QueryFlushMode;
import org.jboss.logging.Logger;

public class FlushModeTypeHelper {
    private static final Logger log = Logger.getLogger(FlushModeTypeHelper.class);

    private FlushModeTypeHelper() {
    }

    public static FlushModeType getFlushModeType(FlushMode flushMode) {
        if (flushMode == null) {
            return null;
        }
        return switch (flushMode) {
            default -> throw new IncompatibleClassChangeError();
            case FlushMode.ALWAYS -> {
                log.debug((Object)"Interpreting Hibernate FlushMode.ALWAYS as JPA FlushModeType.AUTO (may cause problems if relying on FlushMode.ALWAYS-specific behavior)");
                yield FlushModeType.AUTO;
            }
            case FlushMode.MANUAL -> {
                log.debug((Object)"Interpreting Hibernate FlushMode.MANUAL as JPA FlushModeType.COMMIT (may cause problems if relying on FlushMode.MANUAL-specific behavior)");
                yield FlushModeType.COMMIT;
            }
            case FlushMode.COMMIT -> FlushModeType.COMMIT;
            case FlushMode.AUTO -> FlushModeType.AUTO;
        };
    }

    public static QueryFlushMode getForcedFlushMode(FlushMode flushMode) {
        if (flushMode == null) {
            return QueryFlushMode.DEFAULT;
        }
        return switch (flushMode) {
            default -> throw new IncompatibleClassChangeError();
            case FlushMode.ALWAYS -> QueryFlushMode.FLUSH;
            case FlushMode.MANUAL, FlushMode.COMMIT -> QueryFlushMode.NO_FLUSH;
            case FlushMode.AUTO -> QueryFlushMode.DEFAULT;
        };
    }

    public static FlushMode getFlushMode(FlushModeType flushModeType) {
        if (flushModeType == null) {
            return null;
        }
        return switch (flushModeType) {
            default -> throw new IncompatibleClassChangeError();
            case FlushModeType.AUTO -> FlushMode.AUTO;
            case FlushModeType.COMMIT -> FlushMode.COMMIT;
        };
    }

    public static FlushMode getFlushMode(QueryFlushMode queryFlushMode) {
        if (queryFlushMode == null) {
            return null;
        }
        return switch (queryFlushMode) {
            case QueryFlushMode.FLUSH -> FlushMode.ALWAYS;
            case QueryFlushMode.NO_FLUSH -> FlushMode.MANUAL;
            default -> null;
        };
    }

    public static FlushMode interpretFlushMode(Object value) {
        if (value == null) {
            return FlushMode.AUTO;
        }
        if (value instanceof FlushMode) {
            FlushMode flushMode = (FlushMode)((Object)value);
            return flushMode;
        }
        if (value instanceof FlushModeType) {
            FlushModeType flushModeType = (FlushModeType)value;
            return FlushModeTypeHelper.getFlushMode(flushModeType);
        }
        if (value instanceof String) {
            String string = (String)value;
            return FlushModeTypeHelper.interpretExternalSetting(string);
        }
        throw new IllegalArgumentException("Unknown FlushMode source : " + value);
    }

    public static FlushMode interpretExternalSetting(String externalName) {
        if (externalName == null) {
            return null;
        }
        try {
            log.debugf("Attempting to interpret external setting [%s] as FlushMode name", (Object)externalName);
            return FlushMode.valueOf(externalName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            log.debugf("Attempting to interpret external setting [%s] as FlushModeType name", (Object)externalName);
            try {
                return FlushModeTypeHelper.getFlushMode(FlushModeType.valueOf((String)externalName.toLowerCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MappingException("unknown FlushMode : " + externalName);
            }
        }
    }
}

