/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.spi.LoadState;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.collection.spi.LazyInitializable;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class PersistenceUtilHelper {
    private PersistenceUtilHelper() {
    }

    public static LoadState getLoadState(Object reference) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(reference);
        if (lazyInitializer != null) {
            return !lazyInitializer.isUninitialized() ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(reference)) {
            return PersistenceUtilHelper.isInitialized(ManagedTypeHelper.asPersistentAttributeInterceptable(reference)) ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        if (reference instanceof LazyInitializable) {
            return ((LazyInitializable)reference).wasInitialized() ? LoadState.LOADED : LoadState.NOT_LOADED;
        }
        return LoadState.UNKNOWN;
    }

    private static boolean isInitialized(PersistentAttributeInterceptable interceptable) {
        BytecodeLazyAttributeInterceptor interceptor = PersistenceUtilHelper.extractInterceptor(interceptable);
        return interceptor == null || !interceptor.hasAnyUninitializedAttributes();
    }

    private static BytecodeLazyAttributeInterceptor extractInterceptor(PersistentAttributeInterceptable interceptable) {
        return (BytecodeLazyAttributeInterceptor)interceptable.$$_hibernate_getInterceptor();
    }

    public static LoadState isLoadedWithoutReference(Object entity, String attributeName, MetadataCache cache) {
        boolean sureFromUs = false;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return LoadState.NOT_LOADED;
            }
            entity = lazyInitializer.getImplementation();
            sureFromUs = true;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity)) {
            LoadState state;
            boolean isInitialized;
            BytecodeLazyAttributeInterceptor interceptor = PersistenceUtilHelper.extractInterceptor(ManagedTypeHelper.asPersistentAttributeInterceptable(entity));
            boolean bl = isInitialized = interceptor == null || interceptor.isAttributeLoaded(attributeName);
            if (isInitialized && interceptor != null) {
                try {
                    state = PersistenceUtilHelper.getLoadState(PersistenceUtilHelper.getAttributeValue(entity, attributeName, cache));
                    if (state == LoadState.UNKNOWN) {
                        state = LoadState.LOADED;
                    }
                }
                catch (AttributeExtractionException ignore) {
                    state = LoadState.UNKNOWN;
                }
            } else if (interceptor != null) {
                state = LoadState.NOT_LOADED;
            } else if (sureFromUs) {
                try {
                    state = PersistenceUtilHelper.getLoadState(PersistenceUtilHelper.getAttributeValue(entity, attributeName, cache));
                    if (state == LoadState.UNKNOWN) {
                        state = LoadState.LOADED;
                    }
                }
                catch (AttributeExtractionException ignore) {
                    state = LoadState.UNKNOWN;
                }
            } else {
                state = LoadState.UNKNOWN;
            }
            return state;
        }
        return LoadState.UNKNOWN;
    }

    public static LoadState isLoadedWithReference(Object entity, String attributeName, MetadataCache cache) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return LoadState.NOT_LOADED;
            }
            entity = lazyInitializer.getImplementation();
        }
        try {
            return PersistenceUtilHelper.getLoadState(PersistenceUtilHelper.getAttributeValue(entity, attributeName, cache));
        }
        catch (AttributeExtractionException ignore) {
            return LoadState.UNKNOWN;
        }
    }

    private static Object getAttributeValue(Object entity, String attributeName, MetadataCache cache) {
        return cache.getClassMetadata(entity.getClass()).getAttributeAccess(attributeName).extractValue(entity);
    }

    private static Method getMethod(Class<?> clazz, String attributeName) {
        try {
            char[] string = attributeName.toCharArray();
            string[0] = Character.toUpperCase(string[0]);
            String casedAttributeName = new String(string);
            try {
                return clazz.getDeclaredMethod("get" + casedAttributeName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return clazz.getDeclaredMethod("is" + casedAttributeName, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static final class MetadataCache
    implements Serializable {
        private final ClassValue<ClassMetadataCache> metadataCacheClassValue;

        public MetadataCache() {
            this(new MetadataClassValue());
        }

        private MetadataCache(ClassValue<ClassMetadataCache> metadataCacheClassValue) {
            this.metadataCacheClassValue = metadataCacheClassValue;
        }

        Object writeReplace() throws ObjectStreamException {
            return new MetadataCache(null);
        }

        private Object readResolve() throws ObjectStreamException {
            return new MetadataCache();
        }

        ClassMetadataCache getClassMetadata(Class<?> clazz) {
            return this.metadataCacheClassValue.get(clazz);
        }
    }

    public static class AttributeExtractionException
    extends HibernateException {
        public AttributeExtractionException(String message) {
            super(message);
        }

        public AttributeExtractionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ClassMetadataCache {
        private final Class<?> specifiedClass;
        private final List<Class<?>> classHierarchy;
        private final Map<String, AttributeAccess> attributeAccessMap = new HashMap<String, AttributeAccess>();

        public ClassMetadataCache(Class<?> clazz) {
            this.specifiedClass = clazz;
            this.classHierarchy = ClassMetadataCache.findClassHierarchy(clazz);
        }

        private static List<Class<?>> findClassHierarchy(Class<?> clazz) {
            ArrayList classes = new ArrayList();
            Class<?> current = clazz;
            do {
                classes.add(current);
            } while ((current = current.getSuperclass()) != null);
            return classes;
        }

        public AttributeAccess getAttributeAccess(String attributeName) {
            AttributeAccess attributeAccess = this.attributeAccessMap.get(attributeName);
            if (attributeAccess == null) {
                attributeAccess = this.buildAttributeAccess(attributeName);
                this.attributeAccessMap.put(attributeName, attributeAccess);
            }
            return attributeAccess;
        }

        private AttributeAccess buildAttributeAccess(String attributeName) {
            for (Class<?> clazz : this.classHierarchy) {
                try {
                    return new FieldAttributeAccess(clazz.getDeclaredField(attributeName));
                }
                catch (NoSuchFieldException e) {
                    Method method = PersistenceUtilHelper.getMethod(clazz, attributeName);
                    if (method == null) continue;
                    return new MethodAttributeAccess(attributeName, method);
                }
            }
            return new NoSuchAttributeAccess(this.specifiedClass, attributeName);
        }
    }

    public static interface AttributeAccess {
        public Object extractValue(Object var1) throws AttributeExtractionException;
    }

    private static final class MetadataClassValue
    extends ClassValue<ClassMetadataCache> {
        private MetadataClassValue() {
        }

        @Override
        protected ClassMetadataCache computeValue(Class type) {
            return new ClassMetadataCache(type);
        }
    }

    private static class NoSuchAttributeAccess
    implements AttributeAccess {
        private final Class<?> clazz;
        private final String attributeName;

        public NoSuchAttributeAccess(Class<?> clazz, String attributeName) {
            this.clazz = clazz;
            this.attributeName = attributeName;
        }

        @Override
        public Object extractValue(Object owner) throws AttributeExtractionException {
            throw new AttributeExtractionException("No such attribute : " + this.clazz.getName() + "#" + this.attributeName);
        }
    }

    public static class MethodAttributeAccess
    implements AttributeAccess {
        private final String name;
        private final Method method;

        public MethodAttributeAccess(String attributeName, Method method) {
            this.name = attributeName;
            try {
                ReflectHelper.ensureAccessibility(method);
            }
            catch (Exception e) {
                this.method = null;
                return;
            }
            this.method = method;
        }

        @Override
        public Object extractValue(Object owner) {
            if (this.method == null) {
                throw new AttributeExtractionException("Attribute (method) " + this.name + " is not accessible");
            }
            try {
                return this.method.invoke(owner, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new AttributeExtractionException("Unable to access attribute (method): " + this.method.getDeclaringClass().getName() + "#" + this.name, e);
            }
            catch (InvocationTargetException e) {
                throw new AttributeExtractionException("Unable to access attribute (method): " + this.method.getDeclaringClass().getName() + "#" + this.name, e.getCause());
            }
        }
    }

    public static class FieldAttributeAccess
    implements AttributeAccess {
        private final String name;
        private final Field field;

        public FieldAttributeAccess(Field field) {
            this.name = field.getName();
            try {
                ReflectHelper.ensureAccessibility(field);
            }
            catch (Exception e) {
                this.field = null;
                return;
            }
            this.field = field;
        }

        @Override
        public Object extractValue(Object owner) {
            if (this.field == null) {
                throw new AttributeExtractionException("Attribute (field) " + this.name + " is not accessible");
            }
            try {
                return this.field.get(owner);
            }
            catch (IllegalAccessException e) {
                throw new AttributeExtractionException("Unable to access attribute (field): " + this.field.getDeclaringClass().getName() + "#" + this.name, e);
            }
        }
    }
}

