/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.ast.internal.AbstractMultiIdEntityLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiKeyLoadSizingStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class MultiIdEntityLoaderStandard<T>
extends AbstractMultiIdEntityLoader<T> {
    private final int idJdbcTypeCount;

    public MultiIdEntityLoaderStandard(EntityPersister entityDescriptor, int idColumnSpan, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.idJdbcTypeCount = idColumnSpan;
        assert (this.idJdbcTypeCount > 0);
    }

    private boolean isInClauseParameterPaddingEnabled() {
        return this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled();
    }

    private MultiKeyLoadSizingStrategy getBatchLoadSizingStrategy() {
        return this.getJdbcServices().getJdbcEnvironment().getDialect().getBatchLoadSizingStrategy();
    }

    @Override
    protected void handleResults(MultiIdLoadOptions loadOptions, EventSource session, List<Integer> elementPositionsLoadedByBatch, List<Object> result) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        for (Integer position : elementPositionsLoadedByBatch) {
            EntityKey entityKey = (EntityKey)result.get(position);
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled()) {
                EntityEntry entry = persistenceContext.getEntry(entity);
                entity = entry.getStatus().isDeletedOrGone() ? null : persistenceContext.proxyFor(entity);
            }
            result.set(position, entity);
        }
    }

    @Override
    protected int maxBatchSize(Object[] ids, MultiIdLoadOptions loadOptions) {
        Integer explicitBatchSize = loadOptions.getBatchSize();
        return explicitBatchSize != null && explicitBatchSize > 0 ? explicitBatchSize.intValue() : this.getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.idJdbcTypeCount, ids.length, this.isInClauseParameterPaddingEnabled());
    }

    @Override
    protected void loadEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (idsInBatch != null);
        assert (!idsInBatch.isEmpty());
        this.listEntitiesById(idsInBatch, lockOptions, loadOptions, session);
    }

    private List<T> listEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, MultiIdLoadOptions loadOptions, EventSource session) {
        int numberOfIdsInBatch = idsInBatch.size();
        return numberOfIdsInBatch == 1 ? this.performSingleMultiLoad(idsInBatch.get(0), lockOptions, session) : this.performRegularMultiLoad(idsInBatch, lockOptions, loadOptions, session, numberOfIdsInBatch);
    }

    private List<T> performRegularMultiLoad(List<Object> idsInBatch, LockOptions lockOptions, MultiIdLoadOptions loadOptions, EventSource session, int numberOfIdsInBatch) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("#loadEntitiesById(`%s`, `%s`, ..)", (Object)this.getLoadable().getEntityName(), (Object)numberOfIdsInBatch);
        }
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder(numberOfIdsInBatch * this.idJdbcTypeCount);
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, numberOfIdsInBatch, session.getLoadQueryInfluencers(), lockOptions, jdbcParametersBuilder::add, this.getSessionFactory());
        JdbcParametersList jdbcParameters = jdbcParametersBuilder.build();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = 0;
        for (int i = 0; i < numberOfIdsInBatch; ++i) {
            offset += jdbcParameterBindings.registerParametersForEachJdbcValue(idsInBatch.get(i), offset, this.getLoadable().getIdentifierMapping(), jdbcParameters, session);
        }
        assert (offset == jdbcParameters.size());
        return this.getJdbcSelectExecutor().list(this.getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE), jdbcParameterBindings, new ExecutionContextWithSubselectFetchHandler(session, this.fetchableKeysHandler(session, sqlAst, jdbcParameters, jdbcParameterBindings), Boolean.TRUE.equals(loadOptions.getReadOnly(session))), RowTransformerStandardImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, idsInBatch.size());
    }

    private SubselectFetch.RegistrationHandler fetchableKeysHandler(EventSource session, SelectStatement sqlAst, JdbcParametersList jdbcParameters, JdbcParameterBindings jdbcParameterBindings) {
        BatchFetchQueue batchFetchQueue = session.getPersistenceContext().getBatchFetchQueue();
        return session.getLoadQueryInfluencers().hasSubselectLoadableCollections(this.getLoadable().getEntityPersister()) ? SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, jdbcParameters, jdbcParameterBindings) : null;
    }

    private List<T> performSingleMultiLoad(Object id, LockOptions lockOptions, SharedSessionContractImplementor session) {
        Object loaded = this.getLoadable().getEntityPersister().load(id, null, lockOptions, session);
        return Collections.singletonList(loaded);
    }

    @Override
    protected void loadEntitiesWithUnresolvedIds(MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session, Object[] unresolvableIds, List<T> result) {
        int maxBatchSize = this.maxBatchSize(unresolvableIds, loadOptions);
        int numberOfIdsLeft = unresolvableIds.length;
        int idPosition = 0;
        while (numberOfIdsLeft > 0) {
            int batchSize = Math.min(numberOfIdsLeft, maxBatchSize);
            Object[] idsInBatch = new Object[batchSize];
            System.arraycopy(unresolvableIds, idPosition, idsInBatch, 0, batchSize);
            result.addAll(this.listEntitiesById(Arrays.asList(idsInBatch), lockOptions, loadOptions, session));
            numberOfIdsLeft -= batchSize;
            idPosition += batchSize;
        }
    }
}

