/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.MetaType;
import org.hibernate.type.Type;

public interface Value
extends Serializable {
    public int getColumnSpan();

    public List<Selectable> getSelectables();

    public List<Column> getColumns();

    default public List<Selectable> getVirtualSelectables() {
        return this.getSelectables();
    }

    default public List<Column> getConstraintColumns() {
        return this.getColumns();
    }

    public Type getType() throws MappingException;

    @Deprecated(since="7.0")
    default public JdbcMapping getSelectableType(Mapping factory, int index) throws MappingException {
        return this.getSelectableType((MappingContext)factory, index);
    }

    @Incubating
    default public JdbcMapping getSelectableType(MappingContext mappingContext, int index) throws MappingException {
        return this.getType(mappingContext, this.getType(), index);
    }

    private JdbcMapping getType(MappingContext factory, Type elementType, int index) {
        if (elementType instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)elementType;
            Type[] subtypes = compositeType.getSubtypes();
            for (int i = 0; i < subtypes.length; ++i) {
                int columnSpan;
                Type subtype = subtypes[i];
                if (subtype instanceof EntityType) {
                    EntityType entityType = (EntityType)subtype;
                    v0 = this.getIdType(entityType).getColumnSpan(factory);
                } else {
                    v0 = columnSpan = subtype.getColumnSpan(factory);
                }
                if (columnSpan < index) {
                    index -= columnSpan;
                    continue;
                }
                if (columnSpan == 0) continue;
                return this.getType(factory, subtype, index);
            }
            throw new IllegalStateException("Type index is past the types column span!");
        }
        if (elementType instanceof EntityType) {
            EntityType entityType = (EntityType)elementType;
            return this.getType(factory, this.getIdType(entityType), index);
        }
        if (elementType instanceof MetaType) {
            MetaType metaType = (MetaType)elementType;
            return (JdbcMapping)((Object)metaType.getBaseType());
        }
        return (JdbcMapping)((Object)elementType);
    }

    private Type getIdType(EntityType entityType) {
        PersistentClass entityBinding = this.getBuildingContext().getMetadataCollector().getEntityBinding(entityType.getAssociatedEntityName());
        return entityType.isReferenceToPrimaryKey() ? entityBinding.getIdentifier().getType() : entityBinding.getProperty(entityType.getRHSUniqueKeyPropertyName()).getType();
    }

    public FetchMode getFetchMode();

    public Table getTable();

    public boolean hasFormula();

    public boolean isAlternateUniqueKey();

    public boolean isNullable();

    public void createForeignKey();

    public void createUniqueKey(MetadataBuildingContext var1);

    public boolean isSimpleValue();

    @Deprecated(since="7.0")
    default public boolean isValid(Mapping mapping) throws MappingException {
        return this.isValid((MappingContext)mapping);
    }

    public boolean isValid(MappingContext var1) throws MappingException;

    public void setTypeUsingReflection(String var1, String var2) throws MappingException;

    public Object accept(ValueVisitor var1);

    public boolean isSame(Value var1);

    public boolean[] getColumnInsertability();

    public boolean hasAnyInsertableColumns();

    public boolean[] getColumnUpdateability();

    public boolean hasAnyUpdatableColumns();

    @Incubating
    default public MetadataBuildingContext getBuildingContext() {
        throw new UnsupportedOperationException("Value#getBuildingContext is not implemented by: " + this.getClass().getName());
    }

    public ServiceRegistry getServiceRegistry();

    public Value copy();

    public boolean isColumnInsertable(int var1);

    public boolean isColumnUpdateable(int var1);

    @Incubating
    default public String getExtraCreateTableInfo() {
        return "";
    }

    @Internal
    default public void checkColumnDuplication(Set<String> distinctColumns, String owner) {
        for (int i = 0; i < this.getSelectables().size(); ++i) {
            Column col;
            Selectable selectable = this.getSelectables().get(i);
            if (!this.isColumnInsertable(i) && !this.isColumnUpdateable(i) || distinctColumns.add((col = (Column)selectable).getName())) continue;
            throw new MappingException("Column '" + col.getName() + "' is duplicated in mapping for " + owner + " (use '@Column(insertable=false, updatable=false)' when mapping multiple properties to the same column)");
        }
    }
}

