/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.HibernateException;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class FullNameImplicitDiscriminatorStrategy
implements ImplicitDiscriminatorStrategy {
    public static final FullNameImplicitDiscriminatorStrategy FULL_NAME_STRATEGY = new FullNameImplicitDiscriminatorStrategy();

    @Override
    public Object toDiscriminatorValue(EntityMappingType entityMapping, NavigableRole discriminatorRole, MappingMetamodelImplementor mappingModel) {
        return entityMapping.getEntityName();
    }

    @Override
    public EntityMappingType toEntityMapping(Object discriminatorValue, NavigableRole discriminatorRole, MappingMetamodelImplementor mappingModel) {
        String assumedEntityName;
        EntityPersister persister;
        if (discriminatorValue instanceof String && (persister = mappingModel.findEntityDescriptor(assumedEntityName = (String)discriminatorValue)) != null) {
            return persister;
        }
        throw new HibernateException("Cannot interpret discriminator value (" + discriminatorRole + ") : " + discriminatorValue);
    }
}

