/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.internal.FullNameImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.DiscriminatorValueDetailsImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.StringJavaType;

public class UnifiedAnyDiscriminatorConverter<O, R>
extends DiscriminatorConverter<O, R> {
    private final NavigableRole discriminatorRole;
    private final Map<Object, DiscriminatorValueDetails> detailsByValue;
    private final Map<String, DiscriminatorValueDetails> detailsByEntityName;
    private final ImplicitDiscriminatorStrategy implicitValueStrategy;
    private final MappingMetamodelImplementor mappingMetamodel;

    public UnifiedAnyDiscriminatorConverter(NavigableRole discriminatorRole, JavaType<O> domainJavaType, JavaType<R> relationalJavaType, Map<Object, String> explicitValueMappings, ImplicitDiscriminatorStrategy implicitValueStrategy, MappingMetamodelImplementor mappingMetamodel) {
        super(discriminatorRole.getFullPath(), domainJavaType, relationalJavaType);
        this.discriminatorRole = discriminatorRole;
        this.mappingMetamodel = mappingMetamodel;
        this.implicitValueStrategy = this.resolveImplicitValueStrategy(implicitValueStrategy, explicitValueMappings);
        this.detailsByValue = CollectionHelper.concurrentMap(explicitValueMappings.size());
        this.detailsByEntityName = CollectionHelper.concurrentMap(explicitValueMappings.size());
        explicitValueMappings.forEach((value, entityName) -> {
            String importedEntityName = mappingMetamodel.getImportedName((String)entityName);
            EntityPersister entityMapping = mappingMetamodel.getEntityDescriptor(importedEntityName);
            this.register(value, entityMapping);
        });
    }

    private ImplicitDiscriminatorStrategy resolveImplicitValueStrategy(ImplicitDiscriminatorStrategy implicitValueStrategy, Map<Object, String> explicitValueMappings) {
        if (explicitValueMappings.isEmpty()) {
            if (implicitValueStrategy == null) {
                return FullNameImplicitDiscriminatorStrategy.FULL_NAME_STRATEGY;
            }
        } else if (explicitValueMappings.containsKey(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) && implicitValueStrategy != null) {
            throw new HibernateException("Illegal use of ImplicitDiscriminatorStrategy with explicit non-null discriminator mapping: " + this.discriminatorRole.getFullPath());
        }
        return implicitValueStrategy;
    }

    private DiscriminatorValueDetails register(Object value, EntityMappingType entityMapping) {
        DiscriminatorValueDetailsImpl details = new DiscriminatorValueDetailsImpl(value, entityMapping);
        this.detailsByValue.put(value, details);
        this.detailsByEntityName.put(entityMapping.getEntityName(), details);
        return details;
    }

    public Map<Object, DiscriminatorValueDetails> getDetailsByValue() {
        return this.detailsByValue;
    }

    public Map<String, DiscriminatorValueDetails> getDetailsByEntityName() {
        return this.detailsByEntityName;
    }

    @Override
    public DiscriminatorValueDetails getDetailsForDiscriminatorValue(Object relationalValue) {
        EntityMappingType entityMapping;
        Object enumValue;
        DiscriminatorValueDetails enumMatch;
        if (relationalValue == null) {
            return this.detailsByValue.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        DiscriminatorValueDetails existing = this.detailsByValue.get(relationalValue);
        if (existing != null) {
            return existing;
        }
        if (relationalValue.getClass().isEnum() && (enumMatch = this.detailsByValue.get(enumValue = this.getRelationalJavaType() instanceof StringJavaType ? ((Enum)relationalValue).name() : (this.getRelationalJavaType() instanceof CharacterJavaType ? (Comparable<Character>)Character.valueOf(((Enum)relationalValue).name().charAt(0)) : (Comparable<Character>)Integer.valueOf(((Enum)relationalValue).ordinal())))) != null) {
            return enumMatch;
        }
        if (this.implicitValueStrategy != null && (entityMapping = this.implicitValueStrategy.toEntityMapping(relationalValue, this.discriminatorRole, this.mappingMetamodel)) != null) {
            return this.register(relationalValue, entityMapping);
        }
        DiscriminatorValueDetails nonNullMatch = this.detailsByValue.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR);
        if (nonNullMatch != null) {
            return nonNullMatch;
        }
        throw new HibernateException("Unknown discriminator value (" + this.discriminatorRole.getFullPath() + ") : " + relationalValue);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForEntityName(String entityName) {
        DiscriminatorValueDetails existing = this.detailsByEntityName.get(entityName);
        if (existing != null) {
            return existing;
        }
        if (this.implicitValueStrategy != null) {
            EntityPersister entityMapping = this.mappingMetamodel.getEntityDescriptor(entityName);
            assert (entityMapping != null);
            Object discriminatorValue = this.implicitValueStrategy.toDiscriminatorValue(entityMapping, this.discriminatorRole, this.mappingMetamodel);
            return this.register(discriminatorValue, entityMapping);
        }
        throw new HibernateException("Cannot determine discriminator value from entity-name (" + this.discriminatorRole.getFullPath() + ") : " + entityName);
    }

    @Override
    public void forEachValueDetail(Consumer<DiscriminatorValueDetails> consumer) {
        this.detailsByEntityName.values().forEach(consumer);
    }

    @Override
    public <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> handler) {
        for (DiscriminatorValueDetails valueDetails : this.detailsByEntityName.values()) {
            X result = handler.apply(valueDetails);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

