/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.InjectionHelper;
import org.hibernate.metamodel.internal.JpaMetamodelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetamodelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.DynamicModelJavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class JpaMetamodelImpl
implements JpaMetamodelImplementor,
Serializable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(JpaMetamodel.class);
    private final TypeConfiguration typeConfiguration;
    private final MappingMetamodel mappingMetamodel;
    private final ServiceRegistry serviceRegistry;
    private final Map<String, ManagedDomainType<?>> managedTypeByName = new TreeMap();
    private final Map<Class<?>, ManagedDomainType<?>> managedTypeByClass = new HashMap();
    private JpaMetamodelPopulationSetting jpaMetaModelPopulationSetting;
    private final Map<String, Set<String>> allowedEnumLiteralsToEnumTypeNames = new HashMap<String, Set<String>>();
    private final Map<String, EnumJavaType<?>> enumJavaTypes = new HashMap();
    private final transient Map<String, RootGraphImplementor<?>> entityGraphMap = new ConcurrentHashMap();
    private final Map<Class<?>, SqmPolymorphicRootDescriptor<?>> polymorphicEntityReferenceMap = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityProxyInterfaceMap = new HashMap();
    private final Map<String, ImportInfo<?>> nameToImportMap = new ConcurrentHashMap();
    private final Map<String, Object> knownInvalidnameToImportMap = new ConcurrentHashMap<String, Object>();

    public JpaMetamodelImpl(TypeConfiguration typeConfiguration, MappingMetamodel mappingMetamodel, ServiceRegistry serviceRegistry) {
        this.typeConfiguration = typeConfiguration;
        this.mappingMetamodel = mappingMetamodel;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.typeConfiguration.getJpaCompliance();
    }

    @Override
    public <X> @Nullable ManagedDomainType<X> findManagedType(@Nullable String typeName) {
        return typeName == null ? null : this.managedTypeByName.get(typeName);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(String typeName) {
        ManagedDomainType<X> managedType = this.findManagedType(typeName);
        if (managedType == null) {
            throw new IllegalArgumentException("Not a managed type: " + typeName);
        }
        return managedType;
    }

    @Override
    public @Nullable EntityDomainType<?> findEntityType(@Nullable String entityName) {
        if (entityName == null) {
            return null;
        }
        ManagedDomainType<?> managedType = this.managedTypeByName.get(entityName);
        if (!(managedType instanceof EntityDomainType)) {
            return null;
        }
        EntityDomainType entityDomainType = (EntityDomainType)managedType;
        return entityDomainType;
    }

    @Override
    public EntityDomainType<?> entity(String entityName) {
        EntityDomainType<?> entityType = this.findEntityType(entityName);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + entityName);
        }
        return entityType;
    }

    @Override
    public @Nullable EmbeddableDomainType<?> findEmbeddableType(@Nullable String embeddableName) {
        if (embeddableName == null) {
            return null;
        }
        ManagedDomainType<?> managedType = this.managedTypeByName.get(embeddableName);
        if (!(managedType instanceof EmbeddableDomainType)) {
            return null;
        }
        EmbeddableDomainType embeddableDomainType = (EmbeddableDomainType)managedType;
        return embeddableDomainType;
    }

    @Override
    public EmbeddableDomainType<?> embeddable(String embeddableName) {
        EmbeddableDomainType<?> embeddableType = this.findEmbeddableType(embeddableName);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an embeddable: " + embeddableName);
        }
        return embeddableType;
    }

    @Override
    public <X> EntityDomainType<X> getHqlEntityReference(String entityName) {
        EntityDomainType<?> entityDescriptor;
        Class<Object> loadedClass = null;
        ImportInfo importInfo = this.resolveImport(entityName);
        if (importInfo != null) {
            loadedClass = importInfo.loadedClass;
            entityName = importInfo.importedName;
        }
        if ((entityDescriptor = this.findEntityType(entityName)) != null) {
            return entityDescriptor;
        }
        if (loadedClass == null) {
            loadedClass = this.resolveRequestedClass(entityName);
            if (importInfo != null && loadedClass != null) {
                importInfo.loadedClass = loadedClass;
            }
        }
        if (loadedClass != null) {
            return this.resolveEntityReference(loadedClass);
        }
        return null;
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        EntityDomainType<X> hqlEntityReference = this.getHqlEntityReference(entityName);
        if (hqlEntityReference == null) {
            throw new EntityTypeException("Could not resolve entity name '" + entityName + "'", entityName);
        }
        return hqlEntityReference;
    }

    @Override
    public <X> @Nullable ManagedDomainType<X> findManagedType(Class<X> cls) {
        return this.managedTypeByClass.get(cls);
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        ManagedDomainType<X> type = this.findManagedType(cls);
        if (type == null) {
            throw new IllegalArgumentException("Not a managed type: " + cls);
        }
        return type;
    }

    @Override
    public <X> @Nullable EntityDomainType<X> findEntityType(Class<X> cls) {
        ManagedType type = this.managedTypeByClass.get(cls);
        if (!(type instanceof EntityDomainType)) {
            return null;
        }
        return (EntityDomainType)type;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        EntityDomainType<X> entityType = this.findEntityType(cls);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls.getName());
        }
        return entityType;
    }

    @Override
    public <X> @Nullable EmbeddableDomainType<X> findEmbeddableType(Class<X> cls) {
        ManagedType type = this.managedTypeByClass.get(cls);
        if (!(type instanceof EmbeddableDomainType)) {
            return null;
        }
        return (EmbeddableDomainType)type;
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        EmbeddableDomainType<X> embeddableType = this.findEmbeddableType(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an embeddable: " + cls.getName());
        }
        return embeddableType;
    }

    private Collection<ManagedDomainType<?>> getAllManagedTypes() {
        return switch (this.jpaMetaModelPopulationSetting) {
            default -> throw new IncompatibleClassChangeError();
            case JpaMetamodelPopulationSetting.IGNORE_UNSUPPORTED -> this.managedTypeByClass.values();
            case JpaMetamodelPopulationSetting.ENABLED -> this.managedTypeByName.values();
            case JpaMetamodelPopulationSetting.DISABLED -> Collections.emptySet();
        };
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        return new HashSet(this.getAllManagedTypes());
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return this.getAllManagedTypes().stream().filter(EntityType.class::isInstance).map(t -> (EntityType)t).collect(Collectors.toSet());
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.getAllManagedTypes().stream().filter(EmbeddableType.class::isInstance).map(t -> (EmbeddableType)t).collect(Collectors.toSet());
    }

    @Override
    public @Nullable Set<String> getEnumTypesForValue(String enumValue) {
        return this.allowedEnumLiteralsToEnumTypeNames.get(enumValue);
    }

    @Override
    public EnumJavaType<?> getEnumType(String className) {
        return this.enumJavaTypes.get(className);
    }

    @Override
    public <E extends Enum<E>> E enumValue(EnumJavaType<E> enumType, String enumValueName) {
        return (E)Enum.valueOf(enumType.getJavaTypeClass(), enumValueName);
    }

    @Override
    public JavaType<?> getJavaConstantType(String className, String fieldName) {
        try {
            Field referencedField = this.getJavaField(className, fieldName);
            if (referencedField != null) {
                return this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(referencedField.getType());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <T> T getJavaConstant(String className, String fieldName) {
        try {
            Field referencedField = this.getJavaField(className, fieldName);
            return (T)referencedField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getJavaField(String className, String fieldName) throws NoSuchFieldException {
        Class namedClass = this.getServiceRegistry().requireService(ClassLoaderService.class).classForName(className);
        if (namedClass != null) {
            return namedClass.getDeclaredField(fieldName);
        }
        return null;
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        EntityGraph old = this.entityGraphMap.put(graphName, entityGraph.makeImmutableCopy(graphName));
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", graphName);
        }
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.entityGraphMap.get(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        EntityType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity: " + entityClass.getName());
        }
        ArrayList<RootGraphImplementor<T>> results = new ArrayList<RootGraphImplementor<T>>();
        for (RootGraphImplementor<?> entityGraph : this.entityGraphMap.values()) {
            if (!entityGraph.appliesTo((EntityDomainType<?>)entityType)) continue;
            RootGraphImplementor<?> result = entityGraph;
            results.add(result);
        }
        return results;
    }

    @Override
    public <T> Map<String, EntityGraph<? extends T>> getNamedEntityGraphs(Class<T> entityClass) {
        EntityType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity: " + entityClass.getName());
        }
        HashMap<String, EntityGraph<T>> results = new HashMap<String, EntityGraph<T>>();
        for (RootGraphImplementor<?> entityGraph : this.entityGraphMap.values()) {
            if (!entityGraph.appliesTo((EntityDomainType<?>)entityType)) continue;
            results.put(entityGraph.getName(), entityGraph);
        }
        return results;
    }

    @Override
    public String qualifyImportableName(String queryName) {
        ImportInfo importInfo = this.resolveImport(queryName);
        return importInfo == null ? null : importInfo.importedName;
    }

    private <T> ImportInfo<T> resolveImport(String name) {
        ImportInfo<?> importInfo = this.nameToImportMap.get(name);
        if (importInfo != null) {
            return importInfo;
        }
        if (this.knownInvalidnameToImportMap.containsKey(name)) {
            return null;
        }
        Class loadedClass = this.resolveRequestedClass(name);
        if (loadedClass == null) {
            if (this.knownInvalidnameToImportMap.size() < 1000) {
                this.knownInvalidnameToImportMap.put(name, name);
            }
            return null;
        }
        ImportInfo info = new ImportInfo(name, loadedClass);
        this.nameToImportMap.put(name, info);
        return info;
    }

    private void applyNamedEntityGraphs(Collection<NamedEntityGraphDefinition> namedEntityGraphs) {
        for (NamedEntityGraphDefinition definition : namedEntityGraphs) {
            log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s]", definition.getRegisteredName(), definition.getEntityName(), definition.getJpaEntityName());
            EntityDomainType<?> entityType = this.findEntityType(definition.getEntityName());
            if (entityType == null) {
                throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
            }
            NamedEntityGraph namedEntityGraph = definition.getAnnotation();
            RootGraphImpl<?> entityGraph = JpaMetamodelImpl.createRootGraph(definition.getRegisteredName(), entityType, namedEntityGraph.includeAllAttributes());
            if (namedEntityGraph.attributeNodes() != null) {
                this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
            }
            this.entityGraphMap.put(definition.getRegisteredName(), entityGraph);
        }
    }

    private static <T> RootGraphImpl<T> createRootGraph(String name, EntityDomainType<T> entityType, boolean includeAllAttributes) {
        RootGraphImpl<T> entityGraph = new RootGraphImpl<T>(name, entityType);
        if (includeAllAttributes) {
            for (Attribute attribute : entityType.getAttributes()) {
                entityGraph.addAttributeNodes(attribute);
            }
        }
        return entityGraph;
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor<?> graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            AttributeNodeImplementor attributeNode = graphNode.findOrCreateAttributeNode(namedAttributeNode.value());
            if (StringHelper.isNotEmpty(namedAttributeNode.subgraph())) {
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), (SubGraphImplementor<?>)attributeNode.makeSubGraph());
            }
            if (!StringHelper.isNotEmpty(namedAttributeNode.keySubgraph())) continue;
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), (SubGraphImplementor<?>)attributeNode.makeKeySubGraph());
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubGraphImplementor<?> subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    private <X> Class<X> resolveRequestedClass(String entityName) {
        try {
            return this.getServiceRegistry().requireService(ClassLoaderService.class).classForName(entityName);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public <T> EntityDomainType<T> resolveEntityReference(Class<T> javaType) {
        ManagedDomainType<?> managedType = this.managedTypeByClass.get(javaType);
        if (managedType instanceof EntityDomainType) {
            return (EntityDomainType)managedType;
        }
        String proxyEntityName = this.entityProxyInterfaceMap.get(javaType);
        if (proxyEntityName != null) {
            return this.entity(proxyEntityName);
        }
        EntityDomainType polymorphicDomainType = this.polymorphicEntityReferenceMap.get(javaType);
        if (polymorphicDomainType != null) {
            return polymorphicDomainType;
        }
        HashSet matchingDescriptors = new HashSet();
        for (ManagedDomainType<?> managedType2 : this.managedTypeByName.values()) {
            ManagedDomainType<?> superType;
            if (managedType2.getPersistenceType() != Type.PersistenceType.ENTITY || !javaType.isAssignableFrom(managedType2.getJavaType()) || (superType = managedType2.getSuperType()) != null && superType.getPersistenceType() == Type.PersistenceType.ENTITY && javaType.isAssignableFrom(superType.getJavaType())) continue;
            matchingDescriptors.add((EntityDomainType)managedType2);
        }
        if (!matchingDescriptors.isEmpty()) {
            SqmPolymorphicRootDescriptor descriptor = new SqmPolymorphicRootDescriptor(this.typeConfiguration.getJavaTypeRegistry().resolveDescriptor(javaType), matchingDescriptors);
            this.polymorphicEntityReferenceMap.putIfAbsent(javaType, descriptor);
            return descriptor;
        }
        throw new EntityTypeException("Could not resolve entity class '" + javaType.getName() + "'", javaType.getName());
    }

    @Override
    public MappingMetamodel getMappingMetamodel() {
        return this.mappingMetamodel;
    }

    public void processJpa(MetadataImplementor bootMetamodel, MappingMetamodel mappingMetamodel, Map<Class<?>, String> entityProxyInterfaceMap, JpaStaticMetamodelPopulationSetting jpaStaticMetaModelPopulationSetting, JpaMetamodelPopulationSetting jpaMetaModelPopulationSetting, Collection<NamedEntityGraphDefinition> namedEntityGraphDefinitions, RuntimeModelCreationContext runtimeModelCreationContext) {
        bootMetamodel.getImports().forEach((key, value) -> this.nameToImportMap.put((String)key, new ImportInfo((String)value, null)));
        this.entityProxyInterfaceMap.putAll(entityProxyInterfaceMap);
        MetadataContext context = new MetadataContext(this, mappingMetamodel, bootMetamodel, jpaStaticMetaModelPopulationSetting, jpaMetaModelPopulationSetting, runtimeModelCreationContext);
        for (PersistentClass entityBinding : bootMetamodel.getEntityBindings()) {
            this.locateOrBuildEntityType(entityBinding, context, this.typeConfiguration);
        }
        this.handleUnusedMappedSuperclasses(context, this.typeConfiguration);
        context.wrapUp();
        this.jpaMetaModelPopulationSetting = jpaMetaModelPopulationSetting;
        this.managedTypeByName.putAll(context.getIdentifiableTypesByName());
        this.managedTypeByClass.putAll(context.getEntityTypeMap());
        this.managedTypeByClass.putAll(context.getMappedSuperclassTypeMap());
        int mapEmbeddables = 0;
        for (EmbeddableDomainType<?> embeddable : context.getEmbeddableTypeSet()) {
            if (embeddable.getExpressibleJavaType() instanceof EntityJavaType) continue;
            Class embeddableClass = embeddable.getJavaType();
            if (embeddableClass != Map.class) {
                this.managedTypeByClass.put(embeddable.getJavaType(), embeddable);
                this.managedTypeByName.put(embeddable.getTypeName(), embeddable);
                continue;
            }
            this.managedTypeByName.put("dynamic-embeddable-" + mapEmbeddables++, embeddable);
        }
        this.typeConfiguration.getJavaTypeRegistry().forEachDescriptor(descriptor -> {
            if (descriptor instanceof EnumJavaType) {
                EnumJavaType enumJavaType = (EnumJavaType)descriptor;
                Class enumJavaClass = enumJavaType.getJavaTypeClass();
                for (Enum enumConstant : (Enum[])enumJavaClass.getEnumConstants()) {
                    JpaMetamodelImpl.addAllowedEnumLiteralsToEnumTypesMap(this.allowedEnumLiteralsToEnumTypeNames, enumConstant.name(), enumJavaClass.getSimpleName(), enumJavaClass.getCanonicalName(), enumJavaClass.getName());
                    this.enumJavaTypes.put(enumJavaClass.getName(), enumJavaType);
                    this.enumJavaTypes.put(enumJavaClass.getCanonicalName(), enumJavaType);
                }
            }
        });
        this.applyNamedEntityGraphs(namedEntityGraphDefinitions);
        this.populateStaticMetamodel(bootMetamodel, context);
    }

    private void populateStaticMetamodel(MetadataImplementor bootMetamodel, MetadataContext context) {
        bootMetamodel.visitNamedHqlQueryDefinitions(definition -> InjectionHelper.injectTypedQueryReference(definition, this.namedQueryMetamodelClass((NamedQueryDefinition<?>)definition, context)));
        bootMetamodel.visitNamedNativeQueryDefinitions(definition -> InjectionHelper.injectTypedQueryReference(definition, this.namedQueryMetamodelClass((NamedQueryDefinition<?>)definition, context)));
        bootMetamodel.getNamedEntityGraphs().values().forEach(definition -> InjectionHelper.injectEntityGraph(definition, this.graphMetamodelClass((NamedEntityGraphDefinition)definition, context), this));
    }

    private Class<?> namedQueryMetamodelClass(NamedQueryDefinition<?> definition, MetadataContext context) {
        String location = definition.getLocation();
        return location == null ? null : context.metamodelClass(this.managedTypeByName.get(location));
    }

    private Class<?> graphMetamodelClass(NamedEntityGraphDefinition definition, MetadataContext context) {
        return context.metamodelClass(this.managedTypeByName.get(definition.getEntityName()));
    }

    public static void addAllowedEnumLiteralsToEnumTypesMap(Map<String, Set<String>> allowedEnumLiteralsToEnumTypeNames, String enumConstantName, String enumSimpleName, String enumAlternativeName, String enumClassName) {
        allowedEnumLiteralsToEnumTypeNames.computeIfAbsent(enumConstantName, s -> new HashSet()).add(enumClassName);
        String simpleQualifiedName = enumSimpleName + "." + enumConstantName;
        allowedEnumLiteralsToEnumTypeNames.computeIfAbsent(simpleQualifiedName, s -> new HashSet()).add(enumClassName);
        String qualifiedAlternativeName = enumAlternativeName + "." + enumConstantName;
        allowedEnumLiteralsToEnumTypeNames.computeIfAbsent(qualifiedAlternativeName, s -> new HashSet()).add(enumClassName);
        String qualifiedName = enumClassName + "." + enumConstantName;
        allowedEnumLiteralsToEnumTypeNames.computeIfAbsent(qualifiedName, s -> new HashSet()).add(enumClassName);
    }

    private <T> EntityDomainType<T> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        EntityDomainType<?> entityType = context.locateEntityType(persistentClass);
        return entityType == null ? this.buildEntityType(persistentClass, context, typeConfiguration) : entityType;
    }

    private <T> EntityTypeImpl<T> buildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        context.pushEntityWorkedOn(persistentClass);
        EntityTypeImpl<T> entityType = new EntityTypeImpl<T>(JpaMetamodelImpl.javaType(persistentClass, context), this.supertypeForPersistentClass(persistentClass, context, typeConfiguration), persistentClass, (JpaMetamodelImplementor)this);
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private static <T> JavaType<T> javaType(PersistentClass persistentClass, MetadataContext context) {
        Class<?> javaTypeClass = persistentClass.getMappedClass();
        if (javaTypeClass == null || Map.class.isAssignableFrom(javaTypeClass)) {
            return new DynamicModelJavaType();
        }
        return context.getTypeConfiguration().getJavaTypeRegistry().resolveEntityTypeDescriptor(javaTypeClass);
    }

    private void handleUnusedMappedSuperclasses(MetadataContext context, TypeConfiguration typeConfiguration) {
        Set<MappedSuperclass> unusedMappedSuperclasses = context.getUnusedMappedSuperclasses();
        if (!unusedMappedSuperclasses.isEmpty()) {
            for (MappedSuperclass mappedSuperclass : unusedMappedSuperclasses) {
                log.unusedMappedSuperclass(mappedSuperclass.getMappedClass().getName());
                this.locateOrBuildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
            }
        }
    }

    private <T> MappedSuperclassDomainType<T> locateOrBuildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        return mappedSuperclassType == null ? this.buildMappedSuperclassType(mappedSuperclass, context, typeConfiguration) : mappedSuperclassType;
    }

    private <T> MappedSuperclassTypeImpl<T> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        IdentifiableDomainType<T> superType = this.supertypeForMappedSuperclass(mappedSuperclass, context, typeConfiguration);
        JavaType javaType = context.getTypeConfiguration().getJavaTypeRegistry().resolveManagedTypeDescriptor(mappedSuperclass.getMappedClass());
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaType, mappedSuperclass, superType, (JpaMetamodelImplementor)this);
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }

    private <T> IdentifiableDomainType<? super T> supertypeForPersistentClass(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<T> supertype;
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<T> mappedSuperclassDomainType = supertype = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (supertype == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            return superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        return supertype;
    }

    private <T> IdentifiableDomainType<? super T> supertypeForMappedSuperclass(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<T> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<T> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            return superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        return superType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.typeConfiguration.getSessionFactory());
    }

    private static class ImportInfo<T> {
        private final String importedName;
        private Class<T> loadedClass;

        private ImportInfo(String importedName, Class<T> loadedClass) {
            this.importedName = importedName;
            this.loadedClass = loadedClass;
        }
    }

    private static class SerialForm
    implements Serializable {
        private final SessionFactoryImplementor sessionFactory;

        public SerialForm(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        private Object readResolve() {
            return this.sessionFactory.getJpaMetamodel();
        }
    }
}

