/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Locale;

public enum SortDirection {
    ASCENDING,
    DESCENDING;


    public SortDirection reverse() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ASCENDING -> DESCENDING;
            case DESCENDING -> ASCENDING;
        };
    }

    public static SortDirection interpret(String value) {
        if (value == null) {
            return null;
        }
        return switch (value.toLowerCase(Locale.ROOT)) {
            case "asc", "ascending" -> ASCENDING;
            case "desc", "descending" -> DESCENDING;
            default -> throw new IllegalArgumentException("Unknown sort order: " + value);
        };
    }
}

