/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.complete.CompleteFetchBuilderEntityValuedModelPart;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;

public class FetchMementoHbmStandard
implements FetchMemento,
FetchMemento.Parent {
    private static final String ELEMENT_PREFIX = "element.";
    private static final int ELEMENT_PREFIX_LENGTH = 8;
    private final NavigablePath navigablePath;
    private final String ownerTableAlias;
    private final String tableAlias;
    private final List<String> keyColumnNames;
    private final LockMode lockMode;
    private final FetchParentMemento parent;
    private final Map<String, FetchMemento> fetchMementoMap;
    private final Fetchable fetchable;

    public FetchMementoHbmStandard(NavigablePath navigablePath, String ownerTableAlias, String tableAlias, List<String> keyColumnNames, LockMode lockMode, FetchParentMemento parent, Map<String, FetchMemento> fetchMementoMap, Fetchable fetchable) {
        this.navigablePath = navigablePath;
        this.ownerTableAlias = ownerTableAlias;
        this.tableAlias = tableAlias;
        this.keyColumnNames = keyColumnNames;
        this.lockMode = lockMode;
        this.parent = parent;
        this.fetchMementoMap = fetchMementoMap;
        this.fetchable = fetchable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public FetchBuilder resolve(FetchMemento.Parent parent, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        Fetchable fetchable = this.fetchable;
        if (fetchable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
            return this.resolve(pluralAttributeMapping, querySpaceConsumer, context);
        }
        return this.resolve((ToOneAttributeMapping)this.fetchable, querySpaceConsumer, context);
    }

    private FetchBuilder resolve(PluralAttributeMapping pluralAttributeMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        EntityMappingType partMappingType = (EntityMappingType)pluralAttributeMapping.getElementDescriptor().getPartMappingType();
        DynamicResultBuilderEntityStandard resultBuilder = new DynamicResultBuilderEntityStandard(partMappingType, this.tableAlias, this.navigablePath);
        HashMap<Fetchable, FetchBuilder> fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>();
        this.fetchMementoMap.forEach((attrName, fetchMemento) -> {
            FetchBuilder fetchBuilder = fetchMemento.resolve(this, querySpaceConsumer, context);
            if (attrName.equals("element")) {
                if (fetchBuilder instanceof DynamicFetchBuilder) {
                    DynamicFetchBuilder dynamicFetchBuilder = (DynamicFetchBuilder)fetchBuilder;
                    resultBuilder.addIdColumnAliases(dynamicFetchBuilder.getColumnAliases().toArray(new String[0]));
                } else {
                    resultBuilder.addIdColumnAliases(((CompleteFetchBuilderEntityValuedModelPart)fetchBuilder).getColumnAliases().toArray(new String[0]));
                }
                fetchBuilderMap.put(pluralAttributeMapping.getElementDescriptor(), fetchBuilder);
            } else if (attrName.equals("index")) {
                CollectionPart indexDescriptor = pluralAttributeMapping.getIndexDescriptor();
                resultBuilder.addFetchBuilder(indexDescriptor, fetchBuilder);
                fetchBuilderMap.put(indexDescriptor, fetchBuilder);
            } else if (attrName.startsWith(ELEMENT_PREFIX)) {
                Fetchable attributeMapping = (Fetchable)partMappingType.findByPath(attrName.substring(8));
                resultBuilder.addFetchBuilder(attributeMapping, fetchBuilder);
                fetchBuilderMap.put(attributeMapping, fetchBuilder);
            } else {
                Fetchable attributeMapping = (Fetchable)partMappingType.findByPath((String)attrName);
                resultBuilder.addFetchBuilder(attributeMapping, fetchBuilder);
                fetchBuilderMap.put(attributeMapping, fetchBuilder);
            }
        });
        return new DynamicFetchBuilderLegacy(this.tableAlias, this.ownerTableAlias, this.fetchable, this.keyColumnNames, fetchBuilderMap, resultBuilder);
    }

    private FetchBuilder resolve(ToOneAttributeMapping toOneAttributeMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        HashMap<Fetchable, FetchBuilder> fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>();
        this.fetchMementoMap.forEach((attrName, fetchMemento) -> fetchBuilderMap.put((Fetchable)toOneAttributeMapping.findSubPart((String)attrName), fetchMemento.resolve(this, querySpaceConsumer, context)));
        DynamicResultBuilderEntityStandard resultBuilder = new DynamicResultBuilderEntityStandard(toOneAttributeMapping.getEntityMappingType(), this.tableAlias, this.navigablePath);
        fetchBuilderMap.forEach((fetchable, fetchBuilder) -> resultBuilder.addFetchBuilder((Fetchable)fetchable, (FetchBuilder)fetchBuilder));
        return new DynamicFetchBuilderLegacy(this.tableAlias, this.ownerTableAlias, this.fetchable, this.keyColumnNames, fetchBuilderMap, resultBuilder);
    }

    public static interface FetchParentMemento {
        public NavigablePath getNavigablePath();

        public FetchableContainer getFetchableContainer();
    }
}

