/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.LegacyFetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

@Incubating
public interface ResultSetMapping
extends JdbcValuesMappingProducer {
    public String getMappingIdentifier();

    public boolean isDynamic();

    public int getNumberOfResultBuilders();

    public List<ResultBuilder> getResultBuilders();

    public void visitResultBuilders(BiConsumer<Integer, ResultBuilder> var1);

    public void visitLegacyFetchBuilders(Consumer<LegacyFetchBuilder> var1);

    public void addResultBuilder(ResultBuilder var1);

    public void addLegacyFetchBuilder(LegacyFetchBuilder var1);

    public NamedResultSetMappingMemento toMemento(String var1);

    public static ResultSetMapping resolveResultSetMapping(String name, SessionFactoryImplementor sessionFactory) {
        return ResultSetMapping.resolveResultSetMapping(name, false, sessionFactory);
    }

    public static ResultSetMapping resolveResultSetMapping(String name, boolean isDynamic, SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getFastSessionServices().getJdbcValuesMappingProducerProvider().buildResultSetMapping(name, isDynamic, sessionFactory);
    }
}

