/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.implicit;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.Builders;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderEmbeddable
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final EmbeddableValuedFetchable fetchable;
    private final Map<Fetchable, FetchBuilder> fetchBuilders;

    public ImplicitFetchBuilderEmbeddable(NavigablePath fetchPath, EmbeddableValuedFetchable fetchable, DomainResultCreationState creationState) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        this.fetchBuilders = ImplicitFetchBuilderEmbeddable.fetchBuilderMap(fetchPath, fetchable, ResultsHelper.impl(creationState));
    }

    private static Map<Fetchable, FetchBuilder> fetchBuilderMap(NavigablePath fetchPath, EmbeddableValuedFetchable fetchable, DomainResultCreationStateImpl creationStateImpl) {
        Function<Fetchable, FetchBuilder> fetchBuilderResolver = creationStateImpl.getCurrentExplicitFetchMementoResolver();
        int size = fetchable.getNumberOfFetchables();
        LinkedHashMap<Fetchable, FetchBuilder> fetchBuilders = CollectionHelper.linkedMapOfSize(size);
        for (int i = 0; i < size; ++i) {
            Fetchable subFetchable;
            FetchBuilder explicitFetchBuilder = fetchBuilderResolver.apply(subFetchable = fetchable.getFetchable(i));
            fetchBuilders.put(subFetchable, explicitFetchBuilder == null ? Builders.implicitFetchBuilder(fetchPath, subFetchable, creationStateImpl) : explicitFetchBuilder);
        }
        return fetchBuilders;
    }

    private ImplicitFetchBuilderEmbeddable(ImplicitFetchBuilderEmbeddable original) {
        this.fetchPath = original.fetchPath;
        this.fetchable = original.fetchable;
        if (original.fetchBuilders.isEmpty()) {
            this.fetchBuilders = Collections.emptyMap();
        } else {
            this.fetchBuilders = new HashMap<Fetchable, FetchBuilder>(original.fetchBuilders.size());
            for (Map.Entry<Fetchable, FetchBuilder> entry : original.fetchBuilders.entrySet()) {
                this.fetchBuilders.put(entry.getKey(), entry.getValue().cacheKeyInstance());
            }
        }
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new ImplicitFetchBuilderEmbeddable(this);
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState creationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        this.tableGroup(parent, fetchPath, creationStateImpl);
        return parent.generateFetchableFetch(this.fetchable, fetchPath, FetchTiming.IMMEDIATE, true, null, creationState);
    }

    private void tableGroup(FetchParent parent, NavigablePath fetchPath, DomainResultCreationStateImpl creationStateImpl) {
        creationStateImpl.getFromClauseAccess().resolveTableGroup(fetchPath, navigablePath -> {
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.fetchable.createTableGroupJoin(fetchPath, parentTableGroup, null, null, SqlAstJoinType.INNER, true, false, creationStateImpl);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderEmbeddable that = (ImplicitFetchBuilderEmbeddable)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable) && this.fetchBuilders.equals(that.fetchBuilders);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        result = 31 * result + this.fetchBuilders.hashCode();
        return result;
    }

    public String toString() {
        return "ImplicitFetchBuilderEmbeddable(" + this.fetchPath + ")";
    }

    @Override
    public void visitFetchBuilders(BiConsumer<Fetchable, FetchBuilder> consumer) {
        this.fetchBuilders.forEach((k, v) -> consumer.accept((Fetchable)k, (FetchBuilder)v));
    }
}

