/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.implicit;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.Builders;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderEntity
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final ToOneAttributeMapping fetchable;
    private final Map<Fetchable, FetchBuilder> fetchBuilders;

    public ImplicitFetchBuilderEntity(NavigablePath fetchPath, ToOneAttributeMapping fetchable, DomainResultCreationState creationState) {
        Fetchable associationKey;
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        Function<Fetchable, FetchBuilder> fetchBuilderResolver = creationStateImpl.getCurrentExplicitFetchMementoResolver();
        ForeignKeyDescriptor foreignKeyDescriptor = fetchable.getForeignKeyDescriptor();
        if (fetchable.getReferencedPropertyName() == null) {
            String associationKeyPropertyName = fetchable.getEntityMappingType().getIdentifierMapping().getPartName();
            associationKey = (Fetchable)fetchable.findSubPart(associationKeyPropertyName);
        } else {
            String associationKeyPropertyName;
            String keyName = associationKeyPropertyName = fetchable.getReferencedPropertyName();
            String[] stringArray = StringHelper.split(".", associationKeyPropertyName);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String part;
                keyName = part = stringArray[i];
            }
            associationKey = (Fetchable)fetchable.findSubPart(keyName);
        }
        FetchBuilder explicitAssociationKeyFetchBuilder = fetchBuilderResolver.apply(fetchable);
        if (explicitAssociationKeyFetchBuilder == null) {
            MappingType mappingType = foreignKeyDescriptor.getPartMappingType();
            if (mappingType instanceof EmbeddableMappingType) {
                EmbeddableMappingType embeddableType = (EmbeddableMappingType)mappingType;
                this.fetchBuilders = ImplicitFetchBuilderEntity.fetchBuilderMap(fetchPath, fetchBuilderResolver, creationStateImpl, embeddableType);
            } else {
                this.fetchBuilders = Collections.emptyMap();
            }
        } else {
            this.fetchBuilders = Collections.singletonMap(associationKey, explicitAssociationKeyFetchBuilder);
        }
    }

    private static Map<Fetchable, FetchBuilder> fetchBuilderMap(NavigablePath fetchPath, Function<Fetchable, FetchBuilder> fetchBuilderResolver, DomainResultCreationStateImpl creationStateImpl, EmbeddableMappingType embeddableValuedModelPart) {
        int size = embeddableValuedModelPart.getNumberOfFetchables();
        LinkedHashMap<Fetchable, FetchBuilder> fetchBuilders = CollectionHelper.linkedMapOfSize(size);
        for (int i = 0; i < size; ++i) {
            Fetchable subFetchable;
            FetchBuilder explicitFetchBuilder = fetchBuilderResolver.apply(subFetchable = embeddableValuedModelPart.getFetchable(i));
            fetchBuilders.put(subFetchable, explicitFetchBuilder == null ? Builders.implicitFetchBuilder(fetchPath, subFetchable, creationStateImpl) : explicitFetchBuilder);
        }
        return fetchBuilders;
    }

    private ImplicitFetchBuilderEntity(ImplicitFetchBuilderEntity original) {
        this.fetchPath = original.fetchPath;
        this.fetchable = original.fetchable;
        if (original.fetchBuilders.isEmpty()) {
            this.fetchBuilders = Collections.emptyMap();
        } else {
            this.fetchBuilders = new HashMap<Fetchable, FetchBuilder>(original.fetchBuilders.size());
            for (Map.Entry<Fetchable, FetchBuilder> entry : original.fetchBuilders.entrySet()) {
                this.fetchBuilders.put(entry.getKey(), entry.getValue().cacheKeyInstance());
            }
        }
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new ImplicitFetchBuilderEntity(this);
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState creationState) {
        return parent.generateFetchableFetch(this.fetchable, fetchPath, this.fetchable.getMappedFetchOptions().getTiming(), false, null, creationState);
    }

    @Override
    public void visitFetchBuilders(BiConsumer<Fetchable, FetchBuilder> consumer) {
        this.fetchBuilders.forEach((k, v) -> consumer.accept((Fetchable)k, (FetchBuilder)v));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderEntity that = (ImplicitFetchBuilderEntity)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable) && this.fetchBuilders.equals(that.fetchBuilders);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        result = 31 * result + this.fetchBuilders.hashCode();
        return result;
    }

    public String toString() {
        return "ImplicitFetchBuilderEntity(" + this.fetchPath + ")";
    }
}

