/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.implicit;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ImplicitResultClassBuilder
implements ResultBuilder {
    private final Class<?> suppliedResultClass;

    public ImplicitResultClassBuilder(Class<?> suppliedResultClass) {
        this.suppliedResultClass = suppliedResultClass;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        assert (resultPosition == 0);
        SqlAstCreationState sqlAstCreationState = domainResultCreationState.getSqlAstCreationState();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        boolean jdbcResultPosition = true;
        String columnName = jdbcResultsMetadata.resolveColumnName(1);
        BasicType basicType = jdbcResultsMetadata.resolveType(1, typeConfiguration.getJavaTypeRegistry().resolveDescriptor(this.suppliedResultClass), typeConfiguration);
        SqlSelection selection = ImplicitResultClassBuilder.sqlSelection(resultPosition, sqlExpressionResolver, columnName, basicType, typeConfiguration);
        return new BasicResult(selection.getValuesArrayPosition(), columnName, basicType);
    }

    private static SqlSelection sqlSelection(int resultPosition, SqlExpressionResolver sqlExpressionResolver, String columnName, BasicType<?> basicType, TypeConfiguration typeConfiguration) {
        return sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), state -> new ResultSetMappingSqlSelection(resultPosition, basicType)), basicType.getMappedJavaType(), null, typeConfiguration);
    }

    @Override
    public Class<?> getJavaType() {
        return this.suppliedResultClass;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }
}

