/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.spi.NativeQueryConstructorTransformer;
import org.hibernate.jpa.spi.NativeQueryListTransformer;
import org.hibernate.jpa.spi.NativeQueryMapTransformer;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Order;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.PathException;
import org.hibernate.query.Query;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.DelegatingDomainQueryExecutionContext;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.internal.Builders;
import org.hibernate.query.results.internal.ResultSetMappingImpl;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderBasicStandard;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityCalculated;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderInstantiation;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilderEntity;
import org.hibernate.query.results.internal.implicit.ImplicitResultClassBuilder;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.sql.internal.NativeNonSelectQueryPlanImpl;
import org.hibernate.query.sql.internal.ParameterRecognizerImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sql.spi.NativeSelectQueryDefinition;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.query.sql.spi.NonSelectInterpretationsKey;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sql.spi.SelectInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.spi.SingleResultConsumer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class NativeQueryImpl<R>
extends AbstractQuery<R>
implements NativeQueryImplementor<R>,
DomainQueryExecutionContext,
ResultSetMappingResolutionContext {
    private final String sqlString;
    private final String originalSqlString;
    private final ParameterMetadataImplementor parameterMetadata;
    private final List<ParameterOccurrence> parameterOccurrences;
    private final QueryParameterBindings parameterBindings;
    private final Class<R> resultType;
    private final ResultSetMapping resultSetMapping;
    private final boolean resultMappingSuppliedToCtor;
    private final HashMap<String, EntityMappingType> entityMappingTypeByTableAlias;
    private final QueryOptionsImpl queryOptions;
    private Boolean startsWithSelect;
    private Set<String> querySpaces;
    private Callback callback;

    public NativeQueryImpl(NamedNativeQueryMemento<?> memento, SharedSessionContractImplementor session) {
        this(memento, () -> NativeQueryImpl.buildResultSetMapping(NativeQueryImpl.getResultSetMappingName(memento), false, session), (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento resultSetMappingMemento;
            if (memento.getResultMappingName() != null && (resultSetMappingMemento = NativeQueryImpl.getNamedObjectRepository(session).getResultSetMappingMemento(memento.getResultMappingName())) != null) {
                resultSetMappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
                return true;
            }
            if (memento.getResultType() != null) {
                resultSetMapping.addResultBuilder(Builders.resultClassBuilder(memento.getResultType(), context));
                return true;
            }
            return false;
        }, null, session);
    }

    private static NamedObjectRepository getNamedObjectRepository(SharedSessionContractImplementor session) {
        return session.getFactory().getQueryEngine().getNamedObjectRepository();
    }

    private static String getResultSetMappingName(NamedNativeQueryMemento<?> memento) {
        if (memento.getResultMappingName() != null) {
            return memento.getResultMappingName();
        }
        if (memento.getResultType() != null) {
            return memento.getResultType().getName();
        }
        return memento.getSqlString();
    }

    public NativeQueryImpl(NamedNativeQueryMemento<?> memento, Class<R> resultJavaType, SharedSessionContractImplementor session) {
        this(memento, () -> {
            String mappingIdentifier = resultJavaType != null ? resultJavaType.getName() : null;
            return NativeQueryImpl.buildResultSetMapping(mappingIdentifier, false, session);
        }, (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento resultSetMappingMemento;
            if (memento.getResultMappingName() != null && (resultSetMappingMemento = NativeQueryImpl.getNamedObjectRepository(session).getResultSetMappingMemento(memento.getResultMappingName())) != null) {
                resultSetMappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
                return true;
            }
            if (memento.getResultType() != null) {
                resultSetMapping.addResultBuilder(Builders.resultClassBuilder(memento.getResultType(), context));
                return true;
            }
            return false;
        }, resultJavaType, session);
    }

    public NativeQueryImpl(NamedNativeQueryMemento<?> memento, String resultSetMappingName, SharedSessionContractImplementor session) {
        this(memento, () -> NativeQueryImpl.buildResultSetMapping(resultSetMappingName, false, session), (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento mappingMemento = NativeQueryImpl.getNamedObjectRepository(session).getResultSetMappingMemento(resultSetMappingName);
            assert (mappingMemento != null);
            mappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
            return true;
        }, null, session);
    }

    public NativeQueryImpl(NamedNativeQueryMemento<?> memento, Supplier<ResultSetMapping> resultSetMappingCreator, ResultSetMappingHandler resultSetMappingHandler, SharedSessionContractImplementor session) {
        this(memento, resultSetMappingCreator, resultSetMappingHandler, null, session);
    }

    public NativeQueryImpl(NamedNativeQueryMemento<?> memento, Supplier<ResultSetMapping> resultSetMappingCreator, ResultSetMappingHandler resultSetMappingHandler, @Nullable Class<R> resultType, SharedSessionContractImplementor session) {
        block5: {
            block6: {
                super(session);
                this.entityMappingTypeByTableAlias = new HashMap();
                this.queryOptions = new QueryOptionsImpl();
                this.originalSqlString = memento.getOriginalSqlString();
                ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(this.originalSqlString, session);
                this.sqlString = parameterInterpretation.getAdjustedSqlString();
                this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
                this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
                this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
                this.resultType = resultType;
                this.querySpaces = new HashSet<String>();
                this.resultSetMapping = resultSetMappingCreator.get();
                this.resultMappingSuppliedToCtor = resultSetMappingHandler.resolveResultSetMapping(this.resultSetMapping, this.querySpaces::add, this);
                if (resultType == null) break block5;
                if (SqmUtil.isResultTypeAlwaysAllowed(resultType)) break block6;
                switch (this.resultSetMapping.getNumberOfResultBuilders()) {
                    case 0: {
                        throw new IllegalArgumentException("Named query exists, but did not specify a resultClass");
                    }
                    case 1: {
                        Class<?> actualResultJavaType = this.resultSetMapping.getResultBuilders().get(0).getJavaType();
                        if (actualResultJavaType != null && !resultType.isAssignableFrom(actualResultJavaType)) {
                            throw this.buildIncompatibleException(resultType, actualResultJavaType);
                        }
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                    }
                }
            }
            this.setTupleTransformerForResultType(resultType);
        }
        this.applyOptions(memento);
    }

    public NativeQueryImpl(String sqlString, NamedResultSetMappingMemento resultSetMappingMemento, AbstractSharedSessionContract session) {
        super(session);
        this.entityMappingTypeByTableAlias = new HashMap();
        this.queryOptions = new QueryOptionsImpl();
        this.originalSqlString = sqlString;
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(sqlString, session);
        this.sqlString = parameterInterpretation.getAdjustedSqlString();
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
        this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
        this.resultType = null;
        this.querySpaces = new HashSet<String>();
        this.resultSetMapping = NativeQueryImpl.buildResultSetMapping(resultSetMappingMemento.getName(), false, session);
        resultSetMappingMemento.resolve(this.resultSetMapping, string -> this.addSynchronizedQuerySpace((String)string), this);
        this.resultMappingSuppliedToCtor = true;
    }

    public NativeQueryImpl(String sqlString, SharedSessionContractImplementor session) {
        this(sqlString, null, session);
    }

    public NativeQueryImpl(String sqlString, @Nullable Class<R> resultType, SharedSessionContractImplementor session) {
        super(session);
        this.entityMappingTypeByTableAlias = new HashMap();
        this.queryOptions = new QueryOptionsImpl();
        this.querySpaces = new HashSet<String>();
        this.originalSqlString = sqlString;
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(sqlString, session);
        this.sqlString = parameterInterpretation.getAdjustedSqlString();
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
        this.parameterBindings = this.parameterMetadata.createBindings(session.getFactory());
        this.resultType = resultType;
        if (resultType != null) {
            this.setTupleTransformerForResultType(resultType);
        }
        this.resultSetMapping = ResultSetMapping.resolveResultSetMapping(sqlString, true, session.getFactory());
        this.resultMappingSuppliedToCtor = false;
    }

    protected <T> void setTupleTransformerForResultType(Class<T> resultClass) {
        TupleTransformer<T> tupleTransformer = this.determineTupleTransformerForResultType(resultClass);
        if (tupleTransformer != null) {
            this.setTupleTransformer((TupleTransformer)tupleTransformer);
        }
    }

    protected @Nullable TupleTransformer<?> determineTupleTransformerForResultType(Class<?> resultClass) {
        if (Tuple.class.equals(resultClass)) {
            return NativeQueryTupleTransformer.INSTANCE;
        }
        if (Map.class.equals(resultClass)) {
            return NativeQueryMapTransformer.INSTANCE;
        }
        if (List.class.equals(resultClass)) {
            return NativeQueryListTransformer.INSTANCE;
        }
        if (resultClass != Object.class && resultClass != Object[].class && ReflectHelper.isClass(resultClass) && !this.hasJavaTypeDescriptor(resultClass)) {
            return new NativeQueryConstructorTransformer(resultClass);
        }
        return null;
    }

    private <T> boolean hasJavaTypeDescriptor(Class<T> resultClass) {
        JavaType descriptor = this.getTypeConfiguration().getJavaTypeRegistry().findDescriptor(resultClass);
        return descriptor != null && descriptor.getClass() != UnknownBasicJavaType.class;
    }

    private static ResultSetMapping buildResultSetMapping(String registeredName, boolean isDynamic, SharedSessionContractImplementor session) {
        return ResultSetMapping.resolveResultSetMapping(registeredName, isDynamic, session.getFactory());
    }

    public List<ParameterOccurrence> getParameterOccurrences() {
        return this.parameterOccurrences;
    }

    private ParameterInterpretation resolveParameterInterpretation(String sqlString, SharedSessionContractImplementor session) {
        return session.getFactory().getQueryEngine().getInterpretationCache().resolveNativeQueryParameters(sqlString, s -> NativeQueryImpl.parameterInterpretation(sqlString, session));
    }

    private static ParameterInterpretationImpl parameterInterpretation(String sqlString, SharedSessionContractImplementor session) {
        ParameterRecognizerImpl parameterRecognizer = new ParameterRecognizerImpl();
        session.getFactory().getServiceRegistry().requireService(NativeQueryInterpreter.class).recognizeParameters(sqlString, parameterRecognizer);
        return new ParameterInterpretationImpl(parameterRecognizer);
    }

    @Override
    protected void applyOptions(NamedNativeQueryMemento<?> memento) {
        Set<String> copy;
        super.applyOptions(memento);
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if ((copy = CollectionHelper.makeCopy(memento.getQuerySpaces())) != null) {
            this.querySpaces = copy;
        }
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        String actualResultClassName;
        String resultClassName = resultClass.getName();
        if (resultClassName.equals(actualResultClassName = actualResultClass.getName())) {
            return new IllegalArgumentException("Type specified for TypedQuery [" + resultClassName + "] is incompatible with the query return type of the same name. Both classes have the same name but are different as they have been loaded respectively by Classloaders " + resultClass.getClassLoader().toString() + ", " + actualResultClass.getClassLoader().toString() + ". This suggests a classloader bug in the Runtime executing Hibernate ORM, or in the integration code.");
        }
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClassName + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    @Override
    public String getQueryString() {
        return this.sqlString;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public Callback getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackImpl();
        }
        return this.callback;
    }

    @Override
    public boolean hasCallbackActions() {
        return this.callback != null && this.callback.hasAfterLoadActions();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.getQueryParameterBindings();
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public NamedNativeQueryMemento<?> toMemento(String name) {
        return new NamedNativeQueryMementoImpl<R>(name, this.resultType != null ? this.resultType : this.extractResultClass(this.resultSetMapping), this.sqlString, this.originalSqlString, this.resultSetMapping.getMappingIdentifier(), this.querySpaces, this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getQueryOptions().getFlushMode(), this.isReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getQueryOptions().getLimit().getFirstRow(), this.getQueryOptions().getLimit().getMaxRows(), this.getHints());
    }

    private Class<R> extractResultClass(ResultSetMapping resultSetMapping) {
        ResultBuilder resultBuilder;
        List<ResultBuilder> resultBuilders = resultSetMapping.getResultBuilders();
        if (resultBuilders.size() == 1 && ((resultBuilder = resultBuilders.get(0)) instanceof ImplicitResultClassBuilder || resultBuilder instanceof ImplicitModelPartResultBuilderEntity || resultBuilder instanceof DynamicResultBuilderEntityCalculated)) {
            return resultBuilder.getJavaType();
        }
        return null;
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("Illegal attempt to get lock mode on a native-query");
    }

    @Override
    public NativeQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHibernateLockMode(LockMode lockMode) {
        super.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        throw new IllegalStateException("Illegal attempt to set lock mode for a native query");
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(LockModeType lockModeType) {
        throw new IllegalStateException("Illegal attempt to set lock mode for a native query");
    }

    @Override
    protected void applyGraph(String graphString, GraphSemantic graphSemantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    protected void applyGraph(RootGraphImplementor<?> entityGraph, GraphSemantic graphSemantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    protected void applyEntityGraphHint(String hintName, Object value) {
        super.applyEntityGraphHint(hintName, value);
    }

    @Override
    public <T> NativeQueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        return (NativeQueryImplementor)super.setTupleTransformer((TupleTransformer)transformer);
    }

    @Override
    public NativeQueryImplementor<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        return (NativeQueryImplementor)super.setResultListTransformer((ResultListTransformer)transformer);
    }

    @Override
    public Boolean isSelectQuery() {
        if (this.resultMappingSuppliedToCtor || this.resultSetMapping.getNumberOfResultBuilders() > 0 || this.isReadOnly() || this.startsWithSelect()) {
            return true;
        }
        return null;
    }

    private boolean startsWithSelect() {
        if (this.startsWithSelect == null) {
            this.startsWithSelect = this.sqlString.toLowerCase(Locale.ROOT).startsWith("select ");
        }
        return this.startsWithSelect;
    }

    @Override
    protected void prepareForExecution() {
        if (this.getSynchronizedQuerySpaces() != null && !this.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.shouldFlush()) {
            this.getSession().flush();
        }
        this.callback = null;
    }

    private boolean shouldFlush() {
        if (this.getSession().isTransactionInProgress()) {
            FlushMode flushMode = this.getQueryOptions().getFlushMode();
            return switch (flushMode == null ? this.getSession().getHibernateFlushMode() : flushMode) {
                case FlushMode.AUTO -> this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap();
                case FlushMode.ALWAYS -> true;
                default -> false;
            };
        }
        return false;
    }

    @Override
    protected List<R> doList() {
        return this.resolveSelectQueryPlan().performList(this);
    }

    @Override
    public long getResultCount() {
        DelegatingDomainQueryExecutionContext context = new DelegatingDomainQueryExecutionContext(this){

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }
        };
        return (Long)this.createCountQueryPlan().executeQuery(context, SingleResultConsumer.instance());
    }

    @Override
    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> page) {
        throw new UnsupportedOperationException("native queries do not support key-based pagination");
    }

    protected SelectQueryPlan<R> resolveSelectQueryPlan() {
        ResultSetMapping mapping;
        if (this.resultType != null && this.resultSetMapping.isDynamic() && this.resultSetMapping.getNumberOfResultBuilders() == 0) {
            mapping = ResultSetMapping.resolveResultSetMapping(this.originalSqlString, true, this.getSessionFactory());
            if (this.getSessionFactory().getMappingMetamodel().isEntityClass(this.resultType)) {
                mapping.addResultBuilder(Builders.entityCalculated(StringHelper.unqualify(this.resultType.getName()), this.resultType.getName(), LockMode.READ, this.getSessionFactory()));
            } else if (!(SqmUtil.isResultTypeAlwaysAllowed(this.resultType) || ReflectHelper.isClass(this.resultType) && !this.hasJavaTypeDescriptor(this.resultType))) {
                mapping.addResultBuilder(Builders.resultClassBuilder(this.resultType, this.getSessionFactory()));
            }
        } else {
            mapping = this.resultSetMapping;
        }
        return this.isCacheableQuery() ? this.getInterpretationCache().resolveSelectQueryPlan(this.selectInterpretationsKey(mapping), () -> this.createQueryPlan(mapping)) : this.createQueryPlan(mapping);
    }

    private NativeSelectQueryPlan<R> createQueryPlan(final ResultSetMapping resultSetMapping) {
        NativeSelectQueryDefinition queryDefinition = new NativeSelectQueryDefinition<R>(){
            final String sqlString;
            {
                this.sqlString = NativeQueryImpl.this.expandParameterLists();
            }

            @Override
            public String getSqlString() {
                return this.sqlString;
            }

            @Override
            public boolean isCallable() {
                return false;
            }

            @Override
            public List<ParameterOccurrence> getQueryParameterOccurrences() {
                return NativeQueryImpl.this.parameterOccurrences;
            }

            @Override
            public ResultSetMapping getResultSetMapping() {
                return resultSetMapping;
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return NativeQueryImpl.this.querySpaces;
            }
        };
        return this.getNativeQueryInterpreter().createQueryPlan(queryDefinition, this.getSessionFactory());
    }

    protected NativeSelectQueryPlan<Long> createCountQueryPlan() {
        NativeSelectQueryDefinition<Long> queryDefinition = new NativeSelectQueryDefinition<Long>(){
            final BasicType<Long> longType;
            final String sqlString;
            {
                this.longType = NativeQueryImpl.this.getTypeConfiguration().getBasicTypeForJavaType(Long.class);
                this.sqlString = NativeQueryImpl.this.expandParameterLists();
            }

            @Override
            public String getSqlString() {
                return "select count(*) from (" + this.sqlString + ") a_";
            }

            @Override
            public boolean isCallable() {
                return false;
            }

            @Override
            public List<ParameterOccurrence> getQueryParameterOccurrences() {
                return NativeQueryImpl.this.parameterOccurrences;
            }

            @Override
            public ResultSetMapping getResultSetMapping() {
                ResultSetMappingImpl mapping = new ResultSetMappingImpl("", true);
                mapping.addResultBuilder(new DynamicResultBuilderBasicStandard(1, this.longType));
                return mapping;
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return NativeQueryImpl.this.querySpaces;
            }
        };
        return this.getNativeQueryInterpreter().createQueryPlan(queryDefinition, this.getSessionFactory());
    }

    private TypeConfiguration getTypeConfiguration() {
        return this.getSessionFactory().getTypeConfiguration();
    }

    private NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.getSessionFactory().getQueryEngine().getNativeQueryInterpreter();
    }

    protected String expandParameterLists() {
        if (this.parameterOccurrences == null || this.parameterOccurrences.isEmpty()) {
            return this.sqlString;
        }
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        Dialect dialect = sessionFactory.getJdbcServices().getDialect();
        boolean paddingEnabled = sessionFactory.getSessionFactoryOptions().inClauseParameterPaddingEnabled();
        int inExprLimit = dialect.getInExpressionCountLimit();
        StringBuilder sb = null;
        int offset = 0;
        for (ParameterOccurrence occurrence : this.parameterOccurrences) {
            String expansionListAsString;
            char ch;
            int i;
            int sourcePosition;
            QueryParameterImplementor<?> queryParameter = occurrence.getParameter();
            QueryParameterBinding<?> binding = this.parameterBindings.getBinding(queryParameter);
            if (!binding.isMultiValued()) continue;
            Collection<?> bindValues = binding.getBindValues();
            int bindValueCount = bindValues.size();
            int bindValueMaxCount = NativeQueryImpl.determineBindValueMaxCount(paddingEnabled, inExprLimit, bindValueCount);
            if (inExprLimit > 0 && bindValueCount > inExprLimit) {
                log.tooManyInExpressions(dialect.getClass().getName(), inExprLimit, queryParameter.getName() == null ? queryParameter.getPosition().toString() : queryParameter.getName(), bindValueCount);
            }
            if ((sourcePosition = occurrence.getSourcePosition()) < 0) continue;
            boolean isEnclosedInParens = true;
            for (i = sourcePosition - 1; i >= 0; --i) {
                ch = this.sqlString.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                isEnclosedInParens = ch == '(';
                break;
            }
            if (isEnclosedInParens) {
                for (i = sourcePosition + 1; i < this.sqlString.length(); ++i) {
                    ch = this.sqlString.charAt(i);
                    if (Character.isWhitespace(ch)) continue;
                    isEnclosedInParens = ch == ')';
                    break;
                }
            }
            if (bindValueCount == 1 && isEnclosedInParens) continue;
            if (sb == null) {
                sb = new StringBuilder(this.sqlString.length() + 20);
                sb.append(this.sqlString);
            }
            if (bindValueMaxCount == 0) {
                expansionListAsString = isEnclosedInParens ? "null" : "(null)";
            } else {
                char[] chars;
                if (isEnclosedInParens) {
                    chars = new char[(bindValueMaxCount << 1) - 1];
                    chars[0] = 63;
                    for (i = 1; i < bindValueMaxCount; ++i) {
                        index = i << 1;
                        chars[index - 1] = 44;
                        chars[index] = 63;
                    }
                } else {
                    chars = new char[(bindValueMaxCount << 1) + 1];
                    chars[0] = 40;
                    chars[1] = 63;
                    for (i = 1; i < bindValueMaxCount; ++i) {
                        index = i << 1;
                        chars[index] = 44;
                        chars[index + 1] = 63;
                    }
                    chars[chars.length - 1] = 41;
                }
                expansionListAsString = new String(chars);
            }
            int start = sourcePosition + offset;
            int end = start + 1;
            sb.replace(start, end, expansionListAsString);
            offset += expansionListAsString.length() - 1;
        }
        return sb == null ? this.sqlString : sb.toString();
    }

    public static int determineBindValueMaxCount(boolean paddingEnabled, int inExprLimit, int bindValueCount) {
        boolean inClauseParameterPaddingEnabled;
        int bindValueMaxCount = bindValueCount;
        boolean bl = inClauseParameterPaddingEnabled = paddingEnabled && bindValueCount > 2;
        if (inClauseParameterPaddingEnabled) {
            int bindValuePaddingCount = MathHelper.ceilingPowerOfTwo(bindValueCount);
            if (inExprLimit > 0 && bindValuePaddingCount > inExprLimit) {
                bindValuePaddingCount = inExprLimit;
            }
            if (bindValueCount < bindValuePaddingCount) {
                bindValueMaxCount = bindValuePaddingCount;
            }
        }
        return bindValueMaxCount;
    }

    private SelectInterpretationsKey selectInterpretationsKey(ResultSetMapping resultSetMapping) {
        return new SelectInterpretationsKey(this.getQueryString(), resultSetMapping, this.getSynchronizedQuerySpaces(), this.getQueryOptions().getTupleTransformer(), this.getQueryOptions().getResultListTransformer());
    }

    private boolean isCacheableQuery() {
        return !this.parameterBindings.hasAnyMultiValuedBindings();
    }

    @Override
    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private BasicTypeRegistry getBasicTypeRegistry() {
        return this.getTypeConfiguration().getBasicTypeRegistry();
    }

    private QueryInterpretationCache getInterpretationCache() {
        return this.getSession().getFactory().getQueryEngine().getInterpretationCache();
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        NonSelectInterpretationsKey cacheKey = this.generateNonSelectInterpretationsKey();
        if (cacheKey != null) {
            queryPlan = this.getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            String sqlString = this.expandParameterLists();
            queryPlan = new NativeNonSelectQueryPlanImpl(sqlString, this.querySpaces, this.parameterOccurrences);
            if (cacheKey != null) {
                this.getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    protected NonSelectInterpretationsKey generateNonSelectInterpretationsKey() {
        return this.isCacheableQuery() ? new NonSelectInterpretationsKey(this.getQueryString(), this.getSynchronizedQuerySpaces()) : null;
    }

    @Override
    public void addResultTypeClass(Class<?> resultClass) {
        assert (this.resultSetMapping.getNumberOfResultBuilders() == 0);
        this.registerBuilder(Builders.resultClassBuilder(resultClass, this.getSessionFactory()));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias) {
        return this.registerBuilder(Builders.scalar(columnAlias));
    }

    public NativeQueryImplementor<R> addScalar(int position, Class<?> type) {
        return this.registerBuilder(Builders.scalar(position, this.getBasicTypeRegistry().getRegisteredType(type)));
    }

    protected NativeQueryImplementor<R> registerBuilder(ResultBuilder builder) {
        this.resultSetMapping.addResultBuilder(builder);
        return this;
    }

    @Override
    public NativeQuery<R> addScalar(String columnAlias, BasicTypeReference type) {
        return this.registerBuilder(Builders.scalar(columnAlias, this.getBasicTypeRegistry().resolve(type)));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, BasicDomainType type) {
        return this.registerBuilder(Builders.scalar(columnAlias, (BasicType)type));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, Class javaType) {
        return this.registerBuilder(Builders.scalar(columnAlias, javaType, this.getSessionFactory()));
    }

    @Override
    public <C> NativeQueryImplementor<R> addScalar(String columnAlias, Class<C> jdbcJavaType, AttributeConverter<?, C> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, jdbcJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <O, J> NativeQueryImplementor<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, AttributeConverter<O, J> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, domainJavaType, jdbcJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <C> NativeQueryImplementor<R> addScalar(String columnAlias, Class<C> relationalJavaType, Class<? extends AttributeConverter<?, C>> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, relationalJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <O, J> NativeQueryImplementor<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, Class<? extends AttributeConverter<O, J>> converterJavaType) {
        return this.registerBuilder(Builders.converted(columnAlias, domainJavaType, jdbcJavaType, converterJavaType, this.getSessionFactory()));
    }

    @Override
    public <J> NativeQuery.InstantiationResultNode<J> addInstantiation(Class<J> targetJavaType) {
        DynamicResultBuilderInstantiation<J> builder = Builders.instantiation(targetJavaType, this.getSessionFactory());
        this.registerBuilder(builder);
        return builder;
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, Class entityJavaType, String attributePath) {
        return this.addAttributeResult(columnAlias, entityJavaType.getName(), attributePath);
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, String entityName, String attributePath) {
        this.registerBuilder(Builders.attributeResult(columnAlias, entityName, attributePath, this.getSessionFactory()));
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, SingularAttribute attribute) {
        this.registerBuilder(Builders.attributeResult(columnAlias, attribute));
        return this;
    }

    @Override
    public DynamicResultBuilderEntityStandard addRoot(String tableAlias, String entityName) {
        DynamicResultBuilderEntityStandard resultBuilder = Builders.entity(tableAlias, entityName, this.getSessionFactory());
        this.resultSetMapping.addResultBuilder(resultBuilder);
        this.entityMappingTypeByTableAlias.put(tableAlias, resultBuilder.getEntityMapping());
        return resultBuilder;
    }

    @Override
    public DynamicResultBuilderEntityStandard addRoot(String tableAlias, Class entityType) {
        return this.addRoot(tableAlias, entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName) {
        DynamicResultBuilderEntityCalculated builder = Builders.entityCalculated(tableAlias, entityName, this.getSessionFactory());
        this.entityMappingTypeByTableAlias.put(tableAlias, builder.getEntityMapping());
        this.registerBuilder(builder);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName, LockMode lockMode) {
        DynamicResultBuilderEntityCalculated builder = Builders.entityCalculated(tableAlias, entityName, lockMode, this.getSessionFactory());
        this.entityMappingTypeByTableAlias.put(tableAlias, builder.getEntityMapping());
        this.registerBuilder(builder);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(Class entityType) {
        return this.addEntity(entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(Class<R> entityType, LockMode lockMode) {
        return this.addEntity(StringHelper.unqualify(entityType.getName()), entityType.getName(), lockMode);
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass) {
        return this.addEntity(tableAlias, entityClass.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass, LockMode lockMode) {
        return this.addEntity(tableAlias, entityClass.getName(), lockMode);
    }

    @Override
    public NativeQuery.FetchReturn addFetch(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        ModelPart subPart = this.entityMappingTypeByTableAlias.get(ownerTableAlias).findSubPart(joinPropertyName);
        this.addEntityMappingType(tableAlias, subPart);
        DynamicFetchBuilderLegacy fetchBuilder = Builders.fetch(tableAlias, ownerTableAlias, (Fetchable)subPart);
        this.resultSetMapping.addLegacyFetchBuilder(fetchBuilder);
        return fetchBuilder;
    }

    private void addEntityMappingType(String tableAlias, ModelPart part) {
        if (part instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)part;
            MappingType partMappingType = pluralAttributeMapping.getElementDescriptor().getPartMappingType();
            if (partMappingType instanceof EntityMappingType) {
                EntityMappingType entityMappingType = (EntityMappingType)partMappingType;
                this.entityMappingTypeByTableAlias.put(tableAlias, entityMappingType);
            }
        } else if (part instanceof EntityAssociationMapping) {
            EntityAssociationMapping entityAssociationMapping = (EntityAssociationMapping)part;
            this.entityMappingTypeByTableAlias.put(tableAlias, entityAssociationMapping.asEntityMappingType());
        } else if (part instanceof EmbeddedAttributeMapping) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path) {
        this.createFetchJoin(tableAlias, path);
        return this;
    }

    private NativeQuery.FetchReturn createFetchJoin(String tableAlias, String path) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new PathException("Not a property path '" + path + "'");
        }
        String ownerTableAlias = path.substring(0, loc);
        String joinedPropertyName = path.substring(loc + 1);
        return this.addFetch(tableAlias, ownerTableAlias, joinedPropertyName);
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.addFetch(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path, LockMode lockMode) {
        this.createFetchJoin(tableAlias, path).setLockMode(lockMode);
        return this;
    }

    @Override
    public Collection<String> getSynchronizedQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.addQuerySpaces(querySpace);
        return this;
    }

    protected void addQuerySpaces(String ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, spaces);
        }
    }

    protected void addQuerySpaces(Serializable ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, (String[])spaces);
        }
    }

    private MappingMetamodelImplementor getMappingMetamodel() {
        return this.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel();
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityName(String entityName) {
        this.addQuerySpaces(this.getMappingMetamodel().getEntityDescriptor(entityName).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityClass(Class entityClass) {
        this.addQuerySpaces(this.getMappingMetamodel().getEntityDescriptor(entityClass).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setQueryFlushMode(QueryFlushMode queryFlushMode) {
        super.setQueryFlushMode(queryFlushMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    public TypedQuery<R> setTimeout(Integer timeout) {
        if (timeout == null) {
            timeout = -1;
        }
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setQueryPlanCacheable(boolean queryPlanCacheable) {
        super.setQueryPlanCacheable(queryPlanCacheable);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    public <T> T unwrap(Class<T> javaType) {
        if (javaType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (javaType.isAssignableFrom(ParameterMetadata.class)) {
            return (T)this.parameterMetadata;
        }
        if (javaType.isAssignableFrom(QueryParameterBindings.class)) {
            return (T)this.parameterBindings;
        }
        if (javaType.isAssignableFrom(EntityManager.class)) {
            return (T)this.getSession();
        }
        if (javaType.isAssignableFrom(EntityManagerFactory.class)) {
            return (T)this.getSession().getFactory();
        }
        throw new PersistenceException("Unrecognized unwrap type [" + javaType.getName() + "]");
    }

    @Override
    public NativeQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        this.putIfNotNull(hints, "org.hibernate.lockMode", this.getLockOptions().getLockMode());
    }

    @Override
    protected void applySynchronizeSpacesHint(Object value) {
        this.applySynchronizeSpace(value);
    }

    protected void applySynchronizeSpace(Object value) {
        block3: {
            block5: {
                Object[] array;
                block4: {
                    block2: {
                        if (!(value instanceof String)) break block2;
                        String string = (String)value;
                        this.addSynchronizedQuerySpace(string);
                        break block3;
                    }
                    if (!(value instanceof Class)) break block4;
                    Class clazz = (Class)value;
                    this.addSynchronizedEntityClass(clazz);
                    break block3;
                }
                if (!(value instanceof Object[])) break block5;
                for (Object element : array = (Object[])value) {
                    this.applySynchronizeSpace(element);
                }
                break block3;
            }
            if (!(value instanceof Iterable)) break block3;
            Iterable iterable = (Iterable)value;
            for (Object element : iterable) {
                this.applySynchronizeSpace(element);
            }
        }
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(String name, P value, Class<P> javaTypeClass) {
        super.setParameter(name, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(int position, P value, Class<P> javaTypeClass) {
        super.setParameter(position, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaTypeClass) {
        super.setParameter((QueryParameter)parameter, (Object)value, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (BindableType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(name, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, P[] values, Class<P> javaTypeClass) {
        super.setParameterList(position, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Collection)values, (BindableType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList((QueryParameter)parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaTypeClass) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (Class)javaTypeClass);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList((QueryParameter)parameter, (Object[])values, (BindableType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    @Deprecated
    public <S> NativeQueryImplementor<S> setResultTransformer(ResultTransformer<S> transformer) {
        return this.setTupleTransformer((TupleTransformer)transformer).setResultListTransformer(transformer);
    }

    @Override
    public NativeQueryImplementor<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public Query<R> setOrder(List<? extends Order<? super R>> orderList) {
        throw new UnsupportedOperationException("Ordering not currently supported for native queries");
    }

    @Override
    public Query<R> setOrder(Order<? super R> order) {
        throw new UnsupportedOperationException("Ordering not currently supported for native queries");
    }

    @Override
    public NativeQueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @FunctionalInterface
    private static interface ResultSetMappingHandler {
        public boolean resolveResultSetMapping(ResultSetMapping var1, Consumer<String> var2, ResultSetMappingResolutionContext var3);
    }

    private static class ParameterInterpretationImpl
    implements ParameterInterpretation {
        private final String sqlString;
        private final List<ParameterOccurrence> parameterList;
        private final Map<Integer, QueryParameterImplementor<?>> positionalParameters;
        private final Map<String, QueryParameterImplementor<?>> namedParameters;

        public ParameterInterpretationImpl(ParameterRecognizerImpl parameterRecognizer) {
            this.sqlString = parameterRecognizer.getAdjustedSqlString();
            this.parameterList = parameterRecognizer.getParameterList();
            this.positionalParameters = parameterRecognizer.getPositionalQueryParameters();
            this.namedParameters = parameterRecognizer.getNamedQueryParameters();
        }

        @Override
        public List<ParameterOccurrence> getOrderedParameterOccurrences() {
            return this.parameterList;
        }

        @Override
        public ParameterMetadataImplementor toParameterMetadata(SharedSessionContractImplementor session1) {
            return CollectionHelper.isEmpty(this.positionalParameters) && CollectionHelper.isEmpty(this.namedParameters) ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.positionalParameters, this.namedParameters);
        }

        @Override
        public String getAdjustedSqlString() {
            return this.sqlString;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("ParameterInterpretationImpl (").append(this.sqlString).append(") : {");
            String lineSeparator = System.lineSeparator();
            if (CollectionHelper.isNotEmpty(this.parameterList)) {
                int size = this.parameterList.size();
                for (int i = 0; i < size; ++i) {
                    buffer.append(lineSeparator).append("    ,");
                }
                buffer.setLength(buffer.length() - 1);
            }
            return buffer.append(lineSeparator).append("}").toString();
        }
    }
}

