/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.internal.AliasConstantsHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.LegacyFetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderCollectionStandard;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ResultSetMappingProcessor
implements SQLQueryParser.ParserContext {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ResultSetMappingProcessor.class);
    private final ResultSetMapping resultSetMapping;
    private final Map<String, NativeQuery.ResultNode> alias2Return = new HashMap<String, NativeQuery.ResultNode>();
    private final Map<String, String> alias2OwnerAlias = new HashMap<String, String>();
    private final Map<String, EntityPersister> alias2Persister = new HashMap<String, EntityPersister>();
    private final Map<String, String> alias2Suffix = new HashMap<String, String>();
    private final Map<String, CollectionPersister> alias2CollectionPersister = new HashMap<String, CollectionPersister>();
    private final Map<String, String> alias2CollectionSuffix = new HashMap<String, String>();
    private final Map<String, Map<String, String[]>> entityPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final Map<String, Map<String, String[]>> collectionPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final SessionFactoryImplementor factory;
    private int entitySuffixSeed;
    private int collectionSuffixSeed;

    public ResultSetMappingProcessor(ResultSetMapping resultSetMapping, SessionFactoryImplementor factory) {
        this.resultSetMapping = resultSetMapping;
        this.factory = factory;
    }

    private Map<String, String[]> internalGetPropertyResultsMap(String alias) {
        Map<String, String[]> propertyResultMaps = this.collectionPropertyResultMaps.get(alias);
        if (propertyResultMaps == null) {
            propertyResultMaps = this.entityPropertyResultMaps.get(alias);
        }
        if (propertyResultMaps != null) {
            return propertyResultMaps;
        }
        NativeQuery.ResultNode rtn = this.alias2Return.get(alias);
        if (rtn instanceof NativeQuery.ReturnProperty && !(rtn instanceof NativeQuery.FetchReturn)) {
            return null;
        }
        return Collections.emptyMap();
    }

    public SQLQueryParser.ParserContext process() {
        this.resultSetMapping.visitResultBuilders((i, resultBuilder) -> {
            if (resultBuilder instanceof NativeQuery.RootReturn) {
                NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
                this.alias2Return.put(rootReturn.getTableAlias(), rootReturn);
                resultBuilder.visitFetchBuilders(this::processFetchBuilder);
            } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
                NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
                this.alias2Return.put(collectionReturn.getTableAlias(), collectionReturn);
                Map<String, String[]> propertyResultsMap = Collections.emptyMap();
                this.addCollection(collectionReturn.getNavigablePath().getFullPath(), collectionReturn.getTableAlias(), propertyResultsMap);
            }
        });
        this.resultSetMapping.visitLegacyFetchBuilders(fetchBuilder -> {
            this.alias2Return.put(fetchBuilder.getTableAlias(), (NativeQuery.ReturnableResultNode)((Object)fetchBuilder));
            this.alias2OwnerAlias.put(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias());
        });
        for (NativeQuery.ResultNode queryReturn : this.alias2Return.values()) {
            this.processReturn(queryReturn);
        }
        return this;
    }

    private void processFetchBuilder(Fetchable attributeName, FetchBuilder fetchBuilder) {
        if (fetchBuilder instanceof LegacyFetchBuilder) {
            this.resultSetMapping.addLegacyFetchBuilder((LegacyFetchBuilder)fetchBuilder);
        } else if (fetchBuilder instanceof NativeQuery.FetchReturn) {
            NativeQuery.FetchReturn fetchReturn = (NativeQuery.FetchReturn)((Object)fetchBuilder);
            this.alias2Return.put(fetchReturn.getTableAlias(), fetchReturn);
            this.alias2OwnerAlias.put(fetchReturn.getTableAlias(), fetchReturn.getOwnerAlias());
        }
        fetchBuilder.visitFetchBuilders(this::processFetchBuilder);
    }

    public ResultSetMapping generateResultMapping(boolean queryHadAliases) {
        if (!queryHadAliases) {
            return this.resultSetMapping;
        }
        ResultSetMapping resultSetMapping = ResultSetMapping.resolveResultSetMapping(null, false, this.factory);
        HashSet visited = new HashSet();
        this.resultSetMapping.visitResultBuilders((i, resultBuilder) -> {
            if (resultBuilder instanceof NativeQuery.RootReturn) {
                NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
                String suffix = this.alias2Suffix.get(rootReturn.getTableAlias());
                visited.add(rootReturn.getTableAlias());
                if (suffix == null) {
                    resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
                } else {
                    DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(rootReturn, suffix);
                    resultSetMapping.addResultBuilder(resultBuilderEntity);
                    this.alias2Return.put(rootReturn.getTableAlias(), resultBuilderEntity);
                }
            } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
                NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
                String suffix = this.alias2CollectionSuffix.get(collectionReturn.getTableAlias());
                if (suffix == null) {
                    resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
                } else {
                    CompleteResultBuilderCollectionStandard resultBuilderCollection = this.createSuffixedResultBuilder(collectionReturn, suffix, this.alias2Suffix.get(collectionReturn.getTableAlias()));
                    resultSetMapping.addResultBuilder(resultBuilderCollection);
                    this.alias2Return.put(collectionReturn.getTableAlias(), resultBuilderCollection);
                }
            } else {
                resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
            }
        });
        this.resultSetMapping.visitLegacyFetchBuilders(fetchBuilder -> this.applyFetchBuilder(resultSetMapping, (LegacyFetchBuilder)fetchBuilder, visited));
        return resultSetMapping;
    }

    private void applyFetchBuilder(ResultSetMapping resultSetMapping, LegacyFetchBuilder fetchBuilder, Set<String> visited) {
        if (!visited.add(fetchBuilder.getTableAlias())) {
            return;
        }
        String suffix = this.alias2Suffix.get(fetchBuilder.getTableAlias());
        if (suffix == null) {
            resultSetMapping.addLegacyFetchBuilder(fetchBuilder);
        } else {
            List<String> columnNames;
            if (!visited.contains(fetchBuilder.getOwnerAlias())) {
                this.applyFetchBuilder(resultSetMapping, (DynamicFetchBuilderLegacy)this.alias2Return.get(fetchBuilder.getOwnerAlias()), visited);
            }
            DynamicResultBuilderEntityStandard ownerBuilder = (DynamicResultBuilderEntityStandard)this.alias2Return.get(fetchBuilder.getOwnerAlias());
            DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(this.alias2Persister.get(fetchBuilder.getTableAlias()).findContainingEntityMapping(), fetchBuilder.getTableAlias(), suffix, null, this.determineNavigablePath(fetchBuilder));
            EntityPersister loadable = this.alias2Persister.get(fetchBuilder.getOwnerAlias());
            String[] columnAliases = loadable.getSubclassPropertyColumnAliases(fetchBuilder.getFetchable().getFetchableName(), this.alias2Suffix.get(fetchBuilder.getOwnerAlias()));
            if (columnAliases.length == 0) {
                CollectionPersister collectionPersister = this.alias2CollectionPersister.get(fetchBuilder.getTableAlias());
                if (collectionPersister == null) {
                    columnNames = Collections.emptyList();
                } else {
                    String collectionSuffix = this.alias2CollectionSuffix.get(fetchBuilder.getTableAlias());
                    String[] keyColumnAliases = collectionPersister.getKeyColumnAliases(collectionSuffix);
                    columnNames = Arrays.asList(keyColumnAliases);
                    if (collectionPersister.hasIndex()) {
                        resultBuilderEntity.addProperty((Fetchable)((PluralAttributeMapping)fetchBuilder.getFetchable()).getIndexDescriptor(), collectionPersister.getIndexColumnAliases(collectionSuffix));
                    }
                }
            } else {
                columnNames = Arrays.asList(columnAliases);
            }
            ownerBuilder.addFetchBuilder(fetchBuilder.getFetchable(), new DynamicFetchBuilderLegacy(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias(), fetchBuilder.getFetchable(), columnNames, Collections.emptyMap(), resultBuilderEntity));
            this.alias2Return.put(fetchBuilder.getTableAlias(), resultBuilderEntity);
        }
    }

    private NavigablePath determineNavigablePath(LegacyFetchBuilder fetchBuilder) {
        NativeQuery.ResultNode ownerResult = this.alias2Return.get(fetchBuilder.getOwnerAlias());
        if (ownerResult instanceof NativeQuery.RootReturn) {
            return ((NativeQuery.RootReturn)ownerResult).getNavigablePath().append(fetchBuilder.getFetchable().getFetchableName());
        }
        return this.determineNavigablePath((DynamicFetchBuilderLegacy)ownerResult).append(fetchBuilder.getFetchable().getFetchableName());
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(NativeQuery.RootReturn rootReturn, String suffix) {
        return this.createSuffixedResultBuilder(rootReturn.getEntityMapping(), rootReturn.getTableAlias(), suffix, rootReturn.getLockMode(), new NavigablePath(rootReturn.getEntityMapping().getEntityName(), rootReturn.getTableAlias()));
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(EntityMappingType entityMapping, String tableAlias, String suffix, LockMode lockMode, NavigablePath navigablePath) {
        EntityPersister loadable = entityMapping.getEntityPersister();
        DynamicResultBuilderEntityStandard resultBuilderEntity = new DynamicResultBuilderEntityStandard(entityMapping, tableAlias, navigablePath);
        resultBuilderEntity.setLockMode(lockMode);
        String[] identifierAliases = loadable.getIdentifierAliases(suffix);
        resultBuilderEntity.addIdColumnAliases(identifierAliases);
        resultBuilderEntity.setDiscriminatorAlias(loadable.getDiscriminatorAlias(suffix));
        if (loadable.hasIdentifierProperty()) {
            resultBuilderEntity.addProperty((Fetchable)loadable.getIdentifierMapping(), identifierAliases);
        }
        loadable.visitFetchables((index, fetchable) -> {
            if (fetchable.isSelectable()) {
                Type propertyType;
                if (loadable instanceof SingleTableEntityPersister) {
                    SingleTableEntityPersister singleTableEntityPersister = (SingleTableEntityPersister)loadable;
                    propertyType = singleTableEntityPersister.getSubclassPropertyType(index);
                } else {
                    propertyType = loadable.getPropertyType(fetchable.getFetchableName());
                }
                this.addFetchBuilder(suffix, loadable, resultBuilderEntity, tableAlias, identifierAliases, (Fetchable)fetchable, loadable.getSubclassPropertyColumnAliases(fetchable.getFetchableName(), suffix), propertyType);
            }
        }, null);
        return resultBuilderEntity;
    }

    private void addFetchBuilder(String suffix, EntityPersister loadable, DynamicFetchBuilderContainer resultBuilderEntity, String tableAlias, String[] identifierAliases, Fetchable fetchable, String[] columnAliases, Type propertyType) {
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            String[] keyColumnAliases = collectionType.useLHSPrimaryKey() ? identifierAliases : loadable.getSubclassPropertyColumnAliases(collectionType.getLHSPropertyName(), suffix);
            resultBuilderEntity.addProperty(fetchable, keyColumnAliases);
        } else if (propertyType instanceof ComponentType) {
            ComponentType componentType = (ComponentType)propertyType;
            HashMap<Fetchable, FetchBuilder> fetchBuilderMap = new HashMap<Fetchable, FetchBuilder>();
            DynamicFetchBuilderLegacy fetchBuilder = new DynamicFetchBuilderLegacy("", tableAlias, fetchable, Arrays.asList(columnAliases), fetchBuilderMap);
            String[] propertyNames = componentType.getPropertyNames();
            Type[] propertyTypes = componentType.getSubtypes();
            int aliasIndex = 0;
            for (int i = 0; i < propertyNames.length; ++i) {
                int columnSpan = propertyTypes[i].getColumnSpan(loadable.getFactory());
                this.addFetchBuilder(suffix, loadable, fetchBuilder, tableAlias, identifierAliases, fetchable, ArrayHelper.slice(columnAliases, aliasIndex, columnSpan), propertyTypes[i]);
                aliasIndex += columnSpan;
            }
            resultBuilderEntity.addFetchBuilder(fetchable, fetchBuilder);
        } else if (columnAliases.length != 0) {
            ToOneAttributeMapping toOne;
            if (propertyType instanceof EntityType && !(toOne = (ToOneAttributeMapping)fetchable).getIdentifyingColumnsTableExpression().equals(loadable.getTableName())) {
                assert (columnAliases.length == 1);
                String[] targetAliases = new String[]{toOne.getTargetKeyPropertyName()};
                resultBuilderEntity.addProperty(fetchable, targetAliases);
                return;
            }
            resultBuilderEntity.addProperty(fetchable, columnAliases);
        }
    }

    private CompleteResultBuilderCollectionStandard createSuffixedResultBuilder(NativeQuery.CollectionReturn collectionReturn, String suffix, String entitySuffix) {
        String[] elementColumnAliases;
        CollectionPersister collectionPersister = collectionReturn.getPluralAttribute().getCollectionDescriptor();
        if (collectionPersister.getElementType() instanceof EntityType) {
            EntityPersister elementPersister = collectionPersister.getElementPersister();
            String[] propertyNames = elementPersister.getPropertyNames();
            String[] identifierAliases = elementPersister.getIdentifierAliases(entitySuffix);
            String discriminatorAlias = elementPersister.getDiscriminatorAlias(entitySuffix);
            ArrayList<String> aliases = new ArrayList<String>(propertyNames.length + identifierAliases.length + (discriminatorAlias == null ? 0 : 1));
            Collections.addAll(aliases, identifierAliases);
            if (discriminatorAlias != null) {
                aliases.add(discriminatorAlias);
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                Collections.addAll(aliases, elementPersister.getPropertyAliases(entitySuffix, i));
            }
            elementColumnAliases = ArrayHelper.toStringArray(aliases);
        } else {
            elementColumnAliases = collectionPersister.getElementColumnAliases(suffix);
        }
        return new CompleteResultBuilderCollectionStandard(collectionReturn.getTableAlias(), collectionReturn.getNavigablePath(), collectionReturn.getPluralAttribute(), collectionPersister.getKeyColumnAliases(suffix), collectionPersister.hasIndex() ? collectionPersister.getIndexColumnAliases(suffix) : null, elementColumnAliases);
    }

    private EntityPersister getSQLLoadable(String entityName) throws MappingException {
        return this.factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
    }

    private String generateEntitySuffix() {
        return AliasConstantsHelper.get(this.entitySuffixSeed++);
    }

    private String generateCollectionSuffix() {
        return this.collectionSuffixSeed++ + "__";
    }

    private void processReturn(NativeQuery.ResultNode rtn) {
        if (rtn instanceof NativeQuery.RootReturn) {
            this.processRootReturn((NativeQuery.RootReturn)rtn);
        } else if (rtn instanceof NativeQuery.FetchReturn) {
            this.processFetchReturn((NativeQuery.FetchReturn)rtn);
        } else if (rtn instanceof NativeQuery.InstantiationResultNode) {
            this.processConstructorReturn((NativeQuery.InstantiationResultNode)rtn);
        } else if (rtn instanceof NativeQuery.ReturnProperty) {
            this.processScalarReturn((NativeQuery.ReturnProperty)rtn);
        } else if (rtn instanceof NativeQuery.ReturnableResultNode) {
            this.processPropertyReturn((NativeQuery.ReturnableResultNode)rtn);
        } else {
            throw new IllegalStateException("Unrecognized NativeSQLQueryReturn concrete type encountered : " + rtn);
        }
    }

    private void processPropertyReturn(NativeQuery.ReturnableResultNode rtn) {
    }

    private void processConstructorReturn(NativeQuery.InstantiationResultNode<?> rtn) {
    }

    private void processScalarReturn(NativeQuery.ReturnProperty typeReturn) {
    }

    private void processRootReturn(NativeQuery.RootReturn rootReturn) {
        if (this.alias2Persister.containsKey(rootReturn.getTableAlias())) {
            return;
        }
        EntityPersister persister = rootReturn.getEntityMapping().getEntityPersister();
        Map<String, String[]> propertyResultsMap = Collections.emptyMap();
        this.addPersister(rootReturn.getTableAlias(), propertyResultsMap, persister);
    }

    private void addPersister(String alias, Map<String, String[]> propertyResult, EntityPersister persister) {
        this.alias2Persister.put(alias, persister);
        String suffix = this.generateEntitySuffix();
        LOG.tracev("Mapping alias [{0}] to entity-suffix [{1}]", alias, suffix);
        this.alias2Suffix.put(alias, suffix);
        this.entityPropertyResultMaps.put(alias, propertyResult);
    }

    private void addCollection(String role, String alias, Map<String, String[]> propertyResults) {
        CollectionPersister collectionDescriptor = this.factory.getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(role);
        this.alias2CollectionPersister.put(alias, collectionDescriptor);
        String suffix = this.generateCollectionSuffix();
        LOG.tracev("Mapping alias [{0}] to collection-suffix [{1}]", alias, suffix);
        this.alias2CollectionSuffix.put(alias, suffix);
        this.collectionPropertyResultMaps.put(alias, propertyResults);
        if (collectionDescriptor.isOneToMany() || collectionDescriptor.isManyToMany()) {
            this.addPersister(alias, this.filter(propertyResults), collectionDescriptor.getElementPersister());
        }
    }

    private Map<String, String[]> filter(Map<String, String[]> propertyResults) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(propertyResults.size());
        String keyPrefix = "element.";
        for (Map.Entry<String, String[]> element : propertyResults.entrySet()) {
            String path = element.getKey();
            if (!path.startsWith("element.")) continue;
            result.put(path.substring("element.".length()), element.getValue());
        }
        return result;
    }

    private void processFetchReturn(NativeQuery.FetchReturn fetchReturn) {
        EntityPersister ownerPersister;
        Type returnType;
        String alias = fetchReturn.getTableAlias();
        if (this.alias2Persister.containsKey(alias) || this.alias2CollectionPersister.containsKey(alias)) {
            return;
        }
        String ownerAlias = fetchReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + alias + "]");
        }
        if (!this.alias2Persister.containsKey(ownerAlias)) {
            this.processReturn(this.alias2Return.get(ownerAlias));
        }
        if ((returnType = (ownerPersister = this.alias2Persister.get(ownerAlias)).getPropertyType(fetchReturn.getFetchable().getFetchableName())) instanceof CollectionType) {
            String role = ownerPersister.getEntityName() + "." + fetchReturn.getFetchable().getFetchableName();
            Map<String, String[]> propertyResultsMap = Collections.emptyMap();
            this.addCollection(role, alias, propertyResultsMap);
        } else if (returnType instanceof EntityType) {
            EntityType eType = (EntityType)returnType;
            String returnEntityName = eType.getAssociatedEntityName();
            EntityPersister persister = this.getSQLLoadable(returnEntityName);
            Map<String, String[]> propertyResultsMap = Collections.emptyMap();
            this.addPersister(alias, propertyResultsMap, persister);
        }
    }

    @Override
    public boolean isEntityAlias(String alias) {
        return this.getEntityPersister(alias) != null;
    }

    @Override
    public boolean isCollectionAlias(String alias) {
        return this.getCollectionPersister(alias) != null;
    }

    @Override
    public EntityPersister getEntityPersister(String alias) {
        return this.alias2Persister.get(alias);
    }

    @Override
    public CollectionPersister getCollectionPersister(String alias) {
        return this.alias2CollectionPersister.get(alias);
    }

    @Override
    public String getEntitySuffix(String alias) {
        return this.alias2Suffix.get(alias);
    }

    @Override
    public String getCollectionSuffix(String alias) {
        return this.alias2CollectionSuffix.get(alias);
    }

    public String getOwnerAlias(String alias) {
        return this.alias2OwnerAlias.get(alias);
    }

    @Override
    public Map<String, String[]> getPropertyResultsMap(String alias) {
        return this.internalGetPropertyResultsMap(alias);
    }
}

