/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SelfRenderingWindowFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmWindowFunction;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SelfRenderingSqmWindowFunction<T>
extends SelfRenderingSqmFunction<T>
implements SqmWindowFunction<T> {
    private final SqmPredicate filter;
    private final Boolean respectNulls;
    private final Boolean fromFirst;

    public SelfRenderingSqmWindowFunction(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        this.filter = filter;
        this.respectNulls = respectNulls;
        this.fromFirst = fromFirst;
    }

    @Override
    public SelfRenderingSqmWindowFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmWindowFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        SelfRenderingSqmWindowFunction expression = context.registerCopy(this, new SelfRenderingSqmWindowFunction(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.filter == null ? null : this.filter.copy(context), this.respectNulls, this.fromFirst, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator argumentsValidator = this.getArgumentsValidator();
        if (argumentsValidator != null) {
            argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingWindowFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, this.filter == null ? null : walker.visitNestedTopLevelPredicate(this.filter), this.respectNulls, this.fromFirst, resultType, this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public SqmPredicate getFilter() {
        return this.filter;
    }

    @Override
    public Boolean getRespectNulls() {
        return this.respectNulls;
    }

    @Override
    public Boolean getFromFirst() {
        return this.fromFirst;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        sb.append(this.getFunctionName());
        sb.append('(');
        int i = 1;
        if (arguments.get(0) instanceof SqmDistinct) {
            arguments.get(0).appendHqlString(sb);
            if (arguments.size() > 1) {
                sb.append(' ');
                arguments.get(1).appendHqlString(sb);
                i = 2;
            }
        }
        while (i < arguments.size()) {
            sb.append(", ");
            arguments.get(i).appendHqlString(sb);
            ++i;
        }
        sb.append(')');
        if (this.fromFirst != null) {
            if (this.fromFirst.booleanValue()) {
                sb.append(" from first");
            } else {
                sb.append(" from last");
            }
        }
        if (this.respectNulls != null) {
            if (this.respectNulls.booleanValue()) {
                sb.append(" respect nulls");
            } else {
                sb.append(" ignore nulls");
            }
        }
        if (this.filter != null) {
            sb.append(" filter (where ");
            this.filter.appendHqlString(sb);
            sb.append(')');
        }
    }
}

