/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.Order;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmPathVisitor;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;

public class SqmUtil {
    private SqmUtil() {
    }

    public static boolean isSelect(SqmStatement<?> sqm) {
        return sqm instanceof SqmSelectStatement;
    }

    public static boolean isMutation(SqmStatement<?> sqm) {
        return sqm instanceof SqmDmlStatement;
    }

    public static void verifyIsSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isSelect(sqm)) {
            throw new IllegalSelectQueryException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()), hqlString);
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isMutation(sqm)) {
            throw SqmUtil.expectingNonSelect(sqm, hqlString);
        }
    }

    public static IllegalQueryOperationException expectingNonSelect(SqmStatement<?> sqm, String hqlString) {
        return new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()), hqlString, null);
    }

    public static ModelPartContainer getTargetMappingIfNeeded(SqmPath<?> sqmPath, ModelPartContainer modelPartContainer, SqmToSqlAstConverter sqlAstCreationState) {
        if (sqlAstCreationState.getCurrentClauseStack().getCurrent() != Clause.FROM && modelPartContainer.getPartMappingType() != modelPartContainer && sqmPath.getLhs() instanceof SqmFrom) {
            EntityAssociationMapping association;
            ModelPartContainer modelPart;
            if (modelPartContainer instanceof PluralAttributeMapping) {
                PluralAttributeMapping plural = (PluralAttributeMapping)modelPartContainer;
                v0 = SqmUtil.getCollectionPart(plural, NullnessUtil.castNonNull(sqmPath.getNavigablePath().getParent()));
            } else {
                v0 = modelPart = modelPartContainer;
            }
            if (modelPart instanceof EntityAssociationMapping && SqmUtil.shouldRenderTargetSide(sqmPath, association = (EntityAssociationMapping)modelPart, sqlAstCreationState)) {
                return association.getAssociatedEntityMappingType();
            }
        }
        return modelPartContainer;
    }

    private static boolean shouldRenderTargetSide(SqmPath<?> sqmPath, EntityAssociationMapping association, SqmToSqlAstConverter sqlAstCreationState) {
        if (!association.getTargetKeyPropertyNames().contains(sqmPath.getReferencedPathSource().getPathName())) {
            return false;
        }
        Clause clause = sqlAstCreationState.getCurrentClauseStack().getCurrent();
        return clause == Clause.GROUP || clause == Clause.ORDER || !SqmUtil.isFkOptimizationAllowed(sqmPath.getLhs(), association) || SqmUtil.inGroupByOrOrderBy(sqmPath, sqlAstCreationState);
    }

    private static boolean inGroupByOrOrderBy(SqmPath<?> sqmPath, SqmToSqlAstConverter converter) {
        Stack<SqmQueryPart> queryPartStack = converter.getSqmQueryPartStack();
        NavigablePath np = sqmPath.getNavigablePath();
        Boolean found = queryPartStack.findCurrentFirst(queryPart -> {
            SqmQuerySpec spec = queryPart.getFirstQuerySpec();
            return spec.groupByClauseContains(np, converter) || spec.orderByClauseContains(np, converter) ? Boolean.valueOf(true) : null;
        });
        return Boolean.TRUE.equals(found);
    }

    private static CollectionPart getCollectionPart(PluralAttributeMapping attribute, NavigablePath path) {
        CollectionPart collectionPart;
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(path.getLocalName());
        if (nature != null) {
            switch (nature) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ELEMENT: {
                    collectionPart = attribute.getElementDescriptor();
                    break;
                }
                case INDEX: {
                    collectionPart = attribute.getIndexDescriptor();
                    break;
                }
                case ID: {
                    collectionPart = attribute.getIdentifierDescriptor();
                    break;
                }
            }
        } else {
            collectionPart = null;
        }
        return collectionPart;
    }

    @Deprecated(forRemoval=true, since="6.6.1")
    public static boolean isFkOptimizationAllowed(SqmPath<?> sqmPath) {
        if (sqmPath instanceof SqmJoin) {
            SqmJoin sqmJoin = (SqmJoin)sqmPath;
            switch (sqmJoin.getSqmJoinType()) {
                case LEFT: {
                    EntityAssociationMapping associationMapping = SqmUtil.resolveAssociationMapping(sqmJoin);
                    if (associationMapping != null && SqmUtil.isFiltered(associationMapping)) {
                        return false;
                    }
                }
                case INNER: {
                    return sqmJoin.getJoinPredicate() == null;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isFkOptimizationAllowed(SqmPath<?> sqmPath, EntityAssociationMapping associationMapping) {
        if (associationMapping.isFkOptimizationAllowed() && sqmPath instanceof SqmJoin) {
            SqmJoin sqmJoin = (SqmJoin)sqmPath;
            switch (sqmJoin.getSqmJoinType()) {
                case LEFT: {
                    if (SqmUtil.isFiltered(associationMapping)) {
                        return false;
                    }
                }
                case INNER: {
                    return sqmJoin.getJoinPredicate() == null;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isFiltered(EntityAssociationMapping associationMapping) {
        EntityMappingType entityMappingType = associationMapping.getAssociatedEntityMappingType();
        return !associationMapping.isFkOptimizationAllowed() || entityMappingType.getIdentifierMappingForJoin() != entityMappingType.getIdentifierMapping();
    }

    private static @Nullable EntityAssociationMapping resolveAssociationMapping(SqmJoin<?, ?> sqmJoin) {
        SqmSingularJoin singularJoin;
        if (sqmJoin instanceof SqmSingularJoin && (singularJoin = (SqmSingularJoin)sqmJoin).getAttribute().getSqmPathType() instanceof EntityDomainType) {
            return SqmUtil.resolveAssociationMapping(singularJoin);
        }
        return null;
    }

    private static @Nullable EntityAssociationMapping resolveAssociationMapping(SqmSingularJoin<?, ?> sqmJoin) {
        MappingMetamodelImplementor metamodel = sqmJoin.nodeBuilder().getMappingMetamodel();
        PersistentAttribute attribute = sqmJoin.getAttribute();
        ManagedType declaringType = attribute.getDeclaringType();
        if (declaringType.getPersistenceType() != Type.PersistenceType.ENTITY) {
            StringBuilder pathBuilder = new StringBuilder();
            do {
                SqmSingularJoin sqmSingularJoin;
                if (!pathBuilder.isEmpty()) {
                    pathBuilder.insert(0, '.');
                }
                pathBuilder.insert(0, attribute.getName());
                SqmPath sqmPath = sqmJoin.getLhs();
                if (!(sqmPath instanceof SqmSingularJoin)) {
                    return null;
                }
                sqmJoin = sqmSingularJoin = (SqmSingularJoin)sqmPath;
                attribute = sqmJoin.getAttribute();
                declaringType = attribute.getDeclaringType();
            } while (declaringType.getPersistenceType() != Type.PersistenceType.ENTITY);
            pathBuilder.insert(0, '.');
            pathBuilder.insert(0, attribute.getName());
            return (EntityAssociationMapping)metamodel.getEntityDescriptor(((EntityDomainType)declaringType).getHibernateEntityName()).findByPath(pathBuilder.toString());
        }
        return (EntityAssociationMapping)((Object)metamodel.getEntityDescriptor(((EntityDomainType)declaringType).getHibernateEntityName()).findAttributeMapping(attribute.getName()));
    }

    public static List<NavigablePath> getWhereClauseNavigablePaths(SqmQuerySpec<?> querySpec) {
        SqmWhereClause where = querySpec.getWhereClause();
        return where == null || where.getPredicate() == null ? Collections.emptyList() : SqmUtil.collectNavigablePaths(List.of(where.getPredicate()));
    }

    public static List<NavigablePath> getGroupByNavigablePaths(SqmQuerySpec<?> querySpec) {
        List<SqmExpression<?>> expressions = querySpec.getGroupByClauseExpressions();
        return expressions.isEmpty() ? Collections.emptyList() : SqmUtil.collectNavigablePaths(expressions);
    }

    public static List<NavigablePath> getOrderByNavigablePaths(SqmQuerySpec<?> querySpec) {
        SqmOrderByClause order = querySpec.getOrderByClause();
        if (order == null || order.getSortSpecifications().isEmpty()) {
            return Collections.emptyList();
        }
        List<SqmExpression<?>> expressions = order.getSortSpecifications().stream().map(SqmSortSpecification::getSortExpression).collect(Collectors.toList());
        return SqmUtil.collectNavigablePaths(expressions);
    }

    private static List<NavigablePath> collectNavigablePaths(List<SqmExpression<?>> expressions) {
        ArrayList<NavigablePath> navigablePaths = CollectionHelper.arrayList(expressions.size());
        SqmPathVisitor pathVisitor = new SqmPathVisitor(path -> navigablePaths.add(path.getNavigablePath()));
        for (SqmExpression<?> expression : expressions) {
            if (expression instanceof SqmAliasedNodeRef) {
                SqmAliasedNodeRef sqmAliasedNodeRef = (SqmAliasedNodeRef)expression;
                NavigablePath navigablePath = sqmAliasedNodeRef.getNavigablePath();
                if (navigablePath == null) continue;
                navigablePaths.add(navigablePath);
                continue;
            }
            expression.accept(pathVisitor);
        }
        return navigablePaths;
    }

    public static <T, A> SqmAttributeJoin<T, A> findCompatibleFetchJoin(SqmFrom<?, T> sqmFrom, SqmPathSource<A> pathSource, SqmJoinType requestedJoinType) {
        for (SqmJoin<T, ?> join : sqmFrom.getSqmJoins()) {
            SqmAttributeJoin attributeJoin;
            if (join.getReferencedPathSource() != pathSource || !(attributeJoin = (SqmAttributeJoin)join).isFetched()) continue;
            SqmJoinType joinType = join.getSqmJoinType();
            if (joinType != requestedJoinType) {
                throw new IllegalStateException(String.format("Requested join fetch with association [%s] with '%s' join type, but found existing join fetch with '%s' join type.", new Object[]{pathSource.getPathName(), requestedJoinType, joinType}));
            }
            return attributeJoin;
        }
        return null;
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        IdentityHashMap result = new IdentityHashMap(domainParameterXref.getQueryParameterCount());
        domainParameterXref.getQueryParameters().forEach((queryParam, sqmParams) -> {
            Map sqmParamMap = result.computeIfAbsent((QueryParameterImplementor<?>)queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter sqmParam : sqmParams) {
                Map<SqmParameter<?>, List<List<JdbcParameter>>> jdbcParamsBySqmParam = jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam();
                sqmParamMap.put(sqmParam, SqmUtil.convert(jdbcParamsBySqmParam.get(sqmParam)));
                for (SqmParameter<?> expansion : domainParameterXref.getExpansions(sqmParam)) {
                    sqmParamMap.put(expansion, SqmUtil.convert(jdbcParamsBySqmParam.get(expansion)));
                    result.put((QueryParameterImplementor<?>)queryParam, sqmParamMap);
                }
            }
        });
        return result;
    }

    private static List<JdbcParametersList> convert(List<List<JdbcParameter>> lists) {
        if (lists == null) {
            return null;
        }
        ArrayList<JdbcParametersList> output = new ArrayList<JdbcParametersList>(lists.size());
        for (List<JdbcParameter> element : lists) {
            output.add(JdbcParametersList.fromList(element));
        }
        return output;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamXref, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        domainParameterXref.getQueryParameters().forEach((queryParam, sqmParameters) -> {
            QueryParameterBinding domainParamBinding = domainParamBindings.getBinding(queryParam);
            Map jdbcParamMap = (Map)jdbcParamXref.get(queryParam);
            for (SqmParameter sqmParameter : sqmParameters) {
                BasicValueConverter valueConverter;
                JdbcMapping mapping;
                MappingModelExpressible resolvedMappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameter);
                if (resolvedMappingModelType != null) {
                    domainParamBinding.setType(resolvedMappingModelType);
                }
                Bindable parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, sqmParameters, mappingModelResolutionAccess, session.getFactory());
                List jdbcParamsBinds = (List)jdbcParamMap.get(sqmParameter);
                if (jdbcParamsBinds == null) continue;
                if (!domainParamBinding.isBound()) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = (JdbcParametersList)jdbcParamsBinds.get(i);
                        parameterType.forEachJdbcType((position, jdbcMapping) -> jdbcParameterBindings.addBinding(jdbcParams.get(position), new JdbcParameterBindingImpl((JdbcMapping)jdbcMapping, null)));
                    }
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection bindValues = domainParamBinding.getBindValues();
                    Iterator valueItr = bindValues.iterator();
                    Object firstValue = valueItr.next();
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = (JdbcParametersList)jdbcParamsBinds.get(i);
                        SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, firstValue, session);
                    }
                    List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParameter);
                    int expansionCount = bindValues.size() - 1;
                    int parameterUseCount = jdbcParamsBinds.size();
                    assert (expansions.size() == expansionCount * parameterUseCount);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        Object expandedValue = valueItr.next();
                        for (int j = 0; j < parameterUseCount; ++j) {
                            SqmParameter<?> expansionSqmParam = expansions.get(expansionPosition + j * expansionCount);
                            List jdbcParamBinds = (List)jdbcParamMap.get(expansionSqmParam);
                            for (int i = 0; i < jdbcParamBinds.size(); ++i) {
                                JdbcParametersList expansionJdbcParams = (JdbcParametersList)jdbcParamBinds.get(i);
                                SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, expansionJdbcParams, expandedValue, session);
                            }
                        }
                        ++expansionPosition;
                    }
                    continue;
                }
                MappingModelExpressible patt23752$temp = domainParamBinding.getType();
                JdbcMapping jdbcMapping2 = patt23752$temp instanceof JdbcMapping ? (mapping = (JdbcMapping)((Object)patt23752$temp)) : (domainParamBinding.getBindType() instanceof BasicValuedMapping ? ((BasicValuedMapping)domainParamBinding.getType()).getJdbcMapping() : null);
                BasicValueConverter basicValueConverter = valueConverter = jdbcMapping2 == null ? null : jdbcMapping2.getValueConverter();
                if (valueConverter != null) {
                    Object convertedValue = valueConverter.toRelationalValue(domainParamBinding.getBindValue());
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = (JdbcParametersList)jdbcParamsBinds.get(i);
                        assert (jdbcParams.size() == 1);
                        JdbcParameter jdbcParameter = jdbcParams.get(0);
                        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, convertedValue));
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                if (bindValue == null) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = (JdbcParametersList)jdbcParamsBinds.get(i);
                        for (int j = 0; j < jdbcParams.size(); ++j) {
                            JdbcParameter jdbcParameter = jdbcParams.get(j);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, bindValue));
                        }
                    }
                    continue;
                }
                for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                    JdbcParametersList jdbcParams = (JdbcParametersList)jdbcParamsBinds.get(i);
                    SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, bindValue, session);
                }
            }
        });
        return jdbcParameterBindings;
    }

    private static void createValueBindings(JdbcParameterBindings jdbcParameterBindings, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding, Bindable parameterType, JdbcParametersList jdbcParams, Object bindValue, SharedSessionContractImplementor session) {
        if (parameterType == null) {
            throw new SqlTreeCreationException("Unable to interpret mapping-model type for Query parameter : " + domainParam);
        }
        if (parameterType instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)parameterType;
            parameterType = pluralAttributeMapping.getElementDescriptor();
        }
        if (parameterType instanceof EntityIdentifierMapping) {
            EntityIdentifierMapping identifierMapping = parameterType;
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityMappingType) {
            EntityMappingType entityMappingType = (EntityMappingType)((Object)parameterType);
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            parameterType = identifierMapping;
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityAssociationMapping) {
            EntityAssociationMapping association = (EntityAssociationMapping)((Object)parameterType);
            if (association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                bindValue = association.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(bindValue);
                parameterType = association.getAssociatedEntityMappingType().getIdentifierMapping();
            } else {
                bindValue = association.getForeignKeyDescriptor().getAssociationKeyFromSide(bindValue, association.getSideNature().inverse(), session);
                parameterType = association.getForeignKeyDescriptor();
            }
        } else if (parameterType instanceof JavaObjectType) {
            parameterType = domainParamBinding.getType();
        }
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(bindValue, parameterType, jdbcParams, session);
        assert (offset == jdbcParams.size());
    }

    public static Bindable determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, List<SqmParameter<?>> sqmParameters, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SessionFactoryImplementor sessionFactory) {
        Bindable tryOne = SqmUtil.asBindable(binding.getBindType());
        if (tryOne != null) {
            return tryOne;
        }
        Bindable tryTwo = SqmUtil.asBindable(parameter.getHibernateType());
        if (tryTwo != null) {
            return tryTwo;
        }
        if (binding.getType() != null) {
            return binding.getType();
        }
        for (int i = 0; i < sqmParameters.size(); ++i) {
            MappingModelExpressible<?> mappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameters.get(i));
            if (mappingModelType == null) continue;
            return mappingModelType;
        }
        return sessionFactory.getTypeConfiguration().standardBasicTypeForJavaType(parameter.getParameterType());
    }

    private static Bindable asBindable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BasicTypeImpl) {
            BasicTypeImpl basicType = (BasicTypeImpl)object;
            return basicType;
        }
        if (object instanceof ConvertedBasicTypeImpl) {
            ConvertedBasicTypeImpl convertedBasicType = (ConvertedBasicTypeImpl)object;
            return convertedBasicType;
        }
        if (object instanceof Bindable) {
            Bindable bindable = (Bindable)object;
            return bindable;
        }
        return null;
    }

    public static SqmStatement.ParameterResolutions resolveParameters(final SqmStatement<?> statement) {
        if (statement.getQuerySource() == SqmQuerySource.CRITERIA) {
            CriteriaParameterCollector parameterCollector = new CriteriaParameterCollector();
            ParameterCollector.collectParameters(statement, parameterCollector::process);
            return parameterCollector.makeResolution();
        }
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return statement.getSqmParameters();
            }

            @Override
            public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }

    static JpaOrder sortSpecification(SqmSelectStatement<?> sqm, Order<?> order) {
        List<SqmSelectableNode<?>> items = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelectionItems();
        int element = order.getElement();
        if (element < 1) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (the first select item is element 1)");
        }
        if (element > items.size()) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (there are only " + items.size() + " select items)");
        }
        SqmSelectableNode<?> selected = items.get(element - 1);
        NodeBuilder builder = sqm.nodeBuilder();
        if (order.getEntityClass() == null) {
            return new SqmSortSpecification(new SqmAliasedNodeRef(element, builder.getIntegerType(), builder), order.getDirection(), order.getNullPrecedence(), order.isCaseInsensitive());
        }
        if (items.size() == 1) {
            if (selected instanceof SqmFrom) {
                SqmFrom root = (SqmFrom)selected;
                if (!order.getEntityClass().isAssignableFrom(root.getJavaType())) {
                    throw new IllegalQueryOperationException("Select item was of wrong entity type");
                }
                StringTokenizer tokens = new StringTokenizer(order.getAttributeName(), ".");
                JpaPath path = root;
                while (tokens.hasMoreTokens()) {
                    path = path.get(tokens.nextToken());
                }
                return builder.sort((JpaExpression)path, order.getDirection(), order.getNullPrecedence(), order.isCaseInsensitive());
            }
            throw new IllegalQueryOperationException("Select item was not an entity type");
        }
        throw new IllegalQueryOperationException("Query has multiple items in the select list");
    }

    public static boolean isSelectionAssignableToResultType(SqmSelection<?> selection, Class<?> expectedResultType) {
        SqmSelectableNode<?> sqmSelectableNode;
        if (expectedResultType == null) {
            return true;
        }
        if (selection != null && (sqmSelectableNode = selection.getSelectableNode()) instanceof SqmParameter) {
            SqmParameter sqmParameter = (SqmParameter)sqmSelectableNode;
            Class anticipatedClass = sqmParameter.getAnticipatedType() != null ? sqmParameter.getAnticipatedType().getBindableJavaType() : null;
            return anticipatedClass != null && expectedResultType.isAssignableFrom(anticipatedClass);
        }
        if (selection == null || !SqmUtil.isHqlTuple(selection) && selection.getSelectableNode().isCompoundSelection()) {
            return false;
        }
        JavaType nodeJavaType = selection.getNodeJavaType();
        return nodeJavaType != null && expectedResultType.isAssignableFrom(nodeJavaType.getJavaTypeClass());
    }

    public static boolean isHqlTuple(SqmSelection<?> selection) {
        return selection != null && selection.getSelectableNode() instanceof SqmTuple;
    }

    public static Class<?> resolveExpressibleJavaTypeClass(SqmExpression<?> expression) {
        SqmExpressible expressible = expression.getExpressible();
        return expressible == null || expressible.getExpressibleJavaType() == null ? null : expressible.getExpressibleJavaType().getJavaTypeClass();
    }

    public static void validateQueryReturnType(SqmQueryPart<?> queryPart, @Nullable Class<?> expectedResultType) {
        if (expectedResultType != null && !SqmUtil.isResultTypeAlwaysAllowed(expectedResultType)) {
            SqmUtil.checkQueryReturnType(queryPart, expectedResultType);
        }
    }

    public static void checkQueryReturnType(SqmQueryPart<?> queryPart, Class<?> expectedResultType) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec querySpec = (SqmQuerySpec)queryPart;
            SqmUtil.checkQueryReturnType(querySpec, expectedResultType);
        } else if (queryPart instanceof SqmQueryGroup) {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart sqmQueryPart : queryGroup.getQueryParts()) {
                SqmUtil.checkQueryReturnType(sqmQueryPart, expectedResultType);
            }
        } else {
            throw new AssertionFailure("Unexpected query part");
        }
    }

    private static void checkQueryReturnType(SqmQuerySpec<?> querySpec, Class<?> expectedResultClass) {
        block7: {
            List<SqmSelection<?>> selections;
            JpaCompliance jpaCompliance;
            block8: {
                block5: {
                    block6: {
                        jpaCompliance = querySpec.nodeBuilder().getJpaCompliance();
                        selections = querySpec.getSelectClause().getSelections();
                        if (selections != null && !selections.isEmpty()) break block5;
                        List<SqmRoot<?>> sqmRoots = querySpec.getFromClause().getRoots();
                        if (sqmRoots == null || sqmRoots.isEmpty()) {
                            throw new IllegalArgumentException("Criteria did not define any query roots");
                        }
                        if (sqmRoots.size() != 1) break block6;
                        SqmUtil.verifySingularSelectionType(expectedResultClass, jpaCompliance, (SqmSelectableNode)sqmRoots.get(0));
                        break block7;
                    }
                    throw new IllegalArgumentException("Criteria has multiple query roots");
                }
                if (selections.size() != 1) break block8;
                SqmSelection<?> sqmSelection = selections.get(0);
                SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
                if (selectableNode.isCompoundSelection()) {
                    Class<?> expectedSelectItemType = expectedResultClass.isArray() ? expectedResultClass.getComponentType() : expectedResultClass;
                    for (JpaSelection<?> selection : selectableNode.getSelectionItems()) {
                        SqmUtil.verifySelectionType(expectedSelectItemType, jpaCompliance, (SqmSelectableNode)selection);
                    }
                } else {
                    SqmUtil.verifySingularSelectionType(expectedResultClass, jpaCompliance, sqmSelection.getSelectableNode());
                }
                break block7;
            }
            if (!expectedResultClass.isArray()) break block7;
            Class<?> componentType = expectedResultClass.getComponentType();
            for (SqmSelection<?> selection : selections) {
                SqmUtil.verifySelectionType(componentType, jpaCompliance, selection.getSelectableNode());
            }
        }
    }

    private static void verifySingularSelectionType(Class<?> expectedResultClass, JpaCompliance jpaCompliance, SqmSelectableNode<?> selectableNode) {
        block2: {
            try {
                SqmUtil.verifySelectionType(expectedResultClass, jpaCompliance, selectableNode);
            }
            catch (QueryTypeMismatchException mismatchException) {
                JavaType javaTypeDescriptor = selectableNode.getJavaTypeDescriptor();
                if (javaTypeDescriptor == null || SqmUtil.hasMatchingConstructor(expectedResultClass, javaTypeDescriptor.getJavaTypeClass())) break block2;
                throw mismatchException;
            }
        }
    }

    private static <T> boolean hasMatchingConstructor(Class<T> expectedResultClass, Class<?> selectedJavaType) {
        try {
            expectedResultClass.getDeclaredConstructor(selectedJavaType);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static <T> void verifySelectionType(Class<T> expectedResultClass, JpaCompliance jpaCompliance, SqmSelectableNode<?> selection) {
        SqmParameter sqmParameter;
        SqmExpressible nodeType;
        if (selection instanceof SqmParameter && ((nodeType = (sqmParameter = (SqmParameter)selection).getExpressible()) == null || nodeType.getExpressibleJavaType() == null)) {
            return;
        }
        if (!jpaCompliance.isJpaQueryComplianceEnabled()) {
            SqmUtil.verifyResultType(expectedResultClass, selection.getExpressible());
        }
    }

    public static boolean isResultTypeAlwaysAllowed(Class<?> expectedResultClass) {
        return expectedResultClass == null || expectedResultClass == Object.class || expectedResultClass == Object[].class || expectedResultClass == List.class || expectedResultClass == Map.class || expectedResultClass == Tuple.class;
    }

    protected static void verifyResultType(Class<?> resultClass, @Nullable SqmExpressible<?> selectionExpressible) {
        Class<?> javaTypeClass;
        JavaType<?> javaType;
        if (selectionExpressible != null && (javaType = selectionExpressible.getExpressibleJavaType()) != null && (javaTypeClass = javaType.getJavaTypeClass()) != Object.class && !SqmUtil.isValid(resultClass, selectionExpressible, javaTypeClass, javaType)) {
            SqmUtil.throwQueryTypeMismatchException(resultClass, selectionExpressible);
        }
    }

    private static boolean isValid(Class<?> resultClass, SqmExpressible<?> selectionExpressible, Class<?> selectionExpressibleJavaTypeClass, JavaType<?> selectionExpressibleJavaType) {
        PrimitiveJavaType primitiveJavaType;
        return resultClass.isAssignableFrom(selectionExpressibleJavaTypeClass) || selectionExpressibleJavaType instanceof PrimitiveJavaType && (primitiveJavaType = (PrimitiveJavaType)selectionExpressibleJavaType).getPrimitiveClass() == resultClass || SqmUtil.isMatchingDateType(selectionExpressibleJavaTypeClass, resultClass, selectionExpressible) || SqmUtil.isEntityIdType(selectionExpressible, resultClass);
    }

    private static boolean isEntityIdType(SqmExpressible<?> selectionExpressible, Class<?> resultClass) {
        if (selectionExpressible instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableDomainType = (IdentifiableDomainType)selectionExpressible;
            return resultClass.isAssignableFrom(identifiableDomainType.getIdType().getBindableJavaType());
        }
        if (selectionExpressible instanceof EntitySqmPathSource) {
            EntitySqmPathSource entityPath = (EntitySqmPathSource)selectionExpressible;
            return resultClass.isAssignableFrom(entityPath.getSqmPathType().getIdType().getBindableJavaType());
        }
        return false;
    }

    private static boolean isMatchingDateType(Class<?> javaTypeClass, Class<?> resultClass, SqmExpressible<?> sqmExpressible) {
        return javaTypeClass == Date.class && SqmUtil.isMatchingDateJdbcType(resultClass, SqmUtil.getJdbcType(sqmExpressible));
    }

    private static JdbcType getJdbcType(SqmExpressible<?> sqmExpressible) {
        SqmPathSource pathSource;
        DomainType domainType;
        if (sqmExpressible instanceof BasicDomainType) {
            BasicDomainType basicDomainType = (BasicDomainType)sqmExpressible;
            return basicDomainType.getJdbcType();
        }
        if (sqmExpressible instanceof SqmPathSource && (domainType = (pathSource = (SqmPathSource)sqmExpressible).getSqmPathType()) instanceof BasicDomainType) {
            BasicDomainType basicDomainType = (BasicDomainType)domainType;
            return basicDomainType.getJdbcType();
        }
        return null;
    }

    private static boolean isMatchingDateJdbcType(Class<?> resultClass, JdbcType jdbcType) {
        if (jdbcType != null) {
            return switch (jdbcType.getDefaultSqlTypeCode()) {
                case 91 -> resultClass.isAssignableFrom(java.sql.Date.class);
                case 92 -> resultClass.isAssignableFrom(Time.class);
                case 93 -> resultClass.isAssignableFrom(Timestamp.class);
                default -> false;
            };
        }
        return false;
    }

    private static void throwQueryTypeMismatchException(Class<?> resultClass, SqmExpressible<?> sqmExpressible) {
        throw new QueryTypeMismatchException(String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressible.getTypeName()));
    }

    private static class CriteriaParameterCollector {
        private Set<SqmParameter<?>> sqmParameters;
        private Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        private CriteriaParameterCollector() {
        }

        public void process(SqmParameter<?> parameter) {
            if (this.sqmParameters == null) {
                this.sqmParameters = new LinkedHashSet();
            }
            if (parameter instanceof SqmJpaCriteriaParameterWrapper) {
                SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)parameter;
                if (this.jpaCriteriaParamResolutions == null) {
                    this.jpaCriteriaParamResolutions = new IdentityHashMap();
                }
                this.jpaCriteriaParamResolutions.computeIfAbsent(wrapper.getJpaCriteriaParameter(), r -> new ArrayList()).add(wrapper);
                this.sqmParameters.add(wrapper);
            } else {
                if (parameter instanceof JpaCriteriaParameter) {
                    throw new UnsupportedOperationException();
                }
                this.sqmParameters.add(parameter);
            }
        }

        private SqmStatement.ParameterResolutions makeResolution() {
            return new ParameterResolutionsImpl(this.sqmParameters == null ? Collections.emptySet() : this.sqmParameters, this.jpaCriteriaParamResolutions == null ? Collections.emptyMap() : this.jpaCriteriaParamResolutions);
        }
    }

    private static class ParameterResolutionsImpl
    implements SqmStatement.ParameterResolutions {
        private final Set<SqmParameter<?>> sqmParameters;
        private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;

        public ParameterResolutionsImpl(Set<SqmParameter<?>> sqmParameters, Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions) {
            this.sqmParameters = sqmParameters;
            if (jpaCriteriaParamResolutions == null || jpaCriteriaParamResolutions.isEmpty()) {
                this.jpaCriteriaParamResolutions = Collections.emptyMap();
            } else {
                this.jpaCriteriaParamResolutions = new IdentityHashMap(CollectionHelper.determineProperSizing(jpaCriteriaParamResolutions));
                for (Map.Entry<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> entry : jpaCriteriaParamResolutions.entrySet()) {
                    Iterator<SqmJpaCriteriaParameterWrapper<?>> itr = entry.getValue().iterator();
                    if (!itr.hasNext()) {
                        throw new IllegalStateException("SqmJpaCriteriaParameterWrapper references for JpaCriteriaParameter [" + entry.getKey() + "] already exhausted");
                    }
                    this.jpaCriteriaParamResolutions.put(entry.getKey(), itr.next());
                }
            }
        }

        @Override
        public Set<SqmParameter<?>> getSqmParameters() {
            return this.sqmParameters;
        }

        @Override
        public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
            return this.jpaCriteriaParamResolutions;
        }
    }
}

